/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.NonPositiveDefiniteMatrixException;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.util.FastMath;

public class RectangularCholeskyDecomposition {
    private final RealMatrix root;
    private int rank;

    public RectangularCholeskyDecomposition(RealMatrix matrix) throws NonPositiveDefiniteMatrixException {
        this(matrix, 0.0);
    }

    public RectangularCholeskyDecomposition(RealMatrix matrix, double small) throws NonPositiveDefiniteMatrixException {
        int order = matrix.getRowDimension();
        double[][] c2 = matrix.getData();
        double[][] b2 = new double[order][order];
        int[] index = new int[order];
        for (int i2 = 0; i2 < order; ++i2) {
            index[i2] = i2;
        }
        int r2 = 0;
        boolean loop = true;
        while (loop) {
            double sqrt;
            int ir;
            int swapR = r2;
            for (int i3 = r2 + 1; i3 < order; ++i3) {
                int ii = index[i3];
                int isr = index[swapR];
                if (!(c2[ii][ii] > c2[isr][isr])) continue;
                swapR = i3;
            }
            if (swapR != r2) {
                int tmpIndex = index[r2];
                index[r2] = index[swapR];
                index[swapR] = tmpIndex;
                double[] tmpRow = b2[r2];
                b2[r2] = b2[swapR];
                b2[swapR] = tmpRow;
            }
            if (c2[ir = index[r2]][ir] <= small) {
                if (r2 == 0) {
                    throw new NonPositiveDefiniteMatrixException(c2[ir][ir], ir, small);
                }
                for (int i4 = r2; i4 < order; ++i4) {
                    if (!(c2[index[i4]][index[i4]] < -small)) continue;
                    throw new NonPositiveDefiniteMatrixException(c2[index[i4]][index[i4]], i4, small);
                }
                loop = false;
                continue;
            }
            b2[r2][r2] = sqrt = FastMath.sqrt(c2[ir][ir]);
            double inverse = 1.0 / sqrt;
            double inverse2 = 1.0 / c2[ir][ir];
            for (int i5 = r2 + 1; i5 < order; ++i5) {
                double e2;
                int ii = index[i5];
                b2[i5][r2] = e2 = inverse * c2[ii][ir];
                double[] dArray = c2[ii];
                int n2 = ii;
                dArray[n2] = dArray[n2] - c2[ii][ir] * c2[ii][ir] * inverse2;
                for (int j2 = r2 + 1; j2 < i5; ++j2) {
                    double f2;
                    int ij = index[j2];
                    c2[ii][ij] = f2 = c2[ii][ij] - e2 * b2[j2][r2];
                    c2[ij][ii] = f2;
                }
            }
            loop = ++r2 < order;
        }
        this.rank = r2;
        this.root = MatrixUtils.createRealMatrix(order, r2);
        for (int i6 = 0; i6 < order; ++i6) {
            for (int j3 = 0; j3 < r2; ++j3) {
                this.root.setEntry(index[i6], j3, b2[i6][j3]);
            }
        }
    }

    public RealMatrix getRootMatrix() {
        return this.root;
    }

    public int getRank() {
        return this.rank;
    }
}

