/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.List;
import com.itextpdf.text.ListBody;
import com.itextpdf.text.ListItem;
import com.itextpdf.text.ListLabel;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.text.pdf.BidiLine;
import com.itextpdf.text.pdf.FloatLayout;
import com.itextpdf.text.pdf.PdfChunk;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfDocument;
import com.itextpdf.text.pdf.PdfFont;
import com.itextpdf.text.pdf.PdfLine;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPRow;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPTableEvent;
import com.itextpdf.text.pdf.PdfPTableEventAfterSplit;
import com.itextpdf.text.pdf.PdfPTableEventSplit;
import com.itextpdf.text.pdf.draw.DrawInterface;
import com.itextpdf.text.pdf.interfaces.IAccessibleElement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnText {
    private final Logger LOGGER = LoggerFactory.getLogger(ColumnText.class);
    public static final int AR_NOVOWEL = 1;
    public static final int AR_COMPOSEDTASHKEEL = 4;
    public static final int AR_LIG = 8;
    public static final int DIGITS_EN2AN = 32;
    public static final int DIGITS_AN2EN = 64;
    public static final int DIGITS_EN2AN_INIT_LR = 96;
    public static final int DIGITS_EN2AN_INIT_AL = 128;
    public static final int DIGIT_TYPE_AN = 0;
    public static final int DIGIT_TYPE_AN_EXTENDED = 256;
    protected int runDirection = 1;
    public static final float GLOBAL_SPACE_CHAR_RATIO = 0.0f;
    public static final int START_COLUMN = 0;
    public static final int NO_MORE_TEXT = 1;
    public static final int NO_MORE_COLUMN = 2;
    protected static final int LINE_STATUS_OK = 0;
    protected static final int LINE_STATUS_OFFLIMITS = 1;
    protected static final int LINE_STATUS_NOLINE = 2;
    protected float maxY;
    protected float minY;
    protected float leftX;
    protected float rightX;
    protected int alignment = 0;
    protected ArrayList<float[]> leftWall;
    protected ArrayList<float[]> rightWall;
    protected BidiLine bidiLine;
    protected boolean isWordSplit;
    protected float yLine;
    protected float lastX;
    protected float currentLeading = 16.0f;
    protected float fixedLeading = 16.0f;
    protected float multipliedLeading = 0.0f;
    protected PdfContentByte canvas;
    protected PdfContentByte[] canvases;
    protected int lineStatus;
    protected float indent = 0.0f;
    protected float followingIndent = 0.0f;
    protected float rightIndent = 0.0f;
    protected float extraParagraphSpace = 0.0f;
    protected float rectangularWidth = -1.0f;
    protected boolean rectangularMode = false;
    private float spaceCharRatio = 0.0f;
    private boolean lastWasNewline = true;
    private boolean repeatFirstLineIndent = true;
    private int linesWritten;
    private float firstLineY;
    private boolean firstLineYDone = false;
    private int arabicOptions = 0;
    protected float descender;
    protected boolean composite = false;
    protected ColumnText compositeColumn;
    protected LinkedList<Element> compositeElements;
    protected int listIdx = 0;
    protected int rowIdx = 0;
    private int splittedRow = -2;
    protected Phrase waitPhrase;
    private boolean useAscender = false;
    private float filledWidth;
    private boolean adjustFirstLine = true;
    private boolean inheritGraphicState = false;
    private boolean ignoreSpacingBefore = true;

    public ColumnText(PdfContentByte canvas2) {
        this.canvas = canvas2;
    }

    public static ColumnText duplicate(ColumnText org) {
        ColumnText ct = new ColumnText(null);
        ct.setACopy(org);
        return ct;
    }

    public ColumnText setACopy(ColumnText org) {
        if (org != null) {
            this.setSimpleVars(org);
            if (org.bidiLine != null) {
                this.bidiLine = new BidiLine(org.bidiLine);
            }
        }
        return this;
    }

    protected void setSimpleVars(ColumnText org) {
        this.maxY = org.maxY;
        this.minY = org.minY;
        this.alignment = org.alignment;
        this.leftWall = null;
        if (org.leftWall != null) {
            this.leftWall = new ArrayList<float[]>(org.leftWall);
        }
        this.rightWall = null;
        if (org.rightWall != null) {
            this.rightWall = new ArrayList<float[]>(org.rightWall);
        }
        this.yLine = org.yLine;
        this.currentLeading = org.currentLeading;
        this.fixedLeading = org.fixedLeading;
        this.multipliedLeading = org.multipliedLeading;
        this.canvas = org.canvas;
        this.canvases = org.canvases;
        this.lineStatus = org.lineStatus;
        this.indent = org.indent;
        this.followingIndent = org.followingIndent;
        this.rightIndent = org.rightIndent;
        this.extraParagraphSpace = org.extraParagraphSpace;
        this.rectangularWidth = org.rectangularWidth;
        this.rectangularMode = org.rectangularMode;
        this.spaceCharRatio = org.spaceCharRatio;
        this.lastWasNewline = org.lastWasNewline;
        this.repeatFirstLineIndent = org.repeatFirstLineIndent;
        this.linesWritten = org.linesWritten;
        this.arabicOptions = org.arabicOptions;
        this.runDirection = org.runDirection;
        this.descender = org.descender;
        this.composite = org.composite;
        this.splittedRow = org.splittedRow;
        if (org.composite) {
            this.compositeElements = new LinkedList();
            for (Element element : org.compositeElements) {
                if (element instanceof PdfPTable) {
                    this.compositeElements.add(new PdfPTable((PdfPTable)element));
                    continue;
                }
                this.compositeElements.add(element);
            }
            if (org.compositeColumn != null) {
                this.compositeColumn = ColumnText.duplicate(org.compositeColumn);
            }
        }
        this.listIdx = org.listIdx;
        this.rowIdx = org.rowIdx;
        this.firstLineY = org.firstLineY;
        this.leftX = org.leftX;
        this.rightX = org.rightX;
        this.firstLineYDone = org.firstLineYDone;
        this.waitPhrase = org.waitPhrase;
        this.useAscender = org.useAscender;
        this.filledWidth = org.filledWidth;
        this.adjustFirstLine = org.adjustFirstLine;
        this.inheritGraphicState = org.inheritGraphicState;
        this.ignoreSpacingBefore = org.ignoreSpacingBefore;
    }

    private void addWaitingPhrase() {
        if (this.bidiLine == null && this.waitPhrase != null) {
            this.bidiLine = new BidiLine();
            for (Chunk c2 : this.waitPhrase.getChunks()) {
                this.bidiLine.addChunk(new PdfChunk(c2, null, this.waitPhrase.getTabSettings()));
            }
            this.waitPhrase = null;
        }
    }

    public void addText(Phrase phrase) {
        if (phrase == null || this.composite) {
            return;
        }
        this.addWaitingPhrase();
        if (this.bidiLine == null) {
            this.waitPhrase = phrase;
            return;
        }
        for (Chunk element : phrase.getChunks()) {
            this.bidiLine.addChunk(new PdfChunk(element, null, phrase.getTabSettings()));
        }
    }

    public void setText(Phrase phrase) {
        this.bidiLine = null;
        this.composite = false;
        this.compositeColumn = null;
        this.compositeElements = null;
        this.listIdx = 0;
        this.rowIdx = 0;
        this.splittedRow = -1;
        this.waitPhrase = phrase;
    }

    public void addText(Chunk chunk) {
        if (chunk == null || this.composite) {
            return;
        }
        this.addText(new Phrase(chunk));
    }

    public void addElement(Element element) {
        if (element == null) {
            return;
        }
        if (element instanceof Image) {
            Image img = (Image)element;
            PdfPTable t2 = new PdfPTable(1);
            float w2 = img.getWidthPercentage();
            if (w2 == 0.0f) {
                t2.setTotalWidth(img.getScaledWidth());
                t2.setLockedWidth(true);
            } else {
                t2.setWidthPercentage(w2);
            }
            t2.setSpacingAfter(img.getSpacingAfter());
            t2.setSpacingBefore(img.getSpacingBefore());
            switch (img.getAlignment()) {
                case 0: {
                    t2.setHorizontalAlignment(0);
                    break;
                }
                case 2: {
                    t2.setHorizontalAlignment(2);
                    break;
                }
                default: {
                    t2.setHorizontalAlignment(1);
                }
            }
            PdfPCell c2 = new PdfPCell(img, true);
            c2.setPadding(0.0f);
            c2.setBorder(img.getBorder());
            c2.setBorderColor(img.getBorderColor());
            c2.setBorderWidth(img.getBorderWidth());
            c2.setBackgroundColor(img.getBackgroundColor());
            t2.addCell(c2);
            element = t2;
        }
        if (element.type() == 10) {
            element = new Paragraph((Chunk)element);
        } else if (element.type() == 11) {
            element = new Paragraph((Phrase)element);
        } else if (element.type() == 23) {
            ((PdfPTable)element).init();
        }
        if (element.type() != 12 && element.type() != 14 && element.type() != 23 && element.type() != 55 && element.type() != 37) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("element.not.allowed", new Object[0]));
        }
        if (!this.composite) {
            this.composite = true;
            this.compositeElements = new LinkedList();
            this.bidiLine = null;
            this.waitPhrase = null;
        }
        if (element.type() == 12) {
            Paragraph p2 = (Paragraph)element;
            this.compositeElements.addAll(p2.breakUp());
            return;
        }
        this.compositeElements.add(element);
    }

    public static boolean isAllowedElement(Element element) {
        int type2 = element.type();
        if (type2 == 10 || type2 == 11 || type2 == 37 || type2 == 12 || type2 == 14 || type2 == 55 || type2 == 23) {
            return true;
        }
        return element instanceof Image;
    }

    protected ArrayList<float[]> convertColumn(float[] cLine) {
        if (cLine.length < 4) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("no.valid.column.line.found", new Object[0]));
        }
        ArrayList<float[]> cc = new ArrayList<float[]>();
        for (int k2 = 0; k2 < cLine.length - 2; k2 += 2) {
            float x1 = cLine[k2];
            float y1 = cLine[k2 + 1];
            float x2 = cLine[k2 + 2];
            float y2 = cLine[k2 + 3];
            if (y1 == y2) continue;
            float a2 = (x1 - x2) / (y1 - y2);
            float b2 = x1 - a2 * y1;
            float[] r2 = new float[]{Math.min(y1, y2), Math.max(y1, y2), a2, b2};
            cc.add(r2);
            this.maxY = Math.max(this.maxY, r2[1]);
            this.minY = Math.min(this.minY, r2[0]);
        }
        if (cc.isEmpty()) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("no.valid.column.line.found", new Object[0]));
        }
        return cc;
    }

    protected float findLimitsPoint(ArrayList<float[]> wall) {
        this.lineStatus = 0;
        if (this.yLine < this.minY || this.yLine > this.maxY) {
            this.lineStatus = 1;
            return 0.0f;
        }
        for (int k2 = 0; k2 < wall.size(); ++k2) {
            float[] r2 = wall.get(k2);
            if (this.yLine < r2[0] || this.yLine > r2[1]) continue;
            return r2[2] * this.yLine + r2[3];
        }
        this.lineStatus = 2;
        return 0.0f;
    }

    protected float[] findLimitsOneLine() {
        float x1 = this.findLimitsPoint(this.leftWall);
        if (this.lineStatus == 1 || this.lineStatus == 2) {
            return null;
        }
        float x2 = this.findLimitsPoint(this.rightWall);
        if (this.lineStatus == 2) {
            return null;
        }
        return new float[]{x1, x2};
    }

    protected float[] findLimitsTwoLines() {
        float[] x2;
        float[] x1;
        boolean repeat = false;
        while (true) {
            if (repeat && this.currentLeading == 0.0f) {
                return null;
            }
            repeat = true;
            x1 = this.findLimitsOneLine();
            if (this.lineStatus == 1) {
                return null;
            }
            this.yLine -= this.currentLeading;
            if (this.lineStatus == 2) continue;
            x2 = this.findLimitsOneLine();
            if (this.lineStatus == 1) {
                return null;
            }
            if (this.lineStatus == 2) {
                this.yLine -= this.currentLeading;
                continue;
            }
            if (!(x1[0] >= x2[1]) && !(x2[0] >= x1[1])) break;
        }
        return new float[]{x1[0], x1[1], x2[0], x2[1]};
    }

    public void setColumns(float[] leftLine, float[] rightLine) {
        this.maxY = -1.0E21f;
        this.minY = 1.0E21f;
        this.setYLine(Math.max(leftLine[1], leftLine[leftLine.length - 1]));
        this.rightWall = this.convertColumn(rightLine);
        this.leftWall = this.convertColumn(leftLine);
        this.rectangularWidth = -1.0f;
        this.rectangularMode = false;
    }

    public void setSimpleColumn(Phrase phrase, float llx, float lly, float urx, float ury, float leading, int alignment) {
        this.addText(phrase);
        this.setSimpleColumn(llx, lly, urx, ury, leading, alignment);
    }

    public void setSimpleColumn(float llx, float lly, float urx, float ury, float leading, int alignment) {
        this.setLeading(leading);
        this.alignment = alignment;
        this.setSimpleColumn(llx, lly, urx, ury);
    }

    public void setSimpleColumn(float llx, float lly, float urx, float ury) {
        this.leftX = Math.min(llx, urx);
        this.maxY = Math.max(lly, ury);
        this.minY = Math.min(lly, ury);
        this.rightX = Math.max(llx, urx);
        this.yLine = this.maxY;
        this.rectangularWidth = this.rightX - this.leftX;
        if (this.rectangularWidth < 0.0f) {
            this.rectangularWidth = 0.0f;
        }
        this.rectangularMode = true;
    }

    public void setSimpleColumn(Rectangle rect) {
        this.setSimpleColumn(rect.getLeft(), rect.getBottom(), rect.getRight(), rect.getTop());
    }

    public void setLeading(float leading) {
        this.fixedLeading = leading;
        this.multipliedLeading = 0.0f;
    }

    public void setLeading(float fixedLeading, float multipliedLeading) {
        this.fixedLeading = fixedLeading;
        this.multipliedLeading = multipliedLeading;
    }

    public float getLeading() {
        return this.fixedLeading;
    }

    public float getMultipliedLeading() {
        return this.multipliedLeading;
    }

    public void setYLine(float yLine) {
        this.yLine = yLine;
    }

    public float getYLine() {
        return this.yLine;
    }

    public int getRowsDrawn() {
        return this.rowIdx;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setIndent(float indent) {
        this.setIndent(indent, true);
    }

    public void setIndent(float indent, boolean repeatFirstLineIndent) {
        this.indent = indent;
        this.lastWasNewline = true;
        this.repeatFirstLineIndent = repeatFirstLineIndent;
    }

    public float getIndent() {
        return this.indent;
    }

    public void setFollowingIndent(float indent) {
        this.followingIndent = indent;
        this.lastWasNewline = true;
    }

    public float getFollowingIndent() {
        return this.followingIndent;
    }

    public void setRightIndent(float indent) {
        this.rightIndent = indent;
        this.lastWasNewline = true;
    }

    public float getRightIndent() {
        return this.rightIndent;
    }

    public float getCurrentLeading() {
        return this.currentLeading;
    }

    public boolean getInheritGraphicState() {
        return this.inheritGraphicState;
    }

    public void setInheritGraphicState(boolean inheritGraphicState) {
        this.inheritGraphicState = inheritGraphicState;
    }

    public boolean isIgnoreSpacingBefore() {
        return this.ignoreSpacingBefore;
    }

    public void setIgnoreSpacingBefore(boolean ignoreSpacingBefore) {
        this.ignoreSpacingBefore = ignoreSpacingBefore;
    }

    public int go() throws DocumentException {
        return this.go(false);
    }

    public int go(boolean simulate) throws DocumentException {
        return this.go(simulate, null);
    }

    public int go(boolean simulate, IAccessibleElement elementToGo) throws DocumentException {
        this.isWordSplit = false;
        if (this.composite) {
            return this.goComposite(simulate);
        }
        ListBody lBody = null;
        if (ColumnText.isTagged(this.canvas) && elementToGo instanceof ListItem) {
            lBody = ((ListItem)elementToGo).getListBody();
        }
        this.addWaitingPhrase();
        if (this.bidiLine == null) {
            return 1;
        }
        this.descender = 0.0f;
        this.linesWritten = 0;
        this.lastX = 0.0f;
        boolean dirty2 = false;
        float ratio = this.spaceCharRatio;
        Object[] currentValues = new Object[2];
        PdfFont currentFont = null;
        Float lastBaseFactor = new Float(0.0f);
        currentValues[1] = lastBaseFactor;
        PdfDocument pdf = null;
        PdfContentByte graphics = null;
        PdfContentByte text2 = null;
        this.firstLineY = Float.NaN;
        int localRunDirection = this.runDirection;
        if (this.canvas != null) {
            graphics = this.canvas;
            pdf = this.canvas.getPdfDocument();
            text2 = !ColumnText.isTagged(this.canvas) ? this.canvas.getDuplicate(this.inheritGraphicState) : this.canvas;
        } else if (!simulate) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("columntext.go.with.simulate.eq.eq.false.and.text.eq.eq.null", new Object[0]));
        }
        if (!simulate) {
            if (ratio == 0.0f) {
                ratio = text2.getPdfWriter().getSpaceCharRatio();
            } else if (ratio < 0.001f) {
                ratio = 0.001f;
            }
        }
        if (!this.rectangularMode) {
            float max = 0.0f;
            for (PdfChunk c2 : this.bidiLine.chunks) {
                max = Math.max(max, c2.height());
            }
            this.currentLeading = this.fixedLeading + max * this.multipliedLeading;
        }
        float firstIndent = 0.0f;
        int status = 0;
        boolean rtl = false;
        while (true) {
            float x1;
            PdfLine line2;
            float f2 = firstIndent = this.lastWasNewline ? this.indent : this.followingIndent;
            if (this.rectangularMode) {
                if (this.rectangularWidth <= firstIndent + this.rightIndent) {
                    status = 2;
                    if (!this.bidiLine.isEmpty()) break;
                    status |= 1;
                    break;
                }
                if (this.bidiLine.isEmpty()) {
                    status = 1;
                    break;
                }
                line2 = this.bidiLine.processLine(this.leftX, this.rectangularWidth - firstIndent - this.rightIndent, this.alignment, localRunDirection, this.arabicOptions, this.minY, this.yLine, this.descender);
                this.isWordSplit |= this.bidiLine.isWordSplit();
                if (line2 == null) {
                    status = 1;
                    break;
                }
                float[] maxSize = line2.getMaxSize(this.fixedLeading, this.multipliedLeading);
                this.currentLeading = this.isUseAscender() && Float.isNaN(this.firstLineY) ? line2.getAscender() : Math.max(maxSize[0], maxSize[1] - this.descender);
                if (this.yLine > this.maxY || this.yLine - this.currentLeading < this.minY) {
                    status = 2;
                    this.bidiLine.restore();
                    break;
                }
                this.yLine -= this.currentLeading;
                if (!simulate && !dirty2) {
                    if (line2.isRTL && this.canvas.isTagged()) {
                        this.canvas.beginMarkedContentSequence(PdfName.REVERSEDCHARS);
                        rtl = true;
                    }
                    text2.beginText();
                    dirty2 = true;
                }
                if (Float.isNaN(this.firstLineY)) {
                    this.firstLineY = this.yLine;
                }
                this.updateFilledWidth(this.rectangularWidth - line2.widthLeft());
                x1 = this.leftX;
            } else {
                float yTemp = this.yLine - this.currentLeading;
                float[] xx = this.findLimitsTwoLines();
                if (xx == null) {
                    status = 2;
                    if (this.bidiLine.isEmpty()) {
                        status |= 1;
                    }
                    this.yLine = yTemp;
                    break;
                }
                if (this.bidiLine.isEmpty()) {
                    status = 1;
                    this.yLine = yTemp;
                    break;
                }
                x1 = Math.max(xx[0], xx[2]);
                float x2 = Math.min(xx[1], xx[3]);
                if (x2 - x1 <= firstIndent + this.rightIndent) continue;
                line2 = this.bidiLine.processLine(x1, x2 - x1 - firstIndent - this.rightIndent, this.alignment, localRunDirection, this.arabicOptions, this.minY, this.yLine, this.descender);
                if (!simulate && !dirty2) {
                    if (line2.isRTL && this.canvas.isTagged()) {
                        this.canvas.beginMarkedContentSequence(PdfName.REVERSEDCHARS);
                        rtl = true;
                    }
                    text2.beginText();
                    dirty2 = true;
                }
                if (line2 == null) {
                    status = 1;
                    this.yLine = yTemp;
                    break;
                }
            }
            if (ColumnText.isTagged(this.canvas) && elementToGo instanceof ListItem && !Float.isNaN(this.firstLineY) && !this.firstLineYDone) {
                if (!simulate) {
                    ListLabel lbl = ((ListItem)elementToGo).getListLabel();
                    this.canvas.openMCBlock(lbl);
                    Chunk symbol = new Chunk(((ListItem)elementToGo).getListSymbol());
                    symbol.setRole(null);
                    ColumnText.showTextAligned(this.canvas, 0, new Phrase(symbol), this.leftX + lbl.getIndentation(), this.firstLineY, 0.0f);
                    this.canvas.closeMCBlock(lbl);
                }
                this.firstLineYDone = true;
            }
            if (!simulate) {
                if (lBody != null) {
                    this.canvas.openMCBlock(lBody);
                    lBody = null;
                }
                currentValues[0] = currentFont;
                text2.setTextMatrix(x1 + (line2.isRTL() ? this.rightIndent : firstIndent) + line2.indentLeft(), this.yLine);
                this.lastX = pdf.writeLineToContent(line2, text2, graphics, currentValues, ratio);
                currentFont = (PdfFont)currentValues[0];
            }
            this.lastWasNewline = this.repeatFirstLineIndent && line2.isNewlineSplit();
            this.yLine -= line2.isNewlineSplit() ? this.extraParagraphSpace : 0.0f;
            ++this.linesWritten;
            this.descender = line2.getDescender();
        }
        if (dirty2) {
            text2.endText();
            if (this.canvas != text2) {
                this.canvas.add(text2);
            }
            if (rtl && this.canvas.isTagged()) {
                this.canvas.endMarkedContentSequence();
            }
        }
        return status;
    }

    public boolean isWordSplit() {
        return this.isWordSplit;
    }

    public float getExtraParagraphSpace() {
        return this.extraParagraphSpace;
    }

    public void setExtraParagraphSpace(float extraParagraphSpace) {
        this.extraParagraphSpace = extraParagraphSpace;
    }

    public void clearChunks() {
        if (this.bidiLine != null) {
            this.bidiLine.clearChunks();
        }
    }

    public float getSpaceCharRatio() {
        return this.spaceCharRatio;
    }

    public void setSpaceCharRatio(float spaceCharRatio) {
        this.spaceCharRatio = spaceCharRatio;
    }

    public void setRunDirection(int runDirection) {
        if (runDirection < 0 || runDirection > 3) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("invalid.run.direction.1", runDirection));
        }
        this.runDirection = runDirection;
    }

    public int getRunDirection() {
        return this.runDirection;
    }

    public int getLinesWritten() {
        return this.linesWritten;
    }

    public float getLastX() {
        return this.lastX;
    }

    public int getArabicOptions() {
        return this.arabicOptions;
    }

    public void setArabicOptions(int arabicOptions) {
        this.arabicOptions = arabicOptions;
    }

    public float getDescender() {
        return this.descender;
    }

    public static float getWidth(Phrase phrase, int runDirection, int arabicOptions) {
        ColumnText ct = new ColumnText(null);
        ct.addText(phrase);
        ct.addWaitingPhrase();
        PdfLine line2 = ct.bidiLine.processLine(0.0f, 20000.0f, 0, runDirection, arabicOptions, 0.0f, 0.0f, 0.0f);
        if (line2 == null) {
            return 0.0f;
        }
        return 20000.0f - line2.widthLeft();
    }

    public static float getWidth(Phrase phrase) {
        return ColumnText.getWidth(phrase, 1, 0);
    }

    public static void showTextAligned(PdfContentByte canvas2, int alignment, Phrase phrase, float x2, float y2, float rotation, int runDirection, int arabicOptions) {
        float urx;
        float llx;
        if (alignment != 0 && alignment != 1 && alignment != 2) {
            alignment = 0;
        }
        canvas2.saveState();
        ColumnText ct = new ColumnText(canvas2);
        float lly = -1.0f;
        float ury = 2.0f;
        switch (alignment) {
            case 0: {
                llx = 0.0f;
                urx = 20000.0f;
                break;
            }
            case 2: {
                llx = -20000.0f;
                urx = 0.0f;
                break;
            }
            default: {
                llx = -20000.0f;
                urx = 20000.0f;
            }
        }
        if (rotation == 0.0f) {
            llx += x2;
            lly += y2;
            urx += x2;
            ury += y2;
        } else {
            double alpha = (double)rotation * Math.PI / 180.0;
            float cos = (float)Math.cos(alpha);
            float sin = (float)Math.sin(alpha);
            canvas2.concatCTM(cos, sin, -sin, cos, x2, y2);
        }
        ct.setSimpleColumn(phrase, llx, lly, urx, ury, 2.0f, alignment);
        if (runDirection == 3) {
            if (alignment == 0) {
                alignment = 2;
            } else if (alignment == 2) {
                alignment = 0;
            }
        }
        ct.setAlignment(alignment);
        ct.setArabicOptions(arabicOptions);
        ct.setRunDirection(runDirection);
        try {
            ct.go();
        }
        catch (DocumentException e2) {
            throw new ExceptionConverter(e2);
        }
        canvas2.restoreState();
    }

    public static void showTextAligned(PdfContentByte canvas2, int alignment, Phrase phrase, float x2, float y2, float rotation) {
        ColumnText.showTextAligned(canvas2, alignment, phrase, x2, y2, rotation, 1, 0);
    }

    public static float fitText(Font font, String text2, Rectangle rect, float maxFontSize, int runDirection) {
        try {
            ColumnText ct = null;
            int status = 0;
            if (maxFontSize <= 0.0f) {
                int cr = 0;
                int lf = 0;
                char[] t2 = text2.toCharArray();
                for (int k2 = 0; k2 < t2.length; ++k2) {
                    if (t2[k2] == '\n') {
                        ++lf;
                        continue;
                    }
                    if (t2[k2] != '\r') continue;
                    ++cr;
                }
                int minLines = Math.max(cr, lf) + 1;
                maxFontSize = Math.abs(rect.getHeight()) / (float)minLines - 0.001f;
            }
            font.setSize(maxFontSize);
            Phrase ph = new Phrase(text2, font);
            ct = new ColumnText(null);
            ct.setSimpleColumn(ph, rect.getLeft(), rect.getBottom(), rect.getRight(), rect.getTop(), maxFontSize, 0);
            ct.setRunDirection(runDirection);
            status = ct.go(true);
            if ((status & 1) != 0) {
                return maxFontSize;
            }
            float precision = 0.1f;
            float min = 0.0f;
            float max = maxFontSize;
            float size = maxFontSize;
            for (int k3 = 0; k3 < 50; ++k3) {
                size = (min + max) / 2.0f;
                ct = new ColumnText(null);
                font.setSize(size);
                ct.setSimpleColumn(new Phrase(text2, font), rect.getLeft(), rect.getBottom(), rect.getRight(), rect.getTop(), size, 0);
                ct.setRunDirection(runDirection);
                status = ct.go(true);
                if ((status & 1) != 0) {
                    if (max - min < size * precision) {
                        return size;
                    }
                    min = size;
                    continue;
                }
                max = size;
            }
            return size;
        }
        catch (Exception e2) {
            throw new ExceptionConverter(e2);
        }
    }

    protected int goComposite(boolean simulate) throws DocumentException {
        boolean isRTL;
        PdfDocument pdf = null;
        if (this.canvas != null) {
            pdf = this.canvas.pdf;
        }
        if (!this.rectangularMode) {
            throw new DocumentException(MessageLocalization.getComposedMessage("irregular.columns.are.not.supported.in.composite.mode", new Object[0]));
        }
        this.linesWritten = 0;
        this.descender = 0.0f;
        boolean firstPass = true;
        boolean bl = isRTL = this.runDirection == 3;
        while (!this.compositeElements.isEmpty()) {
            Element element = this.compositeElements.getFirst();
            if (element.type() == 12) {
                Paragraph para = (Paragraph)element;
                int status = 0;
                for (int keep = 0; keep < 2; ++keep) {
                    boolean s2;
                    float lastY = this.yLine;
                    boolean createHere = false;
                    if (this.compositeColumn == null) {
                        this.compositeColumn = new ColumnText(this.canvas);
                        this.compositeColumn.setAlignment(para.getAlignment());
                        this.compositeColumn.setIndent(para.getIndentationLeft() + para.getFirstLineIndent(), false);
                        this.compositeColumn.setExtraParagraphSpace(para.getExtraParagraphSpace());
                        this.compositeColumn.setFollowingIndent(para.getIndentationLeft());
                        this.compositeColumn.setRightIndent(para.getIndentationRight());
                        this.compositeColumn.setLeading(para.getLeading(), para.getMultipliedLeading());
                        this.compositeColumn.setRunDirection(this.runDirection);
                        this.compositeColumn.setArabicOptions(this.arabicOptions);
                        this.compositeColumn.setSpaceCharRatio(this.spaceCharRatio);
                        this.compositeColumn.addText(para);
                        if (!firstPass || !this.adjustFirstLine) {
                            this.yLine -= para.getSpacingBefore();
                        }
                        createHere = true;
                    }
                    this.compositeColumn.setUseAscender((firstPass || this.descender == 0.0f) && this.adjustFirstLine ? this.useAscender : false);
                    this.compositeColumn.setInheritGraphicState(this.inheritGraphicState);
                    this.compositeColumn.leftX = this.leftX;
                    this.compositeColumn.rightX = this.rightX;
                    this.compositeColumn.yLine = this.yLine;
                    this.compositeColumn.rectangularWidth = this.rectangularWidth;
                    this.compositeColumn.rectangularMode = this.rectangularMode;
                    this.compositeColumn.minY = this.minY;
                    this.compositeColumn.maxY = this.maxY;
                    boolean keepCandidate = para.getKeepTogether() && createHere && (!firstPass || !this.adjustFirstLine);
                    boolean bl2 = s2 = simulate || keepCandidate && keep == 0;
                    if (ColumnText.isTagged(this.canvas) && !s2) {
                        this.canvas.openMCBlock(para);
                    }
                    status = this.compositeColumn.go(s2);
                    if (ColumnText.isTagged(this.canvas) && !s2) {
                        this.canvas.closeMCBlock(para);
                    }
                    this.lastX = this.compositeColumn.getLastX();
                    this.updateFilledWidth(this.compositeColumn.filledWidth);
                    if ((status & 1) == 0 && keepCandidate) {
                        this.compositeColumn = null;
                        this.yLine = lastY;
                        return 2;
                    }
                    if (simulate || !keepCandidate) break;
                    if (keep != 0) continue;
                    this.compositeColumn = null;
                    this.yLine = lastY;
                }
                firstPass = false;
                if (this.compositeColumn.getLinesWritten() > 0) {
                    this.yLine = this.compositeColumn.yLine;
                    this.linesWritten += this.compositeColumn.linesWritten;
                    this.descender = this.compositeColumn.descender;
                    this.isWordSplit |= this.compositeColumn.isWordSplit();
                }
                this.currentLeading = this.compositeColumn.currentLeading;
                if (status & true) {
                    this.compositeColumn = null;
                    this.compositeElements.removeFirst();
                    this.yLine -= para.getSpacingAfter();
                }
                if ((status & 2) == 0) continue;
                return 2;
            }
            if (element.type() == 14) {
                List list2 = (List)element;
                ArrayList<Element> items = list2.getItems();
                ListItem item2 = null;
                float listIndentation = list2.getIndentationLeft();
                int count = 0;
                Stack<Object[]> stack = new Stack<Object[]>();
                for (int k2 = 0; k2 < items.size(); ++k2) {
                    Element obj = items.get(k2);
                    if (obj instanceof ListItem) {
                        if (count == this.listIdx) {
                            item2 = (ListItem)obj;
                            break;
                        }
                        ++count;
                    } else if (obj instanceof List) {
                        stack.push(new Object[]{list2, k2, new Float(listIndentation)});
                        list2 = (List)obj;
                        items = list2.getItems();
                        listIndentation += list2.getIndentationLeft();
                        k2 = -1;
                        continue;
                    }
                    while (k2 == items.size() - 1 && !stack.isEmpty()) {
                        Object[] objs = (Object[])stack.pop();
                        list2 = (List)objs[0];
                        items = list2.getItems();
                        k2 = (Integer)objs[1];
                        listIndentation = ((Float)objs[2]).floatValue();
                    }
                }
                int status = 0;
                boolean keepTogetherAndDontFit = false;
                for (int keep = 0; keep < 2; ++keep) {
                    boolean s3;
                    float lastY = this.yLine;
                    boolean createHere = false;
                    if (this.compositeColumn == null) {
                        if (item2 == null) {
                            this.listIdx = 0;
                            this.compositeElements.removeFirst();
                            break;
                        }
                        this.compositeColumn = new ColumnText(this.canvas);
                        this.compositeColumn.setUseAscender((firstPass || this.descender == 0.0f) && this.adjustFirstLine ? this.useAscender : false);
                        this.compositeColumn.setInheritGraphicState(this.inheritGraphicState);
                        this.compositeColumn.setAlignment(item2.getAlignment());
                        this.compositeColumn.setIndent(item2.getIndentationLeft() + listIndentation + item2.getFirstLineIndent(), false);
                        this.compositeColumn.setExtraParagraphSpace(item2.getExtraParagraphSpace());
                        this.compositeColumn.setFollowingIndent(this.compositeColumn.getIndent());
                        this.compositeColumn.setRightIndent(item2.getIndentationRight() + list2.getIndentationRight());
                        this.compositeColumn.setLeading(item2.getLeading(), item2.getMultipliedLeading());
                        this.compositeColumn.setRunDirection(this.runDirection);
                        this.compositeColumn.setArabicOptions(this.arabicOptions);
                        this.compositeColumn.setSpaceCharRatio(this.spaceCharRatio);
                        this.compositeColumn.addText(item2);
                        if (!firstPass || !this.adjustFirstLine) {
                            this.yLine -= item2.getSpacingBefore();
                        }
                        createHere = true;
                    }
                    this.compositeColumn.leftX = this.leftX;
                    this.compositeColumn.rightX = this.rightX;
                    this.compositeColumn.yLine = this.yLine;
                    this.compositeColumn.rectangularWidth = this.rectangularWidth;
                    this.compositeColumn.rectangularMode = this.rectangularMode;
                    this.compositeColumn.minY = this.minY;
                    this.compositeColumn.maxY = this.maxY;
                    boolean keepCandidate = item2.getKeepTogether() && createHere && (!firstPass || !this.adjustFirstLine);
                    boolean bl3 = s3 = simulate || keepCandidate && keep == 0;
                    if (ColumnText.isTagged(this.canvas) && !s3) {
                        item2.getListLabel().setIndentation(listIndentation);
                        if (list2.getFirstItem() == item2 || this.compositeColumn != null && this.compositeColumn.bidiLine != null) {
                            this.canvas.openMCBlock(list2);
                        }
                        this.canvas.openMCBlock(item2);
                    }
                    status = this.compositeColumn.go(s3, item2);
                    if (ColumnText.isTagged(this.canvas) && !s3) {
                        this.canvas.closeMCBlock(item2.getListBody());
                        this.canvas.closeMCBlock(item2);
                    }
                    this.lastX = this.compositeColumn.getLastX();
                    this.updateFilledWidth(this.compositeColumn.filledWidth);
                    if ((status & 1) == 0 && keepCandidate) {
                        keepTogetherAndDontFit = true;
                        this.compositeColumn = null;
                        this.yLine = lastY;
                    }
                    if (simulate || !keepCandidate || keepTogetherAndDontFit) break;
                    if (keep != 0) continue;
                    this.compositeColumn = null;
                    this.yLine = lastY;
                }
                if (ColumnText.isTagged(this.canvas) && !simulate && (item2 == null || list2.getLastItem() == item2 && status & true || (status & 2) != 0)) {
                    this.canvas.closeMCBlock(list2);
                }
                if (keepTogetherAndDontFit) {
                    return 2;
                }
                if (item2 == null) continue;
                firstPass = false;
                this.yLine = this.compositeColumn.yLine;
                this.linesWritten += this.compositeColumn.linesWritten;
                this.descender = this.compositeColumn.descender;
                this.currentLeading = this.compositeColumn.currentLeading;
                if (!(ColumnText.isTagged(this.canvas) || Float.isNaN(this.compositeColumn.firstLineY) || this.compositeColumn.firstLineYDone)) {
                    if (!simulate) {
                        if (isRTL) {
                            ColumnText.showTextAligned(this.canvas, 2, new Phrase(item2.getListSymbol()), this.compositeColumn.lastX + item2.getIndentationLeft(), this.compositeColumn.firstLineY, 0.0f, this.runDirection, this.arabicOptions);
                        } else {
                            ColumnText.showTextAligned(this.canvas, 0, new Phrase(item2.getListSymbol()), this.compositeColumn.leftX + listIndentation, this.compositeColumn.firstLineY, 0.0f);
                        }
                    }
                    this.compositeColumn.firstLineYDone = true;
                }
                if ((status & 1) != 0) {
                    this.compositeColumn = null;
                    ++this.listIdx;
                    this.yLine -= item2.getSpacingAfter();
                }
                if ((status & 2) == 0) continue;
                return 2;
            }
            if (element.type() == 23) {
                ArrayList<PdfPRow> rows;
                int kTemp;
                boolean skipHeader;
                float tableWidth;
                PdfPTable table = (PdfPTable)element;
                int backedUpRunDir = this.runDirection;
                this.runDirection = table.getRunDirection();
                boolean bl4 = isRTL = this.runDirection == 3;
                if (table.size() <= table.getHeaderRows()) {
                    this.compositeElements.removeFirst();
                    continue;
                }
                float yTemp = this.yLine;
                yTemp += this.descender;
                if (this.rowIdx == 0 && this.adjustFirstLine) {
                    yTemp -= table.spacingBefore();
                }
                if (yTemp < this.minY || yTemp > this.maxY) {
                    return 2;
                }
                float yLineWrite = yTemp;
                float x1 = this.leftX;
                this.currentLeading = 0.0f;
                if (table.isLockedWidth()) {
                    tableWidth = table.getTotalWidth();
                    this.updateFilledWidth(tableWidth);
                } else {
                    tableWidth = this.rectangularWidth * table.getWidthPercentage() / 100.0f;
                    table.setTotalWidth(tableWidth);
                }
                table.normalizeHeadersFooters();
                int headerRows = table.getHeaderRows();
                int footerRows = table.getFooterRows();
                int realHeaderRows = headerRows - footerRows;
                float footerHeight = table.getFooterHeight();
                float headerHeight = table.getHeaderHeight() - footerHeight;
                boolean bl5 = skipHeader = table.isSkipFirstHeader() && this.rowIdx <= realHeaderRows && (table.isComplete() || this.rowIdx != realHeaderRows);
                if (!skipHeader) {
                    yTemp -= headerHeight;
                }
                int k3 = 0;
                if (this.rowIdx < headerRows) {
                    this.rowIdx = headerRows;
                }
                PdfPTable.FittingRows fittingRows = null;
                if (table.isSkipLastFooter()) {
                    fittingRows = table.getFittingRows(yTemp - this.minY, this.rowIdx);
                }
                if (!table.isSkipLastFooter() || fittingRows.lastRow < table.size() - 1) {
                    fittingRows = table.getFittingRows((yTemp -= footerHeight) - this.minY, this.rowIdx);
                }
                if (yTemp < this.minY || yTemp > this.maxY) {
                    return 2;
                }
                k3 = fittingRows.lastRow + 1;
                yTemp -= fittingRows.height;
                this.LOGGER.info("Want to split at row " + k3);
                for (kTemp = k3; kTemp > this.rowIdx && kTemp < table.size() && table.getRow(kTemp).isMayNotBreak(); --kTemp) {
                }
                if (kTemp < table.size() - 1 && !table.getRow(kTemp).isMayNotBreak()) {
                    ++kTemp;
                }
                if (kTemp > this.rowIdx && kTemp < k3 || kTemp == headerRows && table.getRow(headerRows).isMayNotBreak() && table.isLoopCheck()) {
                    yTemp = this.minY;
                    k3 = kTemp;
                    table.setLoopCheck(false);
                }
                this.LOGGER.info("Will split at row " + k3);
                if (table.isSplitLate() && k3 > 0) {
                    fittingRows.correctLastRowChosen(table, k3 - 1);
                }
                if (!table.isComplete()) {
                    yTemp += footerHeight;
                }
                if (!table.isSplitRows()) {
                    if (this.splittedRow != -1) {
                        this.splittedRow = -1;
                    } else if (k3 == this.rowIdx) {
                        if (k3 == table.size()) {
                            this.compositeElements.removeFirst();
                            continue;
                        }
                        if (table.isComplete() || k3 != 1) {
                            table.getRows().remove(k3);
                        }
                        return 2;
                    }
                } else if (table.isSplitLate() && (this.rowIdx < k3 || this.splittedRow == -2 && (table.getHeaderRows() == 0 || table.isSkipFirstHeader()))) {
                    this.splittedRow = -1;
                } else if (k3 < table.size()) {
                    float h2 = (yTemp -= fittingRows.completedRowsHeight - fittingRows.height) - this.minY;
                    PdfPRow newRow = table.getRow(k3).splitRow(table, k3, h2);
                    if (newRow == null) {
                        this.LOGGER.info("Didn't split row!");
                        this.splittedRow = -1;
                        if (this.rowIdx == k3) {
                            return 2;
                        }
                    } else {
                        if (k3 != this.splittedRow) {
                            this.splittedRow = k3 + 1;
                            table = new PdfPTable(table);
                            this.compositeElements.set(0, table);
                            rows = table.getRows();
                            for (int i2 = headerRows; i2 < this.rowIdx; ++i2) {
                                rows.set(i2, null);
                            }
                        }
                        yTemp = this.minY;
                        table.getRows().add(++k3, newRow);
                        this.LOGGER.info("Inserting row at position " + k3);
                    }
                }
                firstPass = false;
                if (!simulate) {
                    switch (table.getHorizontalAlignment()) {
                        case 2: {
                            if (isRTL) break;
                            x1 += this.rectangularWidth - tableWidth;
                            break;
                        }
                        case 1: {
                            x1 += (this.rectangularWidth - tableWidth) / 2.0f;
                            break;
                        }
                        default: {
                            if (!isRTL) break;
                            x1 += this.rectangularWidth - tableWidth;
                        }
                    }
                    PdfPTable nt = PdfPTable.shallowCopy(table);
                    ArrayList<PdfPRow> sub = nt.getRows();
                    if (!skipHeader && realHeaderRows > 0) {
                        rows = table.getRows(0, realHeaderRows);
                        if (ColumnText.isTagged(this.canvas)) {
                            nt.getHeader().rows = rows;
                        }
                        sub.addAll(rows);
                    } else {
                        nt.setHeaderRows(footerRows);
                    }
                    rows = table.getRows(this.rowIdx, k3);
                    if (ColumnText.isTagged(this.canvas)) {
                        nt.getBody().rows = rows;
                    }
                    sub.addAll(rows);
                    boolean showFooter = !table.isSkipLastFooter();
                    boolean newPageFollows = false;
                    if (k3 < table.size()) {
                        nt.setComplete(true);
                        showFooter = true;
                        newPageFollows = true;
                    }
                    if (footerRows > 0 && nt.isComplete() && showFooter) {
                        ArrayList<PdfPRow> rows2 = table.getRows(realHeaderRows, realHeaderRows + footerRows);
                        if (ColumnText.isTagged(this.canvas)) {
                            nt.getFooter().rows = rows2;
                        }
                        sub.addAll(rows2);
                    } else {
                        footerRows = 0;
                    }
                    if (sub.size() - footerRows > 0) {
                        PdfPTableEvent tableEvent;
                        float rowHeight = 0.0f;
                        int lastIdx = sub.size() - 1 - footerRows;
                        PdfPRow last = sub.get(lastIdx);
                        if (table.isExtendLastRow(newPageFollows)) {
                            rowHeight = last.getMaxHeights();
                            last.setMaxHeights(yTemp - this.minY + rowHeight);
                            yTemp = this.minY;
                        }
                        if (newPageFollows && (tableEvent = table.getTableEvent()) instanceof PdfPTableEventSplit) {
                            ((PdfPTableEventSplit)tableEvent).splitTable(table);
                        }
                        if (this.canvases != null) {
                            if (ColumnText.isTagged(this.canvases[3])) {
                                this.canvases[3].openMCBlock(table);
                            }
                            nt.writeSelectedRows(0, -1, 0, -1, x1, yLineWrite, this.canvases, false);
                            if (ColumnText.isTagged(this.canvases[3])) {
                                this.canvases[3].closeMCBlock(table);
                            }
                        } else {
                            if (ColumnText.isTagged(this.canvas)) {
                                this.canvas.openMCBlock(table);
                            }
                            nt.writeSelectedRows(0, -1, 0, -1, x1, yLineWrite, this.canvas, false);
                            if (ColumnText.isTagged(this.canvas)) {
                                this.canvas.closeMCBlock(table);
                            }
                        }
                        if (!table.isComplete()) {
                            table.addNumberOfRowsWritten(k3);
                        }
                        if (this.splittedRow == k3 && k3 < table.size()) {
                            PdfPRow splitted = table.getRows().get(k3);
                            splitted.copyRowContent(nt, lastIdx);
                        } else if (k3 > 0 && k3 < table.size()) {
                            PdfPRow row2 = table.getRow(k3);
                            row2.splitRowspans(table, k3 - 1, nt, lastIdx);
                        }
                        if (table.isExtendLastRow(newPageFollows)) {
                            last.setMaxHeights(rowHeight);
                        }
                        if (newPageFollows && (tableEvent = table.getTableEvent()) instanceof PdfPTableEventAfterSplit) {
                            PdfPRow row3 = table.getRow(k3);
                            ((PdfPTableEventAfterSplit)tableEvent).afterSplitTable(table, row3, k3);
                        }
                    }
                } else if (table.isExtendLastRow() && this.minY > -1.0737418E9f) {
                    yTemp = this.minY;
                }
                this.yLine = yTemp;
                this.descender = 0.0f;
                this.currentLeading = 0.0f;
                if (!skipHeader && !table.isComplete()) {
                    this.yLine += footerHeight;
                }
                while (k3 < table.size() && !(table.getRowHeight(k3) > 0.0f) && !table.hasRowspan(k3)) {
                    ++k3;
                }
                if (k3 >= table.size()) {
                    this.yLine = this.yLine - table.spacingAfter() < this.minY ? this.minY : (this.yLine -= table.spacingAfter());
                } else {
                    if (this.splittedRow > -1) {
                        ArrayList<PdfPRow> rows3 = table.getRows();
                        for (int i3 = this.rowIdx; i3 < k3; ++i3) {
                            rows3.set(i3, null);
                        }
                    }
                    this.rowIdx = k3;
                    return 2;
                }
                this.compositeElements.removeFirst();
                this.splittedRow = -1;
                this.rowIdx = 0;
                this.runDirection = backedUpRunDir;
                isRTL = this.runDirection == 3;
                continue;
            }
            if (element.type() == 55) {
                if (!simulate) {
                    DrawInterface zh = (DrawInterface)((Object)element);
                    zh.draw(this.canvas, this.leftX, this.minY, this.rightX, this.maxY, this.yLine);
                }
                this.compositeElements.removeFirst();
                continue;
            }
            if (element.type() == 37) {
                ArrayList<Element> floatingElements = new ArrayList<Element>();
                do {
                    floatingElements.add(element);
                    this.compositeElements.removeFirst();
                    Element element2 = element = !this.compositeElements.isEmpty() ? this.compositeElements.getFirst() : null;
                } while (element != null && element.type() == 37);
                FloatLayout fl = new FloatLayout(floatingElements, this.useAscender);
                fl.setSimpleColumn(this.leftX, this.minY, this.rightX, this.yLine);
                fl.compositeColumn.setIgnoreSpacingBefore(this.isIgnoreSpacingBefore());
                int status = fl.layout(this.canvas, simulate);
                this.yLine = fl.getYLine();
                this.descender = 0.0f;
                if ((status & 1) != 0) continue;
                this.compositeElements.addAll(floatingElements);
                return status;
            }
            this.compositeElements.removeFirst();
        }
        return 1;
    }

    public PdfContentByte getCanvas() {
        return this.canvas;
    }

    public void setCanvas(PdfContentByte canvas2) {
        this.canvas = canvas2;
        this.canvases = null;
        if (this.compositeColumn != null) {
            this.compositeColumn.setCanvas(canvas2);
        }
    }

    public void setCanvases(PdfContentByte[] canvases) {
        this.canvases = canvases;
        this.canvas = canvases[3];
        if (this.compositeColumn != null) {
            this.compositeColumn.setCanvases(canvases);
        }
    }

    public PdfContentByte[] getCanvases() {
        return this.canvases;
    }

    public boolean zeroHeightElement() {
        return this.composite && !this.compositeElements.isEmpty() && this.compositeElements.getFirst().type() == 55;
    }

    public java.util.List<Element> getCompositeElements() {
        return this.compositeElements;
    }

    public boolean isUseAscender() {
        return this.useAscender;
    }

    public void setUseAscender(boolean useAscender) {
        this.useAscender = useAscender;
    }

    public static boolean hasMoreText(int status) {
        return (status & 1) == 0;
    }

    public float getFilledWidth() {
        return this.filledWidth;
    }

    public void setFilledWidth(float filledWidth) {
        this.filledWidth = filledWidth;
    }

    public void updateFilledWidth(float w2) {
        if (w2 > this.filledWidth) {
            this.filledWidth = w2;
        }
    }

    public boolean isAdjustFirstLine() {
        return this.adjustFirstLine;
    }

    public void setAdjustFirstLine(boolean adjustFirstLine) {
        this.adjustFirstLine = adjustFirstLine;
    }

    private static boolean isTagged(PdfContentByte canvas2) {
        return canvas2 != null && canvas2.pdf != null && canvas2.writer != null && canvas2.writer.isTagged();
    }
}

