/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import com.sun.istack.Nullable;
import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.graupner.HoTTAdapter;
import gde.device.graupner.HoTTbinReader2;
import gde.device.graupner.HoTTlogReader;
import gde.device.graupner.PackageLoss;
import gde.exception.DataInconsitsentException;
import gde.exception.DataTypeException;
import gde.io.DataParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.menu.MenuToolBar;
import gde.utils.StringHelper;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.file.Paths;
import java.security.InvalidParameterException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HoTTbinReader {
    static final String $CLASS_NAME = HoTTbinReader.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    protected static final int LOG_RECORD_SCAN_START = 4000;
    protected static final int NUMBER_LOG_RECORDS_TO_SCAN = 1500;
    protected static final int NUMBER_LOG_RECORDS_MIN = 7000;
    static final DataExplorer application = DataExplorer.getInstance();
    static final Channels channels = Channels.getInstance();
    static int dataBlockSize = 64;
    static byte[] buf;
    static byte[] buf0;
    static byte[] buf1;
    static byte[] buf2;
    static byte[] buf3;
    static byte[] buf4;
    static byte[] buf5;
    static byte[] buf6;
    static byte[] buf7;
    static byte[] buf8;
    static byte[] buf9;
    static byte[] bufA;
    static byte[] bufB;
    static byte[] bufC;
    static byte[] bufD;
    static long timeStep_ms;
    static RecordSet recordSetReceiver;
    static RecordSet recordSetGAM;
    static RecordSet recordSetEAM;
    static RecordSet recordSetVario;
    static RecordSet recordSetGPS;
    static RecordSet recordSetChannel;
    static RecordSet recordSetESC;
    static RecordSet recordSetESC2;
    static RecordSet recordSetESC3;
    static RecordSet recordSetESC4;
    static int[] pointsReceiver;
    static int[] pointsEAM;
    static int[] pointsVario;
    static int[] pointsGPS;
    static int[] pointsChannel;
    static int[] pointsESC;
    static int[] pointsGAM;
    static int tmpVoltageRx;
    static int tmpTemperatureRx;
    static int tmpHeight;
    static int tmpTemperatureFet;
    static int tmpTemperatureExt;
    static int tmpVoltage;
    static int tmpCurrent;
    static int tmpRevolution;
    static int tmpClimb1;
    static int tmpClimb3;
    static int tmpClimb10;
    static int tmpVoltage1;
    static int tmpVoltage2;
    static int tmpCapacity;
    static int tmpVelocity;
    static int tmpLatitude;
    static int tmpLatitudeDelta;
    static double latitudeTolerance;
    static long lastLatitudeTimeStep;
    static int tmpLongitude;
    static int tmpLongitudeDelta;
    static double longitudeTolerance;
    static long lastLongitudeTimeStep;
    static boolean isJustParsed;
    static boolean isReceiverOnly;
    static EnumSet<HoTTAdapter.Sensor> detectedSensors;
    static boolean isTextModusSignaled;
    static int oldProtocolCount;
    static Vector<Byte> blockSequenceCheck;
    protected static final Map<String, RecordSet> recordSets;
    protected static HoTTAdapter.PickerParameters pickerParameters;
    protected static BinParser rcvBinParser;
    protected static BinParser chnBinParser;
    protected static BinParser varBinParser;
    protected static BinParser gpsBinParser;
    protected static BinParser gamBinParser;
    protected static BinParser eamBinParser;
    protected static BinParser escBinParser;
    static int[] lookup;

    public static HashMap<String, String> getFileInfo(File file, HoTTAdapter.PickerParameters newPickerParameters) throws IOException, DataTypeException {
        HashMap<String, String> fileInfo = null;
        pickerParameters = newPickerParameters;
        try (BufferedInputStream data_in = new BufferedInputStream(new FileInputStream(file));){
            Consumer<String> messageProvider = s -> DataExplorer.getInstance().openMessageDialogAsync(Messages.getString((String)s));
            fileInfo = new InfoParser(messageProvider).getFileInfo(data_in, file.getPath(), file.length());
        }
        return fileInfo;
    }

    static int convertRxDbm2Strength(int inValue) {
        if (inValue >= 40 && inValue < lookup.length + 40) {
            return lookup[inValue - 40];
        }
        if (inValue < 40) {
            return 100;
        }
        return 0;
    }

    protected static void setAltitudeClimbPickeParameter(HoTTAdapter.PickerParameters pickerParameters, EnumSet<HoTTAdapter.Sensor> detectedSensors) {
        if (pickerParameters.altitudeClimbSensorSelection == 0) {
            boolean isSensorDetected = false;
            for (HoTTAdapter.Sensor sensor : detectedSensors) {
                switch (sensor) {
                    case VARIO: {
                        pickerParameters.altitudeClimbSensorSelection = sensor.ordinal();
                        isSensorDetected = true;
                        break;
                    }
                    case GPS: {
                        pickerParameters.altitudeClimbSensorSelection = sensor.ordinal();
                        isSensorDetected = true;
                        break;
                    }
                    case GAM: {
                        pickerParameters.altitudeClimbSensorSelection = sensor.ordinal();
                        isSensorDetected = true;
                        break;
                    }
                    case EAM: {
                        pickerParameters.altitudeClimbSensorSelection = sensor.ordinal();
                        isSensorDetected = true;
                        break;
                    }
                }
                if (!isSensorDetected) continue;
                break;
            }
        } else {
            boolean isSensorContained = false;
            for (HoTTAdapter.Sensor sensor : detectedSensors) {
                if (pickerParameters.altitudeClimbSensorSelection != sensor.ordinal()) continue;
                isSensorContained = true;
                break;
            }
            if (!isSensorContained) {
                pickerParameters.altitudeClimbSensorSelection = 0;
                HoTTbinReader.setAltitudeClimbPickeParameter(pickerParameters, detectedSensors);
            }
        }
        log.log(Level.INFO, String.format("pickerParameters.altitudeClimbSensorSelection = %s", HoTTAdapter.Sensor.fromOrdinal(pickerParameters.altitudeClimbSensorSelection).name()));
    }

    public static synchronized void read(String filePath, HoTTAdapter.PickerParameters newPickerParameters) throws Exception {
        pickerParameters = newPickerParameters;
        HashMap<String, String> header = HoTTbinReader.getFileInfo(new File(filePath), newPickerParameters);
        HoTTbinReader2.detectedSensors = HoTTAdapter.Sensor.getSetFromDetected(header.get("DETECTED SENSOR"));
        if (HoTTbinReader2.detectedSensors.size() <= 2) {
            isReceiverOnly = HoTTbinReader2.detectedSensors.size() == 1;
            HoTTbinReader.readSingle(new File(filePath), header);
        } else {
            HoTTbinReader.readMultiple(new File(filePath), header);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readSingle(File file, HashMap<String, String> header) throws IOException, DataInconsitsentException {
        String $METHOD_NAME = "readSingle";
        long startTime = System.nanoTime() / 1000000L;
        FileInputStream file_input = new FileInputStream(file);
        DataInputStream data_in = new DataInputStream(file_input);
        long fileSize = file.length();
        HoTTAdapter device = (HoTTAdapter)application.getActiveDevice();
        int recordSetNumber = ((Channel)channels.get((Object)1)).maxSize() + 1;
        Object recordSetName = "";
        String recordSetNameExtend = HoTTbinReader.getRecordSetExtend(file);
        Channel channel = null;
        recordSetReceiver = null;
        recordSetGAM = null;
        recordSetEAM = null;
        recordSetVario = null;
        recordSetGPS = null;
        recordSetChannel = null;
        recordSetESC = null;
        dataBlockSize = 64;
        buf = new byte[dataBlockSize];
        buf0 = new byte[30];
        buf1 = new byte[30];
        buf2 = new byte[30];
        buf3 = new byte[30];
        buf4 = new byte[30];
        BufCopier bufCopier = new BufCopier(buf, buf0, buf1, buf2, buf3, buf4);
        long[] timeSteps_ms = new long[]{0L};
        rcvBinParser = HoTTAdapter.Sensor.RECEIVER.createBinParser(pickerParameters, new int[10], timeSteps_ms, new byte[][]{buf});
        varBinParser = HoTTAdapter.Sensor.VARIO.createBinParser(pickerParameters, new int[13], timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        gpsBinParser = HoTTAdapter.Sensor.GPS.createBinParser(pickerParameters, new int[24], timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        gamBinParser = HoTTAdapter.Sensor.GAM.createBinParser(pickerParameters, new int[26], timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        eamBinParser = HoTTAdapter.Sensor.EAM.createBinParser(pickerParameters, new int[31], timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        escBinParser = HoTTAdapter.Sensor.ESC.createBinParser(pickerParameters, new int[30], timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        int version = -1;
        isJustParsed = false;
        isTextModusSignaled = false;
        boolean isVarioDetected = false;
        boolean isGPSdetected = false;
        boolean isESCdetected = false;
        boolean isWrongDataBlockNummerSignaled = false;
        boolean isSdLogFormat = Boolean.parseBoolean(header.get("SD_FORMAT"));
        long numberDatablocks = isSdLogFormat ? fileSize - 27L - 323L : fileSize / (long)dataBlockSize;
        long startTimeStamp_ms = HoTTbinReader.getStartTimeStamp(file.getName(), file.lastModified(), numberDatablocks);
        numberDatablocks = isReceiverOnly && !HoTTbinReader.pickerParameters.isChannelsChannelEnabled ? numberDatablocks / 10L : numberDatablocks;
        String date = new SimpleDateFormat("yyyy-MM-dd").format(startTimeStamp_ms);
        String dateTime = new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(startTimeStamp_ms);
        MenuToolBar menuToolBar = application.getMenuToolBar();
        int progressIndicator = (int)(numberDatablocks / 30L);
        GDE.getUiNotification().setProgress(0);
        if (isSdLogFormat) {
            data_in.skip(27L);
        }
        try {
            String packageLossPercentage;
            String newFileDescription;
            recordSets.clear();
            channel = (Channel)channels.get((Object)1);
            String string = newFileDescription = application.isObjectoriented() ? date + " " + application.getObjectKey() : date;
            if (channel.getFileDescription().length() <= newFileDescription.length() || application.isObjectoriented() && !channel.getFileDescription().contains(application.getObjectKey())) {
                channel.setFileDescription(newFileDescription);
            }
            recordSetName = recordSetNumber + ") " + HoTTAdapter.Sensor.RECEIVER.value() + recordSetNameExtend;
            recordSetReceiver = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)1, (boolean)true, (boolean)true, (boolean)true);
            channel.put(recordSetName, (Object)recordSetReceiver);
            recordSets.put(HoTTAdapter.Sensor.RECEIVER.value(), recordSetReceiver);
            RecordSet tmpRecordSet = (RecordSet)channel.get(recordSetName);
            tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
            tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
            if (GDE.isWithUi()) {
                channel.applyTemplate((String)recordSetName, false);
            }
            if (HoTTbinReader.pickerParameters.isChannelsChannelEnabled) {
                channel = (Channel)channels.get((Object)6);
                channel.setFileDescription((String)(application.isObjectoriented() ? date + " " + application.getObjectKey() : date));
                recordSetName = recordSetNumber + ") " + HoTTAdapter.Sensor.CHANNEL.value() + recordSetNameExtend;
                recordSetChannel = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)6, (boolean)true, (boolean)true, (boolean)true);
                chnBinParser = HoTTAdapter.Sensor.CHANNEL.createBinParser(pickerParameters, new int[recordSetChannel.size()], timeSteps_ms, new byte[][]{buf});
                channel.put(recordSetName, (Object)recordSetChannel);
                recordSets.put(HoTTAdapter.Sensor.CHANNEL.value(), recordSetChannel);
                tmpRecordSet = (RecordSet)channel.get(recordSetName);
                tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
                tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
                if (GDE.isWithUi()) {
                    channel.applyTemplate((String)recordSetName, false);
                }
            }
            int i = 0;
            while ((long)i < numberDatablocks) {
                data_in.read(buf);
                if (log.isLoggable(Level.FINE) && i % 10 == 0) {
                    log.logp(Level.FINE, $CLASS_NAME, "readSingle", StringHelper.fourDigitsRunningNumber((int)buf.length));
                    log.logp(Level.FINE, $CLASS_NAME, "readSingle", StringHelper.byte2Hex4CharString((byte[])buf, (int)buf.length));
                }
                if (!HoTTbinReader.pickerParameters.isFilterTextModus || (buf[6] & 1) == 0) {
                    if (buf[3] != 0 && buf[4] != 0) {
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, String.format("Sensor %x Blocknummer : %d", buf[7], buf[33]));
                        }
                        ((RcvBinParser)rcvBinParser).trackPackageLoss(true);
                        if (log.isLoggable(Level.FINER)) {
                            log.logp(Level.FINER, $CLASS_NAME, "readSingle", StringHelper.byte2Hex2CharString((byte[])new byte[]{buf[7]}, (int)1) + " - " + StringHelper.printBinary((byte)buf[7], (boolean)false));
                        }
                        if (buf[33] == 0 && (buf[38] & 0x80) != 128 && DataParser.parse2Short((byte[])buf, (int)40) >= 0) {
                            HoTTbinReader.parseAddReceiver(buf);
                        }
                        if (HoTTbinReader.pickerParameters.isChannelsChannelEnabled) {
                            HoTTbinReader.parseAddChannel(buf);
                        }
                        if (isReceiverOnly && !HoTTbinReader.pickerParameters.isChannelsChannelEnabled) {
                            for (int j = 0; j < 9; ++j) {
                                data_in.read(buf);
                                timeSteps_ms[0] = timeSteps_ms[0] + 10L;
                            }
                        }
                        if (buf[33] == 0) {
                            bufCopier.copyToBuffer();
                        }
                        if (buf[33] >= 0 && buf[33] <= 4) {
                            switch ((byte)(buf[7] & 0xFF)) {
                                case -119: 
                                case 55: {
                                    if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.VARIO)) break;
                                    if (recordSetVario == null) {
                                        channel = (Channel)channels.get((Object)2);
                                        channel.setFileDescription((String)(application.isObjectoriented() ? date + " " + application.getObjectKey() : date));
                                        recordSetName = recordSetNumber + ") " + HoTTAdapter.Sensor.VARIO.value() + recordSetNameExtend;
                                        recordSetVario = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)2, (boolean)true, (boolean)true, (boolean)true);
                                        channel.put(recordSetName, (Object)recordSetVario);
                                        recordSets.put(HoTTAdapter.Sensor.VARIO.value(), recordSetVario);
                                        tmpRecordSet = (RecordSet)channel.get(recordSetName);
                                        tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
                                        tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
                                        if (GDE.isWithUi()) {
                                            channel.applyTemplate((String)recordSetName, false);
                                        }
                                    }
                                    bufCopier.copyToVarioBuffer();
                                    if (bufCopier.is4BuffersFull()) {
                                        version = HoTTbinReader.parseAddVario(version, buf0, buf1, buf2, buf3, buf4);
                                        bufCopier.clearBuffers();
                                    }
                                    if (isVarioDetected) break;
                                    HoTTAdapter.updateVarioTypeDependent(buf4[9] & 0xFF, device, recordSetVario);
                                    isVarioDetected = true;
                                    break;
                                }
                                case -118: 
                                case 56: {
                                    if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.GPS)) break;
                                    if (recordSetGPS == null) {
                                        channel = (Channel)channels.get((Object)3);
                                        channel.setFileDescription((String)(application.isObjectoriented() ? date + " " + application.getObjectKey() : date));
                                        recordSetName = recordSetNumber + ") " + HoTTAdapter.Sensor.GPS.value() + recordSetNameExtend;
                                        recordSetGPS = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)3, (boolean)true, (boolean)true, (boolean)true);
                                        channel.put(recordSetName, (Object)recordSetGPS);
                                        recordSets.put(HoTTAdapter.Sensor.GPS.value(), recordSetGPS);
                                        tmpRecordSet = (RecordSet)channel.get(recordSetName);
                                        tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
                                        tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
                                        if (GDE.isWithUi()) {
                                            channel.applyTemplate((String)recordSetName, false);
                                        }
                                    }
                                    bufCopier.copyToFreeBuffer();
                                    if (bufCopier.is4BuffersFull()) {
                                        HoTTbinReader.parseAddGPS(buf0, buf1, buf2, buf3, buf4);
                                        bufCopier.clearBuffers();
                                    }
                                    if (isGPSdetected || !HoTTbinReader.isReasonableData(buf4) || recordSetGPS.get(19).size() <= 0 || recordSetGPS.get(19).get(recordSetGPS.get(19).size() - 1) == 0) break;
                                    startTimeStamp_ms = HoTTAdapter.updateGpsTypeDependent(buf4[9] & 0xFF, device, recordSetGPS, startTimeStamp_ms);
                                    isGPSdetected = true;
                                    break;
                                }
                                case -115: 
                                case 53: {
                                    if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.GAM)) break;
                                    if (recordSetGAM == null) {
                                        channel = (Channel)channels.get((Object)4);
                                        channel.setFileDescription((String)(application.isObjectoriented() ? date + " " + application.getObjectKey() : date));
                                        recordSetName = recordSetNumber + ") " + HoTTAdapter.Sensor.GAM.value() + recordSetNameExtend;
                                        recordSetGAM = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)4, (boolean)true, (boolean)true, (boolean)true);
                                        channel.put(recordSetName, (Object)recordSetGAM);
                                        recordSets.put(HoTTAdapter.Sensor.GAM.value(), recordSetGAM);
                                        tmpRecordSet = (RecordSet)channel.get(recordSetName);
                                        tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
                                        tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
                                        if (GDE.isWithUi()) {
                                            channel.applyTemplate((String)recordSetName, false);
                                        }
                                    }
                                    bufCopier.copyToFreeBuffer();
                                    if (!bufCopier.is4BuffersFull()) break;
                                    HoTTbinReader.parseAddGAM(buf0, buf1, buf2, buf3, buf4);
                                    bufCopier.clearBuffers();
                                    break;
                                }
                                case -114: 
                                case 54: {
                                    if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.EAM)) break;
                                    if (recordSetEAM == null) {
                                        channel = (Channel)channels.get((Object)5);
                                        channel.setFileDescription((String)(application.isObjectoriented() ? date + " " + application.getObjectKey() : date));
                                        recordSetName = recordSetNumber + ") " + HoTTAdapter.Sensor.EAM.value() + recordSetNameExtend;
                                        recordSetEAM = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)5, (boolean)true, (boolean)true, (boolean)true);
                                        channel.put(recordSetName, (Object)recordSetEAM);
                                        recordSets.put(HoTTAdapter.Sensor.EAM.value(), recordSetEAM);
                                        tmpRecordSet = (RecordSet)channel.get(recordSetName);
                                        tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
                                        tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
                                        if (GDE.isWithUi()) {
                                            channel.applyTemplate((String)recordSetName, false);
                                        }
                                    }
                                    bufCopier.copyToFreeBuffer();
                                    if (!bufCopier.is4BuffersFull()) break;
                                    HoTTbinReader.parseAddEAM(buf0, buf1, buf2, buf3, buf4);
                                    bufCopier.clearBuffers();
                                    break;
                                }
                                case -116: 
                                case 57: {
                                    if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.ESC)) break;
                                    if (recordSetESC == null) {
                                        channel = (Channel)channels.get((Object)7);
                                        channel.setFileDescription((String)(application.isObjectoriented() ? date + " " + application.getObjectKey() : date));
                                        recordSetName = recordSetNumber + ") " + HoTTAdapter.Sensor.ESC.value() + recordSetNameExtend;
                                        recordSetESC = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)7, (boolean)true, (boolean)true, (boolean)true);
                                        channel.put(recordSetName, (Object)recordSetESC);
                                        recordSets.put(HoTTAdapter.Sensor.ESC.value(), recordSetESC);
                                        tmpRecordSet = (RecordSet)channel.get(recordSetName);
                                        tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
                                        tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
                                        if (GDE.isWithUi()) {
                                            channel.applyTemplate((String)recordSetName, false);
                                        }
                                    }
                                    bufCopier.copyToFreeBuffer();
                                    if (bufCopier.is4BuffersFull()) {
                                        HoTTbinReader.parseAddESC(buf0, buf1, buf2, buf3, buf4);
                                        bufCopier.clearBuffers();
                                    }
                                    if (isESCdetected) break;
                                    HoTTAdapter.updateEscTypeDependent(buf4[9] & 0xFF, device, recordSetESC);
                                    isESCdetected = true;
                                }
                            }
                        } else {
                            if (!isWrongDataBlockNummerSignaled) {
                                application.openMessageDialogAsync(String.format("Datenblocknummer ausserhalb des Bereichs von 0 bis 5 (%d)", buf[33]));
                                isWrongDataBlockNummerSignaled = true;
                            }
                            isJustParsed = true;
                        }
                        if (isJustParsed || isReceiverOnly) {
                            isJustParsed = !((RcvBinParser)rcvBinParser).updateLossStatistics();
                        }
                        timeSteps_ms[0] = timeSteps_ms[0] + 10L;
                        if (i % progressIndicator == 0) {
                            GDE.getUiNotification().setProgress((int)((long)(i * 100) / numberDatablocks));
                        }
                    } else {
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, "-->> Found tx=rx=0 dBm");
                        }
                        ((RcvBinParser)rcvBinParser).trackPackageLoss(false);
                        if (HoTTbinReader.pickerParameters.isChannelsChannelEnabled) {
                            HoTTbinReader.parseAddChannel(buf);
                        }
                        timeSteps_ms[0] = timeSteps_ms[0] + 10L;
                    }
                } else if (!isTextModusSignaled) {
                    isTextModusSignaled = true;
                    application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGW2404"));
                }
                ++i;
            }
            ((RcvBinParser)rcvBinParser).finalUpdateLossStatistics();
            String string2 = packageLossPercentage = recordSetReceiver.getRecordDataSize(true) > 0 ? String.format("%.1f", ((RcvBinParser)HoTTbinReader.rcvBinParser).getLostPackages().percentage) : "100";
            if (HoTTbinReader.pickerParameters.isChannelsChannelEnabled) {
                detectedSensors.add(HoTTAdapter.Sensor.CHANNEL);
            }
            recordSetReceiver.setRecordSetDescription(tmpRecordSet.getRecordSetDescription() + Messages.getString((String)"GDE_MSGI2404", (Object[])new Object[]{((RcvBinParser)rcvBinParser).getLossTotal(), ((RcvBinParser)HoTTbinReader.rcvBinParser).getLostPackages().lossTotal, packageLossPercentage, ((RcvBinParser)rcvBinParser).getLostPackages().getStatistics()}) + String.format(" - Sensor: %s", HoTTbinReader2.detectedSensors.toString()));
            log.logp(Level.WARNING, $CLASS_NAME, "readSingle", "skipped number receiver data due to package loss = " + ((RcvBinParser)HoTTbinReader.rcvBinParser).getLostPackages().lossTotal);
            log.logp(Level.TIME, $CLASS_NAME, "readSingle", "read time = " + StringHelper.getFormatedTime((String)"mm:ss:SSS", (long)(System.nanoTime() / 1000000L - startTime)));
            if (GDE.isWithUi()) {
                for (RecordSet recordSet : recordSets.values()) {
                    device.makeInActiveDisplayable(recordSet);
                    recordSet.descriptionAppendFilename(file.getName());
                }
                menuToolBar.updateChannelSelector();
                menuToolBar.updateRecordSetSelectCombo();
                GDE.getUiNotification().setProgress(100);
            }
        }
        finally {
            data_in.close();
            data_in = null;
        }
    }

    protected static String getRecordSetExtend(File file) {
        return HoTTbinReader.getRecordSetExtend(file.getName());
    }

    protected static String getRecordSetExtend(String fileName) {
        Object recordSetNameExtend;
        block6: {
            recordSetNameExtend = "";
            if (fileName.contains("_")) {
                try {
                    Integer.parseInt(fileName.substring(0, fileName.indexOf(95)));
                    recordSetNameExtend = " [" + fileName.substring(0, fileName.indexOf(95)) + "]";
                }
                catch (Exception e) {
                    if (fileName.substring(0, fileName.lastIndexOf(95)).length() <= 8) {
                        recordSetNameExtend = " [" + fileName.substring(0, fileName.lastIndexOf(95)) + "]";
                    }
                    break block6;
                }
            }
            try {
                Integer.parseInt(fileName.substring(0, 4));
                recordSetNameExtend = " [" + fileName.substring(0, 4) + "]";
            }
            catch (Exception e) {
                if (fileName.substring(0, fileName.length()).length() > 12) break block6;
                recordSetNameExtend = " [" + fileName.substring(0, fileName.length() - 4) + "]";
            }
        }
        return recordSetNameExtend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readMultiple(File file, HashMap<String, String> header) throws IOException, DataInconsitsentException {
        String $METHOD_NAME = "readMultiple";
        long startTime = System.nanoTime() / 1000000L;
        FileInputStream file_input = new FileInputStream(file);
        DataInputStream data_in = new DataInputStream(file_input);
        long fileSize = file.length();
        HoTTAdapter device = (HoTTAdapter)application.getActiveDevice();
        int recordSetNumber = ((Channel)channels.get((Object)1)).maxSize() + 1;
        Object recordSetName = "";
        String recordSetNameExtend = HoTTbinReader.getRecordSetExtend(file);
        Channel channel = null;
        recordSetReceiver = null;
        recordSetGAM = null;
        recordSetEAM = null;
        recordSetVario = null;
        recordSetGPS = null;
        recordSetChannel = null;
        recordSetESC = null;
        dataBlockSize = 64;
        buf = new byte[dataBlockSize];
        buf0 = new byte[30];
        buf1 = new byte[30];
        buf2 = new byte[30];
        buf3 = new byte[30];
        buf4 = new byte[30];
        BufCopier bufCopier = new BufCopier(buf, buf0, buf1, buf2, buf3, buf4);
        long[] timeSteps_ms = new long[]{0L};
        rcvBinParser = HoTTAdapter.Sensor.RECEIVER.createBinParser(pickerParameters, new int[10], timeSteps_ms, new byte[][]{buf});
        varBinParser = HoTTAdapter.Sensor.VARIO.createBinParser(pickerParameters, new int[13], timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        gpsBinParser = HoTTAdapter.Sensor.GPS.createBinParser(pickerParameters, new int[24], timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        gamBinParser = HoTTAdapter.Sensor.GAM.createBinParser(pickerParameters, new int[26], timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        eamBinParser = HoTTAdapter.Sensor.EAM.createBinParser(pickerParameters, new int[31], timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        escBinParser = HoTTAdapter.Sensor.ESC.createBinParser(pickerParameters, new int[30], timeSteps_ms, new byte[][]{buf0, buf1, buf2, buf3, buf4});
        int actualSensor = -1;
        int lastSensor = -1;
        int logCountVario = 0;
        int logCountGPS = 0;
        int logCountGeneral = 0;
        int logCountElectric = 0;
        int logCountSpeedControl = 0;
        isJustParsed = false;
        isTextModusSignaled = false;
        boolean isVarioDetected = false;
        boolean isGPSdetected = false;
        boolean isESCdetected = false;
        boolean isSdLogFormat = Boolean.parseBoolean(header.get("SD_FORMAT"));
        long numberDatablocks = isSdLogFormat ? fileSize - 27L - 323L : fileSize / (long)dataBlockSize;
        long startTimeStamp_ms = HoTTbinReader.getStartTimeStamp(file.getName(), file.lastModified(), numberDatablocks);
        String date = new SimpleDateFormat("yyyy-MM-dd").format(startTimeStamp_ms);
        String dateTime = new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(startTimeStamp_ms);
        MenuToolBar menuToolBar = application.getMenuToolBar();
        int progressIndicator = (int)(numberDatablocks / 30L);
        GDE.getUiNotification().setProgress(0);
        if (isSdLogFormat) {
            data_in.skip(27L);
        }
        try {
            String packageLossPercentage;
            String newFileDescription;
            recordSets.clear();
            channel = (Channel)channels.get((Object)1);
            String string = newFileDescription = application.isObjectoriented() ? date + " " + application.getObjectKey() : date;
            if (channel.getFileDescription().length() <= newFileDescription.length() || application.isObjectoriented() && !channel.getFileDescription().contains(application.getObjectKey())) {
                channel.setFileDescription(newFileDescription);
            }
            recordSetName = recordSetNumber + ") " + HoTTAdapter.Sensor.RECEIVER.value() + recordSetNameExtend;
            recordSetReceiver = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)1, (boolean)true, (boolean)true, (boolean)true);
            channel.put(recordSetName, (Object)recordSetReceiver);
            recordSets.put(HoTTAdapter.Sensor.RECEIVER.value(), recordSetReceiver);
            RecordSet tmpRecordSet = (RecordSet)channel.get(recordSetName);
            tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
            tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
            if (GDE.isWithUi()) {
                channel.applyTemplate((String)recordSetName, false);
            }
            if (HoTTbinReader.pickerParameters.isChannelsChannelEnabled) {
                channel = (Channel)channels.get((Object)6);
                channel.setFileDescription((String)(application.isObjectoriented() ? date + " " + application.getObjectKey() : date));
                recordSetName = recordSetNumber + ") " + HoTTAdapter.Sensor.CHANNEL.value() + recordSetNameExtend;
                recordSetChannel = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)6, (boolean)true, (boolean)true, (boolean)true);
                chnBinParser = HoTTAdapter.Sensor.CHANNEL.createBinParser(pickerParameters, new int[recordSetChannel.size()], timeSteps_ms, new byte[][]{buf});
                channel.put(recordSetName, (Object)recordSetChannel);
                recordSets.put(HoTTAdapter.Sensor.CHANNEL.value(), recordSetChannel);
                tmpRecordSet = (RecordSet)channel.get(recordSetName);
                tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
                tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
                if (GDE.isWithUi()) {
                    channel.applyTemplate((String)recordSetName, false);
                }
            }
            int i = 0;
            while ((long)i < numberDatablocks) {
                data_in.read(buf);
                if (log.isLoggable(Level.FINEST) && i % 10 == 0) {
                    log.logp(Level.FINEST, $CLASS_NAME, "readMultiple", StringHelper.fourDigitsRunningNumber((int)buf.length));
                    log.logp(Level.FINEST, $CLASS_NAME, "readMultiple", StringHelper.byte2Hex4CharString((byte[])buf, (int)buf.length));
                }
                if (!HoTTbinReader.pickerParameters.isFilterTextModus || (buf[6] & 1) == 0) {
                    if (buf[33] >= 0 && buf[33] <= 4 && buf[3] != 0 && buf[4] != 0) {
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, String.format("Sensor %x Blocknummer : %d", buf[7], buf[33]));
                        }
                        ((RcvBinParser)rcvBinParser).trackPackageLoss(true);
                        if (log.isLoggable(Level.FINEST)) {
                            log.logp(Level.FINEST, $CLASS_NAME, "readMultiple", StringHelper.byte2Hex2CharString((byte[])new byte[]{buf[7]}, (int)1) + " - " + StringHelper.printBinary((byte)buf[7], (boolean)false));
                        }
                        if (buf[33] == 0 && (buf[38] & 0x80) != 128 && DataParser.parse2Short((byte[])buf, (int)40) >= 0) {
                            HoTTbinReader.parseAddReceiver(buf);
                        }
                        if (HoTTbinReader.pickerParameters.isChannelsChannelEnabled) {
                            HoTTbinReader.parseAddChannel(buf);
                        }
                        if (actualSensor == -1) {
                            byte by = (byte)(buf[7] & 0xFF);
                            actualSensor = by;
                            lastSensor = by;
                        } else {
                            actualSensor = (byte)(buf[7] & 0xFF);
                        }
                        if (actualSensor != lastSensor) {
                            if (logCountVario >= 5 || logCountGPS >= 5 || logCountGeneral >= 5 || logCountElectric >= 5 || logCountSpeedControl >= 5) {
                                switch (lastSensor) {
                                    case -119: 
                                    case 55: {
                                        if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.VARIO)) break;
                                        if (recordSetVario == null) {
                                            channel = (Channel)channels.get((Object)2);
                                            channel.setFileDescription((String)(application.isObjectoriented() ? date + " " + application.getObjectKey() : date));
                                            recordSetName = recordSetNumber + ") " + HoTTAdapter.Sensor.VARIO.value() + recordSetNameExtend;
                                            recordSetVario = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)2, (boolean)true, (boolean)true, (boolean)true);
                                            channel.put(recordSetName, (Object)recordSetVario);
                                            recordSets.put(HoTTAdapter.Sensor.VARIO.value(), recordSetVario);
                                            tmpRecordSet = (RecordSet)channel.get(recordSetName);
                                            tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
                                            tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
                                            if (GDE.isWithUi()) {
                                                channel.applyTemplate((String)recordSetName, false);
                                            }
                                        }
                                        HoTTbinReader.parseAddVario(1, buf0, buf1, buf2, buf3, buf4);
                                        if (isVarioDetected) break;
                                        HoTTAdapter.updateVarioTypeDependent(buf4[9] & 0xFF, device, recordSetVario);
                                        isVarioDetected = true;
                                        break;
                                    }
                                    case -118: 
                                    case 56: {
                                        if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.GPS)) break;
                                        if (recordSetGPS == null) {
                                            channel = (Channel)channels.get((Object)3);
                                            channel.setFileDescription((String)(application.isObjectoriented() ? date + " " + application.getObjectKey() : date));
                                            recordSetName = recordSetNumber + ") " + HoTTAdapter.Sensor.GPS.value() + recordSetNameExtend;
                                            recordSetGPS = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)3, (boolean)true, (boolean)true, (boolean)true);
                                            channel.put(recordSetName, (Object)recordSetGPS);
                                            recordSets.put(HoTTAdapter.Sensor.GPS.value(), recordSetGPS);
                                            tmpRecordSet = (RecordSet)channel.get(recordSetName);
                                            tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
                                            tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
                                            if (GDE.isWithUi()) {
                                                channel.applyTemplate((String)recordSetName, false);
                                            }
                                        }
                                        HoTTbinReader.parseAddGPS(buf0, buf1, buf2, buf3, buf4);
                                        if (isGPSdetected || !HoTTbinReader.isReasonableData(buf4) || recordSetGPS.get(19).size() <= 0 || recordSetGPS.get(19).get(recordSetGPS.get(19).size() - 1) == 0) break;
                                        startTimeStamp_ms = HoTTAdapter.updateGpsTypeDependent(buf4[9] & 0xFF, device, recordSetGPS, startTimeStamp_ms);
                                        isGPSdetected = true;
                                        break;
                                    }
                                    case -115: 
                                    case 53: {
                                        if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.GAM)) break;
                                        if (recordSetGAM == null) {
                                            channel = (Channel)channels.get((Object)4);
                                            channel.setFileDescription((String)(application.isObjectoriented() ? date + " " + application.getObjectKey() : date));
                                            recordSetName = recordSetNumber + ") " + HoTTAdapter.Sensor.GAM.value() + recordSetNameExtend;
                                            recordSetGAM = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)4, (boolean)true, (boolean)true, (boolean)true);
                                            channel.put(recordSetName, (Object)recordSetGAM);
                                            recordSets.put(HoTTAdapter.Sensor.GAM.value(), recordSetGAM);
                                            tmpRecordSet = (RecordSet)channel.get(recordSetName);
                                            tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
                                            tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
                                            if (GDE.isWithUi()) {
                                                channel.applyTemplate((String)recordSetName, false);
                                            }
                                        }
                                        HoTTbinReader.parseAddGAM(buf0, buf1, buf2, buf3, buf4);
                                        break;
                                    }
                                    case -114: 
                                    case 54: {
                                        if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.EAM)) break;
                                        if (recordSetEAM == null) {
                                            channel = (Channel)channels.get((Object)5);
                                            channel.setFileDescription((String)(application.isObjectoriented() ? date + " " + application.getObjectKey() : date));
                                            recordSetName = recordSetNumber + ") " + HoTTAdapter.Sensor.EAM.value() + recordSetNameExtend;
                                            recordSetEAM = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)5, (boolean)true, (boolean)true, (boolean)true);
                                            channel.put(recordSetName, (Object)recordSetEAM);
                                            recordSets.put(HoTTAdapter.Sensor.EAM.value(), recordSetEAM);
                                            tmpRecordSet = (RecordSet)channel.get(recordSetName);
                                            tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
                                            tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
                                            if (GDE.isWithUi()) {
                                                channel.applyTemplate((String)recordSetName, false);
                                            }
                                        }
                                        HoTTbinReader.parseAddEAM(buf0, buf1, buf2, buf3, buf4);
                                        break;
                                    }
                                    case -116: 
                                    case 57: {
                                        if (!detectedSensors.contains((Object)HoTTAdapter.Sensor.ESC)) break;
                                        if (recordSetESC == null) {
                                            channel = (Channel)channels.get((Object)7);
                                            channel.setFileDescription((String)(application.isObjectoriented() ? date + " " + application.getObjectKey() : date));
                                            recordSetName = recordSetNumber + ") " + HoTTAdapter.Sensor.ESC.value() + recordSetNameExtend;
                                            recordSetESC = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)7, (boolean)true, (boolean)true, (boolean)true);
                                            channel.put(recordSetName, (Object)recordSetESC);
                                            recordSets.put(HoTTAdapter.Sensor.ESC.value(), recordSetESC);
                                            tmpRecordSet = (RecordSet)channel.get(recordSetName);
                                            tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
                                            tmpRecordSet.setStartTimeStamp(startTimeStamp_ms);
                                            if (GDE.isWithUi()) {
                                                channel.applyTemplate((String)recordSetName, false);
                                            }
                                        }
                                        HoTTbinReader.parseAddESC(buf0, buf1, buf2, buf3, buf4);
                                        if (isESCdetected) break;
                                        HoTTAdapter.updateEscTypeDependent(buf4[9] & 0xFF, device, recordSetESC);
                                        isESCdetected = true;
                                    }
                                }
                            }
                            if (log.isLoggable(Level.FINE)) {
                                log.logp(Level.FINE, $CLASS_NAME, "readMultiple", "logCountVario = " + logCountVario + " logCountGPS = " + logCountGPS + " logCountGeneral = " + logCountGeneral + " logCountElectric = " + logCountElectric + " logCountMotorDriver = " + logCountSpeedControl);
                            }
                            lastSensor = actualSensor;
                            logCountSpeedControl = 0;
                            logCountElectric = 0;
                            logCountGeneral = 0;
                            logCountGPS = 0;
                            logCountVario = 0;
                        }
                        switch (lastSensor) {
                            case -119: 
                            case 55: {
                                ++logCountVario;
                                break;
                            }
                            case -118: 
                            case 56: {
                                ++logCountGPS;
                                break;
                            }
                            case -115: 
                            case 53: {
                                ++logCountGeneral;
                                break;
                            }
                            case -114: 
                            case 54: {
                                ++logCountElectric;
                                break;
                            }
                            case -116: 
                            case 57: {
                                ++logCountSpeedControl;
                            }
                        }
                        bufCopier.copyToBuffer();
                        if (isJustParsed || isReceiverOnly) {
                            isJustParsed = !((RcvBinParser)rcvBinParser).updateLossStatistics();
                        }
                        timeSteps_ms[0] = timeSteps_ms[0] + 10L;
                        if (i % progressIndicator == 0) {
                            GDE.getUiNotification().setProgress((int)((long)(i * 100) / numberDatablocks));
                        }
                    } else {
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, "-->> Found tx=rx=0 dBm");
                        }
                        ((RcvBinParser)rcvBinParser).trackPackageLoss(false);
                        if (HoTTbinReader.pickerParameters.isChannelsChannelEnabled) {
                            HoTTbinReader.parseAddChannel(buf);
                        }
                        timeSteps_ms[0] = timeSteps_ms[0] + 10L;
                    }
                } else if (!isTextModusSignaled) {
                    isTextModusSignaled = true;
                    application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGW2404"));
                }
                ++i;
            }
            ((RcvBinParser)rcvBinParser).finalUpdateLossStatistics();
            String string2 = packageLossPercentage = recordSetReceiver.getRecordDataSize(true) > 0 ? String.format("%.1f", ((RcvBinParser)HoTTbinReader.rcvBinParser).getLostPackages().percentage) : "100";
            if (HoTTbinReader.pickerParameters.isChannelsChannelEnabled) {
                detectedSensors.add(HoTTAdapter.Sensor.CHANNEL);
            }
            recordSetReceiver.setRecordSetDescription(tmpRecordSet.getRecordSetDescription() + Messages.getString((String)"GDE_MSGI2404", (Object[])new Object[]{((RcvBinParser)rcvBinParser).getLossTotal(), ((RcvBinParser)HoTTbinReader.rcvBinParser).getLostPackages().lossTotal, packageLossPercentage, ((RcvBinParser)rcvBinParser).getLostPackages().getStatistics()}) + String.format(" - Sensor: %s", HoTTbinReader2.detectedSensors.toString()));
            log.logp(Level.WARNING, $CLASS_NAME, "readMultiple", "skipped number receiver data due to package loss = " + ((RcvBinParser)HoTTbinReader.rcvBinParser).getLostPackages().lossTotal);
            log.logp(Level.TIME, $CLASS_NAME, "readMultiple", "read time = " + StringHelper.getFormatedTime((String)"mm:ss:SSS", (long)(System.nanoTime() / 1000000L - startTime)));
            if (GDE.isWithUi()) {
                for (RecordSet recordSet : recordSets.values()) {
                    device.makeInActiveDisplayable(recordSet);
                    device.updateVisibilityStatus(recordSet, true);
                    recordSet.descriptionAppendFilename(file.getName());
                }
                menuToolBar.updateChannelSelector();
                menuToolBar.updateRecordSetSelectCombo();
                GDE.getUiNotification().setProgress(100);
            }
        }
        finally {
            data_in.close();
            data_in = null;
        }
    }

    protected static void parseAddReceiver(byte[] _buf) throws DataInconsitsentException {
        rcvBinParser.parse();
        recordSetReceiver.addPoints(rcvBinParser.getPoints(), (double)rcvBinParser.getTimeStep_ms());
    }

    protected static void parseAddChannel(byte[] _buf) throws DataInconsitsentException {
        chnBinParser.parse();
        recordSetChannel.addPoints(chnBinParser.getPoints(), (double)chnBinParser.getTimeStep_ms());
    }

    protected static int parseAddVario(int sdLogVersion, byte[] _buf0, byte[] _buf1, byte[] _buf2, byte[] _buf3, byte[] _buf4) throws DataInconsitsentException {
        if (varBinParser.parse()) {
            recordSetVario.addPoints(varBinParser.getPoints(), (double)varBinParser.getTimeStep_ms());
        }
        isJustParsed = true;
        return sdLogVersion;
    }

    protected static void parseAddGPS(byte[] _buf0, byte[] _buf1, byte[] _buf2, byte[] _buf3, byte[] _buf4) throws DataInconsitsentException {
        if (gpsBinParser.parse()) {
            recordSetGPS.addPoints(gpsBinParser.getPoints(), (double)gpsBinParser.getTimeStep_ms());
        }
        isJustParsed = true;
    }

    protected static void parseAddGAM(byte[] _buf0, byte[] _buf1, byte[] _buf2, byte[] _buf3, byte[] _buf4) throws DataInconsitsentException {
        if (gamBinParser.parse()) {
            recordSetGAM.addPoints(gamBinParser.getPoints(), (double)gamBinParser.getTimeStep_ms());
        }
        isJustParsed = true;
    }

    protected static void parseAddEAM(byte[] _buf0, byte[] _buf1, byte[] _buf2, byte[] _buf3, byte[] _buf4) throws DataInconsitsentException {
        if (eamBinParser.parse()) {
            recordSetEAM.addPoints(eamBinParser.getPoints(), (double)eamBinParser.getTimeStep_ms());
        }
        isJustParsed = true;
    }

    protected static void parseAddESC(byte[] _buf0, byte[] _buf1, byte[] _buf2, byte[] _buf3, byte[] _buf4) throws DataInconsitsentException {
        if (escBinParser.parse()) {
            recordSetESC.addPoints(escBinParser.getPoints(), (double)escBinParser.getTimeStep_ms());
        }
        isJustParsed = true;
    }

    static void printByteValues(long millisec, byte[] buffer) {
        StringBuilder sb = new StringBuilder().append(StringHelper.getFormatedTime((String)"mm:ss:SSS", (long)millisec)).append(" : ");
        for (int i = 0; buffer != null && i < buffer.length; ++i) {
            sb.append("(").append(i).append(")").append(buffer[i]).append(" ");
        }
        log.log(Level.FINE, sb.toString());
    }

    static void printShortValues(long millisec, byte[] buffer) {
        StringBuilder sb = new StringBuilder().append(StringHelper.getFormatedTime((String)"mm:ss:SSS", (long)millisec)).append(" : ");
        for (int i = 0; buffer != null && i < buffer.length - 1; ++i) {
            sb.append("(").append(i).append(")").append(DataParser.parse2Short((byte[])buffer, (int)i)).append(" ");
        }
        log.log(Level.FINE, sb.toString());
    }

    protected static long getStartTimeStamp(String fileName, long fileLastModified, long numberDatablocks) {
        long startTimeStamp;
        log.log(Level.FINE, "name=", fileName);
        Pattern hoTTNamePattern = Pattern.compile("\\d{4}\\_\\d{4}-\\d{1,2}-\\d{1,2}");
        Matcher hoTTMatcher = hoTTNamePattern.matcher(fileName);
        if (hoTTMatcher.find()) {
            String logName = hoTTMatcher.group();
            String[] strValueLogName = logName.split("_");
            int logCounter = Integer.parseInt(strValueLogName[0]);
            String[] strValueDate = strValueLogName[1].split("-");
            int year = Integer.parseInt(strValueDate[0]);
            int month = Integer.parseInt(strValueDate[1]);
            int day = Integer.parseInt(strValueDate[2]);
            GregorianCalendar lastModifiedDate = new GregorianCalendar();
            lastModifiedDate.setTimeInMillis(fileLastModified - numberDatablocks * 10L);
            if (year == lastModifiedDate.get(1) && month == lastModifiedDate.get(2) + 1 && day == lastModifiedDate.get(5)) {
                startTimeStamp = lastModifiedDate.getTimeInMillis();
                log.log(Level.FINE, "creation=" + StringHelper.getFormatedTime((String)"yyyy-MM-dd HH:mm:ss.SSS", (long)lastModifiedDate.getTimeInMillis()) + " lastModified=" + StringHelper.getFormatedTime((String)"yyyy-MM-dd HH:mm:ss.SSS", (long)fileLastModified));
            } else {
                GregorianCalendar fileNameDate = new GregorianCalendar(year, month - 1, day, 0, 0, 0);
                fileNameDate.add(12, 10 * (logCounter % 144));
                startTimeStamp = fileNameDate.getTimeInMillis();
                log.log(Level.FINE, "fileNameDate=" + StringHelper.getFormatedTime((String)"yyyy-MM-dd HH:mm:ss", (long)fileNameDate.getTimeInMillis()));
            }
        } else {
            startTimeStamp = fileLastModified;
        }
        return startTimeStamp;
    }

    protected static long getStartTimeStamp(String formattedLogStartTime, long fileStartTimeStamp_ms) {
        long startTimeStamp_ms = fileStartTimeStamp_ms;
        String formattedFileStartTimeStamp = StringHelper.getFormatedTime((String)"YYYY-MM-dd HH:mm:ss.SSS", (long)fileStartTimeStamp_ms);
        if (!formattedFileStartTimeStamp.contains(formattedLogStartTime)) {
            int year = Integer.parseInt(formattedFileStartTimeStamp.substring(0, 4));
            int month = Integer.parseInt(formattedFileStartTimeStamp.substring(5, 7));
            int day = Integer.parseInt(formattedFileStartTimeStamp.substring(8, 10));
            int hour = Integer.parseInt(formattedLogStartTime.substring(0, 2));
            int minute = Integer.parseInt(formattedLogStartTime.substring(3, 5));
            int second = Integer.parseInt(formattedLogStartTime.substring(6, 8));
            GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day, hour, minute, second);
            fileStartTimeStamp_ms = calendar.getTimeInMillis();
        }
        return startTimeStamp_ms;
    }

    protected static long getStartTimeStamp(long fileStartTimeStamp_ms, int timeStampGPS_ms, int numberDataBlocks_base10_ms) {
        try {
            String formattedFileStartTimeStamp = StringHelper.getFormatedTime((String)"YYYY-MM-dd HH:mm:ss.SSS", (long)fileStartTimeStamp_ms);
            int year = Integer.parseInt(formattedFileStartTimeStamp.substring(0, 4));
            int month = Integer.parseInt(formattedFileStartTimeStamp.substring(5, 7));
            int day = Integer.parseInt(formattedFileStartTimeStamp.substring(8, 10));
            int hour = Integer.parseInt(formattedFileStartTimeStamp.substring(11, 13));
            int tmpHH = timeStampGPS_ms / 10000000;
            int minute = timeStampGPS_ms / 100000 - tmpHH * 100;
            int second = timeStampGPS_ms / 1000 - minute * 100 - tmpHH * 10000;
            int milliseconds = timeStampGPS_ms - second * 1000 - minute * 100000 - tmpHH * 10000000;
            int n = numberDataBlocks_base10_ms == 0 ? 100 : numberDataBlocks_base10_ms * 10;
            GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day, hour, minute, second);
            return calendar.getTimeInMillis() + (long)(milliseconds -= n);
        }
        catch (Exception e) {
            return fileStartTimeStamp_ms;
        }
    }

    public static boolean isReasonableData(byte[] buffer) {
        int sum = 0;
        for (byte b : buffer) {
            sum += b & 0xFF;
        }
        return sum > 10;
    }

    static {
        tmpVoltageRx = 0;
        tmpTemperatureRx = 0;
        tmpHeight = 0;
        tmpTemperatureFet = 0;
        tmpTemperatureExt = 0;
        tmpVoltage = 0;
        tmpCurrent = 0;
        tmpRevolution = 0;
        tmpClimb1 = 0;
        tmpClimb3 = 0;
        tmpClimb10 = 0;
        tmpVoltage1 = 0;
        tmpVoltage2 = 0;
        tmpCapacity = 0;
        tmpVelocity = 0;
        tmpLatitude = 0;
        tmpLatitudeDelta = 0;
        latitudeTolerance = 1.0;
        lastLatitudeTimeStep = 0L;
        tmpLongitude = 0;
        tmpLongitudeDelta = 0;
        longitudeTolerance = 1.0;
        lastLongitudeTimeStep = 0L;
        isJustParsed = false;
        isReceiverOnly = false;
        isTextModusSignaled = false;
        oldProtocolCount = 0;
        recordSets = new HashMap<String, RecordSet>();
        lookup = new int[]{95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 85, 85, 85, 85, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 30, 25, 25, 20, 20, 20, 15, 15, 10, 10, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0};
    }

    public static class InfoParser {
        private final Consumer<String> messageProvider;

        public InfoParser(Consumer<String> messageProvider) {
            this.messageProvider = messageProvider;
        }

        @Nullable
        private HashMap<String, String> getFileInfoLog(FilterInputStream data_in, String filePath, long fileLength) throws UnsupportedEncodingException, IOException {
            HashMap<String, String> fileInfo = new HashMap<String, String>();
            fileInfo.put("FilePath", filePath);
            EnumSet<HoTTAdapter.Sensor> sensors = EnumSet.of(HoTTAdapter.Sensor.RECEIVER);
            data_in.reset();
            data_in.mark(999);
            byte[] buffer = new byte[64];
            data_in.read(buffer);
            String preHeader = new String(buffer);
            int indexOf = preHeader.indexOf("LOG DATA OFFSET : ");
            if (indexOf > 10) {
                String line;
                int logDataOffset = Integer.valueOf(preHeader.substring(indexOf + 18, indexOf + 18 + 8));
                data_in.reset();
                StringBuilder sb = new StringBuilder();
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)data_in, "ISO-8859-1"));
                while ((line = reader.readLine()) != null && sb.append(line).append("\n").length() < logDataOffset) {
                    if (!line.contains(": ") || line.indexOf(58) <= 5) continue;
                    String key = line.split(": ")[0].trim();
                    String value = null;
                    try {
                        value = line.split(": ")[1].trim();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (value == null) continue;
                    fileInfo.put(key, value);
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.log(Level.FINE, String.format("%16s : %s", line.split(": ")[0].trim(), fileInfo.get(line.split(": ")[0].trim())));
                }
                reader.close();
                try (BufferedInputStream data_in1 = new BufferedInputStream(new FileInputStream(filePath));){
                    int numberLogChannels = Integer.valueOf(fileInfo.get("LOG NOB CHANNEL"));
                    boolean isASCII = fileInfo.get("LOG TYPE").contains("ASCII");
                    int rawDataBlockSize = 66 + numberLogChannels * 2;
                    fileInfo.put("RAW_LOG_SIZE", "" + rawDataBlockSize);
                    int asciiDataBlockSize = 202 + numberLogChannels * 5;
                    fileInfo.put("ASCII_LOG_SIZE", "" + asciiDataBlockSize);
                    int dataBlockSize = isASCII ? asciiDataBlockSize : rawDataBlockSize;
                    fileInfo.put("LogCount", "" + ((fileLength - (long)logDataOffset) / (long)dataBlockSize - 1L));
                    fileInfo.put("DATA_BLOCK_SIZE", "" + dataBlockSize);
                    buffer = new byte[dataBlockSize];
                    ((FilterInputStream)data_in1).skip(logDataOffset);
                    for (int i = 0; i < 150 && ((FilterInputStream)data_in1).available() >= dataBlockSize; ++i) {
                        HoTTAdapter.Sensor tmpSensor;
                        data_in1.read(buffer);
                        if (isASCII) {
                            HoTTlogReader.convertAscii2Raw(rawDataBlockSize, buffer);
                        }
                        if (buffer[24] == 31 || (tmpSensor = HoTTAdapter.Sensor.fromSensorByte(buffer[26])) == null) continue;
                        sensors.add(tmpSensor);
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.log(Level.FINE, StringHelper.byte2Hex4CharString((byte[])buffer, (int)buffer.length));
                        log.log(Level.FINE, String.format("SensorByte  %02X", buffer[26]));
                    }
                    ((FilterInputStream)data_in1).close();
                }
                fileInfo.put("DETECTED SENSOR", HoTTAdapter.Sensor.getSetAsDetected(sensors));
            }
            return fileInfo;
        }

        public HashMap<String, String> getFileInfo(FilterInputStream data_in, String filePath, long fileLength) throws IOException, DataTypeException {
            HashMap<String, String> fileInfo;
            data_in.mark(64000);
            byte[] buffer = new byte[64];
            data_in.read(buffer);
            if (filePath.endsWith("bin") && new String(buffer).startsWith("GRAUPNER SD LOG")) {
                try {
                    data_in.reset();
                    SdLogFormat sdLogFormat = new SdLogFormat(27, 323, 64);
                    SdLogInputStream sdLogInputStream = new SdLogInputStream(data_in, fileLength, sdLogFormat);
                    HashMap<String, String> fileInfo2 = this.getFileInfo(sdLogInputStream, filePath, fileLength);
                    return fileInfo2;
                }
                catch (DataTypeException sdLogFormat) {
                    this.messageProvider.accept("GDE_MSGW2410");
                    throw new DataTypeException(Messages.getString((String)"GDE_MSGW2410"));
                }
            }
            if (filePath.endsWith("log") && new String(buffer).startsWith("FILE TAG IDVER")) {
                fileInfo = this.getFileInfoLog(data_in, filePath, fileLength);
            } else {
                if (filePath.endsWith("log")) {
                    this.messageProvider.accept("GDE_MSGW0021");
                    throw new DataTypeException(Messages.getString((String)"GDE_MSGW0021"));
                }
                long numberLogs = fileLength / 64L;
                if (numberLogs < 7000L) {
                    this.messageProvider.accept("GDE_MSGW2406");
                } else if (numberLogs < 5500L) {
                    this.messageProvider.accept("GDE_MSGW2407");
                    throw new IOException(Messages.getString((String)"GDE_MSGW2407"));
                }
                fileInfo = InfoParser.getFileInfoBin(data_in, filePath, fileLength);
            }
            return fileInfo;
        }

        private static HashMap<String, String> getFileInfoBin(FilterInputStream data_in, String filePath, long fileLength) throws IOException {
            HashMap<String, String> fileInfo = new HashMap<String, String>();
            fileInfo.put("SD_FORMAT", Boolean.toString(data_in instanceof SdLogInputStream));
            fileInfo.put("FilePath", filePath);
            EnumSet<HoTTAdapter.Sensor> sensors = EnumSet.of(HoTTAdapter.Sensor.RECEIVER);
            data_in.reset();
            byte[] buffer = new byte[64];
            data_in.read(buffer);
            long position = fileLength / 2L - 48000L;
            position = data_in instanceof SdLogInputStream ? (fileLength - 27L - 323L) / 2L - 48000L : (position -= position % 64L);
            if (position > 0L) {
                position = (position -= 64L) <= 64L ? 64L : position;
                long skipped = 0L;
                for (long iterationCount = -1L; (skipped = data_in.skip(position)) < position && iterationCount < 8L; position -= skipped, ++iterationCount) {
                    if (!log.isLoggable(Level.FINER)) continue;
                    log.log(Level.FINER, "position " + position + " skipped " + skipped);
                }
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "position " + position + " skipped " + skipped);
                }
                for (int i = 0; i < 1500 && data_in.available() >= 64; ++i) {
                    data_in.read(buffer);
                    HoTTAdapter.Sensor tmpSensor = HoTTAdapter.Sensor.fromSensorByte(buffer[7]);
                    if (tmpSensor != null) {
                        sensors.add(tmpSensor);
                    }
                    if (!log.isLoggable(Level.FINER)) continue;
                    log.log(Level.FINER, StringHelper.byte2Hex4CharString((byte[])buffer, (int)buffer.length));
                    log.log(Level.FINER, String.format("SensorByte  %02X", buffer[7]));
                }
            }
            if (data_in instanceof SdLogInputStream) {
                fileInfo.put("LogCount", "" + (fileLength - 27L - 323L) / (long)dataBlockSize);
            } else {
                fileInfo.put("LogCount", "" + fileLength / (long)dataBlockSize);
            }
            fileInfo.put("DETECTED SENSOR", HoTTAdapter.Sensor.getSetAsDetected(sensors));
            if (log.isLoggable(Level.FINE)) {
                for (Map.Entry entry : fileInfo.entrySet()) {
                    log.log(Level.FINE, (String)entry.getKey() + " = " + (String)entry.getValue());
                    log.log(Level.FINE, Paths.get(filePath, new String[0]).getFileName().toString() + " - sensor count = " + sensors.size());
                }
            }
            return fileInfo;
        }
    }

    public static class BufCopier {
        private final byte[] buf;
        private final byte[] buf0;
        private final byte[] buf1;
        private final byte[] buf2;
        private final byte[] buf3;
        private final byte[] buf4;
        private final boolean[] isBufReady;

        public BufCopier(byte[] buf, byte[] buf0, byte[] buf1, byte[] buf2, byte[] buf3, byte[] buf4) {
            this.buf = buf;
            this.buf0 = buf0;
            this.buf1 = buf1;
            this.buf2 = buf2;
            this.buf3 = buf3;
            this.buf4 = buf4;
            this.isBufReady = new boolean[5];
        }

        public void clearBuffers() {
            this.isBufReady[4] = false;
            this.isBufReady[3] = false;
            this.isBufReady[2] = false;
            this.isBufReady[1] = false;
        }

        public boolean is4BuffersFull() {
            return this.isBufReady[1] && this.isBufReady[2] && this.isBufReady[3] && this.isBufReady[4];
        }

        public void copyToBuffer() {
            switch (this.buf[33]) {
                case 0: {
                    if (DataParser.parse2Short((byte[])this.buf, (int)0) == 0) break;
                    System.arraycopy(this.buf, 34, this.buf0, 0, this.buf0.length);
                    break;
                }
                case 1: {
                    System.arraycopy(this.buf, 34, this.buf1, 0, this.buf1.length);
                    break;
                }
                case 2: {
                    System.arraycopy(this.buf, 34, this.buf2, 0, this.buf2.length);
                    break;
                }
                case 3: {
                    System.arraycopy(this.buf, 34, this.buf3, 0, this.buf3.length);
                    break;
                }
                case 4: {
                    System.arraycopy(this.buf, 34, this.buf4, 0, this.buf4.length);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }

        public void copyToFreeBuffer() {
            switch (this.buf[33]) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.isBufReady[1]) break;
                    this.isBufReady[1] = true;
                    System.arraycopy(this.buf, 34, this.buf1, 0, this.buf1.length);
                    break;
                }
                case 2: {
                    if (this.isBufReady[2]) break;
                    this.isBufReady[2] = true;
                    System.arraycopy(this.buf, 34, this.buf2, 0, this.buf2.length);
                    break;
                }
                case 3: {
                    if (this.isBufReady[3]) break;
                    this.isBufReady[3] = true;
                    System.arraycopy(this.buf, 34, this.buf3, 0, this.buf3.length);
                    break;
                }
                case 4: {
                    if (this.isBufReady[4]) break;
                    this.isBufReady[4] = true;
                    System.arraycopy(this.buf, 34, this.buf4, 0, this.buf4.length);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }

        public void copyToVarioBuffer() {
            switch (this.buf[33]) {
                case 0: {
                    break;
                }
                case 1: {
                    this.isBufReady[1] = true;
                    System.arraycopy(this.buf, 34, this.buf1, 0, this.buf1.length);
                    break;
                }
                case 2: {
                    this.isBufReady[2] = true;
                    System.arraycopy(this.buf, 34, this.buf2, 0, this.buf2.length);
                    break;
                }
                case 3: {
                    this.isBufReady[3] = true;
                    System.arraycopy(this.buf, 34, this.buf3, 0, this.buf3.length);
                    break;
                }
                case 4: {
                    this.isBufReady[4] = true;
                    System.arraycopy(this.buf, 34, this.buf4, 0, this.buf4.length);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    public static abstract class BinParser {
        public static final int TIMESTEP_INDEX = 0;
        protected final HoTTAdapter.PickerParameters pickerParameters;
        protected final int[] points;
        protected final long[] timeSteps_ms;
        protected final HoTTAdapter.Sensor sensor;
        protected byte[] _buf0;
        protected byte[] _buf1;
        protected byte[] _buf2;
        protected byte[] _buf3;
        protected byte[] _buf4;

        protected BinParser(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers, HoTTAdapter.Sensor sensor) {
            this.pickerParameters = pickerParameters;
            this.points = points;
            this.timeSteps_ms = timeSteps_ms;
            this.sensor = sensor;
            switch (buffers.length) {
                case 5: {
                    this._buf4 = buffers[4];
                }
                case 4: {
                    this._buf3 = buffers[3];
                }
                case 3: {
                    this._buf2 = buffers[2];
                }
                case 2: {
                    this._buf1 = buffers[1];
                }
                case 1: {
                    this._buf0 = buffers[0];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("buffers length mismatch " + buffers.length);
                }
            }
        }

        protected abstract boolean parse();

        protected long getTimeStep_ms() {
            return this.timeSteps_ms[0];
        }

        public HoTTAdapter.Sensor getSensor() {
            return this.sensor;
        }

        public int[] getPoints() {
            return this.points;
        }

        public void migratePoints(int[] targetPoints) {
            throw new UnsupportedOperationException("required for HoTTbinReader2 only");
        }

        public String toString() {
            int maxLen = 11;
            return "BinParser [sensor=" + String.valueOf((Object)this.sensor) + ", timeStep_ms=" + this.getTimeStep_ms() + ", points=" + (this.points != null ? Arrays.toString(Arrays.copyOf(this.points, Math.min(this.points.length, 11))) : null) + "]";
        }
    }

    public static class RcvBinParser
    extends BinParser {
        private int tmpVoltageRx = 0;
        private int tmpTemperatureRx = 0;
        private int consecutiveLossCounter = 0;
        private PackageLoss lostPackages = new PackageLoss();
        protected final byte[] _buf;

        protected RcvBinParser(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
            super(pickerParameters, points, timeSteps_ms, buffers, HoTTAdapter.Sensor.RECEIVER);
            this._buf = buffers[0];
            if (buffers.length != 1) {
                throw new InvalidParameterException("buffers mismatch: " + buffers.length);
            }
        }

        @Override
        protected boolean parse() {
            this.tmpVoltageRx = this._buf[35] & 0xFF;
            this.tmpTemperatureRx = this._buf[36] & 0xFF;
            this.points[1] = (this._buf[38] & 0xFF) * 1000;
            this.points[3] = DataParser.parse2Short((byte[])this._buf, (int)40) * 1000;
            if (this.isPointsValid()) {
                this.points[2] = HoTTbinReader.convertRxDbm2Strength(this._buf[4] & 0xFF) * 1000;
                this.points[4] = (this._buf[3] & 0xFF) * -1000;
                this.points[5] = (this._buf[4] & 0xFF) * -1000;
                this.points[6] = (this._buf[35] & 0xFF) * 1000;
                this.points[7] = ((this._buf[36] & 0xFF) - 20) * 1000;
                this.points[8] = (this._buf[39] & 0xFF) * 1000;
                this.points[9] = (this._buf[32] & 0x40) > 0 || (this._buf[32] & 0x25) > 0 && this.tmpTemperatureRx >= 70 ? (this._buf[32] & 0x65) * 1000 : 0;
                return true;
            }
            this.points[9] = (this._buf[32] & 0x40) > 0 || (this._buf[32] & 0x25) > 0 && this.tmpTemperatureRx >= 70 ? (this._buf[32] & 0x65) * 1000 : 0;
            return false;
        }

        public void trackPackageLoss(boolean isAvailable) {
            if (isAvailable) {
                this.pickerParameters.reverseChannelPackageLossCounter.add(1);
                this.points[0] = this.pickerParameters.reverseChannelPackageLossCounter.getPercentage() * 1000;
            } else {
                this.pickerParameters.reverseChannelPackageLossCounter.add(0);
                this.points[0] = this.pickerParameters.reverseChannelPackageLossCounter.getPercentage() * 1000;
                ++this.consecutiveLossCounter;
            }
            ++this.lostPackages.numberTrackedSamples;
        }

        public boolean updateLossStatistics() {
            if (this.consecutiveLossCounter > 0) {
                this.lostPackages.add(this.consecutiveLossCounter);
                this.consecutiveLossCounter = 0;
                return true;
            }
            return false;
        }

        public void finalUpdateLossStatistics() {
            this.lostPackages.percentage = (double)this.lostPackages.lossTotal * 100.0 / (double)(this.lostPackages.numberTrackedSamples - this.consecutiveLossCounter);
            log.log(Level.INFO, String.format("lostPackages = (%d) %d of %d percentage = %3.1f", this.lostPackages.lossTotal + this.consecutiveLossCounter, this.lostPackages.lossTotal, this.lostPackages.numberTrackedSamples, this.lostPackages.percentage));
        }

        public int getLossTotal() {
            return this.lostPackages.lossTotal + this.consecutiveLossCounter;
        }

        public PackageLoss getLostPackages() {
            return this.lostPackages;
        }

        private boolean isPointsValid() {
            return !this.pickerParameters.isFilterEnabled || this.tmpVoltageRx > -1 && this.tmpVoltageRx < 100 && this.tmpTemperatureRx < 120;
        }

        @Override
        public String toString() {
            return super.toString() + "  [lossTotal=" + this.lostPackages.lossTotal + ", consecutiveLossCounter=" + this.consecutiveLossCounter + "]";
        }
    }

    public static class EscBinParser
    extends BinParser {
        private int tmpTemperatureFet = 0;
        private int tmpVoltage = 0;
        private int tmpCurrent = 0;
        private int tmpRevolution = 0;
        private int tmpCapacity = 0;
        private int parseCount = 0;

        protected EscBinParser(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
            super(pickerParameters, points, timeSteps_ms, buffers, HoTTAdapter.Sensor.ESC);
            if (buffers.length != 5) {
                throw new InvalidParameterException("buffers mismatch: " + buffers.length);
            }
        }

        @Override
        protected boolean parse() {
            this.tmpVoltage = DataParser.parse2Short((byte[])this._buf1, (int)3);
            this.tmpCurrent = DataParser.parse2Short((byte[])this._buf2, (int)1);
            this.points[0] = (this._buf0[4] & 0xFF) * 1000;
            this.tmpCapacity = DataParser.parse2Short((byte[])this._buf1, (int)7);
            this.tmpRevolution = DataParser.parse2UnsignedShort((byte[])this._buf2, (int)5);
            this.tmpTemperatureFet = (this._buf1[9] & 0xFF) - 20;
            if (this.isPointsValid()) {
                this.points[1] = this.tmpVoltage * 1000;
                this.points[2] = this.tmpCurrent * 1000;
                this.points[4] = Double.valueOf((double)this.points[1] / 1000.0 * (double)this.points[2]).intValue();
                if (!this.pickerParameters.isFilterEnabled || this.parseCount <= 20 || this.tmpCapacity != 0 && Math.abs(this.tmpCapacity) <= this.points[3] / 1000 + this.tmpVoltage * this.tmpCurrent / 2500 + 2) {
                    this.points[3] = this.tmpCapacity * 1000;
                } else if (this.tmpCapacity != 0) {
                    log.log(Level.FINE, StringHelper.getFormatedTime((String)"mm:ss.SSS", (long)this.getTimeStep_ms()) + " - " + this.tmpCapacity + " - " + this.points[3] / 1000 + " + " + (this.tmpVoltage * this.tmpCurrent / 2500 + 2));
                }
                this.points[5] = this.tmpRevolution * 1000;
                this.points[6] = this.tmpTemperatureFet * 1000;
                this.points[7] = ((this._buf2[9] & 0xFF) - 20) * 1000;
                this.points[8] = DataParser.parse2Short((byte[])this._buf1, (int)5) * 1000;
                this.points[9] = DataParser.parse2Short((byte[])this._buf2, (int)3) * 1000;
                this.points[10] = DataParser.parse2UnsignedShort((byte[])this._buf2, (int)7) * 1000;
                this.points[11] = ((this._buf2[0] & 0xFF) - 20) * 1000;
                this.points[12] = ((this._buf3[0] & 0xFF) - 20) * 1000;
                if ((this._buf1[1] & 0xFF) != 0) {
                    this.points[13] = (this._buf1[1] & 0xFF) * 1000;
                }
                if ((this._buf4[9] & 0xFF) == 3) {
                    this.points[14] = DataParser.parse2Short((byte[])this._buf3, (int)1) * 1000;
                    this.points[15] = DataParser.parse2Short((byte[])this._buf3, (int)3) * 1000;
                    this.points[16] = (this._buf3[5] & 0xFF) * 1000;
                    this.points[17] = (this._buf3[6] & 0xFF) * 1000;
                    this.points[18] = (this._buf3[7] & 0xFF) * 1000;
                    this.points[19] = (this._buf3[8] & 0xFF) * 1000;
                    this.points[20] = DataParser.parse2UnsignedShort((byte)this._buf3[9], (byte)this._buf4[0]) * 1000;
                    this.points[21] = ((this._buf4[1] & 0xFF) - 20) * 1000;
                    this.points[22] = ((this._buf4[2] & 0xFF) - 20) * 1000;
                    this.points[23] = (this._buf4[3] & 0xFF) * 1000;
                    this.points[24] = ((this._buf4[4] & 0xFF) - 20) * 1000;
                    this.points[25] = DataParser.parse2Short((byte[])this._buf4, (int)5) * 1000;
                    this.points[26] = (this._buf4[7] & 0xFF) * 1000;
                    this.points[27] = (this._buf4[8] & 0xFF) * 1000;
                    this.points[28] = 0;
                    this.points[29] = (this._buf4[9] & 0xFF) * 1000;
                } else if ((this._buf4[9] & 0xFF) >= 128) {
                    this.points[14] = DataParser.parse2Short((byte[])this._buf3, (int)1) * 1000;
                    this.points[15] = DataParser.parse2Short((byte[])this._buf3, (int)3) * 1000;
                    this.points[16] = (this._buf3[5] & 0xFF) * 1000;
                    this.points[17] = (this._buf3[6] & 0xFF) * 1000;
                    this.points[18] = (this._buf3[7] & 0xFF) * 1000;
                    this.points[19] = (this._buf3[8] & 0xFF) * 1000;
                    this.points[20] = DataParser.parse2UnsignedShort((byte)this._buf3[9], (byte)this._buf4[0]) * 1000;
                    this.points[21] = DataParser.parse2UnsignedShort((byte[])this._buf4, (int)1) * 1000;
                    this.points[22] = DataParser.parse2UnsignedShort((byte[])this._buf4, (int)3) * 1000;
                    this.points[23] = DataParser.parse2UnsignedShort((byte[])this._buf4, (int)5) * 1000;
                    this.points[24] = ((this._buf4[7] & 0xFF) - 20) * 1000;
                    this.points[25] = (this._buf4[8] & 0xFF) * 1000;
                    this.points[26] = 0;
                    this.points[27] = 0;
                    this.points[28] = 0;
                    this.points[29] = (this._buf4[9] & 0xFF) * 1000;
                }
                ++this.parseCount;
                return true;
            }
            if ((this._buf1[1] & 0xFF) != 0) {
                this.points[13] = (this._buf1[1] & 0xFF) * 1000;
            }
            ++this.parseCount;
            return false;
        }

        private boolean isPointsValid() {
            return !this.pickerParameters.isFilterEnabled || this.tmpVoltage > 0 && this.tmpVoltage < 1000 && this.tmpCurrent < 4000 && this.tmpCurrent > -10 && this.tmpRevolution > -1 && this.tmpRevolution < 20000 && (this.points[6] == 0 || this.points[6] / 1000 - this.tmpTemperatureFet <= 20);
        }
    }

    public static class EamBinParser
    extends BinParser {
        private int tmpHeight = 0;
        private int tmpClimb3 = 0;
        private int tmpVoltage1 = 0;
        private int tmpVoltage2 = 0;
        private int tmpCapacity = 0;
        private int parseCount = 0;

        protected EamBinParser(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
            super(pickerParameters, points, timeSteps_ms, buffers, HoTTAdapter.Sensor.EAM);
            if (buffers.length != 5) {
                throw new InvalidParameterException("buffers mismatch: " + buffers.length);
            }
        }

        @Override
        protected boolean parse() {
            this.tmpHeight = DataParser.parse2Short((byte[])this._buf3, (int)3);
            this.tmpClimb3 = this._buf4[3] & 0xFF;
            this.tmpVoltage1 = DataParser.parse2Short((byte[])this._buf2, (int)7);
            this.tmpVoltage2 = DataParser.parse2Short((byte)this._buf2[9], (byte)this._buf3[0]);
            this.tmpCapacity = DataParser.parse2Short((byte)this._buf3[9], (byte)this._buf4[0]);
            this.points[0] = (this._buf0[4] & 0xFF) * 1000;
            if (this.isPointsValid()) {
                int j;
                int maxVotage = Integer.MIN_VALUE;
                int minVotage = Integer.MAX_VALUE;
                this.points[1] = DataParser.parse2Short((byte[])this._buf3, (int)7) * 1000;
                this.points[2] = DataParser.parse2Short((byte[])this._buf3, (int)5) * 1000;
                if (!this.pickerParameters.isFilterEnabled || this.parseCount <= 20 || Math.abs(this.tmpCapacity) <= this.points[3] / 1000 + this.points[1] / 1000 * this.points[2] / 1000 / 2500 + 2) {
                    this.points[3] = this.tmpCapacity * 1000;
                } else {
                    log.log(Level.FINE, StringHelper.getFormatedTime((String)"mm:ss.SSS", (long)this.getTimeStep_ms()) + " - " + this.tmpCapacity + " - " + this.points[3] / 1000 + " + " + (this.points[1] / 1000 * this.points[2] / 1000 / 2500 + 2));
                }
                this.points[4] = Double.valueOf((double)this.points[1] / 1000.0 * (double)this.points[2]).intValue();
                this.points[5] = 0;
                for (j = 0; j < 7; ++j) {
                    this.points[j + 6] = (this._buf1[3 + j] & 0xFF) * 1000;
                    if (this.points[j + 6] <= 0) continue;
                    maxVotage = this.points[j + 6] > maxVotage ? this.points[j + 6] : maxVotage;
                    minVotage = this.points[j + 6] < minVotage ? this.points[j + 6] : minVotage;
                }
                for (j = 0; j < 7; ++j) {
                    this.points[j + 13] = (this._buf2[j] & 0xFF) * 1000;
                    if (this.points[j + 13] <= 0) continue;
                    maxVotage = this.points[j + 13] > maxVotage ? this.points[j + 13] : maxVotage;
                    minVotage = this.points[j + 13] < minVotage ? this.points[j + 13] : minVotage;
                }
                this.points[5] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? (maxVotage - minVotage) * 10 : 0;
                this.points[20] = this.tmpHeight * 1000;
                this.points[21] = DataParser.parse2UnsignedShort((byte[])this._buf4, (int)1) * 1000;
                this.points[22] = this.tmpClimb3 * 1000;
                this.points[23] = this.tmpVoltage1 * 1000;
                this.points[24] = this.tmpVoltage2 * 1000;
                this.points[25] = ((this._buf3[1] & 0xFF) - 20) * 1000;
                this.points[26] = ((this._buf3[2] & 0xFF) - 20) * 1000;
                this.points[27] = DataParser.parse2UnsignedShort((byte[])this._buf4, (int)4) * 1000;
                this.points[28] = ((this._buf4[6] & 0xFF) * 60 + (this._buf4[7] & 0xFF)) * 1000;
                this.points[29] = DataParser.parse2Short((byte[])this._buf4, (int)8) * 1000;
                this.points[30] = ((this._buf1[1] & 0xFF) + ((this._buf1[2] & 0x7F) << 8)) * 1000;
                ++this.parseCount;
                return true;
            }
            this.points[30] = ((this._buf1[1] & 0xFF) + ((this._buf1[2] & 0x7F) << 8)) * 1000;
            ++this.parseCount;
            return false;
        }

        private boolean isPointsValid() {
            return !this.pickerParameters.isFilterEnabled || this.tmpClimb3 > 30 && this.tmpHeight > 10 && this.tmpHeight < 5000 && Math.abs(this.tmpVoltage1) < 600 && Math.abs(this.tmpVoltage2) < 600;
        }
    }

    public static class GamBinParser
    extends BinParser {
        private int tmpHeight = 0;
        private int tmpClimb3 = 0;
        private int tmpVoltage1 = 0;
        private int tmpVoltage2 = 0;
        private int tmpCapacity = 0;
        private int parseCount = 0;

        protected GamBinParser(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
            super(pickerParameters, points, timeSteps_ms, buffers, HoTTAdapter.Sensor.GAM);
            if (buffers.length != 5) {
                throw new InvalidParameterException("buffers mismatch: " + buffers.length);
            }
        }

        @Override
        protected boolean parse() {
            this.tmpHeight = DataParser.parse2Short((byte[])this._buf3, (int)0);
            this.tmpClimb3 = this._buf3[4] & 0xFF;
            this.tmpVoltage1 = DataParser.parse2Short((byte)this._buf1[9], (byte)this._buf2[0]);
            this.tmpVoltage2 = DataParser.parse2Short((byte[])this._buf2, (int)1);
            this.tmpCapacity = DataParser.parse2Short((byte)this._buf3[9], (byte)this._buf4[0]);
            this.points[0] = (this._buf0[4] & 0xFF) * 1000;
            if (this.isPointsValid()) {
                int maxVotage = Integer.MIN_VALUE;
                int minVotage = Integer.MAX_VALUE;
                this.points[1] = DataParser.parse2Short((byte[])this._buf3, (int)7) * 1000;
                this.points[2] = DataParser.parse2Short((byte[])this._buf3, (int)5) * 1000;
                if (!this.pickerParameters.isFilterEnabled || this.parseCount <= 20 || this.tmpCapacity != 0 && Math.abs(this.tmpCapacity) <= this.points[3] / 1000 + this.points[1] / 1000 * this.points[2] / 1000 / 2500 + 2) {
                    this.points[3] = this.tmpCapacity * 1000;
                } else {
                    log.log(Level.FINE, StringHelper.getFormatedTime((String)"mm:ss.SSS", (long)this.getTimeStep_ms()) + " - " + this.tmpCapacity + " - " + this.points[3] / 1000 + " + " + (this.points[1] / 1000 * this.points[2] / 1000 / 2500 + 2));
                }
                this.points[4] = Double.valueOf((double)this.points[1] / 1000.0 * (double)this.points[2]).intValue();
                this.points[5] = 0;
                for (int j = 0; j < 6; ++j) {
                    this.points[j + 6] = (this._buf1[3 + j] & 0xFF) * 1000;
                    if (this.points[j + 6] <= 0) continue;
                    maxVotage = this.points[j + 6] > maxVotage ? this.points[j + 6] : maxVotage;
                    minVotage = this.points[j + 6] < minVotage ? this.points[j + 6] : minVotage;
                }
                this.points[5] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? (maxVotage - minVotage) * 10 : 0;
                this.points[12] = DataParser.parse2UnsignedShort((byte[])this._buf2, (int)8) * 1000;
                this.points[13] = this.tmpHeight * 1000;
                this.points[14] = DataParser.parse2UnsignedShort((byte[])this._buf3, (int)2) * 1000;
                this.points[15] = this.tmpClimb3 * 1000;
                this.points[16] = DataParser.parse2Short((byte[])this._buf2, (int)6) * 1000;
                this.points[17] = this.tmpVoltage1 * 1000;
                this.points[18] = this.tmpVoltage2 * 1000;
                this.points[19] = ((this._buf2[3] & 0xFF) - 20) * 1000;
                this.points[20] = ((this._buf2[4] & 0xFF) - 20) * 1000;
                this.points[21] = DataParser.parse2UnsignedShort((byte[])this._buf4, (int)1) * 1000;
                this.points[22] = (this._buf4[3] & 0xFF) * 1000;
                this.points[23] = (this._buf4[4] & 0xFF) * 1000;
                this.points[24] = (this._buf4[8] & 0xFF) * 1000;
                if ((this._buf1[1] & 0xFF) + ((this._buf1[2] & 0x7F) << 8) != 0) {
                    this.points[25] = ((this._buf1[1] & 0xFF) + ((this._buf1[2] & 0x7F) << 8)) * 1000;
                }
                ++this.parseCount;
                return true;
            }
            if ((this._buf1[1] & 0xFF) + ((this._buf1[2] & 0x7F) << 8) != 0) {
                this.points[25] = ((this._buf1[1] & 0xFF) + ((this._buf1[2] & 0x7F) << 8)) * 1000;
            }
            ++this.parseCount;
            return false;
        }

        private boolean isPointsValid() {
            return !this.pickerParameters.isFilterEnabled || this.tmpClimb3 > 30 && this.tmpHeight > 10 && this.tmpHeight < 5000 && Math.abs(this.tmpVoltage1) < 600 && Math.abs(this.tmpVoltage2) < 600;
        }
    }

    public static class GpsBinParser
    extends BinParser {
        private int tmpDate = 0;
        private int tmpTime = 0;
        private int tmpHeight = 0;
        private int tmpClimb1 = 0;
        private int tmpClimb3 = 0;
        private int tmpVelocity = 0;
        private int tmpLatitude = 0;
        private int tmpLatitudeDelta = 0;
        private int tmpLongitude = 0;
        private int tmpLongitudeDelta = 0;
        private double latitudeTolerance = 1.0;
        private long lastLatitudeTimeStep = 0L;
        private double longitudeTolerance = 1.0;
        private long lastLongitudeTimeStep = 0L;

        protected GpsBinParser(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
            super(pickerParameters, points, timeSteps_ms, buffers, HoTTAdapter.Sensor.GPS);
            if (buffers.length != 5) {
                throw new InvalidParameterException("buffers mismatch: " + buffers.length);
            }
        }

        @Override
        protected boolean parse() {
            this.tmpHeight = DataParser.parse2Short((byte[])this._buf2, (int)8);
            this.tmpClimb1 = DataParser.parse2UnsignedShort((byte[])this._buf3, (int)0);
            this.tmpClimb3 = this._buf3[2] & 0xFF;
            this.tmpVelocity = DataParser.parse2UnsignedShort((byte[])this._buf1, (int)4) * 1000;
            this.points[0] = (this._buf0[4] & 0xFF) * 1000;
            if (this.isPointsValid()) {
                this.points[6] = this.pickerParameters.isFilterEnabled && this.tmpVelocity > 2000000 ? this.points[6] : this.tmpVelocity;
                this.tmpLatitude = DataParser.parse2UnsignedShort((byte[])this._buf1, (int)7) * 10000 + DataParser.parse2UnsignedShort((byte)this._buf1[9], (byte)this._buf2[0]);
                this.tmpLatitude = this._buf1[6] == 1 ? -1 * this.tmpLatitude : this.tmpLatitude;
                this.tmpLatitudeDelta = Math.abs(this.tmpLatitude - this.points[1]);
                this.tmpLatitudeDelta = this.tmpLatitudeDelta > 400000 ? this.tmpLatitudeDelta - 400000 : this.tmpLatitudeDelta;
                this.latitudeTolerance = (double)this.points[6] / 1000.0 * (double)(this.getTimeStep_ms() - this.lastLatitudeTimeStep) / this.pickerParameters.latitudeToleranceFactor;
                double d = this.latitudeTolerance = this.latitudeTolerance > 0.0 ? this.latitudeTolerance : 25.0;
                if (!this.pickerParameters.isFilterEnabled || this.points[1] == 0 || (double)this.tmpLatitudeDelta <= this.latitudeTolerance) {
                    this.lastLatitudeTimeStep = this.getTimeStep_ms();
                    this.points[1] = this.tmpLatitude;
                } else if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, StringHelper.getFormatedTime((String)"HH:mm:ss:SSS", (long)(this.getTimeStep_ms() - 3600000L)) + " Lat " + this.tmpLatitude + " - " + this.tmpLatitudeDelta);
                }
                this.tmpLongitude = DataParser.parse2UnsignedShort((byte[])this._buf2, (int)2) * 10000 + DataParser.parse2UnsignedShort((byte[])this._buf2, (int)4);
                this.tmpLongitude = this._buf2[1] == 1 ? -1 * this.tmpLongitude : this.tmpLongitude;
                this.tmpLongitudeDelta = Math.abs(this.tmpLongitude - this.points[2]);
                this.tmpLongitudeDelta = this.tmpLongitudeDelta > 400000 ? this.tmpLongitudeDelta - 400000 : this.tmpLongitudeDelta;
                this.longitudeTolerance = (double)this.points[6] / 1000.0 * (double)(this.getTimeStep_ms() - this.lastLongitudeTimeStep) / this.pickerParameters.longitudeToleranceFactor;
                double d2 = this.longitudeTolerance = this.longitudeTolerance > 0.0 ? this.longitudeTolerance : 45.0;
                if (!this.pickerParameters.isFilterEnabled || this.points[2] == 0 || (double)this.tmpLongitudeDelta <= this.longitudeTolerance) {
                    this.lastLongitudeTimeStep = this.getTimeStep_ms();
                    this.points[2] = this.tmpLongitude;
                } else if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, StringHelper.getFormatedTime((String)"HH:mm:ss:SSS", (long)(this.getTimeStep_ms() - 3600000L)) + " Long " + this.tmpLongitude + " - " + this.tmpLongitudeDelta + " - " + this.longitudeTolerance);
                }
                this.points[3] = this.tmpHeight * 1000;
                this.points[4] = this.tmpClimb1 * 1000;
                this.points[5] = this.tmpClimb3 * 1000;
                this.points[7] = DataParser.parse2UnsignedShort((byte[])this._buf2, (int)6) * 1000;
                this.points[8] = (this._buf1[3] & 0xFF) * 1000;
                this.points[9] = 0;
                this.points[10] = (this._buf0[1] & 0xFF) * 1000;
                this.points[11] = ((this._buf0[2] & 0xFF) - 20) * 1000;
                this.points[12] = (this._buf3[3] & 0xFF) * 1000;
                switch (this._buf3[4]) {
                    case 45: {
                        this.points[13] = 0;
                        break;
                    }
                    case 50: {
                        this.points[13] = 2000;
                        break;
                    }
                    case 51: {
                        this.points[13] = 3000;
                        break;
                    }
                    case 68: {
                        this.points[13] = 4000;
                        break;
                    }
                    default: {
                        try {
                            this.points[13] = Integer.valueOf(String.format("%c", 0xFF & this._buf3[4])) * 1000;
                            break;
                        }
                        catch (NumberFormatException e1) {
                            this.points[13] = 1000;
                        }
                    }
                }
                this.points[14] = (this._buf1[1] & 0xF) * 1000;
                this.points[15] = (this._buf3[5] & 0xFF) * 1000;
                if ((this._buf4[9] & 0xFF) > 100) {
                    this.points[16] = this._buf3[6] * 1000;
                    this.points[17] = DataParser.parse2UnsignedShort((byte[])this._buf3, (int)7) * 1000;
                    this.points[19] = DataParser.parse2Short((byte)this._buf3[9], (byte)this._buf4[0]) * 1000;
                    this.points[20] = DataParser.parse2Short((byte[])this._buf4, (int)1) * 1000;
                    this.points[21] = DataParser.parse2Short((byte[])this._buf4, (int)3) * 1000;
                    this.points[22] = (this._buf4[5] & 0xFF) * 1000;
                } else if ((this._buf4[9] & 0xFF) == 4) {
                    this.points[16] = this._buf4[4] * 1000;
                    this.points[17] = 0;
                    this.points[18] = this._buf3[8] * 100;
                    if (this.points[13] > 0) {
                        this.tmpTime = this._buf3[9] * 10000000 + this._buf4[0] * 100000 + this._buf4[1] * 1000 + this._buf4[2] * 10;
                        if (this.tmpTime < this.points[19]) {
                            log.log(Level.WARNING, String.format("near time: %s %s", StringHelper.getFormatedTime((String)"HH:mm:ss.SSS", (long)(this.timeSteps_ms[0] - 3600000L)), HoTTAdapter.getFormattedTime(this.tmpTime)));
                        }
                        this.points[19] = this.tmpTime;
                        this.tmpDate = ((this._buf4[5] - 48) * 1000000 + (this._buf4[7] - 48) * 10000 + (this._buf4[6] - 48) * 100) * 10;
                        if (this.tmpDate < 0) {
                            log.log(Level.WARNING, String.format("near time: %s Sat-Fix %d #Sats %d %s - %c %c %c", StringHelper.getFormatedTime((String)"HH:mm:ss.SSS", (long)(this.timeSteps_ms[0] - 3600000L)), this.points[13] / 1000, this.points[12] / 1000, HoTTAdapter.getFormattedTime(this.points[19]), this._buf4[5] & 0xFF, this._buf4[7] & 0xFF, this._buf4[6] & 0xFF));
                        }
                        this.points[20] = this.tmpDate;
                        this.points[21] = (DataParser.parse2Short((byte[])this._buf3, (int)6) - 500) * 1000;
                    }
                    this.points[22] = (this._buf4[3] & 0xFF) * 1000;
                } else if ((this._buf4[9] & 0xFF) == 0 || (this._buf4[9] & 0xFF) == 1) {
                    boolean version;
                    boolean bl = version = this.points[23] == 1000 || this._buf3[6] != 0 && this._buf3[7] != 0 && this._buf3[8] != 0;
                    if (!version) {
                        this.points[16] = this._buf3[6] * 1000;
                        this.points[17] = this._buf3[7] * 1000;
                        this.points[18] = this._buf3[8] * 1000;
                        this.points[19] = this._buf3[9] * 10000000 + this._buf4[0] * 100000 + this._buf4[1] * 1000 + this._buf4[2] * 10;
                        this.points[20] = 0;
                        this.points[21] = DataParser.parse2Short((byte[])this._buf4, (int)3) * 1000;
                        this.points[22] = (this._buf4[5] & 0xFF) * 1000;
                    } else {
                        this.points[16] = DataParser.parse2Short((byte[])this._buf3, (int)6) * 1000;
                        this.points[17] = 0;
                        this.points[18] = this._buf3[8] * 1000;
                        this.points[19] = this._buf3[9] * 10000000 + this._buf4[0] * 100000 + this._buf4[1] * 1000 + this._buf4[2] * 10;
                        this.points[20] = 0;
                        this.points[21] = DataParser.parse2Short((byte[])this._buf4, (int)3) * 1000;
                        this.points[22] = (this._buf4[5] & 0xFF) * 1000;
                    }
                } else {
                    this.points[16] = this._buf3[6] * 1000;
                    this.points[17] = this._buf3[7] * 1000;
                    this.points[18] = this._buf3[8] * 1000;
                    this.points[19] = DataParser.parse2Short((byte)this._buf3[9], (byte)this._buf4[0]) * 1000;
                    this.points[20] = DataParser.parse2Short((byte[])this._buf4, (int)1) * 1000;
                    this.points[21] = DataParser.parse2Short((byte[])this._buf4, (int)3) * 1000;
                    this.points[22] = (this._buf4[5] & 0xFF) * 1000;
                }
                this.points[23] = (this._buf4[9] & 0xFF) * 1000;
                return true;
            }
            this.points[14] = (this._buf1[1] & 0xF) * 1000;
            return false;
        }

        private boolean isPointsValid() {
            return !this.pickerParameters.isFilterEnabled || this.tmpClimb1 > 10000 && this.tmpClimb3 > 30 && this.tmpHeight > 10 && this.tmpHeight < 4500;
        }
    }

    public static class VarBinParser
    extends BinParser {
        private int tmpHeight = 0;
        private int tmpClimb10 = 0;

        protected VarBinParser(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
            super(pickerParameters, points, timeSteps_ms, buffers, HoTTAdapter.Sensor.VARIO);
            if (buffers.length != 5) {
                throw new InvalidParameterException("buffers mismatch: " + buffers.length);
            }
            points[2] = 100000;
        }

        @Override
        protected boolean parse() {
            this.points[0] = (this._buf0[4] & 0xFF) * 1000;
            this.tmpHeight = DataParser.parse2Short((byte[])this._buf1, (int)2);
            this.tmpClimb10 = DataParser.parse2UnsignedShort((byte[])this._buf2, (int)2);
            if (this.isPointsValid()) {
                this.points[1] = this.tmpHeight * 1000;
                this.points[2] = (DataParser.parse2UnsignedShort((byte[])this._buf1, (int)8) - 30000) * 10;
                this.points[3] = DataParser.parse2UnsignedShort((byte[])this._buf2, (int)0) * 1000;
                this.points[4] = this.tmpClimb10 * 1000;
                this.points[5] = (this._buf0[1] & 0xFF) * 1000;
                this.points[6] = ((this._buf0[2] & 0xFF) - 20) * 1000;
                this.points[7] = (this._buf1[1] & 0x3F) * 1000;
                if ((this._buf4[9] & 0xFF) > 100 && (this._buf4[9] & 0xFF) < 120) {
                    try {
                        this.points[8] = Integer.parseInt(String.format(Locale.ENGLISH, "%c%c%c%c%c0", this._buf2[4], this._buf2[5], this._buf2[6], this._buf2[8], this._buf2[9]).trim());
                        this.points[9] = Integer.parseInt(String.format(Locale.ENGLISH, "%c%c%c%c%c0", this._buf3[1], this._buf3[2], this._buf3[3], this._buf3[5], this._buf3[6]).trim());
                        this.points[10] = Integer.parseInt(String.format(Locale.ENGLISH, "%c%c%c%c%c0", this._buf3[8], this._buf3[9], this._buf4[0], this._buf4[2], this._buf4[3]).trim());
                    }
                    catch (NumberFormatException e) {
                        byte[] tmpArray = new byte[21];
                        System.arraycopy(this._buf2, 4, tmpArray, 0, 6);
                        System.arraycopy(this._buf3, 0, tmpArray, 6, 10);
                        System.arraycopy(this._buf4, 0, tmpArray, 16, 5);
                        log.log(Level.WARNING, "'" + new String(tmpArray) + "'");
                    }
                    this.points[11] = (this._buf4[8] & 0xFF) * 1000;
                    this.points[12] = (this._buf4[9] & 0xFF) * 1000;
                }
                return true;
            }
            this.points[7] = (this._buf1[1] & 0x3F) * 1000;
            return false;
        }

        private boolean isPointsValid() {
            return !this.pickerParameters.isFilterEnabled || this.tmpHeight > 10 && this.tmpHeight < 5000;
        }
    }

    public static class ChnBinParser
    extends BinParser {
        protected final byte[] _buf;

        protected ChnBinParser(HoTTAdapter.PickerParameters pickerParameters, int[] points, long[] timeSteps_ms, byte[][] buffers) {
            super(pickerParameters, points, timeSteps_ms, buffers, HoTTAdapter.Sensor.CHANNEL);
            this._buf = buffers[0];
            if (buffers.length != 1) {
                throw new InvalidParameterException("buffers mismatch: " + buffers.length);
            }
        }

        @Override
        protected boolean parse() {
            this.points[0] = (this._buf[1] & 0xFF) * 1000;
            this.points[1] = (this._buf[3] & 0xFF) * -1000;
            this.points[2] = (this._buf[4] & 0xFF) * -1000;
            this.points[3] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)8) / 2 * 1000;
            this.points[4] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)10) / 2 * 1000;
            this.points[5] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)12) / 2 * 1000;
            this.points[6] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)14) / 2 * 1000;
            this.points[7] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)16) / 2 * 1000;
            this.points[8] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)18) / 2 * 1000;
            this.points[9] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)20) / 2 * 1000;
            this.points[10] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)22) / 2 * 1000;
            this.points[this.points.length - 4] = (this._buf[50] & 1) * 100000;
            this.points[this.points.length - 3] = (this._buf[50] & 2) * 50000;
            this.points[this.points.length - 2] = (this._buf[50] & 4) * 25000;
            if (this._buf[32] > 0 && this._buf[32] < 27) {
                this.points[this.points.length - 1] = this._buf[32] * 1000;
                log.log(Level.FINE, String.format("Warning %d occured at %s", this.points[22] / 1000, StringHelper.getFormatedTime((String)"HH:mm:ss:SSS", (long)(this.getTimeStep_ms() - 3600000L))));
            } else {
                this.points[this.points.length - 1] = 0;
            }
            if (this._buf[5] == 0) {
                this.points[11] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)24) / 2 * 1000;
                this.points[12] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)26) / 2 * 1000;
                this.points[13] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)28) / 2 * 1000;
                this.points[14] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)30) / 2 * 1000;
                if (this.points[15] == 0) {
                    this.points[15] = 1500000;
                    this.points[16] = 1500000;
                    this.points[17] = 1500000;
                    this.points[18] = 1500000;
                }
            } else {
                this.points[15] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)24) / 2 * 1000;
                this.points[16] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)26) / 2 * 1000;
                this.points[17] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)28) / 2 * 1000;
                this.points[18] = DataParser.parse2UnsignedShort((byte[])this._buf, (int)30) / 2 * 1000;
                if (this.points[11] == 0) {
                    this.points[11] = 1500000;
                    this.points[12] = 1500000;
                    this.points[13] = 1500000;
                    this.points[14] = 1500000;
                }
            }
            return true;
        }
    }

    public static class SdLogInputStream
    extends FilterInputStream {
        private final SdLogFormat sdLogFormat;
        private final long payloadSize;
        private final long posMax;
        private long pos = 0L;
        private long mark = 0L;

        public SdLogInputStream(FilterInputStream in, long fileLength, SdLogFormat sdLogFormat) throws DataTypeException, IOException {
            super(in);
            this.sdLogFormat = sdLogFormat;
            this.posMax = fileLength - (long)sdLogFormat.footerSize - 1L;
            this.payloadSize = fileLength - (long)sdLogFormat.headerSize - (long)sdLogFormat.footerSize;
            if (this.payloadSize < 0L) {
                throw new DataTypeException("file size less than header/footer size");
            }
            if (this.payloadSize % (long)sdLogFormat.dataBlockSize != 0L) {
                throw new DataTypeException("data block size does not match");
            }
            if (!in.markSupported()) {
                throw new DataTypeException("mark/reset not supported");
            }
            byte[] buffer = this.skipHeader();
            String string = new String(buffer);
            Objects.requireNonNull(sdLogFormat);
            if (!string.startsWith("GRAUPNER SD LOG")) {
                throw new DataTypeException("starter text does not match");
            }
            if (!this.verifyHoTTFormat()) {
                throw new DataTypeException("data block counter does not match");
            }
        }

        protected boolean verifyHoTTFormat() throws IOException {
            this.mark(1 + this.sdLogFormat.dataBlockSize * 4);
            boolean isHoTT = true;
            byte[] buffer = new byte[this.sdLogFormat.dataBlockSize];
            for (int i = 0; i < 4; ++i) {
                this.read(buffer);
                if (buffer[0] == i + 1) continue;
                isHoTT = false;
                break;
            }
            this.reset();
            return isHoTT;
        }

        @Override
        public synchronized int read() throws IOException {
            if (this.posMax - this.pos <= 0L) {
                return -1;
            }
            int b = this.in.read();
            if (b >= 0) {
                ++this.pos;
            }
            return b;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            long r = this.posMax - this.pos;
            if (r <= 0L) {
                return -1;
            }
            int i = this.in.read(b, off, len);
            if ((long)i > r) {
                i = (int)r;
            }
            if (i > 0) {
                this.pos += (long)i;
            }
            return i;
        }

        @Override
        public synchronized long skip(long n) throws IOException {
            long i = this.in.skip(n);
            if (i > 0L) {
                this.pos += i;
            }
            return i;
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.in.mark(readlimit);
            this.mark = this.pos;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.in.reset();
            this.pos = this.mark;
        }

        private byte[] skipHeader() throws IOException {
            byte[] buffer = new byte[this.sdLogFormat.headerSize];
            this.in.read(buffer);
            return buffer;
        }

        public long getPayloadSize() {
            return this.payloadSize;
        }
    }

    public static class SdLogFormat {
        private final String starterText = "GRAUPNER SD LOG";
        private final int headerSize;
        private final int footerSize;
        private final int dataBlockSize;

        public SdLogFormat(int headerSize, int footerSize, int dataBlockSize) {
            this.headerSize = headerSize;
            this.footerSize = footerSize;
            this.dataBlockSize = dataBlockSize;
        }
    }
}

