/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader;

import com.monstarmike.tlmreader.IFlight;
import com.monstarmike.tlmreader.datablock.DataBlock;
import com.monstarmike.tlmreader.datablock.HeaderBlock;
import com.monstarmike.tlmreader.datablock.HeaderNameBlock;
import com.monstarmike.tlmreader.datablock.HeaderRpmBlock;
import java.util.ArrayList;
import java.util.List;

public class FlightDefinition
implements IFlight {
    private ArrayList<HeaderBlock> headerData = new ArrayList();
    private DataBlock firstDataBlock;
    private DataBlock lastDataBlock;
    private int numberOfDataBlocks;
    String modelName;
    private HeaderRpmBlock rpmHeaderBlock;

    @Override
    public long getDuration_ms() {
        int start = 0;
        int end = 0;
        if (this.firstDataBlock != null && this.lastDataBlock != null) {
            start = this.firstDataBlock.getTimestamp();
            end = this.lastDataBlock.getTimestamp();
        }
        return (end - start) * 10;
    }

    @Override
    public void addHeaderNameBlock(HeaderNameBlock block) {
        this.headerData.add(block);
    }

    @Override
    public void addRpmHeaderBlock(HeaderRpmBlock rpmBlock) {
        this.rpmHeaderBlock = rpmBlock;
        this.headerData.add(rpmBlock);
    }

    @Override
    public HeaderRpmBlock getRpmHeader() {
        return this.rpmHeaderBlock;
    }

    @Override
    public void addDataBlock(DataBlock block) {
        ++this.numberOfDataBlocks;
        if (this.firstDataBlock == null) {
            this.firstDataBlock = block;
            this.lastDataBlock = block;
        } else {
            this.lastDataBlock = block;
        }
    }

    public String toString() {
        return String.valueOf(this.modelName) + " duration: " + this.getDuration_ms() + " ms";
    }

    @Override
    public List<HeaderBlock> getHeaderBlocks() {
        return this.headerData;
    }

    @Override
    public int getNumberOfDataBlocks() {
        return this.numberOfDataBlocks;
    }
}

