/*
 * Decompiled with CFR 0.152.
 */
package gde.device.logview;

import gde.Analyzer;
import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.ChannelType;
import gde.device.ChannelTypes;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.MeasurementType;
import gde.device.StatisticsType;
import gde.device.resource.DeviceXmlResource;
import gde.exception.DataInconsitsentException;
import gde.exception.DataTypeException;
import gde.exception.MissMatchDeviceException;
import gde.exception.NotSupportedFileFormatException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.StringHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.logging.Logger;
import org.mozilla.universalchardet.ReaderFactory;

public class ZeroReaderWriter {
    static Logger log = Logger.getLogger(ZeroReaderWriter.class.getName());
    static String lineSep = GDE.LINE_SEPARATOR;
    static DecimalFormat df3 = new DecimalFormat("0.000");
    static StringBuffer sb;
    static final DataExplorer application;
    static final Channels channels;
    static final String DATA_SET_NUMBER = "data-set-number";
    static final String DATA_SET_NAME = "data-set-name";
    static final String MEASUREMENT_NAME_UNIT_SYMBOLS = "name-unit-symbol";
    static final String VALUE_FORMAT = "value-format";
    static final String LOG_MESSAGE = "log-message";
    static final String VALUE_FACTORS = "value-factors";
    static final String VALUE_OFFSETS = "value-offsets";
    static final String VALUE_REDUCTIONS = "value-reductions";
    static final String RESET_TIME_MODE = "reset-time-mode";
    static final String TIME_GIVEN_INDEX = "time-given-index";
    static final String TIME_GIVEN_FORMAT = "time-given-format";
    static final String TIME_GIVEN_MS = "time-given-ms";
    static final String TIME_GIVEN_MS_LAST = "time-given-ms-last";
    static final String TIME_GIVEN_MS_START = "time-given-ms-start";
    static final String TIME_MODE_INCREMENT = "time-mode-increment";
    static final String TIME_MODE_INCREMENT_START = "time-mode-increment-start";
    static final String TIME_MODE_INCREMENT_MS = "time-mode-increment-ms";

    private static HashMap<String, String> getHeaderDataSet(HashMap<Integer, HashMap<String, String>> headers, String line) {
        int channelConfigNumber;
        int n = channelConfigNumber = line.substring(2, 3).matches("([0-9])") ? Integer.parseInt(line.substring(2, 3)) : 1;
        if (headers.get(channelConfigNumber) == null) {
            headers.put(channelConfigNumber, new HashMap());
        }
        HashMap<String, String> header = headers.get(channelConfigNumber);
        return header;
    }

    public static HashMap<Integer, HashMap<String, String>> updateHeaders(HashMap<Integer, HashMap<String, String>> headers, char separator, String line) throws NotSupportedFileFormatException, IOException {
        if (line.startsWith("$N")) {
            int channelConfigNumber;
            HashMap<String, String> recordSetHeader = ZeroReaderWriter.getHeaderDataSet(headers, line);
            int n = channelConfigNumber = line.substring(2, 3).matches("([0-9])") ? Integer.parseInt(line.substring(2, 3)) : 1;
            if (channels.get((Object)channelConfigNumber) == null) {
                if (recordSetHeader.get(DATA_SET_NAME) == null) {
                    recordSetHeader.put(DATA_SET_NUMBER, "1");
                } else {
                    recordSetHeader.put(DATA_SET_NUMBER, "" + (Integer.parseInt(recordSetHeader.get(DATA_SET_NUMBER)) + 1));
                }
            } else {
                recordSetHeader.put(DATA_SET_NUMBER, "" + (((Channel)channels.get((Object)channelConfigNumber)).size() + 1));
            }
            recordSetHeader.put(DATA_SET_NAME, line.substring(line.indexOf(separator, 2) + 1));
        } else if (line.startsWith("$C")) {
            ZeroReaderWriter.getHeaderDataSet(headers, line).put(MEASUREMENT_NAME_UNIT_SYMBOLS, line.substring(line.indexOf(separator, 2) + 1));
        } else if (line.startsWith("$V")) {
            ZeroReaderWriter.getHeaderDataSet(headers, line).put(VALUE_FORMAT, line.substring(line.indexOf(separator, 2) + 1));
        } else if (line.startsWith("$L")) {
            ZeroReaderWriter.getHeaderDataSet(headers, line).put(LOG_MESSAGE, ZeroReaderWriter.getHeaderDataSet(headers, line).get(LOG_MESSAGE) + line.substring(line.indexOf(separator, 2) + 1) + "\n");
        } else if (line.startsWith("$F")) {
            ZeroReaderWriter.getHeaderDataSet(headers, line).put(VALUE_FACTORS, line.substring(line.indexOf(separator, 2) + 1));
        } else if (line.startsWith("$O")) {
            ZeroReaderWriter.getHeaderDataSet(headers, line).put(VALUE_OFFSETS, line.substring(line.indexOf(separator, 2) + 1));
        } else if (line.startsWith("$S")) {
            ZeroReaderWriter.getHeaderDataSet(headers, line).put(VALUE_REDUCTIONS, line.substring(line.indexOf(separator, 2) + 1));
        } else if (line.startsWith("$R")) {
            ZeroReaderWriter.getHeaderDataSet(headers, line).put(RESET_TIME_MODE, line.substring(line.indexOf(separator, 2) + 1));
        } else if (line.startsWith("$T")) {
            String[] timeGiventDefinition = line.substring(line.indexOf(separator, 2) + 1).split("" + separator);
            if (timeGiventDefinition.length >= 1) {
                ZeroReaderWriter.getHeaderDataSet(headers, line).put(TIME_GIVEN_INDEX, timeGiventDefinition[0]);
            }
            if (timeGiventDefinition.length >= 2) {
                ZeroReaderWriter.getHeaderDataSet(headers, line).put(TIME_GIVEN_FORMAT, timeGiventDefinition[1]);
            }
        } else if (line.startsWith("$I")) {
            String[] timeModeIncrementDefinition = line.substring(line.indexOf(separator, 2) + 1).split("" + separator);
            if (timeModeIncrementDefinition.length >= 1) {
                ZeroReaderWriter.getHeaderDataSet(headers, line).put(TIME_MODE_INCREMENT, timeModeIncrementDefinition[0]);
            }
            if (timeModeIncrementDefinition.length >= 2) {
                int day = Integer.parseInt(timeModeIncrementDefinition[1].substring(0, 1));
                int month = Integer.parseInt(timeModeIncrementDefinition[1].substring(2, 3));
                int year = Integer.parseInt(timeModeIncrementDefinition[1].substring(4, 7));
                int hour = Integer.parseInt(timeModeIncrementDefinition[1].substring(9, 10));
                int minute = Integer.parseInt(timeModeIncrementDefinition[1].substring(11, 12));
                int second = Integer.parseInt(timeModeIncrementDefinition[1].substring(13, 14));
                int msecond = Integer.parseInt(timeModeIncrementDefinition[1].substring(15, 17));
                GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day, hour, minute, second);
                ZeroReaderWriter.getHeaderDataSet(headers, line).put(TIME_MODE_INCREMENT_START, "" + (calendar.getTimeInMillis() + (long)msecond));
            }
        }
        return headers;
    }

    public static RecordSet read(char separator, String filePath, String recordSetNameExtend) throws NotSupportedFileFormatException, MissMatchDeviceException, IOException, DataInconsitsentException, DataTypeException {
        String line = "*";
        RecordSet recordSet = null;
        long inputFileSize = new File(filePath).length();
        int progressLineLength = Math.abs(application.getActiveDevice().getDataBlockSize(InputTypes.FILE_IO));
        BufferedReader reader = null;
        IDevice device = application.getActiveDevice();
        Channel activeChannel = null;
        HashMap<Integer, HashMap<String, String>> headers = new HashMap<Integer, HashMap<String, String>>();
        try {
            HashMap<String, String> dataSetHeader;
            boolean isNewHeaderEntry = false;
            int channelConfigNumber = 1;
            int recordSetNumber = 0;
            int lineNumber = 0;
            long time_ms = 0L;
            int dataStartOffset = 1;
            reader = ReaderFactory.createBufferedReader((File)new File(filePath));
            while ((line = reader.readLine()) != null) {
                int progress;
                ++lineNumber;
                if (!(line = line.trim()).startsWith("$")) continue;
                if (line.matches("\\$([A-Z])\\$(.*)") || line.matches("\\$([A-Z])([1-6])\\$(.*)")) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "header: " + line);
                    }
                    ZeroReaderWriter.updateHeaders(headers, separator, line);
                    isNewHeaderEntry = true;
                    continue;
                }
                if (line.matches("\\$(.*)\\$(.*)") && !line.matches("\\$([1-6])\\$(.*)")) continue;
                channelConfigNumber = 1;
                dataStartOffset = 1;
                if (line.matches("\\$([1-6])\\$(.*)")) {
                    channelConfigNumber = line.substring(1, 2).matches("([0-9])") ? Integer.parseInt(line.substring(1, 2)) : 1;
                    dataStartOffset = 4;
                }
                int recordSetOrdinal = Integer.parseInt(headers.get(channelConfigNumber).get(DATA_SET_NUMBER));
                Object recordSetKey = recordSetOrdinal + ") " + headers.get(channelConfigNumber).get(DATA_SET_NAME);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "channel = " + channelConfigNumber + "; recordSetName  = " + (String)recordSetKey);
                }
                if (isNewHeaderEntry && (channels.get((Object)channelConfigNumber) != null && ((Channel)channels.get((Object)channelConfigNumber)).get(recordSetKey) == null || channels.get((Object)channelConfigNumber) == null)) {
                    dataSetHeader = headers.get(channelConfigNumber);
                    recordSetNumber = Integer.parseInt(headers.get(channelConfigNumber).get(DATA_SET_NUMBER));
                    dataSetHeader.put(TIME_MODE_INCREMENT_MS, null);
                    dataSetHeader.put(TIME_GIVEN_MS_LAST, null);
                    activeChannel = (Channel)channels.get((Object)channelConfigNumber);
                    if (activeChannel == null) {
                        for (int tmpChannelConfigNumber = channels.size() + 1; channels.get((Object)tmpChannelConfigNumber) == null && tmpChannelConfigNumber <= channelConfigNumber; ++tmpChannelConfigNumber) {
                            channels.put((Object)tmpChannelConfigNumber, (Object)new Channel(Analyzer.getInstance(), DeviceXmlResource.getInstance().getReplacement("type_config_" + tmpChannelConfigNumber), ChannelTypes.TYPE_CONFIG));
                            activeChannel = (Channel)channels.get((Object)tmpChannelConfigNumber);
                            device.getDeviceConfiguration().addChannelType(new ChannelType());
                            device.getDeviceConfiguration().setChannelName("type_config_" + tmpChannelConfigNumber, tmpChannelConfigNumber);
                            device.getDeviceConfiguration().setChannelTypes(ChannelTypes.TYPE_CONFIG, tmpChannelConfigNumber);
                            device.getDeviceConfiguration().addMeasurement2Channel(tmpChannelConfigNumber, new MeasurementType());
                        }
                    }
                    if (activeChannel != null) {
                        int i;
                        GDE.getUiNotification().setStatusMessage(Messages.getString((String)"GDE_MSGT0134") + filePath);
                        GDE.getUiNotification().setProgress(0);
                        recordSetKey = recordSetNumber + ") " + dataSetHeader.get(DATA_SET_NAME);
                        String[] tmpMeasurementNameUnitSymbols = dataSetHeader.get(MEASUREMENT_NAME_UNIT_SYMBOLS).split("" + separator);
                        ArrayList<String> tmpRecordNames = new ArrayList<String>();
                        ArrayList<String> tmpRecordUnits = new ArrayList<String>();
                        ArrayList<String> tmpRecordSymbols = new ArrayList<String>();
                        for (String tmpMeasurementNameUnitSymbol : tmpMeasurementNameUnitSymbols) {
                            String[] measurementNameUnitSymbol = tmpMeasurementNameUnitSymbol.split("\\[|\\]|\\,");
                            tmpRecordNames.add(measurementNameUnitSymbol[0]);
                            tmpRecordUnits.add(measurementNameUnitSymbol.length > 1 ? measurementNameUnitSymbol[1] : " ");
                            tmpRecordSymbols.add(measurementNameUnitSymbol.length > 2 ? measurementNameUnitSymbol[2] : " ");
                        }
                        ArrayList tmpMeasurementFactors = dataSetHeader.get(VALUE_FACTORS) != null ? Arrays.asList(dataSetHeader.get(VALUE_FACTORS).split("" + separator)) : new ArrayList(tmpRecordNames.size());
                        ArrayList tmpMeasurementOffsets = dataSetHeader.get(VALUE_OFFSETS) != null ? Arrays.asList(dataSetHeader.get(VALUE_OFFSETS).split("" + separator)) : new ArrayList(tmpRecordNames.size());
                        ArrayList tmpMeasurementReductions = dataSetHeader.get(VALUE_REDUCTIONS) != null ? Arrays.asList(dataSetHeader.get(VALUE_REDUCTIONS).split("" + separator)) : new ArrayList(tmpRecordNames.size());
                        int existingNumberMeasurementTypes = device.getDeviceConfiguration().getMeasurementNames(channelConfigNumber).length;
                        for (i = tmpRecordNames.size(); i < existingNumberMeasurementTypes; ++i) {
                            device.removeMeasurementFromChannel(channelConfigNumber, device.getMeasurement(channelConfigNumber, tmpRecordNames.size()));
                        }
                        for (i = 0; i < tmpRecordNames.size(); ++i) {
                            MeasurementType measurement = device.getMeasurement(channelConfigNumber, i);
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, (String)tmpRecordNames.get(i));
                            }
                            measurement.setName(((String)tmpRecordNames.get(i)).trim());
                            measurement.setUnit((String)tmpRecordUnits.get(i));
                            measurement.setSymbol((String)tmpRecordSymbols.get(i));
                            measurement.setActive(Boolean.valueOf(true));
                            measurement.setStatistics(StatisticsType.fromString((String)"min=true max=true avg=true sigma=false"));
                            if (tmpMeasurementFactors.size() > i && ((String)tmpMeasurementFactors.get(i)).matches("([0-9])")) {
                                measurement.setFactor(Double.parseDouble((String)tmpMeasurementFactors.get(i)));
                            } else {
                                measurement.setFactor(1.0);
                            }
                            if (tmpMeasurementOffsets.size() > i && ((String)tmpMeasurementOffsets.get(i)).matches("([0-9])")) {
                                measurement.setOffset(Double.parseDouble((String)tmpMeasurementOffsets.get(i)));
                            } else {
                                measurement.setOffset(0.0);
                            }
                            if (tmpMeasurementReductions.size() > i && ((String)tmpMeasurementReductions.get(i)).matches("([0-9])")) {
                                measurement.setReduction(Double.parseDouble((String)tmpMeasurementReductions.get(i)));
                                continue;
                            }
                            measurement.setReduction(0.0);
                        }
                        device.setChangePropery(true);
                        device.storeDeviceProperties();
                        recordSet = RecordSet.createRecordSet((String)recordSetKey, (IDevice)device, (int)channelConfigNumber, (String[])tmpRecordNames.toArray(new String[0]), (String[])tmpRecordSymbols.toArray(new String[0]), (String[])tmpRecordUnits.toArray(new String[0]), (double)device.getTimeStep_ms(), (boolean)true, (boolean)true, (boolean)true);
                        recordSetKey = recordSet.getName();
                        for (i = 0; i < recordSet.size(); ++i) {
                            Record record = recordSet.get(i);
                            if (record.getUnit().equals("km/h")) {
                                record.setDataType(Record.DataType.GPS_SPEED);
                                continue;
                            }
                            if (record.getUnit().equals("m") && (record.getName().toLowerCase().contains("alti") || record.getName().toLowerCase().contains("h\u00f6he"))) {
                                record.setDataType(Record.DataType.GPS_ALTITUDE);
                                continue;
                            }
                            if (record.getUnit().contains("\u00b0") && (record.getName().toLowerCase().contains("long") || record.getName().toLowerCase().contains("l\u00e4nge"))) {
                                record.setDataType(Record.DataType.GPS_LONGITUDE);
                                continue;
                            }
                            if (!record.getUnit().contains("\u00b0") || !record.getName().toLowerCase().contains("lat") && !record.getName().toLowerCase().contains("breit")) continue;
                            record.setDataType(Record.DataType.GPS_LATITUDE);
                        }
                        activeChannel.put(recordSetKey, (Object)recordSet);
                    }
                    isNewHeaderEntry = false;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, String.format("channel: %d, recordSet %d, data line: %s", channelConfigNumber, recordSetNumber, line));
                }
                dataSetHeader = headers.get(channelConfigNumber);
                recordSetNumber = Integer.parseInt(headers.get(channelConfigNumber).get(DATA_SET_NUMBER));
                recordSetKey = recordSetOrdinal + ") " + headers.get(channelConfigNumber).get(DATA_SET_NAME);
                recordSet = (RecordSet)((Channel)channels.get((Object)channelConfigNumber)).get(recordSetKey);
                String[] updateRecordNames = recordSet.getRecordNames();
                int[] points = new int[updateRecordNames.length];
                line = line.substring(dataStartOffset);
                String[] dataStringArray = line.split("" + separator);
                String data = dataStringArray[0].trim().replace(',', '.');
                int indexTimeGiven = dataSetHeader.get(TIME_GIVEN_INDEX) != null ? Integer.parseInt(dataSetHeader.get(TIME_GIVEN_INDEX)) : -1;
                int i = 0;
                block25: for (int j = 0; j < updateRecordNames.length && i < dataStringArray.length; ++i, ++j) {
                    try {
                        data = dataStringArray[i].trim().replace(',', '.').replace(" ", "");
                        if (indexTimeGiven == i) {
                            String formatString = dataSetHeader.get(TIME_GIVEN_FORMAT).replace(" ", "");
                            int year = new GregorianCalendar().get(1);
                            int subIndex = 0;
                            if (formatString.toLowerCase().contains("yyyy")) {
                                subIndex = formatString.indexOf("yyyy");
                                year = Integer.parseInt(data.substring(subIndex, 4));
                            }
                            int month = new GregorianCalendar().get(2);
                            if (formatString.contains("MM")) {
                                subIndex = formatString.indexOf("MM");
                                month = Integer.parseInt(data.substring(subIndex, subIndex + 2)) - 1;
                            }
                            int day = new GregorianCalendar().get(5);
                            if (formatString.contains("dd")) {
                                subIndex = formatString.indexOf("dd");
                                day = Integer.parseInt(data.substring(subIndex, subIndex + 2));
                            }
                            int hour = new GregorianCalendar().get(11);
                            if (formatString.contains("HH")) {
                                subIndex = formatString.indexOf("HH");
                                hour = Integer.parseInt(data.substring(subIndex, subIndex + 2));
                            } else if (formatString.contains("hh")) {
                                subIndex = formatString.indexOf("hh");
                                hour = Integer.parseInt(data.substring(subIndex, subIndex + 2));
                            }
                            int minute = new GregorianCalendar().get(12);
                            if (formatString.contains("mm")) {
                                subIndex = formatString.indexOf("mm");
                                minute = Integer.parseInt(data.substring(subIndex, subIndex + 2));
                            }
                            int second = new GregorianCalendar().get(13);
                            if (formatString.contains("ss")) {
                                subIndex = formatString.indexOf("ss");
                                second = Integer.parseInt(data.substring(subIndex, subIndex + 2));
                            }
                            GregorianCalendar calendar = new GregorianCalendar(year, month, day, hour, minute, second);
                            int milliseconds = 0;
                            if (formatString.contains(".f") || formatString.contains(".S")) {
                                subIndex = formatString.indexOf(".") + 1;
                                milliseconds = Integer.parseInt(data.substring(subIndex, data.length())) * 100;
                            }
                            dataSetHeader.put(TIME_GIVEN_MS, "" + (calendar.getTimeInMillis() + (long)milliseconds));
                            if (dataSetHeader.get(TIME_GIVEN_MS_START) == null) {
                                dataSetHeader.put(TIME_GIVEN_MS_START, "" + (calendar.getTimeInMillis() + (long)milliseconds));
                            }
                            --j;
                            continue;
                        }
                    }
                    catch (Exception e) {
                        data = "0";
                        log.log(Level.WARNING, String.format("Check line = %s", line));
                    }
                    switch (recordSet.get(j).getDataType()) {
                        case GPS_LONGITUDE: 
                        case GPS_LATITUDE: {
                            try {
                                data = data.replace("E", "").replace('W', '-').replace("N", "").replace('S', '-').replace(":", ".");
                                if (data.contains(".")) {
                                    points[j] = Integer.parseInt(String.format("%s%6s", data.substring(0, data.indexOf(46)), (data.substring(data.indexOf(46) + 1) + "000000").substring(0, 6)));
                                    continue block25;
                                }
                                points[j] = Integer.parseInt(data);
                            }
                            catch (NumberFormatException e1) {
                                points[j] = 0;
                            }
                            continue block25;
                        }
                        default: {
                            try {
                                if (dataSetHeader.get(VALUE_FORMAT) == null || dataSetHeader.get(VALUE_FORMAT).equals("DOUBLE")) {
                                    points[j] = (int)(Double.parseDouble(data) * 1000.0);
                                    continue block25;
                                }
                                points[j] = Integer.parseInt(data, 16) * 1000;
                                continue block25;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (dataSetHeader.get(TIME_MODE_INCREMENT) != null) {
                    time_ms = dataSetHeader.get(TIME_MODE_INCREMENT_MS) != null ? Long.parseLong(dataSetHeader.get(TIME_MODE_INCREMENT_MS)) : 0L;
                } else if (dataSetHeader.get(TIME_GIVEN_INDEX) != null) {
                    time_ms = dataSetHeader.get(TIME_GIVEN_MS_LAST) != null ? Long.parseLong(dataSetHeader.get(TIME_GIVEN_MS)) - Long.parseLong(dataSetHeader.get(TIME_GIVEN_MS_LAST)) : 0L;
                }
                recordSet.addPoints(points, (double)time_ms);
                if (dataSetHeader.get(TIME_MODE_INCREMENT) != null) {
                    dataSetHeader.put(TIME_MODE_INCREMENT_MS, "" + (time_ms += Long.parseLong(dataSetHeader.get(TIME_MODE_INCREMENT))));
                } else if (dataSetHeader.get(TIME_GIVEN_INDEX) != null) {
                    dataSetHeader.put(TIME_GIVEN_MS_LAST, "" + (Long.parseLong(dataSetHeader.get(TIME_GIVEN_MS)) - time_ms));
                }
                if ((progress = (int)((long)(lineNumber * 100) / (inputFileSize / (long)(progressLineLength = progressLineLength > line.length() ? progressLineLength : line.length())))) > 90 || progress <= GDE.getUiNotification().getProgressPercentage() || progress % 10 != 0) continue;
                GDE.getUiNotification().setProgress(progress);
                try {
                    Thread.sleep(2L);
                }
                catch (Exception exception) {}
            }
            if (reader != null) {
                reader.close();
            }
            for (Channel channel : Channels.getInstance().values()) {
                dataSetHeader = (HashMap<String, String>)headers.get(channel.getNumber());
                for (RecordSet updateRecordSet : channel.values()) {
                    long startTimeStamp = dataSetHeader.get(TIME_GIVEN_MS_START) != null ? Long.parseLong((String)dataSetHeader.get(TIME_GIVEN_MS_START)) : (long)((double)new File(filePath).lastModified() - updateRecordSet.getMaxTime_ms());
                    updateRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(startTimeStamp));
                    updateRecordSet.setStartTimeStamp(startTimeStamp);
                    channel.setFileDescription(new SimpleDateFormat("yyyy-MM-dd").format(startTimeStamp).substring(0, 10) + channel.getFileDescription().substring(10));
                    channel.setActiveRecordSet(updateRecordSet.getName());
                    device.updateVisibilityStatus(updateRecordSet, true);
                    channel.applyTemplate(updateRecordSet.getName(), true);
                    updateRecordSet.setSaved(true);
                }
            }
            if (GDE.isWithUi()) {
                channels.switchChannel(channelConfigNumber, "");
                application.getMenuToolBar().updateChannelSelector();
                activeChannel = channels.getActiveChannel();
                activeChannel.switchRecordSet(recordSet.getName());
            }
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new UnsupportedEncodingException(Messages.getString((String)"GDE_MSGW0010"));
        }
        catch (FileNotFoundException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new FileNotFoundException(Messages.getString((String)"GDE_MSGW0011", (Object[])new Object[]{filePath}));
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new IOException(Messages.getString((String)"GDE_MSGW0012", (Object[])new Object[]{filePath}));
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new IOException(Messages.getString((String)"GDE_MSGW0012", (Object[])new Object[]{filePath}));
        }
        finally {
            GDE.getUiNotification().setProgress(100);
            GDE.getUiNotification().setStatusMessage("");
            if (GDE.isWithUi()) {
                application.getMenuToolBar().updateChannelSelector();
                application.getMenuToolBar().updateRecordSetSelectCombo();
            }
        }
        return recordSet;
    }

    public static void write(char separator, String recordSetKey, String filePath, boolean isRaw) throws Exception {
        try {
            GDE.getUiNotification().setStatusMessage(Messages.getString((String)"GDE_MSGT0138", (Object[])new String[]{"csv", filePath}));
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "UTF-8"));
            char decimalSeparator = Settings.getInstance().getDecimalSeparator();
            df3.setGroupingUsed(false);
            sb = new StringBuffer();
            RecordSet recordSet = (RecordSet)Channels.getInstance().getActiveChannel().get((Object)recordSetKey);
            IDevice device = DataExplorer.getInstance().getActiveDevice();
            sb.append(device.getName()).append(separator).append(recordSet.getChannelConfigName()).append(lineSep);
            writer.write(sb.toString());
            log.log(Level.FINE, "written header line = " + sb.toString());
            sb = new StringBuffer();
            sb.append(Messages.getString((String)"GDE_MSGT0137")).append(separator);
            for (int i = 0; i < recordSet.size(); ++i) {
                MeasurementType measurement = device.getMeasurement(recordSet.getChannelConfigNumber(), i);
                Record record = recordSet.get(i);
                log.log(Level.FINEST, "append " + record.getName());
                if (isRaw) {
                    if (measurement.isCalculation()) continue;
                    sb.append(record.getName()).append(" [---]").append(separator);
                    log.log(Level.FINEST, "append " + record.getName());
                    continue;
                }
                sb.append(record.getName()).append(" [").append(record.getUnit()).append(']').append(separator);
                log.log(Level.FINEST, "append " + record.getName());
            }
            sb.deleteCharAt(sb.length() - 1).append(lineSep);
            log.log(Level.FINER, "header line = " + sb.toString());
            writer.write(sb.toString());
            long startTime = new Date(recordSet.getTime(0)).getTime();
            int recordEntries = recordSet.getRecordDataSize(true);
            int progressCycle = 0;
            GDE.getUiNotification().setProgress(progressCycle);
            for (int i = 0; i < recordEntries; ++i) {
                sb = new StringBuffer();
                String[] row = recordSet.getExportRow(i, true);
                sb.append(row[0].replace('.', decimalSeparator)).append(separator).append(" ");
                for (int j = 0; j < recordSet.size(); ++j) {
                    MeasurementType measurement = device.getMeasurement(recordSet.getChannelConfigNumber(), j);
                    if (isRaw) {
                        if (measurement.isCalculation()) continue;
                        if (recordSet.isRaw()) {
                            sb.append(row[j + 1].replace('.', decimalSeparator)).append(separator);
                            continue;
                        }
                        sb.append(row[j + 1].replace('.', decimalSeparator)).append(separator);
                        continue;
                    }
                    sb.append(row[j + 1].replace('.', decimalSeparator)).append(separator);
                }
                sb.deleteCharAt(sb.length() - 1).append(lineSep);
                writer.write(sb.toString());
                if (i % 50 == 0) {
                    GDE.getUiNotification().setProgress(++progressCycle * 5000 / recordEntries);
                }
                if (!log.isLoggable(Level.FINE)) continue;
                log.log(Level.FINE, "data line = " + sb.toString());
            }
            sb = null;
            log.log(Level.TIME, "CSV file = " + filePath + " erfolgreich geschiebenwrite time = " + StringHelper.getFormatedTime((String)"ss:SSS", (long)(new Date().getTime() - startTime)));
            writer.flush();
            writer.close();
            writer = null;
            GDE.getUiNotification().setProgress(100);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new Exception(Messages.getString((String)"GDE_MSGE0006", (Object[])new Object[]{"csv", filePath, e.getMessage()}));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new Exception(Messages.getString((String)"GDE_MSGE0007") + e.getClass().getSimpleName() + " - " + e.getMessage());
        }
        finally {
            GDE.getUiNotification().setStatusMessage("");
        }
    }

    static {
        application = DataExplorer.getInstance();
        channels = Channels.getInstance();
    }
}

