/*
 * Decompiled with CFR 0.152.
 */
package gde.device.bantam;

import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.bantam.CalculationThread;
import gde.device.bantam.EStationDialog;
import gde.device.bantam.EStationSerialPort;
import gde.device.bantam.GathererThread;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.SerialPortException;
import gde.io.LogViewReader;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;

public class eStation
extends DeviceConfiguration
implements IDevice {
    static final Logger log = Logger.getLogger(eStation.class.getName());
    public final String[] USAGE_MODE;
    public String[] ACCU_TYPES;
    public static final String CONFIG_EXT_TEMP_CUT_OFF = "ext_temp_cut_off";
    public static final String CONFIG_WAIT_TIME = "wait_time";
    public static final String CONFIG_IN_VOLTAGE_CUT_OFF = "in_voltage_cut_off";
    public static final String CONFIG_SAFETY_TIME = "safety_time";
    public static final String CONFIG_SET_CAPASITY = "capacity_cut_off";
    public static final String CONFIG_PROCESSING = "processing";
    public static final String CONFIG_BATTERY_TYPE = "battery_type";
    public static final String CONFIG_PROCESSING_TIME = "processing_time";
    protected final DataExplorer application;
    protected final EStationSerialPort serialPort;
    protected final Channels channels;
    protected EStationDialog dialog;
    protected HashMap<String, CalculationThread> calculationThreads = new HashMap();

    public eStation(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.bantam.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.USAGE_MODE = new String[]{Messages.getString((String)"GDE_MSGT1400"), Messages.getString((String)"GDE_MSGT1401"), Messages.getString((String)"GDE_MSGT1402")};
        this.ACCU_TYPES = new String[]{Messages.getString((String)"GDE_MSGT1403"), Messages.getString((String)"GDE_MSGT1404"), Messages.getString((String)"GDE_MSGT1405"), Messages.getString((String)"GDE_MSGT1406")};
        this.application = DataExplorer.getInstance();
        this.serialPort = new EStationSerialPort(this, this.application);
        this.channels = Channels.getInstance();
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(1, "", "");
        }
    }

    public eStation(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.bantam.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.USAGE_MODE = new String[]{Messages.getString((String)"GDE_MSGT1400"), Messages.getString((String)"GDE_MSGT1401"), Messages.getString((String)"GDE_MSGT1402")};
        this.ACCU_TYPES = new String[]{Messages.getString((String)"GDE_MSGT1403"), Messages.getString((String)"GDE_MSGT1404"), Messages.getString((String)"GDE_MSGT1405"), Messages.getString((String)"GDE_MSGT1406")};
        this.application = DataExplorer.getInstance();
        this.serialPort = new EStationSerialPort(this, this.application);
        this.channels = Channels.getInstance();
        this.configureSerialPortMenu(1, "", "");
    }

    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        return lov2osdMap;
    }

    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        return "";
    }

    public int getLovDataByteSize() {
        return 84;
    }

    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int deviceDataBufferSize = 76;
        int[] points = new int[this.getNumberOfMeasurements(1)];
        int offset = 0;
        int progressCycle = 0;
        int lovDataSize = this.getLovDataByteSize();
        long lastDateTime = 0L;
        long sumTimeDelta = 0L;
        long deltaTime = 0L;
        if (dataBuffer[0] == 123) {
            byte[] convertBuffer = new byte[deviceDataBufferSize];
            if (doUpdateProgressBar) {
                this.application.setProgress(progressCycle, sThreadId);
            }
            for (int i = 0; i < recordDataSize; ++i) {
                System.arraycopy(dataBuffer, offset + i * lovDataSize, convertBuffer, 0, deviceDataBufferSize);
                recordSet.addPoints(this.convertDataBytes(points, convertBuffer));
                if (!doUpdateProgressBar || i % 50 != 0) continue;
                this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
            }
            recordSet.setTimeStep_ms(this.getAverageTimeStep_ms() != null ? this.getAverageTimeStep_ms() : 1478.0);
        } else {
            byte[] sizeBuffer = new byte[4];
            byte[] convertBuffer = new byte[deviceDataBufferSize];
            if (doUpdateProgressBar) {
                this.application.setProgress(progressCycle, sThreadId);
            }
            for (int i = 0; i < recordDataSize; ++i) {
                System.arraycopy(dataBuffer, offset, sizeBuffer, 0, 4);
                lovDataSize = 4 + LogViewReader.parse2Int((byte[])sizeBuffer);
                System.arraycopy(dataBuffer, offset + 4, convertBuffer, 0, deviceDataBufferSize);
                recordSet.addPoints(this.convertDataBytes(points, convertBuffer));
                StringBuilder sb = new StringBuilder();
                byte[] timeBuffer = new byte[lovDataSize - deviceDataBufferSize - 4];
                System.arraycopy(dataBuffer, (offset += lovDataSize) - timeBuffer.length, timeBuffer, 0, timeBuffer.length);
                String timeStamp = new String(timeBuffer).substring(0, timeBuffer.length - 8) + "0000000000";
                long dateTime = Long.parseLong(timeStamp.substring(6, 17));
                log.log(Level.FINEST, timeStamp + " " + timeStamp.substring(6, 17) + " " + dateTime);
                sb.append(dateTime);
                deltaTime = lastDateTime == 0L ? 0L : (dateTime - lastDateTime) / 1000L - 217L;
                sb.append(" - ").append(deltaTime);
                sb.append(" - ").append(sumTimeDelta += deltaTime);
                log.log(Level.FINER, sb.toString());
                lastDateTime = dateTime;
                recordSet.addTimeStep_ms((double)sumTimeDelta);
                if (!doUpdateProgressBar || i % 50 != 0) continue;
                this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
            }
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        this.updateVisibilityStatus(recordSet, true);
        recordSet.syncScaleOfSyncableRecords();
    }

    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        int maxVotage = Integer.MIN_VALUE;
        int minVotage = Integer.MAX_VALUE;
        points[0] = (((dataBuffer[35] & 0xFF) - 128) * 100 + ((dataBuffer[36] & 0xFF) - 128)) * 10;
        points[1] = (((dataBuffer[33] & 0xFF) - 128) * 100 + ((dataBuffer[34] & 0xFF) - 128)) * 10;
        points[2] = (((dataBuffer[43] & 0xFF) - 128) * 100 + ((dataBuffer[44] & 0xFF) - 128)) * 1000;
        points[3] = Double.valueOf((double)points[0] / 1000.0 * ((double)points[1] / 1000.0) * 1000.0).intValue();
        points[4] = Double.valueOf((double)points[0] / 1000.0 * ((double)points[2] / 1000.0)).intValue();
        points[5] = (((dataBuffer[37] & 0xFF) - 128) * 100 + ((dataBuffer[38] & 0xFF) - 128)) * 10;
        points[6] = (((dataBuffer[39] & 0xFF) - 128) * 100 + ((dataBuffer[40] & 0xFF) - 128)) * 10;
        points[7] = (((dataBuffer[41] & 0xFF) - 128) * 100 + ((dataBuffer[42] & 0xFF) - 128)) * 10;
        points[8] = 0;
        int i = 0;
        int j = 0;
        while (i < points.length - 9) {
            points[i + 9] = (((dataBuffer[j + 45] & 0xFF) - 128) * 100 + ((dataBuffer[j + 46] & 0xFF) - 128)) * 10;
            if (points[i + 9] > 0) {
                maxVotage = points[i + 9] > maxVotage ? points[i + 9] : maxVotage;
                minVotage = points[i + 9] < minVotage ? points[i + 9] : minVotage;
            }
            ++i;
            j += 2;
        }
        points[8] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
        return points;
    }

    boolean isCycleMode(byte[] dataBuffer) {
        return ((dataBuffer[8] & 0xFF) - 128 & 0x10) > 0;
    }

    public int getNumberOfCycle(byte[] dataBuffer) {
        int cycleCount = 0;
        int accuCellType = this.getAccuCellType(dataBuffer);
        if (accuCellType == 2) {
            cycleCount = (dataBuffer[16] & 0xFF) - 128;
        } else if (accuCellType == 3) {
            cycleCount = (dataBuffer[12] & 0xFF) - 128;
        }
        return cycleCount;
    }

    public int getNumberOfLithiumXCells(byte[] dataBuffer) {
        return (dataBuffer[18] & 0xFF) - 128;
    }

    public int getAccuCellType(byte[] dataBuffer) {
        return (dataBuffer[23] & 0xFF) - 128;
    }

    public boolean isProcessing(byte[] dataBuffer) {
        return (dataBuffer[24] & 0xFF) - 128 == 1;
    }

    public int getProcessingMode(byte[] dataBuffer) {
        int modeIndex = (dataBuffer[24] & 0xFF) - 128;
        if (modeIndex != 0) {
            modeIndex = (dataBuffer[8] & 0xF) == 1 ? 2 : 1;
        }
        return modeIndex;
    }

    public int getProcessingTime(byte[] dataBuffer) {
        return (dataBuffer[69] & 0x7F) * 100 + (dataBuffer[70] & 0x7F);
    }

    public int getFeedBackCurrent(byte[] dataBuffer) {
        return (((dataBuffer[33] & 0xFF) - 128) * 100 + ((dataBuffer[34] & 0xFF) - 128)) * 10;
    }

    public HashMap<String, String> getConfigurationValues(HashMap<String, String> configData, byte[] dataBuffer) {
        configData.put(CONFIG_EXT_TEMP_CUT_OFF, "" + (dataBuffer[4] & 0x7F));
        configData.put(CONFIG_WAIT_TIME, "" + (dataBuffer[5] & 0x7F));
        configData.put(CONFIG_IN_VOLTAGE_CUT_OFF, "" + (dataBuffer[7] & 0x7F) / 10);
        configData.put(CONFIG_SAFETY_TIME, "" + ((dataBuffer[29] & 0x7F) * 100 + (dataBuffer[30] & 0x7F) * 10));
        configData.put(CONFIG_SET_CAPASITY, "" + ((dataBuffer[31] & 0x7F) * 100 + (dataBuffer[32] & 0x7F)));
        if (this.getProcessingMode(dataBuffer) != 0) {
            configData.put(CONFIG_BATTERY_TYPE, this.ACCU_TYPES[(dataBuffer[23] & 0x7F) - 1]);
            configData.put(CONFIG_PROCESSING_TIME, "" + ((dataBuffer[69] & 0x7F) * 100 + (dataBuffer[70] & 0x7F)));
        }
        if (log.isLoggable(Level.FINE)) {
            for (Map.Entry<String, String> entry : configData.entrySet()) {
                log.log(Level.FINE, entry.getKey() + " = " + entry.getValue());
            }
        }
        return configData;
    }

    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int progressCycle = 0;
        Vector<Integer> timeStamps = new Vector<Integer>(1, 1);
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        int timeStampBufferSize = 0;
        if (!recordSet.isTimeStepConstant()) {
            timeStampBufferSize = 4 * recordDataSize;
            byte[] timeStampBuffer = new byte[timeStampBufferSize];
            System.arraycopy(dataBuffer, 0, timeStampBuffer, 0, timeStampBufferSize);
            for (int i = 0; i < recordDataSize; ++i) {
                timeStamps.add(((timeStampBuffer[0 + i * 4] & 0xFF) << 24) + ((timeStampBuffer[1 + i * 4] & 0xFF) << 16) + ((timeStampBuffer[2 + i * 4] & 0xFF) << 8) + ((timeStampBuffer[3 + i * 4] & 0xFF) << 0));
                if (!doUpdateProgressBar || i % 50 != 0) continue;
                this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
            }
        }
        log.log(Level.FINE, timeStamps.size() + " timeStamps = " + timeStamps.toString());
        for (int i = 0; i < recordDataSize; ++i) {
            log.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize + timeStampBufferSize);
            System.arraycopy(dataBuffer, i * dataBufferSize + timeStampBufferSize, convertBuffer, 0, dataBufferSize);
            points[0] = ((convertBuffer[0] & 0xFF) << 24) + ((convertBuffer[1] & 0xFF) << 16) + ((convertBuffer[2] & 0xFF) << 8) + ((convertBuffer[3] & 0xFF) << 0);
            points[1] = ((convertBuffer[4] & 0xFF) << 24) + ((convertBuffer[5] & 0xFF) << 16) + ((convertBuffer[6] & 0xFF) << 8) + ((convertBuffer[7] & 0xFF) << 0);
            points[2] = ((convertBuffer[8] & 0xFF) << 24) + ((convertBuffer[9] & 0xFF) << 16) + ((convertBuffer[10] & 0xFF) << 8) + ((convertBuffer[11] & 0xFF) << 0);
            points[3] = Double.valueOf((double)points[0] / 1000.0 * ((double)points[1] / 1000.0) * 1000.0).intValue();
            points[4] = Double.valueOf((double)points[0] / 1000.0 * ((double)points[2] / 1000.0)).intValue();
            points[5] = ((convertBuffer[12] & 0xFF) << 24) + ((convertBuffer[13] & 0xFF) << 16) + ((convertBuffer[14] & 0xFF) << 8) + ((convertBuffer[15] & 0xFF) << 0);
            points[6] = ((convertBuffer[16] & 0xFF) << 24) + ((convertBuffer[17] & 0xFF) << 16) + ((convertBuffer[18] & 0xFF) << 8) + ((convertBuffer[19] & 0xFF) << 0);
            points[7] = ((convertBuffer[20] & 0xFF) << 24) + ((convertBuffer[21] & 0xFF) << 16) + ((convertBuffer[22] & 0xFF) << 8) + ((convertBuffer[23] & 0xFF) << 0);
            points[8] = 0;
            int maxVotage = Integer.MIN_VALUE;
            int minVotage = Integer.MAX_VALUE;
            int j = 0;
            int k = 0;
            while (j < points.length - 9) {
                points[j + 9] = ((convertBuffer[k + 24] & 0xFF) << 24) + ((convertBuffer[k + 25] & 0xFF) << 16) + ((convertBuffer[k + 26] & 0xFF) << 8) + ((convertBuffer[k + 27] & 0xFF) << 0);
                if (points[j + 9] > 0) {
                    maxVotage = points[j + 9] > maxVotage ? points[j + 9] : maxVotage;
                    minVotage = points[j + 9] < minVotage ? points[j + 9] : minVotage;
                }
                ++j;
                k += 4;
            }
            int n = points[8] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
            if (recordSet.isTimeStepConstant()) {
                recordSet.addPoints(points);
            } else {
                recordSet.addPoints(points, (double)((Integer)timeStamps.get(i)).intValue() / 10.0);
            }
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
        recordSet.getDevice().updateVisibilityStatus(recordSet, true);
    }

    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                double reduction = record.getReduction();
                double factor = record.getFactor();
                dataTableRow[index + 1] = record.getOrdinal() > 5 && record.getUnit().equals("V") ? String.format("%.3f", ((double)record.realGet(rowIndex).intValue() / 1000.0 - reduction) * factor) : record.getDecimalFormat().format(((double)record.realGet(rowIndex).intValue() / 1000.0 - reduction) * factor);
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    public double translateValue(Record record, double value) {
        double offset = record.getOffset();
        double factor = record.getFactor();
        double newValue = value * factor + offset;
        log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    public double reverseTranslateValue(Record record, double value) {
        double offset = record.getOffset();
        double factor = record.getFactor();
        double newValue = value / factor - offset;
        log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        int i;
        int displayableCounter = 0;
        recordSet.setAllDisplayable();
        for (String recordKey : recordSet.getNoneCalculationRecordNames()) {
            recordSet.get((Object)recordKey).setActive(Boolean.valueOf(true));
        }
        for (i = 6; i < recordSet.size(); ++i) {
            Record record = recordSet.get(i);
            record.setDisplayable(record.hasReasonableData());
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, record.getName() + " setDisplayable=" + record.hasReasonableData());
            }
            if (!record.isActive() || !record.isDisplayable()) continue;
            ++displayableCounter;
        }
        if (log.isLoggable(Level.FINE)) {
            for (i = 0; i < recordSet.size(); ++i) {
                Record record = recordSet.get(i);
                log.log(Level.FINE, record.getName() + " isActive=" + record.isActive() + " isVisible=" + record.isVisible() + " isDisplayable=" + record.isDisplayable());
            }
        }
        recordSet.setConfiguredDisplayable(displayableCounter);
    }

    public void makeInActiveDisplayable(RecordSet recordSet) {
        if (recordSet.isRaw()) {
            try {
                int displayableCounter = 0;
                for (String measurementKey : recordSet.keySet()) {
                    Record record = recordSet.get((Object)measurementKey);
                    if (!record.isActive() || record.getOrdinal() > 6 && !record.hasReasonableData()) continue;
                    ++displayableCounter;
                }
                Record record = recordSet.get(3);
                if (!(record == null || record.size() != 0 && record.hasReasonableData())) {
                    this.calculationThreads.put(record.getName(), new CalculationThread(record.getName(), this.channels.getActiveChannel().getActiveRecordSet()));
                    try {
                        this.calculationThreads.get(record.getName()).start();
                    }
                    catch (RuntimeException e) {
                        log.log(Level.WARNING, e.getMessage(), e);
                    }
                }
                ++displayableCounter;
                record = recordSet.get(4);
                if (!(record == null || record.size() != 0 && record.hasReasonableData())) {
                    this.calculationThreads.put(record.getName(), new CalculationThread(record.getName(), this.channels.getActiveChannel().getActiveRecordSet()));
                    try {
                        this.calculationThreads.get(record.getName()).start();
                    }
                    catch (RuntimeException e) {
                        log.log(Level.WARNING, e.getMessage(), e);
                    }
                }
                log.log(Level.FINE, "displayableCounter = " + ++displayableCounter);
                recordSet.setConfiguredDisplayable(displayableCounter);
                if (recordSet.getName().equals(this.channels.getActiveChannel().getActiveRecordSet().getName())) {
                    this.application.updateGraphicsWindow();
                }
            }
            catch (RuntimeException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public EStationSerialPort getCommunicationPort() {
        return this.serialPort;
    }

    public String[] getUsedPropertyKeys() {
        return new String[]{IDevice.OFFSET, IDevice.FACTOR};
    }

    public EStationDialog getDialog() {
        return this.dialog;
    }

    public void open_closeCommPort() {
        block14: {
            if (this.serialPort != null) {
                if (!this.serialPort.isConnected()) {
                    try {
                        Channel activChannel = Channels.getInstance().getActiveChannel();
                        if (activChannel == null) break block14;
                        this.getDialog().dataGatherThread = new GathererThread(this.application, this, this.serialPort, activChannel.getNumber(), this.getDialog());
                        try {
                            if (this.serialPort.isConnected()) {
                                this.getDialog().dataGatherThread.start();
                            }
                        }
                        catch (RuntimeException e) {
                            log.log(Level.SEVERE, e.getMessage(), e);
                        }
                        catch (Throwable e) {
                            log.log(Level.SEVERE, e.getMessage(), e);
                        }
                        if (this.getDialog().boundsComposite != null && !this.getDialog().isDisposed()) {
                            this.getDialog().boundsComposite.redraw();
                        }
                    }
                    catch (SerialPortException e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0015", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage()}));
                    }
                    catch (ApplicationConfigurationException e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0010"));
                        this.application.getDeviceSelectionDialog().open();
                    }
                    catch (Throwable e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                    }
                } else {
                    if (this.getDialog().dataGatherThread != null) {
                        this.getDialog().dataGatherThread.stopDataGatheringThread(false, null);
                    }
                    if (this.getDialog().boundsComposite != null && !this.getDialog().isDisposed()) {
                        this.getDialog().boundsComposite.redraw();
                    }
                    this.serialPort.close();
                }
            }
        }
    }

    public int[] getCellVoltageOrdinals() {
        return new int[]{0, 2};
    }

    public String[] crossCheckMeasurements(String[] fileRecordsProperties, RecordSet recordSet) {
        String[] recordKeys = recordSet.getRecordNames();
        Vector<String> cleanedRecordNames = new Vector<String>();
        if (!this.containsBalance(fileRecordsProperties)) {
            for (String tmpRecordName : recordKeys) {
                if (tmpRecordName.toLowerCase().contains("balance")) continue;
                cleanedRecordNames.add(tmpRecordName);
            }
            recordKeys = cleanedRecordNames.toArray(new String[1]);
        }
        return recordKeys;
    }

    private boolean containsBalance(String[] recordsProperties) {
        boolean isContained = false;
        for (String recordProperties : recordsProperties) {
            boolean bl = isContained = recordProperties.toLowerCase().indexOf("balance", 0) > -1;
            if (isContained) break;
        }
        return isContained;
    }

    public int getCurrentSmoothIndex() {
        return 2;
    }
}

