/*
 * Decompiled with CFR 0.152.
 */
package gde.device.smmodellbau;

import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.smmodellbau.LiPoWatch;
import gde.device.smmodellbau.LiPoWatchDialog;
import gde.device.smmodellbau.LiPoWatchSerialPort;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.CalculationThread;
import gde.utils.WaitTimer;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Logger;

public class LiPoWatchDataGatherer
extends Thread {
    static final Logger log = Logger.getLogger(LiPoWatchDataGatherer.class.getName());
    final DataExplorer application;
    final LiPoWatchSerialPort serialPort;
    final LiPoWatchDialog dialog;
    final LiPoWatch device;
    final Integer channelNumber;
    final String configKey;
    CalculationThread calculationThread;

    public LiPoWatchDataGatherer(DataExplorer currrentApplication, LiPoWatch useDevice, LiPoWatchSerialPort useSerialPort) {
        super("dataGatherer");
        this.application = currrentApplication;
        this.device = useDevice;
        this.serialPort = useSerialPort;
        this.dialog = useDevice.getDialog();
        this.channelNumber = 1;
        this.configKey = this.device.getChannelNameReplacement(this.channelNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "entry data gatherer : " + this.channelNumber + " : " + this.configKey);
        }
        Channel channel = (Channel)Channels.getInstance().get((Object)this.channelNumber);
        String recordSetKey = null;
        RecordSet recordSet = null;
        boolean isPortOpenedByMe = false;
        try {
            if (!this.serialPort.isConnected()) {
                this.serialPort.open();
                isPortOpenedByMe = true;
                WaitTimer.delay((long)100L);
            }
            final byte[] configBuffer = this.serialPort.readConfiguration();
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    LiPoWatchDataGatherer.this.dialog.updateConfigurationValues(configBuffer);
                }
            });
            this.dialog.resetDataSetsLabel();
            this.serialPort.setTransmitFinished(false);
            Vector<Vector<byte[]>> dataCollection = this.serialPort.getData(this.dialog);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "back from gathering data");
            }
            for (Vector<byte[]> telegrams : dataCollection) {
                byte[] dataBuffer;
                recordSetKey = channel.getNextRecordSetNumber() + this.device.getRecordSetStemNameReplacement();
                channel.put((Object)recordSetKey, (Object)RecordSet.createRecordSet((String)recordSetKey, (IDevice)this.application.getActiveDevice(), (int)channel.getNumber(), (boolean)true, (boolean)false, (boolean)true));
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, recordSetKey + " created");
                }
                recordSet = (RecordSet)channel.get((Object)recordSetKey);
                this.device.updateInitialRecordSetComment(recordSet);
                channel.applyTemplateBasics(recordSetKey);
                int[] points = new int[recordSet.realSize()];
                for (int j = 1; j < telegrams.size(); ++j) {
                    dataBuffer = telegrams.get(j);
                    recordSet.addPoints(this.device.convertDataBytes(points, dataBuffer));
                }
                int numCells = 0;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "number of measurements = " + telegrams.size());
                }
                for (int j = 0; j < 10 && j < telegrams.size(); ++j) {
                    dataBuffer = telegrams.get(j);
                    numCells += dataBuffer[5] & 0xF;
                }
                int numberRecords = numCells / 10 + 5;
                String[] recordNames = recordSet.getRecordNames();
                for (int j = numberRecords; j < this.device.getNumberOfMeasurements(1) && j < recordNames.length - 1; ++j) {
                    recordSet.remove(recordNames[j]);
                }
                recordSet.syncScaleOfSyncableRecords();
                if (channel.getActiveRecordSet() == null) {
                    Channels.getInstance().switchChannel(this.channelNumber.intValue(), recordSetKey);
                    channel.switchRecordSet(recordSetKey);
                }
                this.device.makeInActiveDisplayable(recordSet);
                this.device.updateVisibilityStatus(recordSet, true);
                this.application.updateStatisticsData();
                this.application.updateDataTable(recordSetKey, false);
            }
            this.application.getMenuToolBar().updateRecordSetSelectCombo();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "exit data gatherer");
            }
        }
        catch (DataInconsitsentException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0028", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName(), e.getMessage()}));
        }
        catch (ApplicationConfigurationException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            this.application.openMessageDialog(this.dialog.getDialogShell(), ((Object)((Object)e)).getClass().getSimpleName() + " - " + e.getMessage());
        }
        catch (TimeOutException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0022", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName(), e.getMessage()}) + System.getProperty("line.separator") + Messages.getString((String)"GDE_MSGW1602"));
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0022", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}) + System.getProperty("line.separator") + Messages.getString((String)"GDE_MSGW1602"));
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            this.application.openMessageDialog(this.dialog.getDialogShell(), e.getClass().getSimpleName() + " - " + e.getMessage());
        }
        finally {
            this.dialog.resetButtons();
            if (isPortOpenedByMe) {
                this.serialPort.close();
            }
        }
    }

    public void setThreadStop() {
        try {
            WaitTimer.delay((long)5L);
            this.serialPort.setTransmitFinished(true);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage());
        }
    }
}

