/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.layout.breaker;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.LineBreakContext;
import org.xhtmlrenderer.layout.TextUtil;
import org.xhtmlrenderer.layout.breaker.BreakAnywhereLineBreakStrategy;
import org.xhtmlrenderer.layout.breaker.BreakPoint;
import org.xhtmlrenderer.layout.breaker.BreakPointsProvider;
import org.xhtmlrenderer.render.FSFont;

public class Breaker {
    private static final String DEFAULT_LANGUAGE = System.getProperty("org.xhtmlrenderer.layout.breaker.default-language", "en");

    public static void breakFirstLetter(LayoutContext c2, LineBreakContext context, int avail, CalculatedStyle style) {
        FSFont font = style.getFSFont(c2);
        context.setEnd(Breaker.getFirstLetterEnd(context.getMaster(), context.getStart()));
        context.setWidth(c2.getTextRenderer().getWidth(c2.getFontContext(), font, context.getCalculatedSubstring()));
        if (context.getWidth() > avail) {
            context.setNeedsNewLine(true);
            context.setUnbreakable(true);
        }
    }

    private static int getFirstLetterEnd(String text2, int start) {
        boolean letterFound = false;
        int end = text2.length();
        for (int i2 = start; i2 < end; ++i2) {
            char currentChar = text2.charAt(i2);
            if (TextUtil.isFirstLetterSeparatorChar(currentChar)) continue;
            if (letterFound) {
                return i2;
            }
            letterFound = true;
        }
        return end;
    }

    public static void breakText(LayoutContext c2, LineBreakContext context, int avail, CalculatedStyle style) {
        FSFont font = style.getFSFont(c2);
        IdentValue whitespace = style.getWhitespace();
        if (whitespace == IdentValue.NOWRAP) {
            context.setEnd(context.getLast());
            context.setWidth(c2.getTextRenderer().getWidth(c2.getFontContext(), font, context.getCalculatedSubstring()));
            return;
        }
        if (whitespace == IdentValue.PRE || whitespace == IdentValue.PRE_WRAP || whitespace == IdentValue.PRE_LINE) {
            int n2 = context.getStartSubstring().indexOf("\n");
            if (n2 > -1) {
                context.setEnd(context.getStart() + n2 + 1);
                context.setWidth(c2.getTextRenderer().getWidth(c2.getFontContext(), font, context.getCalculatedSubstring()));
                context.setNeedsNewLine(true);
                context.setEndsOnNL(true);
            } else if (whitespace == IdentValue.PRE) {
                context.setEnd(context.getLast());
                context.setWidth(c2.getTextRenderer().getWidth(c2.getFontContext(), font, context.getCalculatedSubstring()));
            }
        }
        if (whitespace == IdentValue.PRE || context.isNeedsNewLine() && context.getWidth() <= avail) {
            return;
        }
        context.setEndsOnNL(false);
        Breaker.doBreakText(c2, context, avail, style, false);
    }

    private static int getWidth(LayoutContext c2, FSFont f2, String text2) {
        return c2.getTextRenderer().getWidth(c2.getFontContext(), f2, text2);
    }

    public static BreakPointsProvider getBreakPointsProvider(String text2, LayoutContext c2, Element element, CalculatedStyle style) {
        return c2.getSharedContext().getLineBreakingStrategy().getBreakPointsProvider(text2, Breaker.getLanguage(c2, element), style);
    }

    public static BreakPointsProvider getBreakPointsProvider(String text2, LayoutContext c2, Text textNode, CalculatedStyle style) {
        return c2.getSharedContext().getLineBreakingStrategy().getBreakPointsProvider(text2, Breaker.getLanguage(c2, textNode), style);
    }

    private static String getLanguage(LayoutContext c2, Element element) {
        String language = c2.getNamespaceHandler().getLang(element);
        if (language == null || language.isEmpty()) {
            language = DEFAULT_LANGUAGE;
        }
        return language;
    }

    private static String getLanguage(LayoutContext c2, Text textNode) {
        Node parentNode;
        if (textNode != null && (parentNode = textNode.getParentNode()) instanceof Element) {
            return Breaker.getLanguage(c2, (Element)parentNode);
        }
        return DEFAULT_LANGUAGE;
    }

    private static void doBreakText(LayoutContext c2, LineBreakContext context, int avail, CalculatedStyle style, boolean tryToBreakAnywhere) {
        FSFont f2 = style.getFSFont(c2);
        String currentString = context.getStartSubstring();
        BreakPointsProvider iterator2 = Breaker.getBreakPointsProvider(currentString, c2, context.getTextNode(), style);
        if (tryToBreakAnywhere) {
            iterator2 = new BreakAnywhereLineBreakStrategy(currentString);
        }
        BreakPoint bp = iterator2.next();
        BreakPoint lastBreakPoint = null;
        int right2 = -1;
        int previousWidth = 0;
        int previousPosition = 0;
        while (bp != null && bp.getPosition() != -1) {
            int widthWithHyphen;
            int currentWidth = Breaker.getWidth(c2, f2, currentString.substring(previousPosition, bp.getPosition()) + bp.getHyphen());
            previousWidth = widthWithHyphen = previousWidth + currentWidth;
            previousPosition = bp.getPosition();
            if (widthWithHyphen > avail) break;
            right2 = previousPosition;
            lastBreakPoint = bp;
            bp = iterator2.next();
        }
        if (bp != null && bp.getPosition() != -1 && right2 >= 0 && !lastBreakPoint.getHyphen().isEmpty()) {
            context.setMaster(new StringBuilder(context.getMaster()).insert(context.getStart() + right2, lastBreakPoint.getHyphen()).toString());
            right2 += lastBreakPoint.getHyphen().length();
        }
        if (bp != null && bp.getPosition() == -1) {
            context.setWidth(Breaker.getWidth(c2, f2, currentString));
            context.setEnd(context.getMaster().length());
            return;
        }
        context.setNeedsNewLine(true);
        if (right2 <= 0 && style.getWordWrap() == IdentValue.BREAK_WORD && !tryToBreakAnywhere) {
            Breaker.doBreakText(c2, context, avail, style, true);
            return;
        }
        if (right2 > 0) {
            context.setEnd(context.getStart() + right2);
            context.setWidth(Breaker.getWidth(c2, f2, context.getMaster().substring(context.getStart(), context.getStart() + right2)));
            return;
        }
        context.setEnd(context.getStart() + currentString.length());
        context.setUnbreakable(true);
        context.setWidth(Breaker.getWidth(c2, f2, context.getCalculatedSubstring()));
    }
}

