/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive;

import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.stat.descriptive.AbstractUnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.StorelessUnivariateStatistic;
import org.apache.commons.math3.util.MathUtils;
import org.apache.commons.math3.util.Precision;

public abstract class AbstractStorelessUnivariateStatistic
extends AbstractUnivariateStatistic
implements StorelessUnivariateStatistic {
    public double evaluate(double[] values2) throws MathIllegalArgumentException {
        if (values2 == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        return this.evaluate(values2, 0, values2.length);
    }

    public double evaluate(double[] values2, int begin, int length) throws MathIllegalArgumentException {
        if (this.test(values2, begin, length)) {
            this.clear();
            this.incrementAll(values2, begin, length);
        }
        return this.getResult();
    }

    public abstract StorelessUnivariateStatistic copy();

    public abstract void clear();

    public abstract double getResult();

    public abstract void increment(double var1);

    public void incrementAll(double[] values2) throws MathIllegalArgumentException {
        if (values2 == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        this.incrementAll(values2, 0, values2.length);
    }

    public void incrementAll(double[] values2, int begin, int length) throws MathIllegalArgumentException {
        if (this.test(values2, begin, length)) {
            int k2 = begin + length;
            for (int i2 = begin; i2 < k2; ++i2) {
                this.increment(values2[i2]);
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractStorelessUnivariateStatistic)) {
            return false;
        }
        AbstractStorelessUnivariateStatistic stat = (AbstractStorelessUnivariateStatistic)object;
        return Precision.equalsIncludingNaN(stat.getResult(), this.getResult()) && Precision.equalsIncludingNaN(stat.getN(), this.getN());
    }

    public int hashCode() {
        return 31 * (31 + MathUtils.hash(this.getResult())) + MathUtils.hash(this.getN());
    }
}

