/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.direct;

import java.util.Comparator;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.optimization.PointValuePair;
import org.apache.commons.math3.optimization.direct.AbstractSimplex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class MultiDirectionalSimplex
extends AbstractSimplex {
    private static final double DEFAULT_KHI = 2.0;
    private static final double DEFAULT_GAMMA = 0.5;
    private final double khi;
    private final double gamma;

    public MultiDirectionalSimplex(int n2) {
        this(n2, 1.0);
    }

    public MultiDirectionalSimplex(int n2, double sideLength) {
        this(n2, sideLength, 2.0, 0.5);
    }

    public MultiDirectionalSimplex(int n2, double khi, double gamma) {
        this(n2, 1.0, khi, gamma);
    }

    public MultiDirectionalSimplex(int n2, double sideLength, double khi, double gamma) {
        super(n2, sideLength);
        this.khi = khi;
        this.gamma = gamma;
    }

    public MultiDirectionalSimplex(double[] steps) {
        this(steps, 2.0, 0.5);
    }

    public MultiDirectionalSimplex(double[] steps, double khi, double gamma) {
        super(steps);
        this.khi = khi;
        this.gamma = gamma;
    }

    public MultiDirectionalSimplex(double[][] referenceSimplex) {
        this(referenceSimplex, 2.0, 0.5);
    }

    public MultiDirectionalSimplex(double[][] referenceSimplex, double khi, double gamma) {
        super(referenceSimplex);
        this.khi = khi;
        this.gamma = gamma;
    }

    @Override
    public void iterate(MultivariateFunction evaluationFunction, Comparator<PointValuePair> comparator) {
        PointValuePair[] original = this.getPoints();
        PointValuePair best = original[0];
        PointValuePair reflected = this.evaluateNewSimplex(evaluationFunction, original, 1.0, comparator);
        if (comparator.compare(reflected, best) < 0) {
            PointValuePair[] reflectedSimplex = this.getPoints();
            PointValuePair expanded = this.evaluateNewSimplex(evaluationFunction, original, this.khi, comparator);
            if (comparator.compare(reflected, expanded) <= 0) {
                this.setPoints(reflectedSimplex);
            }
            return;
        }
        this.evaluateNewSimplex(evaluationFunction, original, this.gamma, comparator);
    }

    private PointValuePair evaluateNewSimplex(MultivariateFunction evaluationFunction, PointValuePair[] original, double coeff, Comparator<PointValuePair> comparator) {
        double[] xSmallest = original[0].getPointRef();
        this.setPoint(0, original[0]);
        int dim = this.getDimension();
        for (int i2 = 1; i2 < this.getSize(); ++i2) {
            double[] xOriginal = original[i2].getPointRef();
            double[] xTransformed = new double[dim];
            for (int j2 = 0; j2 < dim; ++j2) {
                xTransformed[j2] = xSmallest[j2] + coeff * (xSmallest[j2] - xOriginal[j2]);
            }
            this.setPoint(i2, new PointValuePair(xTransformed, Double.NaN, false));
        }
        this.evaluate(evaluationFunction, comparator);
        return this.getPoint(0);
    }
}

