/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import org.apache.avalon.framework.logger.Logger;
import org.apache.commons.logging.Log;

public class AvalonLogger
implements Log {
    private static volatile Logger defaultLogger = null;
    private final transient Logger logger;

    public AvalonLogger(Logger logger) {
        this.logger = logger;
    }

    public AvalonLogger(String name) {
        if (defaultLogger == null) {
            throw new NullPointerException("default logger has to be specified if this constructor is used!");
        }
        this.logger = defaultLogger.getChildLogger(name);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public static void setDefaultLogger(Logger logger) {
        defaultLogger = logger;
    }

    public void debug(Object message2, Throwable t2) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.valueOf(message2), t2);
        }
    }

    public void debug(Object message2) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.valueOf(message2));
        }
    }

    public void error(Object message2, Throwable t2) {
        if (this.getLogger().isErrorEnabled()) {
            this.getLogger().error(String.valueOf(message2), t2);
        }
    }

    public void error(Object message2) {
        if (this.getLogger().isErrorEnabled()) {
            this.getLogger().error(String.valueOf(message2));
        }
    }

    public void fatal(Object message2, Throwable t2) {
        if (this.getLogger().isFatalErrorEnabled()) {
            this.getLogger().fatalError(String.valueOf(message2), t2);
        }
    }

    public void fatal(Object message2) {
        if (this.getLogger().isFatalErrorEnabled()) {
            this.getLogger().fatalError(String.valueOf(message2));
        }
    }

    public void info(Object message2, Throwable t2) {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(String.valueOf(message2), t2);
        }
    }

    public void info(Object message2) {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(String.valueOf(message2));
        }
    }

    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.getLogger().isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.getLogger().isFatalErrorEnabled();
    }

    public boolean isInfoEnabled() {
        return this.getLogger().isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    public boolean isWarnEnabled() {
        return this.getLogger().isWarnEnabled();
    }

    public void trace(Object message2, Throwable t2) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.valueOf(message2), t2);
        }
    }

    public void trace(Object message2) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.valueOf(message2));
        }
    }

    public void warn(Object message2, Throwable t2) {
        if (this.getLogger().isWarnEnabled()) {
            this.getLogger().warn(String.valueOf(message2), t2);
        }
    }

    public void warn(Object message2) {
        if (this.getLogger().isWarnEnabled()) {
            this.getLogger().warn(String.valueOf(message2));
        }
    }
}

