/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.core._DelayedJQuote;
import freemarker.core._TemplateModelException;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.ClassIntrospector;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.utility.ClassUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

abstract class ClassBasedModelFactory
implements TemplateHashModel {
    private final BeansWrapper wrapper;
    private final Map<String, TemplateModel> cache = new ConcurrentHashMap<String, TemplateModel>();
    private final Set<String> classIntrospectionsInProgress = new HashSet<String>();

    protected ClassBasedModelFactory(BeansWrapper wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    public TemplateModel get(String key2) throws TemplateModelException {
        try {
            return this.getInternal(key2);
        }
        catch (Exception e2) {
            if (e2 instanceof TemplateModelException) {
                throw (TemplateModelException)e2;
            }
            throw new _TemplateModelException((Throwable)e2, "Failed to get value for key ", new _DelayedJQuote(key2), "; see cause exception.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TemplateModel getInternal(String key2) throws TemplateModelException, ClassNotFoundException {
        int classIntrospectorClearingCounter;
        ClassIntrospector classIntrospector;
        TemplateModel model;
        Object sharedLock;
        TemplateModel model2 = this.cache.get(key2);
        if (model2 != null) {
            return model2;
        }
        Object object = sharedLock = this.wrapper.getSharedIntrospectionLock();
        synchronized (object) {
            model = this.cache.get(key2);
            if (model != null) {
                return model;
            }
            while (model == null && this.classIntrospectionsInProgress.contains(key2)) {
                try {
                    sharedLock.wait();
                    model = this.cache.get(key2);
                }
                catch (InterruptedException e2) {
                    throw new RuntimeException("Class inrospection data lookup aborted: " + e2);
                }
            }
            if (model != null) {
                return model;
            }
            this.classIntrospectionsInProgress.add(key2);
            classIntrospector = this.wrapper.getClassIntrospector();
            classIntrospectorClearingCounter = classIntrospector.getClearingCounter();
        }
        try {
            Object object2;
            Class clazz = ClassUtil.forName(key2);
            classIntrospector.get(clazz);
            model = this.createModel(clazz);
            if (model != null) {
                object2 = sharedLock;
                synchronized (object2) {
                    if (classIntrospector == this.wrapper.getClassIntrospector() && classIntrospectorClearingCounter == classIntrospector.getClearingCounter()) {
                        this.cache.put(key2, model);
                    }
                }
            }
            object2 = model;
            return object2;
        }
        finally {
            Object object3 = sharedLock;
            synchronized (object3) {
                this.classIntrospectionsInProgress.remove(key2);
                sharedLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCache() {
        Object object = this.wrapper.getSharedIntrospectionLock();
        synchronized (object) {
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromCache(Class<?> clazz) {
        Object object = this.wrapper.getSharedIntrospectionLock();
        synchronized (object) {
            this.cache.remove(clazz.getName());
        }
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    protected abstract TemplateModel createModel(Class<?> var1) throws TemplateModelException;

    protected BeansWrapper getWrapper() {
        return this.wrapper;
    }
}

