/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.pdf.parser.Matrix;
import java.util.Arrays;

public class Vector {
    public static final int I1 = 0;
    public static final int I2 = 1;
    public static final int I3 = 2;
    private final float[] vals = new float[]{0.0f, 0.0f, 0.0f};

    public Vector(float x2, float y2, float z2) {
        this.vals[0] = x2;
        this.vals[1] = y2;
        this.vals[2] = z2;
    }

    public float get(int index) {
        return this.vals[index];
    }

    public Vector cross(Matrix by) {
        float x2 = this.vals[0] * by.get(0) + this.vals[1] * by.get(3) + this.vals[2] * by.get(6);
        float y2 = this.vals[0] * by.get(1) + this.vals[1] * by.get(4) + this.vals[2] * by.get(7);
        float z2 = this.vals[0] * by.get(2) + this.vals[1] * by.get(5) + this.vals[2] * by.get(8);
        return new Vector(x2, y2, z2);
    }

    public Vector subtract(Vector v2) {
        float x2 = this.vals[0] - v2.vals[0];
        float y2 = this.vals[1] - v2.vals[1];
        float z2 = this.vals[2] - v2.vals[2];
        return new Vector(x2, y2, z2);
    }

    public Vector cross(Vector with2) {
        float x2 = this.vals[1] * with2.vals[2] - this.vals[2] * with2.vals[1];
        float y2 = this.vals[2] * with2.vals[0] - this.vals[0] * with2.vals[2];
        float z2 = this.vals[0] * with2.vals[1] - this.vals[1] * with2.vals[0];
        return new Vector(x2, y2, z2);
    }

    public Vector normalize() {
        float l2 = this.length();
        float x2 = this.vals[0] / l2;
        float y2 = this.vals[1] / l2;
        float z2 = this.vals[2] / l2;
        return new Vector(x2, y2, z2);
    }

    public Vector multiply(float by) {
        float x2 = this.vals[0] * by;
        float y2 = this.vals[1] * by;
        float z2 = this.vals[2] * by;
        return new Vector(x2, y2, z2);
    }

    public float dot(Vector with2) {
        return this.vals[0] * with2.vals[0] + this.vals[1] * with2.vals[1] + this.vals[2] * with2.vals[2];
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.vals[0] * this.vals[0] + this.vals[1] * this.vals[1] + this.vals[2] * this.vals[2];
    }

    public String toString() {
        return this.vals[0] + "," + this.vals[1] + "," + this.vals[2];
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + Arrays.hashCode(this.vals);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector other = (Vector)obj;
        return Arrays.equals(this.vals, other.vals);
    }
}

