/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.PdfAction;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDestination;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfOutline
extends PdfDictionary {
    private PdfIndirectReference reference;
    private int count = 0;
    private PdfOutline parent;
    private PdfDestination destination;
    private PdfAction action;
    protected ArrayList<PdfOutline> kids = new ArrayList();
    protected PdfWriter writer;
    private String tag;
    private boolean open;
    private BaseColor color;
    private int style = 0;

    PdfOutline(PdfWriter writer) {
        super(OUTLINES);
        this.open = true;
        this.parent = null;
        this.writer = writer;
    }

    public PdfOutline(PdfOutline parent, PdfAction action2, String title2) {
        this(parent, action2, title2, true);
    }

    public PdfOutline(PdfOutline parent, PdfAction action2, String title2, boolean open) {
        this.action = action2;
        this.initOutline(parent, title2, open);
    }

    public PdfOutline(PdfOutline parent, PdfDestination destination, String title2) {
        this(parent, destination, title2, true);
    }

    public PdfOutline(PdfOutline parent, PdfDestination destination, String title2, boolean open) {
        this.destination = destination;
        this.initOutline(parent, title2, open);
    }

    public PdfOutline(PdfOutline parent, PdfAction action2, PdfString title2) {
        this(parent, action2, title2, true);
    }

    public PdfOutline(PdfOutline parent, PdfAction action2, PdfString title2, boolean open) {
        this(parent, action2, title2.toString(), open);
    }

    public PdfOutline(PdfOutline parent, PdfDestination destination, PdfString title2) {
        this(parent, destination, title2, true);
    }

    public PdfOutline(PdfOutline parent, PdfDestination destination, PdfString title2, boolean open) {
        this(parent, destination, title2.toString(), true);
    }

    public PdfOutline(PdfOutline parent, PdfAction action2, Paragraph title2) {
        this(parent, action2, title2, true);
    }

    public PdfOutline(PdfOutline parent, PdfAction action2, Paragraph title2, boolean open) {
        StringBuffer buf = new StringBuffer();
        for (Chunk chunk : title2.getChunks()) {
            buf.append(chunk.getContent());
        }
        this.action = action2;
        this.initOutline(parent, buf.toString(), open);
    }

    public PdfOutline(PdfOutline parent, PdfDestination destination, Paragraph title2) {
        this(parent, destination, title2, true);
    }

    public PdfOutline(PdfOutline parent, PdfDestination destination, Paragraph title2, boolean open) {
        StringBuffer buf = new StringBuffer();
        Iterator<Chunk> i$ = title2.getChunks().iterator();
        while (i$.hasNext()) {
            Chunk element;
            Chunk chunk = element = i$.next();
            buf.append(chunk.getContent());
        }
        this.destination = destination;
        this.initOutline(parent, buf.toString(), open);
    }

    void initOutline(PdfOutline parent, String title2, boolean open) {
        this.open = open;
        this.parent = parent;
        this.writer = parent.writer;
        this.put(PdfName.TITLE, new PdfString(title2, "UnicodeBig"));
        parent.addKid(this);
        if (this.destination != null && !this.destination.hasPage()) {
            this.setDestinationPage(this.writer.getCurrentPage());
        }
    }

    public void setIndirectReference(PdfIndirectReference reference) {
        this.reference = reference;
    }

    public PdfIndirectReference indirectReference() {
        return this.reference;
    }

    public PdfOutline parent() {
        return this.parent;
    }

    public boolean setDestinationPage(PdfIndirectReference pageReference) {
        if (this.destination == null) {
            return false;
        }
        return this.destination.addPage(pageReference);
    }

    public PdfDestination getPdfDestination() {
        return this.destination;
    }

    int getCount() {
        return this.count;
    }

    void setCount(int count) {
        this.count = count;
    }

    public int level() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.level() + 1;
    }

    @Override
    public void toPdf(PdfWriter writer, OutputStream os) throws IOException {
        if (this.color != null && !this.color.equals(BaseColor.BLACK)) {
            this.put(PdfName.C, new PdfArray(new float[]{(float)this.color.getRed() / 255.0f, (float)this.color.getGreen() / 255.0f, (float)this.color.getBlue() / 255.0f}));
        }
        int flag = 0;
        if ((this.style & 1) != 0) {
            flag |= 2;
        }
        if ((this.style & 2) != 0) {
            flag |= 1;
        }
        if (flag != 0) {
            this.put(PdfName.F, new PdfNumber(flag));
        }
        if (this.parent != null) {
            this.put(PdfName.PARENT, this.parent.indirectReference());
        }
        if (this.destination != null && this.destination.hasPage()) {
            this.put(PdfName.DEST, this.destination);
        }
        if (this.action != null) {
            this.put(PdfName.A, this.action);
        }
        if (this.count != 0) {
            this.put(PdfName.COUNT, new PdfNumber(this.count));
        }
        super.toPdf(writer, os);
    }

    public void addKid(PdfOutline outline) {
        this.kids.add(outline);
    }

    public ArrayList<PdfOutline> getKids() {
        return this.kids;
    }

    public void setKids(ArrayList<PdfOutline> kids) {
        this.kids = kids;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getTitle() {
        PdfString title2 = (PdfString)this.get(PdfName.TITLE);
        return title2.toString();
    }

    public void setTitle(String title2) {
        this.put(PdfName.TITLE, new PdfString(title2, "UnicodeBig"));
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public BaseColor getColor() {
        return this.color;
    }

    public void setColor(BaseColor color) {
        this.color = color;
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }
}

