/*
 * Decompiled with CFR 0.152.
 */
package gde.device.schulze;

import gde.device.CheckSumTypes;
import gde.device.schulze.NextGen8;
import gde.exception.DevicePropertiesInconsistenceException;
import gde.io.DataParser;
import java.util.logging.Logger;

public class DataParserNext
extends DataParser {
    static Logger log = Logger.getLogger(DataParserNext.class.getName());
    double capacity = 0.0;
    final NextGen8 device;
    int counter = 0;
    int newState = 0;
    protected final int offset;

    public DataParserNext(NextGen8 useDevice, int useTimeFactor, String useLeaderChar, String useSeparator, CheckSumTypes useCheckSumType, int useDataSize, int offset) {
        super(useTimeFactor, useLeaderChar, useSeparator, useCheckSumType, useDataSize);
        this.device = useDevice;
        this.offset = offset;
    }

    public void parse(String inputLine, int line) throws DevicePropertiesInconsistenceException {
        String[] mainValues = inputLine.indexOf(59) == -1 ? inputLine.split(":") : inputLine.substring(0, inputLine.indexOf(59)).split(":");
        String[] cellValues = inputLine.indexOf(59) == -1 ? new String[]{} : inputLine.substring(inputLine.indexOf(59) + 1).split(";");
        this.channelConfigNumber = Integer.parseInt(mainValues[0].trim());
        if (this.channelConfigNumber == 2 && this.values.length == 14) {
            this.values = new int[5];
        }
        if (this.start_time_ms == Integer.MIN_VALUE) {
            this.start_time_ms = (int)(Double.parseDouble(mainValues[1].trim()) * (double)this.timeFactor);
        } else {
            this.time_ms = (int)(Double.parseDouble(mainValues[1].trim()) * (double)this.timeFactor) - this.start_time_ms;
        }
        this.values[0] = Integer.parseInt(mainValues[2].trim());
        if (mainValues.length == 4) {
            this.values[1] = Integer.parseInt(mainValues[3].substring(5, 6).trim() + mainValues[3].substring(0, 5).trim());
            this.values[4] = Integer.parseInt(mainValues[3].substring(7).trim());
            this.newState = NextGen8.States.valueOf(mainValues[3].substring(6, 7)).getOrdinal();
        } else {
            this.values[1] = Integer.parseInt(mainValues[3].trim());
            this.values[4] = Integer.parseInt(mainValues[4].substring(1).trim());
            this.newState = NextGen8.States.valueOf(mainValues[4].substring(0, 1)).getOrdinal();
        }
        if (this.newState <= 8 && this.newState + 2 != this.state) {
            this.state = this.newState;
        }
        this.capacity += (double)this.values[1] / 1000.0 * this.device.getTimeStep_ms() / 3600.0;
        this.values[2] = (int)(this.capacity * 1000.0);
        this.values[3] = (int)((double)this.values[0] / 1000.0 * (double)this.values[1] / 1000.0 * 1000.0);
        if (cellValues.length > 0 && this.values.length > 5) {
            int minCellValue = Integer.MAX_VALUE;
            int maxCellValue = Integer.MIN_VALUE;
            for (int i = 0; i < cellValues.length && i < this.device.getNumberOfLithiumCells(); ++i) {
                this.values[6 + i] = Integer.parseInt(cellValues[i].trim());
                if (this.values[6 + i] <= 0) continue;
                maxCellValue = this.values[6 + i] > maxCellValue ? this.values[6 + i] : maxCellValue;
                minCellValue = this.values[6 + i] < minCellValue ? this.values[6 + i] : minCellValue;
            }
            this.values[5] = maxCellValue != Integer.MIN_VALUE && minCellValue != Integer.MAX_VALUE ? maxCellValue - minCellValue : 0;
        }
    }
}

