/*
 * Decompiled with CFR 0.152.
 */
package gde.device.r2prototyping;

import gde.GDE;
import gde.data.Channels;
import gde.device.DeviceDialog;
import gde.device.IDevice;
import gde.device.MeasurementType;
import gde.device.r2prototyping.S32Dialog;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.MeasurementControlConfigurable;
import gde.ui.SWTResourceManager;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class S32VisualizationControl
extends Composite {
    static final Logger log = Logger.getLogger(S32VisualizationControl.class.getName());
    Composite measurementComposite;
    Button measurement;
    Button inputFileButton;
    Composite buttonComposite;
    Label measurementUnitLabel;
    Label measurementSymbolLabel;
    Label tabItemLabel;
    ScrolledComposite scolledComposite;
    Composite mainTabComposite;
    boolean isVisibilityChanged = false;
    final Widget mainTabComosite;
    final IDevice device;
    final DataExplorer application;
    final Channels channels;
    final S32Dialog dialog;
    final int channelConfigNumber;
    final String typeName;
    final int measurementCount;
    final int measurementOffset;
    final List<Composite> measurementTypes = new ArrayList<Composite>();

    public S32VisualizationControl(Composite parentComposite, S32Dialog parentDialog, int useChannelConfigNumber, IDevice useDevice, String useName, int useMeasurementOffset, int useMeasurementCount) {
        super(parentComposite, 0);
        this.mainTabComosite = parentComposite;
        this.dialog = parentDialog;
        this.device = useDevice;
        this.typeName = useName;
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.channelConfigNumber = useChannelConfigNumber;
        this.measurementOffset = useMeasurementOffset;
        this.measurementCount = useMeasurementCount;
        this.setLayout((Layout)new GridLayout(1, true));
        this.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "focusGained, event=" + String.valueOf(evt));
                }
                S32VisualizationControl.this.updateMeasurements();
            }
        });
        this.create();
    }

    void updateMeasurements() {
        for (MeasurementType tmpMeasurement : this.device.getChannelMeasuremtsReplacedNames(this.channelConfigNumber)) {
            System.out.println(tmpMeasurement.getUnit());
        }
    }

    void create() {
        if (this.typeName.equals(Messages.getString((String)"GDE_MSGT3809"))) {
            this.tabItemLabel = new Label((Composite)this, 0x1000000);
            GridData tabItemLabelLData = new GridData();
            tabItemLabelLData.horizontalAlignment = 2;
            tabItemLabelLData.verticalAlignment = 1;
            tabItemLabelLData.heightHint = 18;
            tabItemLabelLData.widthHint = 600;
            this.tabItemLabel.setLayoutData((Object)tabItemLabelLData);
            this.tabItemLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE + 2), (int)1));
            this.tabItemLabel.setText(this.typeName);
        }
        this.mainTabComposite = new Composite((Composite)this, 0);
        GridLayout mainTabCompositeLayout = new GridLayout(2, true);
        this.mainTabComposite.setLayout((Layout)mainTabCompositeLayout);
        for (int i = this.measurementOffset; i < this.measurementOffset + this.measurementCount; ++i) {
            this.measurementTypes.add((Composite)new MeasurementControlConfigurable(this.mainTabComposite, (DeviceDialog)this.dialog, this.channelConfigNumber, i, (MeasurementType)this.device.getChannelMeasuremtsReplacedNames(this.channelConfigNumber).get(i), this.device, 1, " " + (i - this.measurementOffset), ""));
        }
    }
}

