/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.menu;

import gde.GDE;
import gde.config.GraphicsTemplate;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.DeviceDialog;
import gde.device.IDevice;
import gde.histo.config.HistoGraphicsTemplate;
import gde.histo.recordings.TrailRecordSet;
import gde.io.FileHandler;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.ui.dialog.DeviceSelectionDialog;
import gde.ui.dialog.PrintSelectionDialog;
import gde.ui.dialog.TimeSetDialog;
import gde.ui.dialog.edit.DevicePropertiesEditor;
import gde.ui.tab.GraphicsComposite;
import gde.ui.tab.GraphicsWindow;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class MenuBar {
    private static final String $CLASS_NAME = MenuBar.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private final Settings settings = Settings.getInstance();
    MenuItem fileMenuItem;
    Menu fileMenu;
    MenuItem openFileMenuItem;
    MenuItem historyFileMenuItem;
    MenuItem toolBoxDeviceMenuItem;
    MenuItem portMenuItem;
    MenuItem aboutMenuItem;
    MenuItem contentsMenuItem;
    MenuItem webCheckMenuItem;
    Menu helpMenu;
    MenuItem helpMenuItem;
    private MenuItem recordCommentMenuItem;
    private MenuItem graphicsCurveSurveyMenuItem;
    private MenuItem graphicsHeaderMenuItem;
    MenuItem prevTabConfigItem;
    MenuItem nextTabConfigItem;
    private MenuItem curveSelectionMenuItem;
    MenuItem prevChannelConfigItem;
    MenuItem nextChannelConfigItem;
    MenuItem prevRecordSetItem;
    MenuItem nextRecordSetItem;
    MenuItem nextChartItem;
    MenuItem refreshItem;
    Menu viewMenu;
    MenuItem viewMenuItem;
    private MenuItem suppressModeItem;
    private MenuItem partialTableMenuItem;
    Menu graphicsMenu;
    MenuItem graphicsMenuItem;
    MenuItem saveDefaultGraphicsTemplateItem;
    MenuItem restoreDefaultGraphicsTemplateItem;
    MenuItem saveAsGraphicsTemplateItem;
    MenuItem restoreGraphicsTemplateItem;
    MenuItem objectTemplatesItem;
    MenuItem smartStatisticsItem;
    MenuItem csvExportMenuItem1;
    MenuItem csvExportMenuItem2;
    MenuItem csvExportMenuItem3;
    MenuItem nextDeviceMenuItem;
    MenuItem prevDeviceMenuItem;
    MenuItem selectDeviceMenuItem;
    Menu deviceMenu;
    MenuItem deviceMenuItem;
    MenuItem copyTabContentAsImageMenuItem;
    MenuItem copyGraphicsPrintImageMenuItem;
    MenuItem activateZoomGraphicMenuItem;
    MenuItem resetZoomGraphicMenuItem;
    MenuItem panGraphicMenuItem;
    Menu editMenu;
    MenuItem editMenuItem;
    MenuItem printMenuItem;
    MenuItem startTimeMenuItem;
    MenuItem exitMenuItem;
    MenuItem preferencesFileMenuItem;
    MenuItem devicePropertyFileEditMenuItem;
    Menu exportMenu;
    MenuItem exportFileMenuItem;
    MenuItem csvImportMenuItem1;
    MenuItem csvImportMenuItem2;
    Menu importMenu;
    MenuItem importFileMenuItem;
    Menu fileHistoryMenu;
    MenuItem saveAsFileMenuItem;
    MenuItem saveFileMenuItem;
    MenuItem newFileMenuItem;
    MenuItem deleteFileMenuItem;
    int iconSet = 0;
    final Menu parent;
    final DataExplorer application;
    final Channels channels;
    final FileHandler fileHandler;
    ArmListener armListener = new ArmListener(this){

        public void widgetArmed(ArmEvent e) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "widgetArmed, event=" + String.valueOf(e));
            }
        }
    };

    public MenuBar(DataExplorer currentApplication, Menu menuParent) {
        this.application = currentApplication;
        this.parent = menuParent;
        this.channels = Channels.getInstance();
        this.fileHandler = new FileHandler();
    }

    public void create() {
        Menu systemMenu;
        this.fileMenuItem = new MenuItem(this.parent, 64);
        this.fileMenuItem.setText(Messages.getString("GDE_MSGT0001"));
        this.fileMenuItem.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent evt) {
                log.log(Level.FINE, "fileMenuItem.helpRequested, event=" + String.valueOf(evt));
                MenuBar.this.application.openHelpDialog("", "HelpInfo_3.html");
            }
        });
        this.fileMenu = new Menu(this.fileMenuItem);
        this.fileMenu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent evt) {
                String filename;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "fileMenu.handleEvent, event=" + String.valueOf(evt));
                }
                MenuBar.this.updateSubHistoryMenuItem("");
                boolean fileIsLoaded = false;
                Channel activeChannel = MenuBar.this.channels.getActiveChannel();
                if (activeChannel != null && (filename = activeChannel.getFullQualifiedFileName()) != null && !filename.isEmpty()) {
                    fileIsLoaded = true;
                }
                MenuBar.this.deleteFileMenuItem.setEnabled(fileIsLoaded);
            }

            public void menuHidden(MenuEvent evt) {
                log.log(Level.FINEST, "fileMenu.menuHidden " + String.valueOf(evt));
            }
        });
        this.newFileMenuItem = new MenuItem(this.fileMenu, 8);
        this.newFileMenuItem.setText(Messages.getString("GDE_MSGT0002", GDE.MOD1));
        this.newFileMenuItem.setImage(SWTResourceManager.getImage("gde/resource/NewHot.gif"));
        this.newFileMenuItem.setAccelerator(SWT.MOD1 + Messages.getAcceleratorChar("GDE_MSGT0002"));
        this.newFileMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "newFileMenuItem.widgetSelected, event=" + String.valueOf(evt));
                }
                if (MenuBar.this.application.getDeviceSelectionDialog().checkDataSaved()) {
                    MenuBar.this.application.getDeviceSelectionDialog().setupDataChannels(MenuBar.this.application.getActiveDevice());
                }
            }
        });
        this.openFileMenuItem = new MenuItem(this.fileMenu, 8);
        this.openFileMenuItem.setText(Messages.getString("GDE_MSGT0003", GDE.MOD1));
        this.openFileMenuItem.setImage(SWTResourceManager.getImage("gde/resource/OpenHot.gif"));
        this.openFileMenuItem.setAccelerator(SWT.MOD1 + Messages.getAcceleratorChar("GDE_MSGT0003"));
        this.openFileMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "openFileMenuItem.widgetSelected, event=" + String.valueOf(evt));
                }
                MenuBar.this.fileHandler.openFileDialog(Messages.getString("GDE_MSGT0004"));
            }
        });
        this.saveFileMenuItem = new MenuItem(this.fileMenu, 8);
        this.saveFileMenuItem.setText(Messages.getString("GDE_MSGT0005", GDE.MOD1));
        this.saveFileMenuItem.setImage(SWTResourceManager.getImage("gde/resource/SaveHot.gif"));
        this.saveFileMenuItem.setAccelerator(SWT.MOD1 + Messages.getAcceleratorChar("GDE_MSGT0005"));
        this.saveFileMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                Channel activeChannel;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "saveFileMenuItem.widgetSelected, event=" + String.valueOf(evt));
                }
                if ((activeChannel = MenuBar.this.channels.getActiveChannel()) != null) {
                    if (!activeChannel.isSaved()) {
                        MenuBar.this.fileHandler.saveOsdFile(Messages.getString("GDE_MSGT0006"), "");
                    } else {
                        MenuBar.this.fileHandler.saveOsdFile(Messages.getString("GDE_MSGT0007"), activeChannel.getFileName());
                    }
                }
            }
        });
        this.saveAsFileMenuItem = new MenuItem(this.fileMenu, 8);
        this.saveAsFileMenuItem.setText(Messages.getString("GDE_MSGT0008"));
        this.saveAsFileMenuItem.setImage(SWTResourceManager.getImage("gde/resource/SaveAsHot.gif"));
        this.saveAsFileMenuItem.setAccelerator(0x1000015);
        this.saveAsFileMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "saveAsFileMenuItem.widgetSelected, event=" + String.valueOf(evt));
                }
                MenuBar.this.fileHandler.saveOsdFile(Messages.getString("GDE_MSGT0006"), "");
            }
        });
        this.deleteFileMenuItem = new MenuItem(this.fileMenu, 8);
        this.deleteFileMenuItem.setText(Messages.getString("GDE_MSGT0667"));
        this.deleteFileMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "deleteFileMenuItem.widgetSelected, event=" + String.valueOf(evt));
                }
                if (MenuBar.this.fileHandler.deleteOsdFile()) {
                    MenuBar.this.application.getDeviceSelectionDialog().setupDataChannels(MenuBar.this.application.getActiveDevice());
                }
            }
        });
        this.historyFileMenuItem = new MenuItem(this.fileMenu, 64);
        this.historyFileMenuItem.setText(Messages.getString("GDE_MSGT0009"));
        this.fileHistoryMenu = new Menu(this.historyFileMenuItem);
        this.historyFileMenuItem.setMenu(this.fileHistoryMenu);
        new MenuItem(this.fileMenu, 2);
        this.importFileMenuItem = new MenuItem(this.fileMenu, 64);
        this.importFileMenuItem.setText(Messages.getString("GDE_MSGT0010"));
        this.importMenu = new Menu(this.importFileMenuItem);
        this.importFileMenuItem.setMenu(this.importMenu);
        this.csvImportMenuItem1 = new MenuItem(this.importMenu, 8);
        this.csvImportMenuItem1.setText(Messages.getString("GDE_MSGT0011"));
        this.csvImportMenuItem1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "csvImportMenuItem.widgetSelected, event=" + String.valueOf(evt));
                }
                MenuBar.this.fileHandler.importFileCSV(Messages.getString("GDE_MSGT0012"), false);
            }
        });
        this.csvImportMenuItem2 = new MenuItem(this.importMenu, 8);
        this.csvImportMenuItem2.setText(Messages.getString("GDE_MSGT0013"));
        this.csvImportMenuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "csvImportMenuItem.widgetSelected, event=" + String.valueOf(evt));
                }
                MenuBar.this.fileHandler.importFileCSV(Messages.getString("GDE_MSGT0014"), true);
            }
        });
        this.exportFileMenuItem = new MenuItem(this.fileMenu, 64);
        this.exportFileMenuItem.setText(Messages.getString("GDE_MSGT0015"));
        this.exportMenu = new Menu(this.exportFileMenuItem);
        this.exportFileMenuItem.setMenu(this.exportMenu);
        this.csvExportMenuItem1 = new MenuItem(this.exportMenu, 64);
        this.csvExportMenuItem1.setText(Messages.getString("GDE_MSGT0016"));
        this.csvExportMenuItem1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "csvExportMenuItem.widgetSelected, event=" + String.valueOf(evt));
                }
                MenuBar.this.fileHandler.exportFileCSV(Messages.getString("GDE_MSGT0017"), false, "ISO-8859-1");
            }
        });
        this.csvExportMenuItem2 = new MenuItem(this.exportMenu, 64);
        this.csvExportMenuItem2.setText(Messages.getString("GDE_MSGT0018"));
        this.csvExportMenuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "csvExportMenuItem.widgetSelected, event=" + String.valueOf(evt));
                }
                MenuBar.this.fileHandler.exportFileCSV(Messages.getString("GDE_MSGT0019"), true, "ISO-8859-1");
            }
        });
        this.csvExportMenuItem3 = new MenuItem(this.exportMenu, 64);
        this.csvExportMenuItem3.setText(Messages.getString("GDE_MSGT0732"));
        this.csvExportMenuItem3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "csvExportMenuItem.widgetSelected, event=" + String.valueOf(evt));
                }
                MenuBar.this.fileHandler.exportFileCSV(Messages.getString("GDE_MSGT0733"), false, "UTF-8");
            }
        });
        if (!GDE.IS_MAC) {
            new MenuItem(this.fileMenu, 2);
            this.preferencesFileMenuItem = new MenuItem(this.fileMenu, 8);
            this.preferencesFileMenuItem.setText(Messages.getString("GDE_MSGT0020", GDE.MOD3));
            this.preferencesFileMenuItem.setAccelerator(SWT.MOD3 + Messages.getAcceleratorChar("GDE_MSGT0052"));
            this.preferencesFileMenuItem.setImage(SWTResourceManager.getImage("gde/resource/SettingsHot.gif"));
            this.preferencesFileMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    MenuBar.this.openPreferencesDialog(evt);
                }
            });
        }
        new MenuItem(this.fileMenu, 2);
        this.printMenuItem = new MenuItem(this.fileMenu, 8);
        this.printMenuItem.setText(Messages.getString("GDE_MSGT0052", GDE.MOD1));
        this.printMenuItem.setImage(SWTResourceManager.getImage("gde/resource/PrintHot.gif"));
        this.printMenuItem.setAccelerator(SWT.MOD1 + Messages.getAcceleratorChar("GDE_MSGT0052"));
        this.printMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(this){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "exitMenuItem.widgetSelected, event=" + String.valueOf(evt));
                }
                new PrintSelectionDialog(GDE.shell, 0).open();
            }
        });
        this.startTimeMenuItem = new MenuItem(this.fileMenu, 8);
        this.startTimeMenuItem.setText(Messages.getString("GDE_MSGT0713"));
        this.startTimeMenuItem.setImage(SWTResourceManager.getImage("gde/resource/TimeHot.gif"));
        this.startTimeMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(this){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "exitMenuItem.widgetSelected, event=" + String.valueOf(evt));
                }
                new TimeSetDialog(GDE.shell, 0).open(new Date().getTime());
            }
        });
        if (!GDE.IS_MAC) {
            new MenuItem(this.fileMenu, 2);
            this.exitMenuItem = new MenuItem(this.fileMenu, 8);
            this.exitMenuItem.setText(Messages.getString("GDE_MSGT0021", GDE.MOD1));
            this.exitMenuItem.setAccelerator(SWT.MOD1 + Messages.getAcceleratorChar("GDE_MSGT0021"));
            this.exitMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    MenuBar.this.closeApplication(evt);
                }
            });
        }
        this.fileMenuItem.setMenu(this.fileMenu);
        this.editMenuItem = new MenuItem(this.parent, 64);
        this.editMenuItem.setText(Messages.getString("GDE_MSGT0022"));
        this.editMenuItem.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent evt) {
                log.log(Level.FINE, "editMenuItem.helpRequested, event=" + String.valueOf(evt));
                MenuBar.this.application.openHelpDialog("", "HelpInfo_31.html");
            }
        });
        this.editMenu = new Menu(this.editMenuItem);
        this.editMenuItem.setMenu(this.editMenu);
        this.editMenu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                RecordSet activeRecordSet;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "editMenu.menuShown, event=" + String.valueOf(e));
                }
                Channel activeChannel = MenuBar.this.channels.getActiveChannel();
                boolean isRecordSetRelatedCopyable = false;
                if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null) {
                    isRecordSetRelatedCopyable = activeRecordSet.size() > 0;
                }
                boolean isCompareSetCopyable = MenuBar.this.application.isWithCompareSet() && MenuBar.this.application.getTabSelectionIndex() == 6;
                MenuBar.this.copyTabContentAsImageMenuItem.setEnabled(isRecordSetRelatedCopyable);
                MenuBar.this.copyGraphicsPrintImageMenuItem.setEnabled(isRecordSetRelatedCopyable && MenuBar.this.application.getTabSelectionIndex() == 0 || isCompareSetCopyable);
            }

            public void menuHidden(MenuEvent e) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "editMenu.menuHidden, event=" + String.valueOf(e));
                }
            }
        });
        this.activateZoomGraphicMenuItem = new MenuItem(this.editMenu, 8);
        this.activateZoomGraphicMenuItem.setText(Messages.getString("GDE_MSGT0023"));
        this.activateZoomGraphicMenuItem.setImage(SWTResourceManager.getImage("gde/resource/ZoomHot.gif"));
        this.activateZoomGraphicMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "activateZoomGraphicMenuItem.widgetSelected, event=" + String.valueOf(evt));
                }
                MenuBar.this.application.setGraphicsMode(GraphicsComposite.GraphicsMode.ZOOM, true);
            }
        });
        this.resetZoomGraphicMenuItem = new MenuItem(this.editMenu, 8);
        this.resetZoomGraphicMenuItem.setText(Messages.getString("GDE_MSGT0024"));
        this.resetZoomGraphicMenuItem.setImage(SWTResourceManager.getImage("gde/resource/ExpandHot.gif"));
        this.resetZoomGraphicMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "resetZoomGraphicMenuItem.widgetSelected, event=" + String.valueOf(evt));
                }
                MenuBar.this.application.setGraphicsMode(GraphicsComposite.GraphicsMode.RESET, false);
            }
        });
        this.panGraphicMenuItem = new MenuItem(this.editMenu, 8);
        this.panGraphicMenuItem.setText(Messages.getString("GDE_MSGT0025"));
        this.panGraphicMenuItem.setImage(SWTResourceManager.getImage("gde/resource/PanHot.gif"));
        this.panGraphicMenuItem.setEnabled(false);
        this.panGraphicMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "panGraphicMenuItem.widgetSelected, event=" + String.valueOf(evt));
                }
                MenuBar.this.application.setGraphicsMode(GraphicsComposite.GraphicsMode.PAN, true);
            }
        });
        new MenuItem(this.editMenu, 2);
        this.copyTabContentAsImageMenuItem = new MenuItem(this.editMenu, 8);
        this.copyTabContentAsImageMenuItem.setText(Messages.getString("GDE_MSGT0026", GDE.MOD1));
        this.copyTabContentAsImageMenuItem.setAccelerator(SWT.MOD1 + 131072 + Messages.getAcceleratorChar("GDE_MSGT0026"));
        this.copyTabContentAsImageMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "copyTabContentAsImageMenuItem.widgetSelected, event=" + String.valueOf(evt));
                MenuBar.this.application.copyTabContentAsImage();
            }
        });
        this.copyGraphicsPrintImageMenuItem = new MenuItem(this.editMenu, 8);
        this.copyGraphicsPrintImageMenuItem.setText(Messages.getString("GDE_MSGT0027", GDE.MOD1));
        this.copyGraphicsPrintImageMenuItem.setAccelerator(SWT.MOD1 + 131072 + Messages.getAcceleratorChar("GDE_MSGT0027"));
        this.copyGraphicsPrintImageMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "copyGraphicsPrintImageMenuItem.widgetSelected, event=" + String.valueOf(evt));
                MenuBar.this.application.copyGraphicsPrintImage();
            }
        });
        this.deviceMenuItem = new MenuItem(this.parent, 64);
        this.deviceMenuItem.setText(Messages.getString("GDE_MSGT0028"));
        this.deviceMenuItem.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent evt) {
                log.log(Level.FINE, "deviceMenuItem.helpRequested, event=" + String.valueOf(evt));
                MenuBar.this.application.openHelpDialog("", "HelpInfo_32.html");
            }
        });
        this.deviceMenu = new Menu(this.deviceMenuItem);
        this.deviceMenuItem.setMenu(this.deviceMenu);
        this.portMenuItem = new MenuItem(this.deviceMenu, 8);
        this.portMenuItem.setText(Messages.getString("GDE_MSGT0049"));
        this.portMenuItem.setImage(SWTResourceManager.getImage("gde/resource/BulletHotRed.gif"));
        this.portMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                IDevice activeDevice;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "selectDeviceMenuItem.widgetSelected, event=" + String.valueOf(evt));
                }
                if ((activeDevice = MenuBar.this.application.getActiveDevice()) != null) {
                    activeDevice.open_closeCommPort();
                }
            }
        });
        new MenuItem(this.deviceMenu, 2);
        this.selectDeviceMenuItem = new MenuItem(this.deviceMenu, 8);
        this.selectDeviceMenuItem.setText(Messages.getString("GDE_MSGT0030", GDE.MOD1));
        this.selectDeviceMenuItem.setImage(SWTResourceManager.getImage("gde/resource/DeviceSelectionHot.gif"));
        this.selectDeviceMenuItem.setAccelerator(SWT.MOD1 + Messages.getAcceleratorChar("GDE_MSGT0030"));
        this.selectDeviceMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                DeviceSelectionDialog deviceSelection;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "selectDeviceMenuItem.widgetSelected, event=" + String.valueOf(evt));
                }
                if ((deviceSelection = MenuBar.this.application.getDeviceSelectionDialog()).checkDataSaved()) {
                    deviceSelection.open();
                }
            }
        });
        this.prevDeviceMenuItem = new MenuItem(this.deviceMenu, 8);
        this.prevDeviceMenuItem.setImage(SWTResourceManager.getImage("gde/resource/ArrowWhiteGreenFieldLefHot.gif"));
        this.prevDeviceMenuItem.setText(Messages.getString("GDE_MSGT0031", GDE.MOD3));
        this.prevDeviceMenuItem.setAccelerator(SWT.MOD3 + 0x1000005);
        this.prevDeviceMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "prevDeviceMenuItem.widgetSelected, event=" + String.valueOf(evt));
                }
                if (MenuBar.this.application.getActiveDevice().getCommunicationPort() == null || !MenuBar.this.application.getActiveDevice().getCommunicationPort().isConnected()) {
                    DeviceSelectionDialog deviceSelect = MenuBar.this.application.getDeviceSelectionDialog();
                    if (deviceSelect.checkDataSaved()) {
                        int selection = deviceSelect.getDeviceConfigurations().indexOf(deviceSelect.getActiveConfig().getName());
                        int size = deviceSelect.getDeviceConfigurations().size();
                        DeviceConfiguration deviceConfig = selection > 0 && selection <= size ? deviceSelect.getDeviceConfigurations().get(deviceSelect.getDeviceConfigurations().get(selection - 1)) : deviceSelect.getDeviceConfigurations().get(deviceSelect.getDeviceConfigurations().get(size - 1));
                        if (MenuBar.this.application.getDeviceDialog() != null && !MenuBar.this.application.getDeviceDialog().isDisposed()) {
                            MenuBar.this.application.getDeviceDialog().dispose();
                        }
                        deviceSelect.setActiveConfig(deviceConfig);
                        deviceSelect.setupDevice();
                    }
                } else {
                    MenuBar.this.application.openMessageDialog(Messages.getString("GDE_MSGI0002"));
                }
            }
        });
        this.nextDeviceMenuItem = new MenuItem(this.deviceMenu, 8);
        this.nextDeviceMenuItem.setImage(SWTResourceManager.getImage("gde/resource/ArrowWhiteGreenFieldRightHot.gif"));
        this.nextDeviceMenuItem.setText(Messages.getString("GDE_MSGT0032", GDE.MOD3));
        this.nextDeviceMenuItem.setAccelerator(SWT.MOD3 + 0x1000006);
        this.nextDeviceMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "nextDeviceMenuItem.widgetSelected, event=" + String.valueOf(evt));
                }
                if (MenuBar.this.application.getActiveDevice().getCommunicationPort() == null || !MenuBar.this.application.getActiveDevice().getCommunicationPort().isConnected()) {
                    DeviceSelectionDialog deviceSelect = MenuBar.this.application.getDeviceSelectionDialog();
                    if (deviceSelect.checkDataSaved()) {
                        int selection = deviceSelect.getDeviceConfigurations().indexOf(deviceSelect.getActiveConfig().getName());
                        int size = deviceSelect.getDeviceConfigurations().size() - 1;
                        DeviceConfiguration deviceConfig = selection >= 0 && selection < size ? deviceSelect.getDeviceConfigurations().get(deviceSelect.getDeviceConfigurations().get(selection + 1)) : deviceSelect.getDeviceConfigurations().get(deviceSelect.getDeviceConfigurations().get(0));
                        if (MenuBar.this.application.getDeviceDialog() != null && !MenuBar.this.application.getDeviceDialog().isDisposed()) {
                            MenuBar.this.application.getDeviceDialog().dispose();
                        }
                        deviceSelect.setActiveConfig(deviceConfig);
                        deviceSelect.setupDevice();
                    }
                } else {
                    MenuBar.this.application.openMessageDialog(Messages.getString("GDE_MSGI0002"));
                }
            }
        });
        new MenuItem(this.deviceMenu, 2);
        this.toolBoxDeviceMenuItem = new MenuItem(this.deviceMenu, 8);
        this.toolBoxDeviceMenuItem.setText(Messages.getString("GDE_MSGT0029", GDE.MOD1));
        this.toolBoxDeviceMenuItem.setImage(SWTResourceManager.getImage("gde/resource/ToolBoxHot.gif"));
        this.toolBoxDeviceMenuItem.setAccelerator(SWT.MOD1 + Messages.getAcceleratorChar("GDE_MSGT0029"));
        this.toolBoxDeviceMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "toolBoxDeviceMenuItem.widgetSelected, event=" + String.valueOf(evt));
                }
                MenuBar.this.application.openDeviceDialog();
            }
        });
        this.devicePropertyFileEditMenuItem = new MenuItem(this.deviceMenu, 8);
        this.devicePropertyFileEditMenuItem.setText(Messages.getString("GDE_MSGT0465", GDE.MOD1));
        this.devicePropertyFileEditMenuItem.setImage(SWTResourceManager.getImage("gde/resource/EditHot.gif"));
        this.devicePropertyFileEditMenuItem.setAccelerator(SWT.MOD1 + Messages.getAcceleratorChar("GDE_MSGT0465"));
        this.devicePropertyFileEditMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "devicePropertyFileEditMenuItem.widgetSelected, event=" + String.valueOf(evt));
                }
                DevicePropertiesEditor.getInstance().openAsDialog(MenuBar.this.application.getActiveDevice().getDeviceConfiguration());
            }
        });
        this.graphicsMenuItem = new MenuItem(this.parent, 64);
        this.graphicsMenuItem.setText(Messages.getString("GDE_MSGT0033"));
        this.graphicsMenuItem.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent evt) {
                log.log(Level.FINE, "graphicsMenuItem.helpRequested, event=" + String.valueOf(evt));
                MenuBar.this.application.openHelpDialog("", "HelpInfo_33.html");
            }
        });
        this.graphicsMenu = new Menu(this.graphicsMenuItem);
        this.graphicsMenuItem.setMenu(this.graphicsMenu);
        this.saveDefaultGraphicsTemplateItem = new MenuItem(this.graphicsMenu, 8);
        this.saveDefaultGraphicsTemplateItem.setText(Messages.getString("GDE_MSGT0034", GDE.MOD1));
        this.saveDefaultGraphicsTemplateItem.setAccelerator(SWT.MOD1 + 131072 + Messages.getAcceleratorChar("GDE_MSGT0034"));
        this.saveDefaultGraphicsTemplateItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "saveGraphicsTemplateItem.widgetSelected, event=" + String.valueOf(evt));
                }
                if (MenuBar.this.application.getHistoExplorer().map(h -> h.isHistoWindowVisible()).orElse(false).booleanValue() && MenuBar.this.application.getPresentHistoExplorer().hasRecords()) {
                    TrailRecordSet trailRecordSet = MenuBar.this.application.getPresentHistoExplorer().getTrailRecordSet();
                    trailRecordSet.getTemplate().setHistoFileName(trailRecordSet.getTemplate().getDefaultHistoFileName());
                    trailRecordSet.saveTemplate();
                } else {
                    MenuBar.this.channels.getActiveChannel().saveTemplate();
                }
            }
        });
        this.restoreDefaultGraphicsTemplateItem = new MenuItem(this.graphicsMenu, 8);
        this.restoreDefaultGraphicsTemplateItem.setText(Messages.getString("GDE_MSGT0195", GDE.MOD1));
        this.restoreDefaultGraphicsTemplateItem.setAccelerator(SWT.MOD1 + Messages.getAcceleratorChar("GDE_MSGT0195"));
        if (!GDE.IS_OS_ARCH_ARM) {
            this.restoreDefaultGraphicsTemplateItem.setToolTipText(Messages.getString("GDE_MSGT0884"));
        }
        this.restoreDefaultGraphicsTemplateItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "restoreDefaultGraphicsTemplateItem.widgetSelected, event=" + String.valueOf(evt));
                }
                if (MenuBar.this.application.getHistoExplorer().map(h -> h.isHistoWindowVisible()).orElse(false).booleanValue() && MenuBar.this.application.getPresentHistoExplorer().hasRecords()) {
                    TrailRecordSet trailRecordSet = MenuBar.this.application.getPresentHistoExplorer().getTrailRecordSet();
                    HistoGraphicsTemplate template = trailRecordSet.getTemplate();
                    template.setHistoFileName(template.getDefaultHistoFileName());
                    template.load();
                    trailRecordSet.applyTemplate(true);
                    MenuBar.this.application.getPresentHistoExplorer().updateHistoTabs(false, true, true);
                } else {
                    Channel activeChannel = MenuBar.this.channels.getActiveChannel();
                    GraphicsTemplate template = activeChannel.getTemplate();
                    template.setNewFileName(template.getDefaultFileName());
                    log.log(Level.FINE, "templateFilePath = " + template.getDefaultFileName());
                    template.load();
                    if (activeChannel.getActiveRecordSet() != null) {
                        activeChannel.applyTemplate(activeChannel.getActiveRecordSet().getName(), true);
                        activeChannel.getActiveRecordSet().setUnsaved(RecordSet.UNSAVED_REASON_GRAPHICS);
                    }
                }
            }
        });
        this.saveAsGraphicsTemplateItem = new MenuItem(this.graphicsMenu, 8);
        this.saveAsGraphicsTemplateItem.setText(Messages.getString("GDE_MSGT0035"));
        this.saveAsGraphicsTemplateItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "saveGraphicsTemplateItem.widgetSelected, event=" + String.valueOf(evt));
                }
                Settings.getInstance();
                log.log(Level.FINE, "templatePath = " + Settings.getGraphicsTemplatePath());
                if (MenuBar.this.application.getHistoExplorer().map(h -> h.isHistoWindowVisible()).orElse(false).booleanValue() && MenuBar.this.application.getPresentHistoExplorer().hasRecords()) {
                    String templateFileName;
                    TrailRecordSet trailRecordSet = MenuBar.this.application.getPresentHistoExplorer().getTrailRecordSet();
                    HistoGraphicsTemplate template = trailRecordSet.getTemplate();
                    FileDialog fileDialog = MenuBar.this.application.prepareFileSaveDialog(Messages.getString("GDE_MSGT0036"), new String[]{"*.xml"}, template.getTargetFileSubPath().getParent().toString(), template.getTargetFileSubPath().getFileName().toString());
                    if (fileDialog.open() != null && (templateFileName = fileDialog.getFileName()) != null && templateFileName.length() > 4) {
                        log.log(Level.FINE, "templateFilePath = " + templateFileName);
                        trailRecordSet.getTemplate().setHistoFileName(templateFileName);
                        trailRecordSet.saveTemplate();
                        if (MenuBar.this.application.getPresentHistoExplorer().isHistoChartWindowVisible()) {
                            MenuBar.this.application.getPresentHistoExplorer().getActiveHistoChartTabItem().resetStatusMessage();
                        }
                    }
                } else {
                    Channel activeChannel = MenuBar.this.channels.getActiveChannel();
                    if (activeChannel != null) {
                        GraphicsTemplate template = activeChannel.getTemplate();
                        Settings.getInstance();
                        FileDialog fileDialog = MenuBar.this.application.prepareFileSaveDialog(Messages.getString("GDE_MSGT0036"), new String[]{"*.xml"}, Settings.getGraphicsTemplatePath(), template.getDefaultFileName());
                        fileDialog.open();
                        String templateFileName = fileDialog.getFileName();
                        if (templateFileName != null && templateFileName.length() > 4) {
                            log.log(Level.FINE, "templateFilePath = " + templateFileName);
                            template.setNewFileName(templateFileName);
                            activeChannel.saveTemplate();
                        }
                    }
                }
            }
        });
        this.restoreGraphicsTemplateItem = new MenuItem(this.graphicsMenu, 8);
        this.restoreGraphicsTemplateItem.setText(Messages.getString("GDE_MSGT0037"));
        this.restoreGraphicsTemplateItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "restoreGraphicsTemplateItem.widgetSelected, event=" + String.valueOf(evt));
                }
                if (MenuBar.this.application.getHistoExplorer().map(h -> h.isHistoWindowVisible()).orElse(false).booleanValue() && MenuBar.this.application.getPresentHistoExplorer().hasRecords()) {
                    Path templateFilePath;
                    TrailRecordSet trailRecordSet = MenuBar.this.application.getPresentHistoExplorer().getTrailRecordSet();
                    HistoGraphicsTemplate template = trailRecordSet.getTemplate();
                    Path templatesPath = MenuBar.this.settings.isObjectTemplatesActive() ? (MenuBar.this.settings.getActiveObjectKey().isEmpty() ? Paths.get(Settings.getGraphicsTemplatePath(), "_") : Paths.get(Settings.getGraphicsTemplatePath(), MenuBar.this.settings.getActiveObjectKey())) : Paths.get(Settings.getGraphicsTemplatePath(), new String[0]);
                    String filePath = MenuBar.this.application.prepareFileOpenDialog(Messages.getString("GDE_MSGT0038"), new String[]{"*.xml"}, templatesPath.toString(), template.getTargetFileSubPath().getFileName().toString(), 4).open();
                    if (filePath != null && (templateFilePath = Paths.get(filePath, new String[0])).getFileName().toString().length() > 4) {
                        template.loadAlien(templateFilePath);
                        trailRecordSet.applyTemplate(true);
                        MenuBar.this.application.getPresentHistoExplorer().updateHistoTabs(false, true, true);
                    }
                } else {
                    FileDialog fileDialog = MenuBar.this.application.openFileOpenDialog(Messages.getString("GDE_MSGT0038"), new String[]{"*.xml"}, Settings.getGraphicsTemplatePath(), null, 4);
                    String templateFileName = fileDialog.getFileName();
                    if (templateFileName != null && templateFileName.length() > 4) {
                        log.log(Level.FINE, "templateFilePath = " + templateFileName);
                        Channel activeChannel = MenuBar.this.channels.getActiveChannel();
                        GraphicsTemplate template = activeChannel.getTemplate();
                        template.setNewFileName(templateFileName);
                        template.load();
                        if (activeChannel.getActiveRecordSet() != null) {
                            activeChannel.applyTemplate(activeChannel.getActiveRecordSet().getName(), true);
                            activeChannel.getActiveRecordSet().setUnsaved(RecordSet.UNSAVED_REASON_GRAPHICS);
                        }
                    }
                }
            }
        });
        new MenuItem(this.graphicsMenu, 2);
        this.objectTemplatesItem = new MenuItem(this.graphicsMenu, 32);
        this.objectTemplatesItem.setText(Messages.getString("GDE_MSGT0920"));
        if (!GDE.IS_OS_ARCH_ARM) {
            this.objectTemplatesItem.setToolTipText(Messages.getString("GDE_MSGT0921"));
        }
        this.objectTemplatesItem.setSelection(this.settings.isObjectTemplatesActive());
        this.objectTemplatesItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "objectTemplatesItem.widgetSelected, event=" + String.valueOf(evt));
                }
                MenuBar.this.settings.setObjectTemplatesActive(MenuBar.this.objectTemplatesItem.getSelection());
                if (MenuBar.this.application.getHistoExplorer().map(h -> h.isHistoWindowVisible()).orElse(false).booleanValue()) {
                    MenuBar.this.application.getPresentHistoExplorer().resetHisto();
                }
            }
        });
        this.smartStatisticsItem = new MenuItem(this.graphicsMenu, 32);
        this.smartStatisticsItem.setText(Messages.getString("GDE_MSGT0885", GDE.MOD1));
        if (!GDE.IS_OS_ARCH_ARM) {
            this.smartStatisticsItem.setToolTipText(Messages.getString("GDE_MSGT0886", GDE.MOD1));
        }
        this.smartStatisticsItem.setAccelerator(SWT.MOD1 + 131072 + Messages.getAcceleratorChar("GDE_MSGT0885"));
        this.smartStatisticsItem.setSelection(false);
        this.smartStatisticsItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "smartStatisticsItem.widgetSelected, event=" + String.valueOf(evt));
                }
                if (MenuBar.this.application.getHistoExplorer().map(h -> h.isHistoWindowVisible()).orElse(false).booleanValue() && MenuBar.this.application.getPresentHistoExplorer().hasRecords()) {
                    TrailRecordSet trailRecordSet = MenuBar.this.application.getPresentHistoExplorer().getTrailRecordSet();
                    trailRecordSet.setSmartStatistics(MenuBar.this.smartStatisticsItem.getSelection());
                    trailRecordSet.getTemplate().store();
                    MenuBar.this.application.getPresentHistoExplorer().updateHistoTabs(false, true, true);
                } else {
                    MenuBar.this.objectTemplatesItem.setSelection(false);
                }
            }
        });
        this.viewMenuItem = new MenuItem(this.parent, 64);
        this.viewMenuItem.setText(Messages.getString("GDE_MSGT0039"));
        this.viewMenuItem.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent evt) {
                log.log(Level.FINE, "viewMenuItem.helpRequested, event=" + String.valueOf(evt));
                MenuBar.this.application.openHelpDialog("", "HelpInfo_34.html");
            }
        });
        this.viewMenu = new Menu(this.viewMenuItem);
        this.viewMenuItem.setMenu(this.viewMenu);
        this.suppressModeItem = new MenuItem(this.viewMenu, 32);
        this.suppressModeItem.setText(Messages.getString("GDE_MSGT0859"));
        this.suppressModeItem.setSelection(this.settings.isSuppressMode());
        this.suppressModeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "suppressModeItem.widgetSelected, event=" + String.valueOf(evt));
                }
                MenuBar.this.settings.setSuppressMode(MenuBar.this.suppressModeItem.getSelection());
                MenuBar.this.application.getHistoExplorer().ifPresent(h -> h.resetHisto());
            }
        });
        this.curveSelectionMenuItem = new MenuItem(this.viewMenu, 32);
        this.curveSelectionMenuItem.setText(Messages.getString("GDE_MSGT0040"));
        this.curveSelectionMenuItem.setSelection(true);
        this.curveSelectionMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "kurveSelectionMenuItem.widgetSelected, event=" + String.valueOf(evt));
                }
                MenuBar.this.application.enableCurveSelector(MenuBar.this.curveSelectionMenuItem.getSelection());
            }
        });
        this.graphicsHeaderMenuItem = new MenuItem(this.viewMenu, 32);
        this.graphicsHeaderMenuItem.setText(Messages.getString("GDE_MSGT0041"));
        this.graphicsHeaderMenuItem.setSelection(false);
        this.graphicsHeaderMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "graphicsHeaderMenuItem.widgetSelected, event=" + String.valueOf(evt));
                }
                if (MenuBar.this.graphicsHeaderMenuItem.getSelection()) {
                    MenuBar.this.application.enableGraphicsHeader(true);
                    MenuBar.this.application.updateDisplayTab();
                } else {
                    MenuBar.this.application.enableGraphicsHeader(false);
                    MenuBar.this.application.updateDisplayTab();
                }
            }
        });
        this.recordCommentMenuItem = new MenuItem(this.viewMenu, 32);
        this.recordCommentMenuItem.setText(Messages.getString("GDE_MSGT0042"));
        if (!GDE.IS_OS_ARCH_ARM) {
            this.recordCommentMenuItem.setToolTipText(Messages.getString("GDE_MSGT0878"));
        }
        this.recordCommentMenuItem.setSelection(false);
        this.recordCommentMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "recordCommentMenuItem.widgetSelected, event=" + String.valueOf(evt));
                }
                if (MenuBar.this.recordCommentMenuItem.getSelection()) {
                    MenuBar.this.application.enableRecordSetComment(true);
                    MenuBar.this.application.updateDisplayTab();
                } else {
                    MenuBar.this.application.enableRecordSetComment(false);
                    MenuBar.this.application.updateDisplayTab();
                }
            }
        });
        this.graphicsCurveSurveyMenuItem = new MenuItem(this.viewMenu, 32);
        this.graphicsCurveSurveyMenuItem.setText(Messages.getString("GDE_MSGT0876"));
        if (!GDE.IS_OS_ARCH_ARM) {
            this.graphicsCurveSurveyMenuItem.setToolTipText(Messages.getString("GDE_MSGT0877"));
        }
        this.graphicsCurveSurveyMenuItem.setSelection(this.settings.isCurveSurvey());
        this.graphicsCurveSurveyMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "graphicsCurveSurvey.widgetSelected, event=" + String.valueOf(evt));
                }
                MenuBar.this.application.getHistoExplorer().ifPresent(h -> {
                    h.enableCurveSurvey(MenuBar.this.graphicsCurveSurveyMenuItem.getSelection());
                    h.updateHistoChartWindow(MenuBar.this.graphicsCurveSurveyMenuItem.getSelection());
                });
            }
        });
        this.partialTableMenuItem = new MenuItem(this.viewMenu, 32);
        this.partialTableMenuItem.setText(Messages.getString("GDE_MSGT0704"));
        if (!GDE.IS_OS_ARCH_ARM) {
            this.partialTableMenuItem.setToolTipText(Messages.getString("GDE_MSGT0705"));
        }
        this.partialTableMenuItem.setSelection(this.settings.isPartialDataTable());
        this.partialTableMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "partialTableMenuItem.widgetSelected, event=" + String.valueOf(evt));
                }
                MenuBar.this.application.getHistoExplorer().ifPresent(h -> {
                    h.enablePartialDataTable(MenuBar.this.partialTableMenuItem.getSelection());
                    h.updateHistoChartWindow(MenuBar.this.graphicsCurveSurveyMenuItem.getSelection());
                    h.updateHistoTableWindow(true);
                });
            }
        });
        new MenuItem(this.viewMenu, 2);
        this.prevTabConfigItem = new MenuItem(this.viewMenu, 8);
        this.prevTabConfigItem.setText(Messages.getString("GDE_MSGT0438", GDE.MOD1));
        this.prevTabConfigItem.setAccelerator(SWT.MOD1 + 0x1000005);
        this.prevTabConfigItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "prevTabConfigItem.widgetSelected, event=" + String.valueOf(evt));
                }
                MenuBar.this.application.switchPreviousTabulator();
            }
        });
        this.nextTabConfigItem = new MenuItem(this.viewMenu, 8);
        this.nextTabConfigItem.setText(Messages.getString("GDE_MSGT0439", GDE.MOD1));
        this.nextTabConfigItem.setAccelerator(SWT.MOD1 + 0x1000006);
        this.nextTabConfigItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "nextTabConfigItem.widgetSelected, event=" + String.valueOf(evt));
                }
                MenuBar.this.application.switchNextTabulator();
            }
        });
        new MenuItem(this.viewMenu, 2);
        this.prevChannelConfigItem = new MenuItem(this.viewMenu, 8);
        this.prevChannelConfigItem.setText(Messages.getString("GDE_MSGT0663", GDE.MOD1));
        this.prevChannelConfigItem.setAccelerator(SWT.MOD1 + 0x1000003);
        this.prevChannelConfigItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "prevChannelConfigItem.widgetSelected, event=" + String.valueOf(evt));
                }
                MenuBar.this.application.getMenuToolBar().prevChannel.notifyListeners(13, new Event());
            }
        });
        this.nextChannelConfigItem = new MenuItem(this.viewMenu, 8);
        this.nextChannelConfigItem.setText(Messages.getString("GDE_MSGT0664", GDE.MOD1));
        this.nextChannelConfigItem.setAccelerator(SWT.MOD1 + 0x1000004);
        this.nextChannelConfigItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "nextChannelConfigItem.widgetSelected, event=" + String.valueOf(evt));
                }
                MenuBar.this.application.getMenuToolBar().nextChannel.notifyListeners(13, new Event());
            }
        });
        new MenuItem(this.viewMenu, 2);
        this.prevRecordSetItem = new MenuItem(this.viewMenu, 8);
        this.prevRecordSetItem.setText(Messages.getString("GDE_MSGT0665", GDE.MOD3));
        this.prevRecordSetItem.setAccelerator(SWT.MOD3 + 0x1000003);
        this.prevRecordSetItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "prevRecordSetItem.widgetSelected, event=" + String.valueOf(evt));
                }
                MenuBar.this.application.getMenuToolBar().prevRecord.notifyListeners(13, new Event());
            }
        });
        this.nextRecordSetItem = new MenuItem(this.viewMenu, 8);
        this.nextRecordSetItem.setText(Messages.getString("GDE_MSGT0666", GDE.MOD3));
        this.nextRecordSetItem.setAccelerator(SWT.MOD3 + 0x1000004);
        this.nextRecordSetItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "nextRecordSetItem.widgetSelected, event=" + String.valueOf(evt));
                }
                MenuBar.this.application.getMenuToolBar().nextRecord.notifyListeners(13, new Event());
            }
        });
        new MenuItem(this.viewMenu, 2);
        this.nextChartItem = new MenuItem(this.viewMenu, 8);
        this.nextChartItem.setText(Messages.getString("GDE_MSGT0900", GDE.MOD1));
        if (!GDE.IS_OS_ARCH_ARM) {
            this.nextChartItem.setToolTipText(Messages.getString("GDE_MSGT0901"));
        }
        this.nextChartItem.setAccelerator(SWT.MOD1 + 131072 + Messages.getAcceleratorChar("GDE_MSGT0900"));
        this.nextChartItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "nextChartItem.widgetSelected, event=" + String.valueOf(evt));
                }
                MenuBar.this.application.getHistoExplorer().ifPresent(h -> {
                    h.scrollSummaryComposite();
                    h.updateHistoChartWindow(false);
                });
            }
        });
        this.refreshItem = new MenuItem(this.viewMenu, 8);
        this.refreshItem.setText(Messages.getString("GDE_MSGT0925", GDE.MOD1));
        if (!GDE.IS_OS_ARCH_ARM) {
            this.refreshItem.setToolTipText(Messages.getString("GDE_MSGT0926"));
        }
        this.refreshItem.setAccelerator(SWT.MOD1 + Messages.getAcceleratorChar("GDE_MSGT0925"));
        this.refreshItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "refreshItem.widgetSelected, event=" + String.valueOf(evt));
                }
                MenuBar.this.application.getHistoExplorer().ifPresent(h -> h.resetHisto());
            }
        });
        this.helpMenuItem = new MenuItem(this.parent, 64);
        this.helpMenuItem.setText(Messages.getString("GDE_MSGT0043"));
        this.helpMenu = new Menu(this.helpMenuItem);
        this.helpMenuItem.setMenu(this.helpMenu);
        this.contentsMenuItem = new MenuItem(this.helpMenu, 8);
        this.contentsMenuItem.setText(Messages.getString("GDE_MSGT0044"));
        this.contentsMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "contentsMenuItem.widgetSelected, event=" + String.valueOf(evt));
                if (MenuBar.this.application.getActiveDevice() != null && MenuBar.this.application.getActiveDevice().getDialog() != null && !MenuBar.this.application.getActiveDevice().getDialog().isDisposed()) {
                    MenuBar.this.application.getActiveDevice().getDialog().getDialogShell().getShell().notifyListeners(28, new Event());
                } else {
                    for (CTabItem tabItem : MenuBar.this.application.getTabFolder().getItems()) {
                        if (tabItem.isDisposed() || !tabItem.getControl().isVisible()) continue;
                        if (tabItem.getControl().isListening(28)) {
                            tabItem.getControl().notifyListeners(28, new Event());
                            break;
                        }
                        if (tabItem instanceof GraphicsWindow) {
                            ((GraphicsWindow)tabItem).getGraphicsComposite().notifyListeners(28, new Event());
                            continue;
                        }
                        if (!tabItem.getText().endsWith("Tool") || MenuBar.this.application.getActiveDevice() == null || !MenuBar.this.application.getActiveDevice().isUtilityDeviceTabRequested()) continue;
                        MenuBar.this.application.openHelpDialog("WStechVario", "HelpInfo.html");
                    }
                }
            }
        });
        this.webCheckMenuItem = new MenuItem(this.helpMenu, 8);
        this.webCheckMenuItem.setText(Messages.getString("GDE_MSGT0045"));
        this.webCheckMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "webCheckMenuItem.widgetSelected, event=" + String.valueOf(evt));
                }
                MenuBar.this.application.openWebBrowser(Messages.getString("GDE_MSGT0046"));
            }
        });
        if (!GDE.IS_MAC) {
            this.aboutMenuItem = new MenuItem(this.helpMenu, 8);
            this.aboutMenuItem.setText(Messages.getString("GDE_MSGT0047"));
            this.aboutMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "aboutMenuItem.widgetSelected, event=" + String.valueOf(evt));
                    }
                    MenuBar.this.application.openAboutDialog();
                }
            });
        }
        if ((systemMenu = GDE.display.getSystemMenu()) != null) {
            MenuItem sysItem = MenuBar.getItem(systemMenu, -6);
            sysItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MenuBar.this.closeApplication(e);
                }
            });
            sysItem = MenuBar.getItem(systemMenu, -4);
            sysItem.addSelectionListener((SelectionListener)new SelectionAdapter(this){

                public void widgetSelected(SelectionEvent e) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Hide others selected -- and blocked!");
                    }
                    e.doit = false;
                }
            });
            sysItem = MenuBar.getItem(systemMenu, -3);
            sysItem.addSelectionListener((SelectionListener)new SelectionAdapter(this){

                public void widgetSelected(SelectionEvent e) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Hide selected -- and blocked!");
                    }
                    e.doit = false;
                }
            });
            sysItem = MenuBar.getItem(systemMenu, -2);
            sysItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MenuBar.this.openPreferencesDialog(e);
                }
            });
            sysItem = MenuBar.getItem(systemMenu, -1);
            sysItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "aboutMenuItem.widgetSelected, event=" + String.valueOf(e));
                    }
                    MenuBar.this.application.openAboutDialog();
                }
            });
        }
    }

    public void updateSubHistoryMenuItem(String fullQualifiedFileName) {
        MenuItem[] menuItems;
        List<String> refFileHistory = Settings.getInstance().getFileHistory();
        if (fullQualifiedFileName != null && fullQualifiedFileName.length() > 4) {
            String newhistoryEntry = fullQualifiedFileName.replace('\\', '/');
            if (refFileHistory.indexOf(newhistoryEntry) > -1) {
                refFileHistory.remove(newhistoryEntry);
            }
            refFileHistory.add(0, newhistoryEntry);
        }
        for (MenuItem menuItem : menuItems = this.fileHistoryMenu.getItems()) {
            menuItem.dispose();
        }
        int i = 0;
        for (String fullQualifiedFileReference : refFileHistory) {
            String shortFileReference = "&" + ++i + ": " + fullQualifiedFileReference.substring(fullQualifiedFileReference.lastIndexOf(47) + 1);
            final MenuItem historyImportMenuItem = new MenuItem(this.fileHistoryMenu, 8);
            historyImportMenuItem.setText(shortFileReference);
            historyImportMenuItem.setData(shortFileReference, (Object)fullQualifiedFileReference);
            historyImportMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    String fileName;
                    String fileType;
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "historyImportMenuItem.widgetSelected, event=" + String.valueOf(evt));
                    }
                    if ((fileType = (fileName = (String)historyImportMenuItem.getData(historyImportMenuItem.getText())).substring(fileName.lastIndexOf(46) + 1)) != null && fileType.length() > 2) {
                        File file;
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "opening file = " + fileName);
                        }
                        if (!(file = new File(fileName)).exists()) {
                            int answer = MenuBar.this.application.openYesNoMessageDialog(Messages.getString("GDE_MSGW0046", new Object[]{file.getAbsolutePath()}));
                            if (answer == 64) {
                                Settings.getInstance().getFileHistory().remove(fileName);
                                MenuBar.this.updateSubHistoryMenuItem(null);
                            }
                        } else {
                            log.log(Level.FINE, "opening file = " + fileName);
                            if (fileType.equalsIgnoreCase("osd")) {
                                MenuBar.this.fileHandler.openOsdFile(fileName);
                            } else if (fileType.equalsIgnoreCase("lov")) {
                                MenuBar.this.fileHandler.openLovFile(fileName);
                            } else {
                                MenuBar.this.application.openMessageDialog(Messages.getString("GDE_MSGI0003"));
                            }
                        }
                    }
                }
            });
        }
    }

    public void setPortConnected(boolean isOpenStatus) {
        if (!this.application.isDisposed() && !this.portMenuItem.isDisposed()) {
            switch (this.iconSet) {
                default: {
                    if (isOpenStatus) {
                        this.portMenuItem.setImage(SWTResourceManager.getImage("gde/resource/BulletHotGreen.gif"));
                        this.portMenuItem.setText(Messages.getString("GDE_MSGT0048"));
                        break;
                    }
                    this.portMenuItem.setImage(SWTResourceManager.getImage("gde/resource/BulletHotRed.gif"));
                    this.portMenuItem.setText(Messages.getString("GDE_MSGT0049"));
                    break;
                }
                case 1: {
                    if (isOpenStatus) {
                        this.portMenuItem.setImage(SWTResourceManager.getImage("gde/resource/RectangleHotRed.gif"));
                        this.portMenuItem.setText(Messages.getString("GDE_MSGT0071"));
                        break;
                    }
                    this.portMenuItem.setImage(SWTResourceManager.getImage("gde/resource/TriangleGreen.gif"));
                    this.portMenuItem.setText(Messages.getString("GDE_MSGT0070"));
                    break;
                }
                case 2: {
                    if (isOpenStatus) {
                        this.portMenuItem.setImage(SWTResourceManager.getImage("gde/resource/RectangleHotRed.gif"));
                        this.portMenuItem.setText(Messages.getString("GDE_MSGT0219"));
                        break;
                    }
                    this.portMenuItem.setImage(SWTResourceManager.getImage("gde/resource/OpenHot.gif"));
                    this.portMenuItem.setText(Messages.getString("GDE_MSGT0218"));
                }
            }
        }
    }

    public void setSerialPortIconSet(int newIconSet) {
        this.iconSet = newIconSet;
        this.setPortConnected(false);
    }

    public int getSerialPortIconSet() {
        return this.iconSet;
    }

    public void setRecordCommentMenuItemSelection(boolean selected) {
        this.recordCommentMenuItem.setSelection(selected);
    }

    public void setCurveSurveyMenuItemSelection(boolean selected) {
        this.graphicsCurveSurveyMenuItem.setSelection(selected);
    }

    public void setGraphicsHeaderMenuItemSelection(boolean selected) {
        this.graphicsHeaderMenuItem.setSelection(selected);
    }

    public void enableDeviceSwitchButtons(boolean enabled) {
        this.prevDeviceMenuItem.setEnabled(enabled);
        this.nextDeviceMenuItem.setEnabled(enabled);
    }

    public void enableZoomMenuButtons(boolean enabled) {
        this.activateZoomGraphicMenuItem.setEnabled(enabled);
        this.resetZoomGraphicMenuItem.setEnabled(enabled);
    }

    public Menu getExportMenu() {
        return this.exportMenu;
    }

    public Menu getImportMenu() {
        return this.importMenu;
    }

    public void cleanup() {
        int i = this.exportMenu.getItemCount() - 1;
        while (this.exportMenu.getItemCount() > 3) {
            this.exportMenu.getItem(i).dispose();
            --i;
        }
        i = this.importMenu.getItemCount() - 1;
        while (this.importMenu.getItemCount() > 2) {
            this.importMenu.getItem(i).dispose();
            --i;
        }
    }

    public void enablePanButton(boolean enable) {
        this.panGraphicMenuItem.setEnabled(enable);
    }

    public void updateAdditionalGPSMenuItems() {
        final boolean isGPSData = this.application.getActiveDevice().isActualRecordSetWithGpsData();
        if (Thread.currentThread().threadId() == this.application.getThreadId()) {
            boolean isAdditionalExportItem = false;
            for (MenuItem menuItem : this.exportMenu.getItems()) {
                if (menuItem.getText().equals(Messages.getString("GDE_MSGT0732"))) {
                    isAdditionalExportItem = true;
                    continue;
                }
                if (!isAdditionalExportItem) continue;
                menuItem.setEnabled(isGPSData);
            }
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    boolean isAdditionalExportItem = false;
                    for (MenuItem menuItem : MenuBar.this.exportMenu.getItems()) {
                        if (menuItem.getText().equals(Messages.getString("GDE_MSGT0732"))) {
                            isAdditionalExportItem = true;
                            continue;
                        }
                        if (!isAdditionalExportItem) continue;
                        menuItem.setEnabled(isGPSData);
                    }
                }
            });
        }
    }

    public void updateDevicePropertyEditorItem() {
        final boolean isEnabled = this.application.getActiveDevice().getDeviceConfiguration().isEditable();
        if (Thread.currentThread().threadId() == this.application.getThreadId()) {
            this.devicePropertyFileEditMenuItem.setEnabled(isEnabled);
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MenuBar.this.devicePropertyFileEditMenuItem.setEnabled(isEnabled);
                }
            });
        }
    }

    private void openPreferencesDialog(SelectionEvent evt) {
        DeviceDialog deviceDialog;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "preferencesFileMenuItem.widgetSelected, event=" + String.valueOf(evt));
        }
        if ((deviceDialog = this.application.getDeviceDialog()) == null || deviceDialog.isDisposed()) {
            this.application.openSettingsDialog();
            this.application.setStatusMessage("");
        } else {
            this.application.setStatusMessage(Messages.getString("GDE_MSGI0001"), 3);
        }
    }

    private void closeApplication(SelectionEvent evt) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "exitMenuItem.widgetSelected, event=" + String.valueOf(evt));
        }
        evt.doit = this.application.getDeviceSelectionDialog().checkDataSaved();
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            if (thread == null || thread.isDaemon() || !thread.isAlive() || !thread.getClass().getName().startsWith("gde.device")) continue;
            this.application.openMessageDialog(Messages.getString("GDE_MSGW0048"));
            evt.doit = false;
        }
        if (evt.doit) {
            this.parent.getParent().dispose();
        }
    }

    static MenuItem getItem(Menu menu, int id) {
        MenuItem[] items;
        for (MenuItem item : items = menu.getItems()) {
            if (item.getID() != id) continue;
            return item;
        }
        return null;
    }

    public MenuItem getSuppressModeItem() {
        return this.suppressModeItem;
    }

    public void setSuppressModeItem(MenuItem suppressModeItem) {
        this.suppressModeItem = suppressModeItem;
    }

    public MenuItem getCurveSelectionMenuItem() {
        return this.curveSelectionMenuItem;
    }

    public void setCurveSelectionMenuItem(MenuItem curveSelectionMenuItem) {
        this.curveSelectionMenuItem = curveSelectionMenuItem;
    }

    public MenuItem getGraphicsHeaderMenuItem() {
        return this.graphicsHeaderMenuItem;
    }

    public void setGraphicsHeaderMenuItem(MenuItem graphicsHeaderMenuItem) {
        this.graphicsHeaderMenuItem = graphicsHeaderMenuItem;
    }

    public MenuItem getRecordCommentMenuItem() {
        return this.recordCommentMenuItem;
    }

    public void setRecordCommentMenuItem(MenuItem recordCommentMenuItem) {
        this.recordCommentMenuItem = recordCommentMenuItem;
    }

    public MenuItem getGraphicsCurveSurveyMenuItem() {
        return this.graphicsCurveSurveyMenuItem;
    }

    public void setGraphicsCurveSurveyMenuItem(MenuItem graphicsCurveSurveyMenuItem) {
        this.graphicsCurveSurveyMenuItem = graphicsCurveSurveyMenuItem;
    }

    public MenuItem getPartialTableMenuItem() {
        return this.partialTableMenuItem;
    }

    public void setPartialTableMenuItem(MenuItem partialTableMenuItem) {
        this.partialTableMenuItem = partialTableMenuItem;
    }

    public MenuItem getSmartStatisticsItem() {
        return this.smartStatisticsItem;
    }
}

