/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.dialog;

import gde.GDE;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class AxisEndValuesDialog
extends Dialog {
    static final Logger log = Logger.getLogger(AxisEndValuesDialog.class.getName());
    Shell dialogShell;
    Canvas canvas;
    CLabel minValueLabel;
    CLabel maxValueLabel;
    Button okBbutton;
    CCombo maxValueSelect;
    CCombo minValueSelect;
    boolean isInit = false;
    double[] newValues = new double[2];
    String[] initialValues = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "10", "25", "50", "100"};
    final DataExplorer application = DataExplorer.getInstance();

    public static void main(String[] args) {
        try {
            Display display = Display.getDefault();
            Shell shell = new Shell(display);
            AxisEndValuesDialog inst = new AxisEndValuesDialog(shell, 0);
            double[] oldMinMax = new double[]{7.0, 1.0};
            double[] newMinMax = inst.open(oldMinMax);
            System.out.println("newMinMax = " + newMinMax[0] + ", " + newMinMax[1]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AxisEndValuesDialog(Shell parent, int style) {
        super(parent, style);
    }

    public double[] open(final double[] oldMinMax) {
        try {
            this.isInit = true;
            Shell parent = this.getParent();
            this.dialogShell = new Shell(parent, 34912);
            SWTResourceManager.registerResourceUser((Widget)this.dialogShell);
            this.dialogShell.setLayout((Layout)new FormLayout());
            this.dialogShell.layout();
            this.dialogShell.pack();
            this.dialogShell.setSize(345, 272);
            this.dialogShell.setText(Messages.getString("GDE_MSGT0151"));
            this.dialogShell.setImage(SWTResourceManager.getImage("gde/resource/Measure.gif"));
            this.dialogShell.addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    switch (event.detail) {
                        case 2: {
                            AxisEndValuesDialog.this.dialogShell.close();
                            event.detail = 0;
                            event.doit = false;
                        }
                    }
                }
            });
            this.dialogShell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent evt) {
                    log.log(Level.FINEST, "dialogShell.widgetDisposed, event=" + String.valueOf(evt));
                    try {
                        double minValue = Double.valueOf(AxisEndValuesDialog.this.minValueSelect.getText().trim().replace(',', '.'));
                        double maxValue = Double.valueOf(AxisEndValuesDialog.this.maxValueSelect.getText().trim().replace(',', '.'));
                        if (maxValue < minValue) {
                            minValue = Double.valueOf(AxisEndValuesDialog.this.maxValueSelect.getText().trim().replace(',', '.'));
                            maxValue = Double.valueOf(AxisEndValuesDialog.this.minValueSelect.getText().trim().replace(',', '.'));
                        } else if (maxValue == minValue) {
                            minValue -= 0.1;
                            maxValue += 0.1;
                        }
                        AxisEndValuesDialog.this.newValues = new double[]{minValue, maxValue};
                    }
                    catch (NumberFormatException e) {
                        log.log(Level.WARNING, e.getMessage(), e);
                    }
                    AxisEndValuesDialog.this.application.resetShellIcon();
                }
            });
            this.dialogShell.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent evt) {
                    if (AxisEndValuesDialog.this.isInit) {
                        log.log(Level.FINEST, "paintControl.paintControl, event=" + String.valueOf(evt));
                        AxisEndValuesDialog.this.generateAndSetSelectionValues(AxisEndValuesDialog.this.maxValueSelect, oldMinMax[1], 20);
                        AxisEndValuesDialog.this.generateAndSetSelectionValues(AxisEndValuesDialog.this.minValueSelect, oldMinMax[0], 20);
                    }
                    AxisEndValuesDialog.this.isInit = false;
                }
            });
            FormData okBbuttonLData = new FormData();
            okBbuttonLData.width = 79;
            okBbuttonLData.height = 26;
            okBbuttonLData.left = new FormAttachment(0, 1000, 17);
            okBbuttonLData.top = new FormAttachment(0, 1000, 99);
            this.okBbutton = new Button((Composite)this.dialogShell, 0x1000008);
            this.okBbutton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.okBbutton.setLayoutData((Object)okBbuttonLData);
            this.okBbutton.setText("OK");
            this.okBbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "okBbutton.widgetSelected, event=" + String.valueOf(evt));
                    AxisEndValuesDialog.this.dialogShell.dispose();
                }
            });
            FormData canvasLData = new FormData();
            canvasLData.width = 200;
            canvasLData.height = 200;
            canvasLData.top = new FormAttachment(0, 1000, 18);
            canvasLData.right = new FormAttachment(1000, 1000, -24);
            canvasLData.bottom = new FormAttachment(1000, 1000, -21);
            canvasLData.left = new FormAttachment(0, 1000, 113);
            this.canvas = new Canvas((Composite)this.dialogShell, 2048);
            this.canvas.setLayoutData((Object)canvasLData);
            this.canvas.setBackgroundImage(SWTResourceManager.getImage("gde/resource/SmallGraph.gif"));
            this.maxValueLabel = new CLabel((Composite)this.dialogShell, 0);
            FormData maxValueLabelLData = new FormData();
            maxValueLabelLData.width = 89;
            maxValueLabelLData.height = 22;
            maxValueLabelLData.left = new FormAttachment(0, 1000, 12);
            maxValueLabelLData.top = new FormAttachment(0, 1000, 12);
            this.maxValueLabel.setLayoutData((Object)maxValueLabelLData);
            this.maxValueLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.maxValueLabel.setText(Messages.getString("GDE_MSGT0152"));
            FormData maxValueSelectLData = new FormData();
            maxValueSelectLData.width = 84;
            maxValueSelectLData.height = GDE.IS_LINUX ? 22 : 20;
            maxValueSelectLData.left = new FormAttachment(0, 1000, 12);
            maxValueSelectLData.top = new FormAttachment(0, 1000, 38);
            this.maxValueSelect = new CCombo((Composite)this.dialogShell, 2048);
            this.maxValueSelect.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.maxValueSelect.setLayoutData((Object)maxValueSelectLData);
            this.maxValueSelect.setItems(this.initialValues);
            this.maxValueSelect.select(7);
            this.maxValueSelect.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent evt) {
                    log.log(Level.FINEST, "maxValueSelect.keyPressed, event=" + String.valueOf(evt));
                    if (evt.character == '\r') {
                        AxisEndValuesDialog.this.dialogShell.dispose();
                    }
                }
            });
            this.minValueLabel = new CLabel((Composite)this.dialogShell, 0);
            FormData cLabel1LData = new FormData();
            cLabel1LData.width = 89;
            cLabel1LData.height = 22;
            cLabel1LData.left = new FormAttachment(0, 1000, 12);
            cLabel1LData.top = new FormAttachment(0, 1000, 169);
            this.minValueLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.minValueLabel.setLayoutData((Object)cLabel1LData);
            this.minValueLabel.setText(Messages.getString("GDE_MSGT0153"));
            FormData minValueSelectLData = new FormData();
            minValueSelectLData.width = 84;
            minValueSelectLData.height = GDE.IS_LINUX ? 22 : 20;
            minValueSelectLData.left = new FormAttachment(0, 1000, 12);
            minValueSelectLData.top = new FormAttachment(0, 1000, 195);
            this.minValueSelect = new CCombo((Composite)this.dialogShell, 2048);
            this.minValueSelect.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.minValueSelect.setLayoutData((Object)minValueSelectLData);
            this.minValueSelect.setItems(this.initialValues);
            this.minValueSelect.select(5);
            this.minValueSelect.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent evt) {
                    log.log(Level.FINEST, "minValueSelect.keyPressed, event=" + String.valueOf(evt));
                    if (evt.character == '\r') {
                        AxisEndValuesDialog.this.dialogShell.dispose();
                    }
                }
            });
            this.dialogShell.setLocation(this.getParent().toDisplay(100, 100));
            this.dialogShell.open();
            Display display = this.dialogShell.getDisplay();
            while (!this.dialogShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.newValues;
    }

    void generateAndSetSelectionValues(CCombo combo, double value, int size) {
        int tmpSize = size + size % 2 + 1;
        String strDoubleValue = String.format("%.3f", value);
        int intValue = Double.valueOf(value).intValue();
        String[] tmpValues = new String[tmpSize];
        int i = intValue - tmpSize / 2;
        int j = tmpSize - 1;
        while (i <= intValue + tmpSize / 2) {
            tmpValues[j] = Integer.valueOf(i).toString();
            ++i;
            --j;
        }
        combo.setItems(tmpValues);
        combo.setItem(10, strDoubleValue);
        combo.select(10);
    }

    public boolean isDisposed() {
        return this.dialogShell.isDisposed();
    }
}

