/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.utils;

public final class Spot<T extends Number>
implements Comparable<Spot<T>> {
    private final T x;
    private final T y;

    public Spot(T x, T y) {
        if (x instanceof Double) {
            if (Double.isInfinite(((Number)x).doubleValue()) || Double.isInfinite(((Number)y).doubleValue())) {
                throw new IllegalArgumentException("infinite");
            }
            if (Double.isNaN(((Number)x).doubleValue()) || Double.isNaN(((Number)y).doubleValue())) {
                throw new IllegalArgumentException("NaN");
            }
            this.x = ((Number)x).doubleValue() == 0.0 ? Double.valueOf(0.0) : x;
            this.y = ((Number)y).doubleValue() == 0.0 ? Double.valueOf(0.0) : y;
        } else if (x instanceof Float) {
            if (Float.isInfinite(((Number)x).floatValue()) || Float.isInfinite(((Number)y).floatValue())) {
                throw new IllegalArgumentException("infinite");
            }
            if (Float.isNaN(((Number)x).floatValue()) || Float.isNaN(((Number)y).floatValue())) {
                throw new IllegalArgumentException("NaN");
            }
            this.x = (double)((Number)x).floatValue() == 0.0 ? Float.valueOf(0.0f) : x;
            this.y = (double)((Number)y).floatValue() == 0.0 ? Float.valueOf(0.0f) : y;
        } else {
            this.x = x;
            this.y = y;
        }
    }

    public T x() {
        return this.x;
    }

    public T y() {
        return this.y;
    }

    @Override
    public int compareTo(Spot<T> that) {
        if (((Number)this.y).doubleValue() < ((Number)that.y).doubleValue()) {
            return -1;
        }
        if (((Number)this.y).doubleValue() > ((Number)that.y).doubleValue()) {
            return 1;
        }
        if (((Number)this.x).doubleValue() < ((Number)that.x).doubleValue()) {
            return -1;
        }
        if (((Number)this.x).doubleValue() > ((Number)that.x).doubleValue()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "(" + String.valueOf(this.x) + ", " + String.valueOf(this.y) + ")";
    }
}

