/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.utils;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class SecureHash {
    public static String sha1(String input) {
        StringBuilder sb = new StringBuilder();
        try {
            byte[] hashBytes = MessageDigest.getInstance("SHA1").digest(input.getBytes());
            if (hashBytes != null) {
                for (byte hashByte : hashBytes) {
                    sb.append(Integer.toString((hashByte & 0xFF) + 256, 16).substring(1));
                }
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static String sha1(InputStream inputStream) throws IOException {
        StringBuilder sb = new StringBuilder();
        MessageDigest sha1Digest = null;
        try {
            byte[] hashBytes;
            sha1Digest = MessageDigest.getInstance("SHA1");
            byte[] data = new byte[8192];
            int read = 0;
            while ((read = inputStream.read(data)) != -1) {
                sha1Digest.update(data, 0, read);
            }
            for (byte hashByte : hashBytes = sha1Digest.digest()) {
                sb.append(Integer.toString((hashByte & 0xFF) + 256, 16).substring(1));
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }
}

