/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.ui;

import gde.Analyzer;
import gde.config.Settings;
import gde.data.Channel;
import gde.device.IDevice;
import gde.log.Logger;

public class VolatileStatusMessage {
    private static final String $CLASS_NAME = VolatileStatusMessage.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private final IDevice device = Analyzer.getInstance().getActiveDevice();
    private final Channel channel = Analyzer.getInstance().getActiveChannel();
    private final String objectKey = Settings.getInstance().getActiveObjectKey();
    private final String textLine;
    private final int color;
    private int remainingAccessCounter;

    public VolatileStatusMessage(String textLine, int swtColor, int accessCounter) {
        this.textLine = textLine;
        this.color = swtColor;
        this.remainingAccessCounter = accessCounter;
    }

    public boolean isIdentical(String newTextLine, int swtColor) {
        return !this.textLine.equals(newTextLine) || this.color != swtColor;
    }

    public String getTextLine() {
        if (--this.remainingAccessCounter < 0) {
            throw new UnsupportedOperationException();
        }
        return this.remainingAccessCounter >= 0 ? this.textLine : "";
    }

    public int getColor() {
        return this.color;
    }

    public boolean isExpired() {
        if (this.remainingAccessCounter > 0) {
            boolean isOtherChart = !this.device.equals(Analyzer.getInstance().getActiveDevice()) || !this.channel.equals(Analyzer.getInstance().getActiveChannel()) || !this.objectKey.equals(Settings.getInstance().getActiveObjectKey());
            return isOtherChart;
        }
        return true;
    }

    public String toString() {
        boolean isSameChart = this.device.equals(Analyzer.getInstance().getActiveDevice()) && this.channel.equals(Analyzer.getInstance().getActiveChannel()) && this.objectKey.equals(Settings.getInstance().getActiveObjectKey());
        return "VolatileStatusMessage [textLine=" + this.textLine + ", color=" + this.color + ", remainingAccessCounter=" + this.remainingAccessCounter + ", isSameChart=" + isSameChart + "]";
    }
}

