/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.settlements;

import gde.device.FigureTypes;
import gde.device.TransitionFigureType;
import gde.histo.settlements.SettlementRecord;
import gde.histo.transitions.Transition;
import gde.log.Logger;
import java.util.logging.Level;

public final class FigureEvaluator {
    private static final String $CLASS_NAME = FigureEvaluator.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private final SettlementRecord histoSettlement;

    public FigureEvaluator(SettlementRecord newHistoSettlement) {
        this.histoSettlement = newHistoSettlement;
    }

    public void addFromTransition(Transition transition) {
        int reverseTranslatedResult;
        TransitionFigureType transitionFigure = this.histoSettlement.getSettlement().getEvaluation().getTransitionFigure();
        log.log(Level.FINE, ">", transitionFigure);
        if (transitionFigure.getFigureType() == FigureTypes.COUNT) {
            reverseTranslatedResult = transition.getThresholdSize() * 1000;
        } else if (transitionFigure.getFigureType() == FigureTypes.TIME_SUM_SEC) {
            reverseTranslatedResult = (int)(this.histoSettlement.getParent().getTime_ms(transition.getThresholdEndIndex() + 1) - this.histoSettlement.getParent().getTime_ms(transition.getThresholdStartIndex()));
        } else if (transitionFigure.getFigureType() == FigureTypes.TIME_STEP_SEC) {
            reverseTranslatedResult = (int)this.histoSettlement.getParent().getTime_ms(transition.getThresholdStartIndex());
        } else {
            boolean reverseTranslatedResult2 = false;
            throw new UnsupportedOperationException();
        }
        this.histoSettlement.add((Integer)reverseTranslatedResult, transition);
        log.fine(() -> String.format("%s: timeStamp_ms=%d  reverseTranslatedResult=%d  figureType=%s", new Object[]{this.histoSettlement.getName(), (int)this.histoSettlement.getParent().getTime_ms(transition.getThresholdEndIndex() + 1), reverseTranslatedResult, transitionFigure.getFigureType()}));
    }
}

