/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.recordings;

import gde.config.Settings;
import gde.histo.cache.ExtendedVault;
import gde.histo.recordings.HistoTableMapper;
import gde.log.Level;
import gde.log.Logger;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

public final class TrailDataTags
extends EnumMap<DataTag, List<String>> {
    private static final String $CLASS_NAME = TrailDataTags.class.getName();
    private static final long serialVersionUID = -1091858232851684060L;
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private final List<String> dataLinkPaths = new ArrayList<String>();
    private final List<String> dataFilePaths = new ArrayList<String>();
    private final List<String> dataChannelNumbers = new ArrayList<String>();
    private final List<String> dataRectifiedObjectKeys = new ArrayList<String>();
    private final List<String> dataRecordsetBaseNames = new ArrayList<String>();
    private final List<String> dataRecordSetOrdinals = new ArrayList<String>();
    private final List<String> dataGpsLocations = new ArrayList<String>();
    private EnumSet<HistoTableMapper.DisplayTag> activeDisplayTags = null;

    public TrailDataTags() {
        super(DataTag.class);
        this.put(DataTag.LINK_PATH, this.dataLinkPaths);
        this.put(DataTag.FILE_PATH, this.dataFilePaths);
        this.put(DataTag.CHANNEL_NUMBER, this.dataChannelNumbers);
        this.put(DataTag.RECTIFIED_OBJECTKEY, this.dataRectifiedObjectKeys);
        this.put(DataTag.RECORDSET_BASE_NAME, this.dataRecordsetBaseNames);
        this.put(DataTag.RECORDSET_ORDINAL, this.dataRecordsetBaseNames);
        this.put(DataTag.GPS_LOCATION, this.dataGpsLocations);
    }

    @Override
    public void clear() {
        for (List list : this.values()) {
            list.clear();
        }
        this.activeDisplayTags = null;
    }

    public void add(ExtendedVault histoVault) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, histoVault.getLoadLinkPath().toString(), "   " + histoVault.getLoadFilePath().toString());
        }
        this.dataLinkPaths.add(histoVault.getLoadLinkPath().toString());
        this.dataFilePaths.add(histoVault.getLoadFilePath().toString());
        this.dataChannelNumbers.add(String.valueOf(histoVault.getLogChannelNumber()).intern());
        this.dataRectifiedObjectKeys.add(histoVault.getRectifiedObjectKey().intern());
        this.dataRecordsetBaseNames.add(histoVault.getLogRecordsetBaseName().intern());
        this.dataRecordSetOrdinals.add(String.valueOf(histoVault.getLogRecordSetOrdinal()).intern());
    }

    public void add(List<String> gpsLocations) {
        this.dataGpsLocations.addAll(gpsLocations);
    }

    public Map<DataTag, String> getByIndex(int index) {
        if (index >= 0) {
            EnumMap<DataTag, String> dataTags4Index = new EnumMap<DataTag, String>(DataTag.class);
            for (Map.Entry logTagEntry : this.entrySet()) {
                if (((List)logTagEntry.getValue()).size() <= 0) continue;
                dataTags4Index.put((DataTag)((Object)logTagEntry.getKey()), (String)((List)logTagEntry.getValue()).get(index));
            }
            return dataTags4Index;
        }
        return new EnumMap<DataTag, String>(DataTag.class);
    }

    public String getText(int index, DataTag dataTag) {
        if (index >= 0) {
            return (String)((List)this.get((Object)dataTag)).get(index);
        }
        throw new IllegalArgumentException();
    }

    public EnumSet<HistoTableMapper.DisplayTag> getActiveDisplayTags(int channelNumber) {
        if (this.activeDisplayTags == null) {
            this.defineActiveDisplayTags(channelNumber);
        }
        return this.activeDisplayTags;
    }

    public void defineActiveDisplayTags(int channelNumber) {
        EnumSet<HistoTableMapper.DisplayTag> resultTags = EnumSet.allOf(HistoTableMapper.DisplayTag.class);
        if (((List)this.get((Object)DataTag.GPS_LOCATION)).isEmpty()) {
            resultTags.remove((Object)HistoTableMapper.DisplayTag.GPS_LOCATION);
        }
        if (!((List)this.get((Object)DataTag.FILE_PATH)).isEmpty() && Settings.getInstance().isPartialDataTable()) {
            Path directoryPath = Paths.get((String)((List)this.get((Object)this.getSourcePathTag(0))).get(0), new String[0]).getParent();
            boolean sameDirectory = true;
            boolean sameBase = true;
            for (int i = 0; i < ((List)this.get((Object)DataTag.FILE_PATH)).size(); ++i) {
                Path path = Paths.get((String)((List)this.get((Object)this.getSourcePathTag(i))).get(i), new String[0]);
                if (!path.getParent().getFileName().equals(directoryPath.getFileName())) {
                    sameDirectory = false;
                }
                if (path.getNameCount() > 2 && !path.getParent().getParent().equals(directoryPath.getParent())) {
                    sameBase = false;
                }
                if (!sameDirectory && !sameBase) break;
            }
            if (sameDirectory) {
                resultTags.remove((Object)HistoTableMapper.DisplayTag.DIRECTORY_NAME);
            }
            if (sameBase) {
                resultTags.remove((Object)HistoTableMapper.DisplayTag.BASE_PATH);
            }
            String tagChannelNumber = (String)((List)this.get((Object)DataTag.CHANNEL_NUMBER)).get(0);
            boolean sameChannel = true;
            for (String tmp : (List)this.get((Object)DataTag.CHANNEL_NUMBER)) {
                if (tmp.equals(tagChannelNumber) && channelNumber == Integer.parseInt(tmp)) continue;
                sameChannel = false;
                break;
            }
            if (sameChannel) {
                resultTags.remove((Object)HistoTableMapper.DisplayTag.CHANNEL_NUMBER);
            }
            String objectKey = (String)((List)this.get((Object)DataTag.RECTIFIED_OBJECTKEY)).get(0);
            boolean sameObject = true;
            for (String tmp : (List)this.get((Object)DataTag.RECTIFIED_OBJECTKEY)) {
                if (tmp.equals(objectKey)) continue;
                sameObject = false;
                break;
            }
            if (sameObject) {
                resultTags.remove((Object)HistoTableMapper.DisplayTag.RECTIFIED_OBJECTKEY);
            }
        }
        this.activeDisplayTags = resultTags;
        log.finer(() -> "activeDisplayTags.size()=" + resultTags.size());
    }

    public DataTag getSourcePathTag(int index) {
        return ((String)((List)this.get((Object)DataTag.LINK_PATH)).get(index)).isEmpty() || Settings.getInstance().getActiveObjectKey().isEmpty() ? DataTag.FILE_PATH : DataTag.LINK_PATH;
    }

    public List<String> getDataGpsLocations() {
        return this.dataGpsLocations;
    }

    public List<String> getDataLinkPaths() {
        return this.dataLinkPaths;
    }

    public List<String> getDataFilePaths() {
        return this.dataFilePaths;
    }

    public List<String> getDataChannelNumbers() {
        return this.dataChannelNumbers;
    }

    public List<String> getDataRectifiedObjectKeys() {
        return this.dataRectifiedObjectKeys;
    }

    public List<String> getDataRecordsetBaseNames() {
        return this.dataRecordsetBaseNames;
    }

    public List<String> getDataRecordSetOrdinals() {
        return this.dataRecordSetOrdinals;
    }

    public static enum DataTag {
        LINK_PATH,
        FILE_PATH,
        CHANNEL_NUMBER,
        RECTIFIED_OBJECTKEY,
        RECORDSET_BASE_NAME,
        RECORDSET_ORDINAL,
        GPS_LOCATION;

    }
}

