/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.device;

import gde.Analyzer;
import gde.device.TransitionClassTypes;
import gde.device.TransitionType;
import gde.histo.device.Candidate;
import gde.histo.device.MaxMinObserver;
import gde.histo.device.RandomCandidate;
import gde.log.Logger;
import java.util.Arrays;
import java.util.Random;
import java.util.logging.Level;

public final class UniversalSampler {
    private static final String $CLASS_NAME = UniversalSampler.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private final int samplingTimespan_ms;
    private final int[] points;
    private final Analyzer analyzer;
    private final MaxMinObserver maxMinObserver;
    private final Random rand = new Random();
    private int readingCount = 0;
    private int samplingCount = 0;
    private Candidate lastCandidate;
    private Candidate thisCandidate;
    private int oversamplingCount = 0;

    private UniversalSampler(int channelNumber, int[] maxPoints, int[] minPoints, int newRecordTimespan_ms, Analyzer analyzer) {
        this(channelNumber, new int[maxPoints.length], maxPoints, minPoints, newRecordTimespan_ms, analyzer);
    }

    private UniversalSampler(int channelNumber, int[] points, int[] maxPoints, int[] minPoints, int newRecordTimespan_ms, Analyzer analyzer) {
        if (points.length != minPoints.length) {
            throw new IllegalArgumentException();
        }
        if (maxPoints.length != minPoints.length) {
            throw new IllegalArgumentException();
        }
        this.points = points;
        this.analyzer = analyzer;
        int proposedTimespan_ms = this.analyzer.getSettings().getSamplingTimespan_ms();
        for (TransitionType transitionType : this.analyzer.getActiveDevice().getDeviceConfiguration().getChannelType(channelNumber).getTransitions().values()) {
            if (transitionType.getClassType() == TransitionClassTypes.PEAK) {
                proposedTimespan_ms = transitionType.getPeakMinimumTimeMsec() == null ? Math.min(proposedTimespan_ms, newRecordTimespan_ms * 2) : Math.min(proposedTimespan_ms, transitionType.getPeakMinimumTimeMsec().orElse(0) / 2);
            }
            int detectableTimespan_ms = Math.min(transitionType.getReferenceTimeMsec(), transitionType.getThresholdTimeMsec()) / 2;
            proposedTimespan_ms = Math.min(proposedTimespan_ms, detectableTimespan_ms);
        }
        if (proposedTimespan_ms >= newRecordTimespan_ms) {
            this.samplingTimespan_ms = proposedTimespan_ms;
            this.maxMinObserver = new MaxMinObserver(this.points, maxPoints, minPoints);
            this.lastCandidate = new RandomCandidate(this.points, this.samplingTimespan_ms, this.maxMinObserver);
            this.thisCandidate = new RandomCandidate(this.points, this.samplingTimespan_ms, this.maxMinObserver);
        } else {
            this.samplingTimespan_ms = -1;
            this.maxMinObserver = null;
            this.lastCandidate = new Candidate(this.points);
            this.thisCandidate = null;
        }
        log.log(Level.FINER, "", this);
    }

    public static UniversalSampler createSampler(int channelNumber, int[] points, int newRecordTimespan_ms, Analyzer analyzer) {
        int[] tmpMaxPoints = new int[points.length];
        int[] tmpMinPoints = new int[points.length];
        Arrays.fill(tmpMaxPoints, Integer.MIN_VALUE);
        Arrays.fill(tmpMinPoints, Integer.MAX_VALUE);
        return new UniversalSampler(channelNumber, points, tmpMaxPoints, tmpMinPoints, newRecordTimespan_ms, analyzer);
    }

    public static UniversalSampler createSampler(int channelNumber, int[] maxPoints, int[] minPoints, int newRecordTimespan_ms, Analyzer analyzer) {
        return new UniversalSampler(channelNumber, maxPoints, minPoints, newRecordTimespan_ms, analyzer);
    }

    public String toString() {
        return String.format("pointsLength=%d  samplingTimespan_ms=%d userSamplingTimespan_ms=%d  readingCount=%d samplingCount=%d oversamplingCount=%d", this.points.length, this.samplingTimespan_ms, this.analyzer.getSettings().getSamplingTimespan_ms(), this.readingCount, this.samplingCount, this.oversamplingCount);
    }

    public boolean capturePoints(long newTimeStep_ms) {
        boolean isValidSample;
        if (!(this.lastCandidate instanceof RandomCandidate)) {
            this.lastCandidate.processSample(this.points, newTimeStep_ms);
            isValidSample = true;
            this.setCounters(1, 0, isValidSample);
        } else {
            RandomCandidate candidate = (RandomCandidate)this.lastCandidate;
            this.lastCandidate = this.thisCandidate;
            isValidSample = candidate.processPoints(newTimeStep_ms, (RandomCandidate)this.lastCandidate, this.rand);
            int overSamplingIncrement = candidate.isNewTimeSpan() ? candidate.getOverSamplingCount() : 0;
            this.setCounters(1, overSamplingIncrement, isValidSample);
            this.thisCandidate = candidate;
        }
        return isValidSample;
    }

    private void setCounters(int increment, int overSamplingIncrement, boolean isValidSample) {
        this.readingCount += increment;
        if (isValidSample) {
            this.samplingCount += increment;
        }
        this.oversamplingCount += overSamplingIncrement;
        if (overSamplingIncrement > 0) {
            log.finer(() -> String.format("%,12d  ", this.lastCandidate.sampleTimeStep_ms) + String.format(String.format("%0" + this.oversamplingCount + "d", 0), new Object[0]));
        }
    }

    public void setMaxMinPoints(int[] newMaxPoints, int[] newMinPoints) {
        if (this.maxMinObserver != null) {
            if (newMaxPoints.length == 0 || newMinPoints.length == 0) {
                int[] maxPoints = new int[this.points.length];
                Arrays.fill(maxPoints, Integer.MIN_VALUE);
                int[] minPoints = new int[this.points.length];
                Arrays.fill(minPoints, Integer.MAX_VALUE);
                this.maxMinObserver.setMaxMinPoints(maxPoints, minPoints);
            } else {
                if (this.points.length != newMaxPoints.length || this.points.length != newMinPoints.length) {
                    throw new UnsupportedOperationException();
                }
                this.maxMinObserver.setMaxMinPoints(newMaxPoints, newMinPoints);
            }
        }
    }

    public int[] getSamplePoints() {
        return this.lastCandidate.samplePoints;
    }

    public long getSampleTimeStep_ms() {
        return this.lastCandidate.sampleTimeStep_ms;
    }

    public int getReadingCount() {
        return this.readingCount;
    }

    public int getSamplingCount() {
        return this.samplingCount;
    }

    public int getOverSamplingCount() {
        return this.oversamplingCount;
    }

    public int[] getMaxPoints() {
        return this.maxMinObserver != null ? this.maxMinObserver.maxPoints : new int[]{};
    }

    public int[] getMinPoints() {
        return this.maxMinObserver != null ? this.maxMinObserver.minPoints : new int[]{};
    }

    public int[] getPoints() {
        return this.points;
    }
}

