/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.device;

import gde.histo.device.Candidate;
import gde.histo.device.MaxMinObserver;
import gde.log.Logger;
import java.util.Arrays;
import java.util.Random;

public final class RandomCandidate
extends Candidate {
    private static final String $CLASS_NAME = RandomCandidate.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private final int samplingTimespan_ms;
    private final MaxMinObserver maxMinObserver;
    private int nextStartTimeStamp_ms;
    private int nextSamplingTimeStamp_ms;
    private boolean isSampleTimePassed;
    private int timeSpanSamplingCount;
    private boolean isNewTimeSpan;
    private int overSamplingCount = 0;
    private boolean isMinMax = false;
    private boolean isRandomCandidate = false;

    public RandomCandidate(int[] points, int newSamplingTimespan_ms, MaxMinObserver newMaxMinObserver) {
        super(points);
        this.samplingTimespan_ms = newSamplingTimespan_ms;
        this.maxMinObserver = newMaxMinObserver;
    }

    @Override
    @Deprecated
    public void processSample(int[] newPoints, long newTimeStep_ms) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("timeStep_ms=%,d isSampleTimePassed=%b isRandomCandidate=%b", this.sampleTimeStep_ms, this.isSampleTimePassed, this.isRandomCandidate));
        sb.append("\n").append(String.format("nextStartTimeStamp_ms=%,d nextSamplingTimeStamp_ms=%,d isMinMax=%b timeSpanSamplingCount=%d", this.nextStartTimeStamp_ms, this.nextSamplingTimeStamp_ms, this.isMinMax, this.timeSpanSamplingCount));
        if (this.samplePoints != null) {
            sb.append("\n").append(Arrays.toString(this.samplePoints));
        } else {
            sb.append("\n").append("no points");
        }
        return sb.toString();
    }

    public boolean processPoints(long newTimeStep_ms, RandomCandidate previousCandidate, Random rand) {
        this.initialize(newTimeStep_ms, previousCandidate, rand);
        boolean isValidSample = this.isValidSample(previousCandidate);
        if (isValidSample) {
            if (previousCandidate.nextStartTimeStamp_ms < this.nextStartTimeStamp_ms) {
                ++previousCandidate.timeSpanSamplingCount;
            } else {
                ++this.timeSpanSamplingCount;
            }
        }
        log.finer(() -> String.format("%,12d isValidSample=%b", previousCandidate.sampleTimeStep_ms, isValidSample));
        return isValidSample;
    }

    private void initialize(long newTimeStep_ms, RandomCandidate previousCandidate, Random rand) {
        if (newTimeStep_ms >= (long)previousCandidate.nextStartTimeStamp_ms) {
            this.overSamplingCount = this.timeSpanSamplingCount > 0 ? this.timeSpanSamplingCount - 1 : 0;
            this.isNewTimeSpan = true;
            this.nextStartTimeStamp_ms = previousCandidate.nextStartTimeStamp_ms + this.samplingTimespan_ms;
            this.nextSamplingTimeStamp_ms = previousCandidate.nextStartTimeStamp_ms + rand.nextInt(this.samplingTimespan_ms);
            this.isSampleTimePassed = false;
            this.timeSpanSamplingCount = 0;
            log.finer(() -> "******************** " + String.format("timeStep_ms=%d nextSamplingTimeStamp_ms=%d", newTimeStep_ms, this.nextSamplingTimeStamp_ms));
            this.isRandomCandidate = newTimeStep_ms >= (long)this.nextSamplingTimeStamp_ms;
            this.isMinMax = this.maxMinObserver.update(newTimeStep_ms, previousCandidate.samplePoints);
            if (previousCandidate.timeSpanSamplingCount == 0 && previousCandidate.nextStartTimeStamp_ms != 0) {
                previousCandidate.isRandomCandidate = true;
            }
        } else {
            this.overSamplingCount = previousCandidate.overSamplingCount;
            this.isNewTimeSpan = false;
            this.nextStartTimeStamp_ms = previousCandidate.nextStartTimeStamp_ms;
            this.nextSamplingTimeStamp_ms = previousCandidate.nextSamplingTimeStamp_ms;
            this.isSampleTimePassed = previousCandidate.isSampleTimePassed || previousCandidate.isRandomCandidate;
            this.timeSpanSamplingCount = previousCandidate.timeSpanSamplingCount;
            this.isRandomCandidate = !this.isSampleTimePassed && newTimeStep_ms >= (long)this.nextSamplingTimeStamp_ms;
            this.isMinMax = this.maxMinObserver.update(newTimeStep_ms, previousCandidate.samplePoints);
        }
        this.sampleTimeStep_ms = newTimeStep_ms;
        this.samplePoints = (int[])(this.isMinMax || this.timeSpanSamplingCount == 0 ? Arrays.copyOf(this.points, this.points.length) : null);
        log.finer(() -> String.format("timeStep_ms=%,12d isSampleTimePassed=%b isRandomCandidate=%b", newTimeStep_ms, this.isSampleTimePassed, this.isRandomCandidate));
    }

    private boolean isValidSample(RandomCandidate lastItem) {
        Action predecessorAction;
        if (lastItem.isMinMax && lastItem.isRandomCandidate) {
            predecessorAction = this.isMinMax ? (this.isRandomCandidate ? Action.FORCE_RELEASE : (this.maxMinObserver.isLastAutonomousExtremum() ? Action.FORCE_RELEASE : Action.DISCARD)) : Action.FORCE_RELEASE;
        } else if (lastItem.isMinMax && !lastItem.isRandomCandidate) {
            predecessorAction = this.isMinMax ? (this.isRandomCandidate ? Action.DISCARD : (this.maxMinObserver.isLastAutonomousExtremum() ? Action.FORCE_RELEASE : Action.DISCARD)) : Action.FORCE_RELEASE;
        } else if (!lastItem.isMinMax && lastItem.isRandomCandidate) {
            predecessorAction = this.isMinMax ? (this.isRandomCandidate ? Action.COMPENSATE_RELEASE : Action.DISCARD) : Action.COMPENSATE_RELEASE;
        } else if (!lastItem.isMinMax && !lastItem.isRandomCandidate) {
            predecessorAction = Action.DISCARD;
        } else {
            throw new UnsupportedOperationException("is never reached");
        }
        log.finer(() -> String.format("action=%-11s %,12d isLastMinMax=%b isLastRandomCandidate=%b isMinMax=%b isRandomCandidate=%b", predecessorAction.toString(), lastItem.sampleTimeStep_ms, lastItem.isMinMax, lastItem.isRandomCandidate, this.isMinMax, this.isRandomCandidate));
        return predecessorAction == Action.FORCE_RELEASE || predecessorAction == Action.COMPENSATE_RELEASE && lastItem.timeSpanSamplingCount <= 0;
    }

    public int getOverSamplingCount() {
        return this.overSamplingCount;
    }

    public boolean isNewTimeSpan() {
        return this.isNewTimeSpan;
    }

    private static enum Action {
        DISCARD,
        FORCE_RELEASE,
        COMPENSATE_RELEASE;

    }
}

