/*
 * Decompiled with CFR 0.152.
 */
package gde.device;

import gde.device.DataTypes;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="PropertyType")
public class PropertyType
implements Cloneable {
    @XmlAttribute(required=true)
    protected String name;
    @XmlAttribute(required=true)
    @XmlSchemaType(name="anySimpleType")
    protected String value;
    @XmlAttribute(required=true)
    protected DataTypes type;
    @XmlAttribute
    protected String description;

    public PropertyType() {
    }

    private PropertyType(PropertyType property) {
        this.name = property.name;
        this.value = property.value;
        this.type = property.type;
        this.description = property.description;
    }

    public PropertyType clone() {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return new PropertyType(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newValue) {
        this.name = newValue;
    }

    public String getValue() {
        if (this.type == DataTypes.DOUBLE) {
            return this.value.trim().replace(',', '.');
        }
        return this.value.trim();
    }

    public void setValue(Object newValue) {
        this.value = String.valueOf(newValue).trim();
    }

    public DataTypes getType() {
        return this.type;
    }

    public void setType(DataTypes newValue) {
        this.type = newValue;
    }

    public String getDescription() {
        return this.description != null ? this.description : "";
    }

    public void setDescription(String newValue) {
        this.description = newValue.trim().equals("") ? null : newValue.trim();
    }

    public static enum ScoreType {
        REAL_SIZE("realSize"),
        TOTAL_READINGS("totalReadings"),
        SAMPLED_READINGS("sampledReadings"),
        TOTAL_PACKAGES("totalPackages"),
        LOST_PACKAGES("lostPackages"),
        SENSORS("sensors"),
        LOST_PACKAGES_PERMILLE("lostPackagesPerMille"),
        LOST_PACKAGES_AVG_MS("lostPackagesAvg_ms"),
        LOST_PACKAGES_MIN_MS("lostPackagesMin_ms"),
        LOST_PACKAGES_MAX_MS("lostPackagesMax_ms"),
        LOST_PACKAGES_SIGMA_MS("lostPackagesSigma_ms"),
        AVG_TIMESTEP_MS("averageTimeStep_ms"),
        MIN_TIMESTEP_MS("minimumTimeStep_ms"),
        MAX_TIMESTEP_MS("maximumTimeStep_ms"),
        SIGMA_TIMESTEP_MS("sigmaTimeStep_ms"),
        DURATION_MM("duration_mm");

        public final String value;

        private ScoreType(String v) {
            this.value = v;
        }
    }
}

