/*
 * Decompiled with CFR 0.152.
 */
package gde.comm;

import java.util.HashMap;
import java.util.Map;
import javax.usb.UsbDeviceDescriptor;

public class UsbDescriptorUtils {
    private static final Map<Byte, String> CLASS_NAMES = new HashMap<Byte, String>();

    public static String decodeBCD(short bcd) {
        return String.format("%x.%02x", (bcd & 0xFF00) >> 8, bcd & 0xFF);
    }

    public static String getUSBClassName(byte usbClass) {
        String name = CLASS_NAMES.get(usbClass);
        if (name == null) {
            return "Unknown";
        }
        return name;
    }

    public static String dump(UsbDeviceDescriptor descriptor, String manufacturer, String product, String serial) {
        return String.format("Device Descriptor:%n  bLength %18d%n  bDescriptorType %10d%n  bcdUSB %19s%n  bDeviceClass %13d %s%n  bDeviceSubClass %10d%n  bDeviceProtocol %10d%n  bMaxPacketSize0 %10d%n  idVendor %17s%n  idProduct %16s%n  bcdDevice %16s%n  iManufacturer %12d%s%n  iProduct %17d%s%n  iSerial %18d%s%n  bNumConfigurations %7d%n", descriptor.bLength(), descriptor.bDescriptorType(), UsbDescriptorUtils.decodeBCD(descriptor.bcdUSB()), descriptor.bDeviceClass() & 0xFF, UsbDescriptorUtils.getUSBClassName(descriptor.bDeviceClass()), descriptor.bDeviceSubClass() & 0xFF, descriptor.bDeviceProtocol() & 0xFF, descriptor.bMaxPacketSize0() & 0xFF, String.format("0x%04x", descriptor.idVendor() & 0xFFFF), String.format("0x%04x", descriptor.idProduct() & 0xFFFF), UsbDescriptorUtils.decodeBCD(descriptor.bcdDevice()), descriptor.iManufacturer() & 0xFF, manufacturer == null ? "" : " " + manufacturer, descriptor.iProduct() & 0xFF, product == null ? "" : " " + product, descriptor.iSerialNumber() & 0xFF, serial == null ? "" : " " + serial, descriptor.bNumConfigurations() & 0xFF);
    }

    static {
        CLASS_NAMES.put((byte)0, "Per Interface");
        CLASS_NAMES.put((byte)1, "Audio");
        CLASS_NAMES.put((byte)2, "Communications");
        CLASS_NAMES.put((byte)3, "HID");
        CLASS_NAMES.put((byte)5, "Physical");
        CLASS_NAMES.put((byte)6, "Imaging");
        CLASS_NAMES.put((byte)7, "Printer");
        CLASS_NAMES.put((byte)8, "Mass Storage");
        CLASS_NAMES.put((byte)9, "Hub");
        CLASS_NAMES.put((byte)10, "Data");
        CLASS_NAMES.put((byte)11, "Smart Card");
        CLASS_NAMES.put((byte)13, "Content Security");
        CLASS_NAMES.put((byte)14, "Video");
        CLASS_NAMES.put((byte)15, "Personal Healthcare");
        CLASS_NAMES.put((byte)-36, "Diagnostic Device");
        CLASS_NAMES.put((byte)-32, "Wireless");
        CLASS_NAMES.put((byte)-2, "Application");
        CLASS_NAMES.put((byte)-1, "Vendor-specific");
    }
}

