/*
 * Decompiled with CFR 0.152.
 */
package gde.comm;

import javax.usb.UsbDevice;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbServices;

public class DumpDeviceTree {
    public static void dump(UsbDevice device, int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("  ");
        }
        if (device.isUsbHub()) {
            System.out.println("Hub " + String.valueOf(device));
        } else {
            System.out.println("Dev " + String.valueOf(device));
        }
        if (device.isUsbHub()) {
            UsbHub hub = (UsbHub)device;
            for (UsbDevice child : hub.getAttachedUsbDevices()) {
                DumpDeviceTree.dump(child, level + 1);
            }
        }
    }

    public static void main(String[] args) throws UsbException {
        UsbServices services = UsbHostManager.getUsbServices();
        DumpDeviceTree.dump((UsbDevice)services.getRootUsbHub(), 0);
    }
}

