/*
 * Decompiled with CFR 0.152.
 */
package gde.device.smmodellbau;

import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.PropertyType;
import gde.device.smmodellbau.UniLog;
import gde.device.smmodellbau.UniLogDialog;
import gde.device.smmodellbau.UniLogSerialPort;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.SerialPortException;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.WaitTimer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;

public class UniLogLiveGatherer
extends Thread {
    static final Logger log = Logger.getLogger(UniLogLiveGatherer.class.getName());
    final DataExplorer application;
    final UniLogSerialPort serialPort;
    final UniLog device;
    final UniLogDialog dialog;
    final Channels channels;
    final Channel channel;
    final Integer channelNumber;
    int timeStep_ms;
    Timer timer;
    TimerTask timerTask;
    boolean isTimerRunning = false;
    boolean isPortOpenedByLiveGatherer = false;
    final int[] time_ms = new int[]{250, 250, 250, 500, 1000, 2000, 5000, 10000};
    boolean isSwitchedRecordSet = false;
    boolean isGatheredRecordSetVisible = true;
    final HashMap<String, Double> calcValues = new HashMap();

    public UniLogLiveGatherer(DataExplorer currentApplication, UniLog useDevice, UniLogSerialPort useSerialPort, int channelConfigNumber, UniLogDialog useDialog) throws Exception {
        super("liveDataGatherer");
        this.application = currentApplication;
        this.device = useDevice;
        this.serialPort = useSerialPort;
        this.dialog = useDialog;
        this.channels = Channels.getInstance();
        this.channelNumber = channelConfigNumber;
        this.channel = (Channel)this.channels.get((Object)this.channelNumber);
        this.calcValues.put(UniLog.A1_FACTOR, useDevice.getMeasurementFactor(this.channelNumber, 11));
        this.calcValues.put(UniLog.A1_OFFSET, useDevice.getMeasurementOffset(this.channelNumber, 11));
        this.calcValues.put(UniLog.A2_FACTOR, useDevice.getMeasurementFactor(this.channelNumber, 12));
        this.calcValues.put(UniLog.A2_OFFSET, useDevice.getMeasurementOffset(this.channelNumber, 12));
        this.calcValues.put(UniLog.A3_FACTOR, useDevice.getMeasurementFactor(this.channelNumber, 13));
        this.calcValues.put(UniLog.A3_OFFSET, useDevice.getMeasurementOffset(this.channelNumber, 13));
        PropertyType property = useDevice.getMeasruementProperty(this.channelNumber, 6, UniLog.NUMBER_CELLS);
        int numCellValue = property != null ? Integer.valueOf(property.getValue()) : 4;
        this.calcValues.put(UniLog.NUMBER_CELLS, Double.valueOf(numCellValue));
        property = useDevice.getMeasruementProperty(this.channelNumber, 8, UniLog.PROP_N_100_W);
        int prop_n100W = property != null ? Integer.valueOf(property.getValue()) : 10000;
        this.calcValues.put(UniLog.PROP_N_100_W, Double.valueOf(prop_n100W));
    }

    @Override
    public void run() {
        try {
            if (!this.serialPort.isConnected()) {
                this.serialPort.open();
                this.isPortOpenedByLiveGatherer = true;
                WaitTimer.delay((long)3000L);
            }
            byte[] readBuffer = this.serialPort.readConfiguration();
            if (this.dialog != null) {
                this.dialog.updateConfigurationValues(readBuffer);
                this.dialog.updateActualConfigTabItemAnalogModi(this.channel.getNumber());
            }
            int timeIntervalPosition = readBuffer[10] & 0xFF;
            this.timeStep_ms = this.time_ms[timeIntervalPosition];
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "timeIntervalPosition = " + timeIntervalPosition + " timeStep_ms = " + this.timeStep_ms);
            }
        }
        catch (SerialPortException e) {
            this.application.openMessageDialogAsync(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0015", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage()}));
            return;
        }
        catch (ApplicationConfigurationException e) {
            this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0010"));
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    UniLogLiveGatherer.this.application.getDeviceSelectionDialog().open();
                }
            });
            return;
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, t.getMessage(), t);
            this.application.openMessageDialogAsync(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0015", (Object[])new Object[]{t.getClass().getSimpleName() + " : " + t.getMessage()}));
            return;
        }
        this.channels.switchChannel(this.channel.getName());
        this.serialPort.isInterruptedByUser = false;
        int delay = 0;
        int period = this.timeStep_ms;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "timer period = " + period + " ms");
        }
        final String recordSetKey = this.channel.getNextRecordSetNumber() + this.device.getRecordSetStemNameReplacement();
        this.channel.put((Object)recordSetKey, (Object)RecordSet.createRecordSet((String)recordSetKey, (IDevice)this.device, (int)this.channelNumber, (boolean)true, (boolean)false, (boolean)true));
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, recordSetKey + " created for channel " + this.channel.getName());
        }
        final RecordSet recordSet = (RecordSet)this.channel.get((Object)recordSetKey);
        this.channel.applyTemplateBasics(recordSetKey);
        this.device.updateInitialRecordSetComment(recordSet);
        recordSet.setTimeStep_ms((double)this.timeStep_ms);
        final int[] points = new int[recordSet.size()];
        final UniLog usedDevice = this.device;
        try {
            this.serialPort.checkConnectionStatus();
            this.serialPort.wait4LiveData(100);
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            String message = Messages.getString((String)"GDE_MSGE0022", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}) + System.getProperty("line.separator") + Messages.getString((String)"GDE_MSGW1301");
            this.cleanup(recordSetKey, message);
        }
        if (!this.serialPort.isInterruptedByUser) {
            this.timer = new Timer();
            this.timerTask = new TimerTask(){
                long measurementCount = 0L;

                @Override
                public void run() {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "====> entry");
                    }
                    try {
                        if (UniLogLiveGatherer.this.isTimerRunning) {
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "recordSetKey = " + recordSetKey + " channelKonfigKey = " + recordSet.getChannelConfigName());
                            }
                            byte[] dataBuffer = UniLogLiveGatherer.this.serialPort.queryLiveData();
                            recordSet.addPoints(usedDevice.convertDataBytes(points, dataBuffer));
                            if (!UniLogLiveGatherer.this.isSwitchedRecordSet && UniLogLiveGatherer.this.channel.getName().equals(UniLogLiveGatherer.this.channels.getActiveChannel().getName())) {
                                UniLogLiveGatherer.this.device.updateMeasurementByAnalogModi(dataBuffer, recordSet.getChannelConfigNumber());
                                UniLogLiveGatherer.this.channel.applyTemplateBasics(recordSetKey);
                                UniLogLiveGatherer.this.application.getMenuToolBar().addRecordSetName(recordSetKey);
                                UniLogLiveGatherer.this.channels.getActiveChannel().switchRecordSet(recordSetKey);
                                UniLogLiveGatherer.this.isSwitchedRecordSet = true;
                            }
                            if (++this.measurementCount % 5L == 0L) {
                                UniLogLiveGatherer.this.device.updateVisibilityStatus(recordSet, true);
                            }
                            if (recordSet.isChildOfActiveChannel() && recordSet.equals((Object)UniLogLiveGatherer.this.channels.getActiveChannel().getActiveRecordSet())) {
                                UniLogLiveGatherer.this.application.updateAllTabs(false);
                            }
                        }
                    }
                    catch (DataInconsitsentException e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        String message = Messages.getString((String)"GDE_MSGE0028", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName(), e.getMessage()});
                        UniLogLiveGatherer.this.cleanup(recordSetKey, message);
                    }
                    catch (TimeOutException e) {
                        log.log(Level.WARNING, e.getMessage(), e);
                        try {
                            UniLogLiveGatherer.this.serialPort.checkDataReady();
                        }
                        catch (Exception e1) {
                            log.log(Level.SEVERE, e1.getMessage(), e1);
                            String message = Messages.getString((String)"GDE_MSGE0022", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName(), e.getMessage()}) + System.getProperty("line.separator") + Messages.getString((String)"GDE_MSGW1301");
                            UniLogLiveGatherer.this.cleanup(recordSetKey, message);
                        }
                    }
                    catch (IOException e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        String message = Messages.getString((String)"GDE_MSGE0022", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}) + System.getProperty("line.separator") + Messages.getString((String)"GDE_MSGW1301");
                        UniLogLiveGatherer.this.cleanup(recordSetKey, message);
                    }
                    catch (Throwable e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        String message = e.getClass().getSimpleName() + " - " + e.getMessage();
                        UniLogLiveGatherer.this.cleanup(recordSetKey, message);
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "======> exit");
                    }
                }
            };
            this.timer.scheduleAtFixedRate(this.timerTask, delay, (long)period);
            this.isTimerRunning = true;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "exit");
            }
        } else {
            this.cleanup(recordSetKey, null);
        }
    }

    public void finalizeRecordSet(String recordSetKey) {
        if (this.isPortOpenedByLiveGatherer) {
            this.serialPort.close();
        }
        RecordSet recordSet = (RecordSet)this.channel.get((Object)recordSetKey);
        this.device.updateVisibilityStatus(recordSet, false);
        this.device.makeInActiveDisplayable(recordSet);
        this.application.updateStatisticsData();
        this.application.updateDataTable(recordSetKey, false);
    }

    public void stopTimerThread() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
        }
        this.isTimerRunning = false;
    }

    void cleanup(String recordSetKey, String message) {
        boolean isErrorState = this.isTimerRunning;
        this.stopTimerThread();
        if (this.isPortOpenedByLiveGatherer) {
            this.serialPort.close();
        }
        ((RecordSet)this.channel.get((Object)recordSetKey)).clear();
        this.channel.remove(recordSetKey);
        this.application.getMenuToolBar().updateRecordSetSelectCombo();
        this.application.updateStatisticsData();
        this.application.updateDataTable(recordSetKey, true);
        this.device.getDialog().resetButtons();
        if (message != null && message.length() > 5 && isErrorState) {
            this.application.openMessageDialog(this.dialog.getDialogShell(), message);
        }
    }
}

