/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import java.util.Vector;

public class PackageLossDeque
extends Vector<Integer> {
    private static final long serialVersionUID = 1L;
    final int integrationInterval;
    int lossCounter;

    public PackageLossDeque(int integrationCount) {
        super(integrationCount);
        this.integrationInterval = integrationCount;
        this.lossCounter = 0;
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.lossCounter = 0;
    }

    @Override
    public synchronized boolean add(Integer value) {
        boolean ret = super.add(value);
        if (value == 0) {
            ++this.lossCounter;
        }
        if (this.size() > this.integrationInterval) {
            if ((Integer)this.get(0) == 0) {
                --this.lossCounter;
            }
            this.remove(0);
        }
        return ret;
    }

    public int getPercentage() {
        return (int)((double)this.lossCounter * 100.0 / (double)this.size());
    }
}

