/*
 * Decompiled with CFR 0.152.
 */
package gde.device.smmodellbau;

import gde.GDE;
import gde.device.DataTypes;
import gde.device.smmodellbau.UniLog2Dialog;
import gde.device.smmodellbau.UniLog2SetupReaderWriter;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.StringHelper;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class UniLog2SetupConfiguration2
extends Composite {
    static final Logger log = Logger.getLogger(UniLog2SetupConfiguration2.class.getName());
    final UniLog2Dialog dialog;
    final DataExplorer application;
    Composite fillerComposite;
    Group unilogTelemtryAlarmsGroup;
    CLabel addressLabel1UL;
    CLabel addressLabel2UL;
    CLabel addressLabel3UL;
    CLabel addressLabel4UL;
    Text addressText1UL;
    Text addressText2UL;
    Text addressText3UL;
    Text addressText4UL;
    Slider addressSlider1UL;
    Slider addressSlider2UL;
    Slider addressSlider3UL;
    Slider addressSlider4UL;
    Button currentButton;
    Button voltageStartButton;
    Button voltageButton;
    Button capacityButton;
    Button heightButton;
    Button voltageRxButton;
    Button cellVoltageButton;
    Button energyButton;
    Button rpmMinButton;
    Button rpmMaxButton;
    Button analogAlarm1Button;
    Button analogAlarm1DirectionButton;
    Button analogAlarm2Button;
    Button analogAlarm2DirectionButton;
    Button analogAlarm3Button;
    Button analogAlarm3DirectionButton;
    CCombo currentCombo;
    CCombo voltageStartCombo;
    CCombo voltageCombo;
    CCombo capacityCombo;
    CCombo heightCombo;
    CCombo voltageRxCombo;
    CCombo cellVoltageCombo;
    CCombo energyCombo;
    CCombo rpmMinCombo;
    CCombo rpmMaxCombo;
    CCombo analogAlarm1Combo;
    CCombo analogAlarm2Combo;
    CCombo analogAlarm3Combo;
    CLabel currentLabel;
    CLabel voltageStartLabel;
    CLabel voltageLabel;
    CLabel capacityLabel;
    CLabel heightLabel;
    CLabel voltageRxLabel;
    CLabel cellVoltageLabel;
    CLabel energyLabel;
    CLabel rpmMinLabel;
    CLabel rpmMaxLabel;
    CLabel analogAlarm1Label;
    CLabel analogAlarm2Label;
    CLabel analogAlarm3Label;
    CLabel a1Label;
    CLabel a2Label;
    CLabel a3Label;
    CLabel c1Label;
    CLabel c2Label;
    CLabel c3Label;
    CLabel c4Label;
    CLabel c5Label;
    CLabel c6Label;
    CCombo a1Combo;
    CCombo a2Combo;
    CCombo a3Combo;
    CCombo c1Combo;
    CCombo c2Combo;
    CCombo c3Combo;
    CCombo c4Combo;
    CCombo c5Combo;
    CCombo c6Combo;
    final int fillerWidth = 15;
    final int buttonWidth = 116;
    final int comboWidth = 84;
    Group jetiExGroup;
    static Group jetiExGroupStatic;
    Button measurement1;
    Button measurement2;
    Button measurement3;
    Button measurement4;
    Button measurement5;
    Button measurement6;
    Button measurement7;
    Button measurement8;
    Button measurement9;
    Button measurement10;
    Button measurement11;
    Button measurement12;
    Button measurement13;
    Button measurement14;
    Button measurement15;
    Button measurement16;
    Button measurement17;
    Button measurement18;
    Button measurement19;
    Button measurement20;
    CLabel jetiExSelectionLabel;
    Group mLinkAddressesGroup;
    static Group mLinkGroupStatic;
    CLabel addressVoltageLabel;
    CLabel addressCurrentLabel;
    CLabel addressRevolutionLabel;
    CLabel addressCapacityLabel;
    CLabel addressVarioLabel;
    CLabel addressHeightLabel;
    CLabel addressIntHeightLabel;
    CLabel addressEnergyLabel;
    CLabel addressRemainCapLabel;
    CLabel cellMinimumLabel;
    Text addressVoltageText;
    Text addressCurrentText;
    Text addressRevolutionText;
    Text addressCapacityText;
    Text addressVarioText;
    Text addressHeightText;
    Text addressHeightGainText;
    Text addressEnergyText;
    Text addressRemainCapText;
    Text cellMinimumText;
    Slider addressVoltageSlider;
    Slider addressCurrentSlider;
    Slider addressRevolutionSlider;
    Slider addressCapacitySlider;
    Slider addressVarioSlider;
    Slider addressHeightSlider;
    Slider addressHeightGainSlider;
    Slider addressEnergySlider;
    Slider addressRemainCapSlider;
    Slider cellMinimumSlider;
    Group spektrumAdapterGroup;
    static Group spektrumAdapterGroupStatic;
    CLabel spektrumAddressLabel;
    CCombo spektrumAddressCombo;
    final String[] spektrumAddresses = new String[]{" 0 ", " 1 ", " 2 ", " 3 ", " 4 ", " 5 ", " 6 ", " 7 ", " 8 ", " 9 "};
    Button spektrumEscSensor;
    Button spektrumCurrentSensor;
    Button spektrumVarioSensor;
    Button spektrumLiPoMonitor;
    final int labelWidth = 110;
    final int textWidth = 25;
    final int sliderWidth = 125;
    final int sliderMinimum = 0;
    final int sliderMaximum = 26;
    final int sliderIncrement = 1;
    final String[] sliderValues = new String[]{"  0", "  1", "  2", "  3", "  4", "  5", "  6", "  7", "  8", "  9", " 10", " 11", " 12", " 13", " 14", " 15", " - -"};
    final String[] currentValues = new String[]{"    1", "    5", "   10", "   15", "   20", "   30", "   40", "   50", "   60", "   70", "   80", "   90", "  100", "  150", "  200", "  250", "  300", "  350", "  400"};
    final String[] voltageStartValues = new String[]{"  3.0", "  3.2", "  3.3", "  3.4", "  3.5", "  4.0", "  4.5", "  5.0", "  5.5", "  6.0", "  6.4", "  6.5", "  6.6", "  6.7", "  6.8", "  7.0", "  7.5", "  8.0", "  8.5", "  9.0", "  9.5", "  9.6", "  9.7", "  9.8", " 10.0", " 10.5", " 11.0", " 11.5", " 12.0", " 12.2", " 12.3", " 12.4", " 12.5", " 13.0", " 13.5", " 14.0", " 14.5", " 15.0", " 15.5", " 15.6", " 15.7", " 15.8", " 15.9", " 16.0", " 16.5", " 17.0", " 17.5", " 18.0", " 18.5", " 19.0", " 19.5", " 20.0", " 20.3", " 20.3", " 20.4", " 20.5", " 20.6", " 20.7", " 21.0", " 21.5", " 22.0", " 23.0", " 24.0", " 24.5", " 24.6", " 24.7", " 24.8", " 25.0", " 30.0", " 40.0", " 50.0", " 60.0"};
    final String[] capacityValues = new String[]{"  250", "  500", "  750", " 1000", " 1250", " 1500", " 1750", " 2000", " 2250", " 2500", " 2750", " 3000", " 3250", " 3500", " 4000", " 5000", " 6000"};
    final String[] heightThresholds = new String[]{"   10", "   25", "   50", "   75", "  100", "  150", "  200", "  250", "  300", "  350", "  400", "  450", "  500", "  600", "  700", "  800", "  900", " 1000", " 1250", " 1500", " 2000", " 2500", " 3000", " 3500", " 4000"};
    final String[] voltageRxStartValues = new String[]{"  3.00", "  3.25", "  3.50", "  3.75", "  4.00", "  4.25", "  4.50", "  4.75", "  4.80", "  4.85", "  4.90", "  4.95", "  5.00", "  5.05", "  5.10", "  5.15", "  5.20", "  5.25", "  5.50", "  6.00", "  6.25", "  6.50", "  6.75", "  7.00", "  7.25", "  7.50", "  7.75", "  8.00"};
    final String[] cellVoltageStartValues = new String[350];
    final String[] analogAlarmStartValues = new String[3101];
    final String[] analogAlarmUnits = new String[]{"[\u00b0C]", "[mV]", "[km/h]", "[km/h]", "[\u00b0C]"};
    final UniLog2SetupReaderWriter configuration;
    final String[] jetiValueNames = Messages.getString((String)"GDE_MSGT2589").split(",");
    final String[] energyValues = new String[291];
    final String[] rpmMinValues = new String[2000];
    final String[] rpmMaxValues = new String[2000];

    public UniLog2SetupConfiguration2(Composite parent, int style, UniLog2Dialog useDialog, UniLog2SetupReaderWriter useConfiguration) {
        super(parent, style);
        int i;
        SWTResourceManager.registerResourceUser((Widget)this);
        this.dialog = useDialog;
        this.configuration = useConfiguration;
        this.application = DataExplorer.getInstance();
        int value = 100;
        for (i = 0; i < 350; ++i) {
            this.cellVoltageStartValues[i] = String.format("    %.2f", (double)(++value) / 100.0);
        }
        value = -100;
        for (i = 0; i < 3101; ++i) {
            this.analogAlarmStartValues[i] = String.format("  %4d", value++);
        }
        value = 900;
        for (i = 0; i < this.energyValues.length; ++i) {
            this.energyValues[i] = String.format(" %5d", value += 100);
        }
        value = 0;
        for (i = 0; i < 2000; ++i) {
            this.rpmMinValues[i] = String.format(" %5d", value += 100);
        }
        value = 0;
        for (i = 0; i < 2000; ++i) {
            this.rpmMaxValues[i] = String.format(" %5d", value += 100);
        }
        this.initGUI();
    }

    public void updateValues() {
        this.currentButton.setSelection((this.configuration.telemetryAlarms & 1) > 0);
        this.currentCombo.setText(String.format(Locale.ENGLISH, " %5d", this.configuration.currentAlarm));
        this.voltageStartButton.setSelection((this.configuration.telemetryAlarms & 2) > 0);
        this.voltageStartCombo.setText(String.format(Locale.ENGLISH, " %5.1f", (double)this.configuration.voltageStartAlarm / 10.0));
        this.voltageButton.setSelection((this.configuration.telemetryAlarms & 4) > 0);
        this.voltageCombo.setText(String.format(Locale.ENGLISH, " %5.1f", (double)this.configuration.voltageAlarm / 10.0));
        this.capacityButton.setSelection((this.configuration.telemetryAlarms & 8) > 0);
        this.capacityCombo.setText(String.format(Locale.ENGLISH, " %5d", this.configuration.capacityAlarm));
        this.energyButton.setSelection((this.configuration.telemetryAlarms & 0x1000) > 0);
        this.energyCombo.setText(String.format(Locale.ENGLISH, " %5d", this.configuration.energyAlarm));
        this.heightButton.setSelection((this.configuration.telemetryAlarms & 0x10) > 0);
        this.heightCombo.setText(String.format(Locale.ENGLISH, " %5d", this.configuration.heightAlarm));
        this.voltageRxButton.setSelection((this.configuration.telemetryAlarms & 0x20) > 0);
        this.voltageRxCombo.setText(String.format(Locale.ENGLISH, "  %5.2f", (double)this.configuration.voltageRxAlarm / 100.0));
        this.cellVoltageButton.setSelection((this.configuration.telemetryAlarms & 0x40) > 0);
        this.cellVoltageCombo.setText(String.format(Locale.ENGLISH, "  %5.2f", (double)this.configuration.cellVoltageAlarm / 100.0));
        this.rpmMinButton.setSelection((this.configuration.telemetryAlarms & 0x2000) > 0);
        this.rpmMinCombo.setText(String.format(Locale.ENGLISH, "  %5d", this.configuration.rpmMinAlarm * 100));
        this.rpmMaxButton.setSelection((this.configuration.telemetryAlarms & 0x4000) > 0);
        this.rpmMaxCombo.setText(String.format(Locale.ENGLISH, "  %5d", this.configuration.rpmMaxAlarm * 100));
        this.analogAlarm1Button.setSelection((this.configuration.telemetryAlarms & 0x80) > 0);
        this.analogAlarm1DirectionButton.setSelection(this.configuration.analogAlarm1Direct == 1);
        this.analogAlarm1Combo.select(this.configuration.analogAlarm1 + 100);
        this.analogAlarm1Label.setText(this.analogAlarmUnits[this.configuration.modusA1]);
        this.analogAlarm2Button.setSelection((this.configuration.telemetryAlarms & 0x100) > 0);
        this.analogAlarm2DirectionButton.setSelection(this.configuration.analogAlarm2Direct == 1);
        this.analogAlarm2Combo.select(this.configuration.analogAlarm2 + 100);
        this.analogAlarm2Label.setText(this.analogAlarmUnits[this.configuration.modusA2]);
        this.analogAlarm3Button.setSelection((this.configuration.telemetryAlarms & 0x200) > 0);
        this.analogAlarm3DirectionButton.setSelection(this.configuration.analogAlarm3Direct == 1);
        this.analogAlarm3Combo.select(this.configuration.analogAlarm3 + 100);
        this.analogAlarm3Label.setText(this.analogAlarmUnits[this.configuration.modusA3]);
        this.addressVoltageSlider.setSelection((int)this.configuration.mLinkAddressVoltage);
        this.addressVoltageText.setText(this.sliderValues[this.configuration.mLinkAddressVoltage]);
        this.addressCurrentSlider.setSelection((int)this.configuration.mLinkAddressCurrent);
        this.addressCurrentText.setText(this.sliderValues[this.configuration.mLinkAddressCurrent]);
        this.addressRevolutionSlider.setSelection((int)this.configuration.mLinkAddressRevolution);
        this.addressRevolutionText.setText(this.sliderValues[this.configuration.mLinkAddressRevolution]);
        this.addressCapacitySlider.setSelection((int)this.configuration.mLinkAddressCapacity);
        this.addressCapacityText.setText(this.sliderValues[this.configuration.mLinkAddressCapacity]);
        this.addressVarioSlider.setSelection((int)this.configuration.mLinkAddressVario);
        this.addressVarioText.setText(this.sliderValues[this.configuration.mLinkAddressVario]);
        this.addressHeightText.setText(this.sliderValues[this.configuration.mLinkAddressHeight]);
        this.addressHeightSlider.setSelection((int)this.configuration.mLinkAddressHeight);
        this.addressHeightGainText.setText(this.sliderValues[this.configuration.mLinkAddressHeightGain]);
        this.addressHeightGainSlider.setSelection((int)this.configuration.mLinkAddressHeightGain);
        this.addressEnergyText.setText(this.sliderValues[this.configuration.mLinkAddressEnergy]);
        this.addressEnergySlider.setSelection((int)this.configuration.mLinkAddressEnergy);
        this.addressRemainCapText.setText(this.sliderValues[this.configuration.mLinkAddressRemainCap]);
        this.addressRemainCapSlider.setSelection((int)this.configuration.mLinkAddressRemainCap);
        this.cellMinimumSlider.setSelection((int)this.configuration.mLinkAddressCellMinimum);
        this.cellMinimumText.setText(this.sliderValues[this.configuration.mLinkAddressCellMinimum]);
        this.a1Combo.select((int)this.configuration.mLinkAddressA1);
        this.a2Combo.select((int)this.configuration.mLinkAddressA2);
        this.a3Combo.select((int)this.configuration.mLinkAddressA3);
        this.c1Combo.select((int)this.configuration.mLinkAddressCell1);
        this.c2Combo.select((int)this.configuration.mLinkAddressCell2);
        this.c3Combo.select((int)this.configuration.mLinkAddressCell3);
        this.c4Combo.select((int)this.configuration.mLinkAddressCell4);
        this.c5Combo.select((int)this.configuration.mLinkAddressCell5);
        this.c6Combo.select((int)this.configuration.mLinkAddressCell6);
        this.measurement1.setSelection((this.configuration.jetiValueVisibility & 2) == 0);
        this.measurement2.setSelection((this.configuration.jetiValueVisibility & 4) == 0);
        this.measurement3.setSelection((this.configuration.jetiValueVisibility & 8) == 0);
        this.measurement4.setSelection((this.configuration.jetiValueVisibility & 0x10) == 0);
        this.measurement5.setSelection((this.configuration.jetiValueVisibility & 0x20) == 0);
        this.measurement6.setSelection((this.configuration.jetiValueVisibility & 0x40) == 0);
        this.measurement7.setSelection((this.configuration.jetiValueVisibility & 0x80) == 0);
        this.measurement8.setSelection((this.configuration.jetiValueVisibility & 0x100) == 0);
        this.measurement9.setSelection((this.configuration.jetiValueVisibility & 0x200) == 0);
        this.measurement10.setSelection((this.configuration.jetiValueVisibility & 0x400) == 0);
        this.measurement11.setSelection((this.configuration.jetiValueVisibility & 0x800) == 0);
        this.measurement12.setSelection((this.configuration.jetiValueVisibility & 0x1000) == 0);
        this.measurement13.setSelection((this.configuration.jetiValueVisibility & 0x2000) == 0);
        this.measurement14.setSelection((this.configuration.jetiValueVisibility & 0x4000) == 0);
        this.measurement15.setSelection((this.configuration.jetiValueVisibility & 0x8000) == 0);
        this.measurement16.setSelection((this.configuration.jetiValueVisibility & 0x10000) == 0);
        this.measurement17.setSelection((this.configuration.jetiValueVisibility & 0x20000) == 0);
        this.measurement18.setSelection((this.configuration.jetiValueVisibility & 0x40000) == 0);
        this.measurement19.setSelection((this.configuration.jetiValueVisibility & 0x80000) == 0);
        this.measurement20.setSelection((this.configuration.jetiValueVisibility & 0x100000) == 0);
        this.jetiExSelectionLabel.setText(Messages.getString((String)"GDE_MSGT2590", (Object[])new Object[]{this.configuration.getJetiMeasurementCount()}));
        this.spektrumAddressCombo.select((int)this.configuration.spektrumNumber);
        this.spektrumEscSensor.setSelection((this.configuration.spektrumSensors & 1) == 0);
        this.spektrumCurrentSensor.setSelection((this.configuration.spektrumSensors & 2) == 0);
        this.spektrumVarioSensor.setSelection((this.configuration.spektrumSensors & 4) == 0);
        this.spektrumLiPoMonitor.setSelection((this.configuration.spektrumSensors & 8) == 0);
    }

    public void updateAnalogAlarmUnits() {
        this.analogAlarm1Label.setText(this.analogAlarmUnits[this.configuration.modusA1]);
        this.analogAlarm2Label.setText(this.analogAlarmUnits[this.configuration.modusA2]);
        this.analogAlarm3Label.setText(this.analogAlarmUnits[this.configuration.modusA3]);
    }

    void initGUI() {
        try {
            this.setLayout((Layout)new FormLayout());
            this.addHelpListener(new HelpListener(){

                public void helpRequested(HelpEvent evt) {
                    log.log(Level.FINEST, "GPSLoggerSetupConfiguration2.helpRequested, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.application.openHelpDialog(Messages.getString((String)"GDE_MSGT2510"), "HelpInfo.html#configuration");
                }
            });
            this.unilogTelemtryAlarmsGroup = new Group((Composite)this, 0);
            RowLayout unilogTelemtryAlarmsGroupLayout = new RowLayout(256);
            this.unilogTelemtryAlarmsGroup.setLayout((Layout)unilogTelemtryAlarmsGroupLayout);
            FormData unilogTelemtryAlarmsGroupLData = new FormData();
            unilogTelemtryAlarmsGroupLData.top = new FormAttachment(0, 1000, 5);
            unilogTelemtryAlarmsGroupLData.left = new FormAttachment(0, 1000, 12);
            unilogTelemtryAlarmsGroupLData.width = 290;
            unilogTelemtryAlarmsGroupLData.height = 315;
            this.unilogTelemtryAlarmsGroup.setLayoutData((Object)unilogTelemtryAlarmsGroupLData);
            this.unilogTelemtryAlarmsGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.unilogTelemtryAlarmsGroup.setText(Messages.getString((String)"GDE_MSGT2565"));
            this.fillerComposite = new Composite((Composite)this.unilogTelemtryAlarmsGroup, 0);
            RowData fillerCompositeRA1LData = new RowData();
            fillerCompositeRA1LData.width = this.fillerWidth;
            fillerCompositeRA1LData.height = 20;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRA1LData);
            this.currentButton = new Button((Composite)this.unilogTelemtryAlarmsGroup, 16416);
            RowData currentButtonLData = new RowData();
            currentButtonLData.width = this.buttonWidth;
            currentButtonLData.height = 19;
            this.currentButton.setLayoutData((Object)currentButtonLData);
            this.currentButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.currentButton.setText(Messages.getString((String)"GDE_MSGT2566"));
            this.currentButton.setSelection((this.configuration.telemetryAlarms & 1) > 0);
            this.currentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "currentButton.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.telemetryAlarms = UniLog2SetupConfiguration2.this.currentButton.getSelection() ? (short)(UniLog2SetupConfiguration2.this.configuration.telemetryAlarms | 1) : (short)(UniLog2SetupConfiguration2.this.configuration.telemetryAlarms ^ 1);
                    UniLog2SetupConfiguration2.this.currentButton.setSelection((UniLog2SetupConfiguration2.this.configuration.telemetryAlarms & 1) > 0);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            RowData currentCComboLData = new RowData();
            currentCComboLData.width = this.comboWidth;
            currentCComboLData.height = 17;
            this.currentCombo = new CCombo((Composite)this.unilogTelemtryAlarmsGroup, 2048);
            this.currentCombo.setLayoutData((Object)currentCComboLData);
            this.currentCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.currentCombo.setItems(this.currentValues);
            this.currentCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.currentCombo.setText(String.format(Locale.ENGLISH, "%5d", this.configuration.currentAlarm));
            this.currentCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "currentCombo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.currentAlarm = (short)Integer.parseInt(UniLog2SetupConfiguration2.this.currentCombo.getText().trim());
                    UniLog2SetupConfiguration2.this.configuration.currentAlarm = UniLog2SetupConfiguration2.this.configuration.currentAlarm < 1 ? 1 : (UniLog2SetupConfiguration2.this.configuration.currentAlarm > 400 ? 400 : (int)UniLog2SetupConfiguration2.this.configuration.currentAlarm);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.currentCombo.addVerifyListener(new VerifyListener(this){

                public void verifyText(VerifyEvent verifyevent) {
                    log.log(Level.FINEST, "currentCombo.verify, event=" + String.valueOf(verifyevent));
                    verifyevent.doit = StringHelper.verifyTypedInput((DataTypes)DataTypes.INTEGER, (String)verifyevent.text);
                }
            });
            this.currentCombo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent keyevent) {
                    log.log(Level.FINEST, "currentCombo.keyReleased, event=" + String.valueOf(keyevent));
                    try {
                        UniLog2SetupConfiguration2.this.configuration.currentAlarm = (short)Integer.parseInt(UniLog2SetupConfiguration2.this.currentCombo.getText().trim());
                        UniLog2SetupConfiguration2.this.configuration.currentAlarm = UniLog2SetupConfiguration2.this.configuration.currentAlarm < 1 ? 1 : (UniLog2SetupConfiguration2.this.configuration.currentAlarm > 400 ? 400 : (int)UniLog2SetupConfiguration2.this.configuration.currentAlarm);
                        UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            this.currentLabel = new CLabel((Composite)this.unilogTelemtryAlarmsGroup, 0x1000000);
            RowData currentLabelLData = new RowData();
            currentLabelLData.width = 50;
            currentLabelLData.height = 19;
            this.currentLabel.setLayoutData((Object)currentLabelLData);
            this.currentLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.currentLabel.setText(Messages.getString((String)"GDE_MSGT2551"));
            this.fillerComposite = new Composite((Composite)this.unilogTelemtryAlarmsGroup, 0);
            fillerCompositeRA1LData = new RowData();
            fillerCompositeRA1LData.width = this.fillerWidth;
            fillerCompositeRA1LData.height = 20;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRA1LData);
            this.voltageStartButton = new Button((Composite)this.unilogTelemtryAlarmsGroup, 16416);
            RowData voltageStartButtonLData = new RowData();
            voltageStartButtonLData.width = this.buttonWidth;
            voltageStartButtonLData.height = 19;
            this.voltageStartButton.setLayoutData((Object)voltageStartButtonLData);
            this.voltageStartButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.voltageStartButton.setText(Messages.getString((String)"GDE_MSGT2552"));
            this.voltageStartButton.setSelection((this.configuration.telemetryAlarms & 2) > 0);
            this.voltageStartButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "voltageStartButton.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.telemetryAlarms = UniLog2SetupConfiguration2.this.voltageStartButton.getSelection() ? (short)(UniLog2SetupConfiguration2.this.configuration.telemetryAlarms | 2) : (short)(UniLog2SetupConfiguration2.this.configuration.telemetryAlarms ^ 2);
                    UniLog2SetupConfiguration2.this.voltageStartButton.setSelection((UniLog2SetupConfiguration2.this.configuration.telemetryAlarms & 2) > 0);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            RowData voltageStartCComboLData = new RowData();
            voltageStartCComboLData.width = this.comboWidth;
            voltageStartCComboLData.height = 17;
            this.voltageStartCombo = new CCombo((Composite)this.unilogTelemtryAlarmsGroup, 2048);
            this.voltageStartCombo.setLayoutData((Object)voltageStartCComboLData);
            this.voltageStartCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.voltageStartCombo.setItems(this.voltageStartValues);
            this.voltageStartCombo.setText(String.format(Locale.ENGLISH, "%5.1f", (double)this.configuration.voltageStartAlarm / 10.0));
            this.voltageStartCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "voltageStartCombo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.voltageStartAlarm = (short)(Double.parseDouble(UniLog2SetupConfiguration2.this.voltageStartCombo.getText().trim().replace(',', '.')) * 10.0);
                    UniLog2SetupConfiguration2.this.configuration.voltageStartAlarm = (short)(UniLog2SetupConfiguration2.this.configuration.voltageStartAlarm < 10 ? 10 : (UniLog2SetupConfiguration2.this.configuration.voltageStartAlarm > 600 ? 600 : (int)UniLog2SetupConfiguration2.this.configuration.voltageStartAlarm));
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.voltageStartCombo.addVerifyListener(new VerifyListener(this){

                public void verifyText(VerifyEvent verifyevent) {
                    log.log(Level.FINEST, "voltageStartCombo.verify, event=" + String.valueOf(verifyevent));
                    verifyevent.doit = StringHelper.verifyTypedInput((DataTypes)DataTypes.DOUBLE, (String)verifyevent.text);
                }
            });
            this.voltageStartCombo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent keyevent) {
                    log.log(Level.FINEST, "voltageStartCombo.keyReleased, event=" + String.valueOf(keyevent));
                    try {
                        UniLog2SetupConfiguration2.this.configuration.voltageStartAlarm = (short)(Double.parseDouble(UniLog2SetupConfiguration2.this.voltageStartCombo.getText().trim().replace(',', '.')) * 10.0);
                        UniLog2SetupConfiguration2.this.configuration.voltageStartAlarm = (short)(UniLog2SetupConfiguration2.this.configuration.voltageStartAlarm < 10 ? 10 : (UniLog2SetupConfiguration2.this.configuration.voltageStartAlarm > 600 ? 600 : (int)UniLog2SetupConfiguration2.this.configuration.voltageStartAlarm));
                        UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            this.voltageStartLabel = new CLabel((Composite)this.unilogTelemtryAlarmsGroup, 0x1000000);
            RowData voltageStartLabelLData = new RowData();
            voltageStartLabelLData.width = 50;
            voltageStartLabelLData.height = 19;
            this.voltageStartLabel.setLayoutData((Object)voltageStartLabelLData);
            this.voltageStartLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.voltageStartLabel.setText(Messages.getString((String)"GDE_MSGT2553"));
            this.fillerComposite = new Composite((Composite)this.unilogTelemtryAlarmsGroup, 0);
            fillerCompositeRA1LData = new RowData();
            fillerCompositeRA1LData.width = this.fillerWidth;
            fillerCompositeRA1LData.height = 20;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRA1LData);
            this.voltageButton = new Button((Composite)this.unilogTelemtryAlarmsGroup, 16416);
            RowData voltageButtonLData = new RowData();
            voltageButtonLData.width = this.buttonWidth;
            voltageButtonLData.height = 19;
            this.voltageButton.setLayoutData((Object)voltageButtonLData);
            this.voltageButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.voltageButton.setText(Messages.getString((String)"GDE_MSGT2554"));
            this.voltageButton.setSelection((this.configuration.telemetryAlarms & 4) > 0);
            this.voltageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "voltageButton.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.telemetryAlarms = UniLog2SetupConfiguration2.this.voltageButton.getSelection() ? (short)(UniLog2SetupConfiguration2.this.configuration.telemetryAlarms | 4) : (short)(UniLog2SetupConfiguration2.this.configuration.telemetryAlarms ^ 4);
                    UniLog2SetupConfiguration2.this.voltageButton.setSelection((UniLog2SetupConfiguration2.this.configuration.telemetryAlarms & 4) > 0);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            RowData voltageCComboLData = new RowData();
            voltageCComboLData.width = this.comboWidth;
            voltageCComboLData.height = 17;
            this.voltageCombo = new CCombo((Composite)this.unilogTelemtryAlarmsGroup, 2048);
            this.voltageCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.voltageCombo.setLayoutData((Object)voltageCComboLData);
            this.voltageCombo.setItems(this.voltageStartValues);
            this.voltageCombo.setText(String.format(Locale.ENGLISH, "%5.1f", (double)this.configuration.voltageAlarm / 10.0));
            this.voltageCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "voltageCombo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.voltageAlarm = (short)(Double.parseDouble(UniLog2SetupConfiguration2.this.voltageCombo.getText().trim().replace(',', '.')) * 10.0);
                    UniLog2SetupConfiguration2.this.configuration.voltageAlarm = (short)(UniLog2SetupConfiguration2.this.configuration.voltageAlarm < 10 ? 10 : (UniLog2SetupConfiguration2.this.configuration.voltageAlarm > 600 ? 600 : (int)UniLog2SetupConfiguration2.this.configuration.voltageAlarm));
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.voltageCombo.addVerifyListener(new VerifyListener(this){

                public void verifyText(VerifyEvent verifyevent) {
                    log.log(Level.FINEST, "voltageCombo.verify, event=" + String.valueOf(verifyevent));
                    verifyevent.doit = StringHelper.verifyTypedInput((DataTypes)DataTypes.DOUBLE, (String)verifyevent.text);
                }
            });
            this.voltageCombo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent keyevent) {
                    log.log(Level.FINEST, "voltageCombo.keyReleased, event=" + String.valueOf(keyevent));
                    try {
                        UniLog2SetupConfiguration2.this.configuration.voltageAlarm = (short)(Double.parseDouble(UniLog2SetupConfiguration2.this.voltageCombo.getText().trim().replace(',', '.')) * 10.0);
                        UniLog2SetupConfiguration2.this.configuration.voltageAlarm = (short)(UniLog2SetupConfiguration2.this.configuration.voltageAlarm < 10 ? 10 : (UniLog2SetupConfiguration2.this.configuration.voltageAlarm > 600 ? 600 : (int)UniLog2SetupConfiguration2.this.configuration.voltageAlarm));
                        UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            RowData voltageLabelLData = new RowData();
            voltageLabelLData.width = 50;
            voltageLabelLData.height = 19;
            this.voltageLabel = new CLabel((Composite)this.unilogTelemtryAlarmsGroup, 0x1000000);
            this.voltageLabel.setLayoutData((Object)voltageLabelLData);
            this.voltageLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.voltageLabel.setText(Messages.getString((String)"GDE_MSGT2555"));
            this.fillerComposite = new Composite((Composite)this.unilogTelemtryAlarmsGroup, 0);
            fillerCompositeRA1LData = new RowData();
            fillerCompositeRA1LData.width = this.fillerWidth;
            fillerCompositeRA1LData.height = 20;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRA1LData);
            this.capacityButton = new Button((Composite)this.unilogTelemtryAlarmsGroup, 16416);
            RowData voltageRxULButtonLData = new RowData();
            voltageRxULButtonLData.width = this.buttonWidth;
            voltageRxULButtonLData.height = 19;
            this.capacityButton.setLayoutData((Object)voltageRxULButtonLData);
            this.capacityButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.capacityButton.setText(Messages.getString((String)"GDE_MSGT2556"));
            this.capacityButton.setSelection((this.configuration.telemetryAlarms & 8) > 0);
            this.capacityButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "voltageRxButton.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.telemetryAlarms = UniLog2SetupConfiguration2.this.capacityButton.getSelection() ? (short)(UniLog2SetupConfiguration2.this.configuration.telemetryAlarms | 8) : (short)(UniLog2SetupConfiguration2.this.configuration.telemetryAlarms ^ 8);
                    UniLog2SetupConfiguration2.this.capacityButton.setSelection((UniLog2SetupConfiguration2.this.configuration.telemetryAlarms & 8) > 0);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.capacityCombo = new CCombo((Composite)this.unilogTelemtryAlarmsGroup, 2048);
            this.capacityCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            RowData capacityComboLData = new RowData();
            capacityComboLData.width = this.comboWidth;
            capacityComboLData.height = 17;
            this.capacityCombo.setLayoutData((Object)capacityComboLData);
            this.capacityCombo.setItems(this.capacityValues);
            this.capacityCombo.setText(String.format(Locale.ENGLISH, "%5d", this.configuration.capacityAlarm));
            this.capacityCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "capacityCombo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.capacityAlarm = (short)Integer.parseInt(UniLog2SetupConfiguration2.this.capacityCombo.getText().trim());
                    UniLog2SetupConfiguration2.this.configuration.capacityAlarm = (short)(UniLog2SetupConfiguration2.this.configuration.capacityAlarm < 100 ? 100 : (UniLog2SetupConfiguration2.this.configuration.capacityAlarm > 30000 ? 30000 : (int)UniLog2SetupConfiguration2.this.configuration.capacityAlarm));
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.capacityCombo.addVerifyListener(new VerifyListener(this){

                public void verifyText(VerifyEvent verifyevent) {
                    log.log(Level.FINEST, "capacityCombo.verify, event=" + String.valueOf(verifyevent));
                    verifyevent.doit = StringHelper.verifyTypedInput((DataTypes)DataTypes.INTEGER, (String)verifyevent.text);
                }
            });
            this.capacityCombo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent keyevent) {
                    log.log(Level.FINEST, "capacityCombo.keyReleased, event=" + String.valueOf(keyevent));
                    try {
                        UniLog2SetupConfiguration2.this.configuration.capacityAlarm = (short)Integer.parseInt(UniLog2SetupConfiguration2.this.capacityCombo.getText().trim());
                        UniLog2SetupConfiguration2.this.configuration.capacityAlarm = (short)(UniLog2SetupConfiguration2.this.configuration.capacityAlarm < 100 ? 100 : (UniLog2SetupConfiguration2.this.configuration.capacityAlarm > 30000 ? 30000 : (int)UniLog2SetupConfiguration2.this.configuration.capacityAlarm));
                        UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            this.capacityLabel = new CLabel((Composite)this.unilogTelemtryAlarmsGroup, 0x1000000);
            RowData voltageRxULLabelLData = new RowData();
            voltageRxULLabelLData.width = 50;
            voltageRxULLabelLData.height = 19;
            this.capacityLabel.setLayoutData((Object)voltageRxULLabelLData);
            this.capacityLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.capacityLabel.setText(Messages.getString((String)"GDE_MSGT2557"));
            this.fillerComposite = new Composite((Composite)this.unilogTelemtryAlarmsGroup, 0);
            fillerCompositeRA1LData = new RowData();
            fillerCompositeRA1LData.width = this.fillerWidth;
            fillerCompositeRA1LData.height = 20;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRA1LData);
            this.energyButton = new Button((Composite)this.unilogTelemtryAlarmsGroup, 16416);
            RowData energyButtonLData = new RowData();
            energyButtonLData.width = this.buttonWidth;
            energyButtonLData.height = 19;
            this.energyButton.setLayoutData((Object)energyButtonLData);
            this.energyButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.energyButton.setText(Messages.getString((String)"GDE_MSGT2547").split(" ")[0]);
            this.energyButton.setSelection((this.configuration.telemetryAlarms & 4) > 0);
            this.energyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "energyButton.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.telemetryAlarms = UniLog2SetupConfiguration2.this.energyButton.getSelection() ? (short)(UniLog2SetupConfiguration2.this.configuration.telemetryAlarms | 0x1000) : (short)(UniLog2SetupConfiguration2.this.configuration.telemetryAlarms ^ 0x1000);
                    UniLog2SetupConfiguration2.this.energyButton.setSelection((UniLog2SetupConfiguration2.this.configuration.telemetryAlarms & 0x1000) > 0);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            RowData energyCComboLData = new RowData();
            energyCComboLData.width = this.comboWidth;
            energyCComboLData.height = 17;
            this.energyCombo = new CCombo((Composite)this.unilogTelemtryAlarmsGroup, 2048);
            this.energyCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.energyCombo.setLayoutData((Object)energyCComboLData);
            this.energyCombo.setItems(this.energyValues);
            this.energyCombo.setText(String.format(Locale.ENGLISH, "%5.1f", (double)this.configuration.energyAlarm / 10.0));
            this.energyCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "energyCombo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.energyAlarm = (short)Integer.parseInt(UniLog2SetupConfiguration2.this.energyCombo.getText().trim());
                    UniLog2SetupConfiguration2.this.configuration.energyAlarm = (short)(UniLog2SetupConfiguration2.this.configuration.energyAlarm < 100 ? 100 : (UniLog2SetupConfiguration2.this.configuration.energyAlarm > 30000 ? 30000 : (int)UniLog2SetupConfiguration2.this.configuration.energyAlarm));
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.energyCombo.addVerifyListener(new VerifyListener(this){

                public void verifyText(VerifyEvent verifyevent) {
                    log.log(Level.FINEST, "energyCombo.verify, event=" + String.valueOf(verifyevent));
                    verifyevent.doit = StringHelper.verifyTypedInput((DataTypes)DataTypes.INTEGER, (String)verifyevent.text);
                }
            });
            this.energyCombo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent keyevent) {
                    log.log(Level.FINEST, "energyCombo.keyReleased, event=" + String.valueOf(keyevent));
                    try {
                        UniLog2SetupConfiguration2.this.configuration.energyAlarm = (short)Integer.parseInt(UniLog2SetupConfiguration2.this.energyCombo.getText().trim());
                        UniLog2SetupConfiguration2.this.configuration.energyAlarm = (short)(UniLog2SetupConfiguration2.this.configuration.energyAlarm < 100 ? 100 : (UniLog2SetupConfiguration2.this.configuration.energyAlarm > 30000 ? 30000 : (int)UniLog2SetupConfiguration2.this.configuration.energyAlarm));
                        UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            RowData energyLabelLData = new RowData();
            energyLabelLData.width = 50;
            energyLabelLData.height = 19;
            this.energyLabel = new CLabel((Composite)this.unilogTelemtryAlarmsGroup, 0x1000000);
            this.energyLabel.setLayoutData((Object)energyLabelLData);
            this.energyLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.energyLabel.setText(Messages.getString((String)"GDE_MSGT2547").split(" ")[2]);
            this.fillerComposite = new Composite((Composite)this.unilogTelemtryAlarmsGroup, 0);
            fillerCompositeRA1LData = new RowData();
            fillerCompositeRA1LData.width = this.fillerWidth;
            fillerCompositeRA1LData.height = 20;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRA1LData);
            this.heightButton = new Button((Composite)this.unilogTelemtryAlarmsGroup, 16416);
            RowData heightButtonLData = new RowData();
            heightButtonLData.width = this.buttonWidth;
            heightButtonLData.height = 19;
            this.heightButton.setLayoutData((Object)heightButtonLData);
            this.heightButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.heightButton.setText(Messages.getString((String)"GDE_MSGT2567"));
            this.heightButton.setSelection((this.configuration.telemetryAlarms & 4) > 0);
            this.heightButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "heightButton.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.telemetryAlarms = UniLog2SetupConfiguration2.this.heightButton.getSelection() ? (short)(UniLog2SetupConfiguration2.this.configuration.telemetryAlarms | 4) : (short)(UniLog2SetupConfiguration2.this.configuration.telemetryAlarms ^ 4);
                    UniLog2SetupConfiguration2.this.heightButton.setSelection((UniLog2SetupConfiguration2.this.configuration.telemetryAlarms & 4) > 0);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            RowData heightCComboLData = new RowData();
            heightCComboLData.width = this.comboWidth;
            heightCComboLData.height = 17;
            this.heightCombo = new CCombo((Composite)this.unilogTelemtryAlarmsGroup, 2048);
            this.heightCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.heightCombo.setLayoutData((Object)heightCComboLData);
            this.heightCombo.setItems(this.heightThresholds);
            this.heightCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "heightCombo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.heightAlarm = (short)Double.parseDouble(UniLog2SetupConfiguration2.this.heightCombo.getText().trim().replace(',', '.'));
                    UniLog2SetupConfiguration2.this.configuration.heightAlarm = (short)(UniLog2SetupConfiguration2.this.configuration.heightAlarm < 10 ? 10 : (UniLog2SetupConfiguration2.this.configuration.heightAlarm > 600 ? 600 : (int)UniLog2SetupConfiguration2.this.configuration.heightAlarm));
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.heightCombo.addVerifyListener(new VerifyListener(this){

                public void verifyText(VerifyEvent verifyevent) {
                    log.log(Level.FINEST, "heightCombo.verify, event=" + String.valueOf(verifyevent));
                    verifyevent.doit = StringHelper.verifyTypedInput((DataTypes)DataTypes.DOUBLE, (String)verifyevent.text);
                }
            });
            this.heightCombo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent keyevent) {
                    log.log(Level.FINEST, "heightCombo.keyReleased, event=" + String.valueOf(keyevent));
                    try {
                        UniLog2SetupConfiguration2.this.configuration.heightAlarm = (short)(Double.parseDouble(UniLog2SetupConfiguration2.this.heightCombo.getText().trim().replace(',', '.')) * 10.0);
                        UniLog2SetupConfiguration2.this.configuration.heightAlarm = (short)(UniLog2SetupConfiguration2.this.configuration.heightAlarm < 10 ? 10 : (UniLog2SetupConfiguration2.this.configuration.heightAlarm > 600 ? 600 : (int)UniLog2SetupConfiguration2.this.configuration.heightAlarm));
                        UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            this.heightLabel = new CLabel((Composite)this.unilogTelemtryAlarmsGroup, 0x1000000);
            RowData heightLabelLData = new RowData();
            heightLabelLData.width = 50;
            heightLabelLData.height = 19;
            this.heightLabel.setLayoutData((Object)heightLabelLData);
            this.heightLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.heightLabel.setText(Messages.getString((String)"GDE_MSGT2555"));
            this.fillerComposite = new Composite((Composite)this.unilogTelemtryAlarmsGroup, 0);
            fillerCompositeRA1LData = new RowData();
            fillerCompositeRA1LData.width = this.fillerWidth;
            fillerCompositeRA1LData.height = 20;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRA1LData);
            this.voltageRxButton = new Button((Composite)this.unilogTelemtryAlarmsGroup, 16416);
            RowData voltageRxButtonLData = new RowData();
            voltageRxButtonLData.width = this.buttonWidth;
            voltageRxButtonLData.height = 19;
            this.voltageRxButton.setLayoutData((Object)voltageRxButtonLData);
            this.voltageRxButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.voltageRxButton.setText(Messages.getString((String)"GDE_MSGT2568"));
            this.voltageRxButton.setSelection((this.configuration.telemetryAlarms & 4) > 0);
            this.voltageRxButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "voltageRxButton.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.telemetryAlarms = UniLog2SetupConfiguration2.this.voltageRxButton.getSelection() ? (short)(UniLog2SetupConfiguration2.this.configuration.telemetryAlarms | 4) : (short)(UniLog2SetupConfiguration2.this.configuration.telemetryAlarms ^ 4);
                    UniLog2SetupConfiguration2.this.voltageRxButton.setSelection((UniLog2SetupConfiguration2.this.configuration.telemetryAlarms & 4) > 0);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            RowData voltageRxCComboLData = new RowData();
            voltageRxCComboLData.width = this.comboWidth;
            voltageRxCComboLData.height = 17;
            this.voltageRxCombo = new CCombo((Composite)this.unilogTelemtryAlarmsGroup, 2048);
            this.voltageRxCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.voltageRxCombo.setLayoutData((Object)voltageRxCComboLData);
            this.voltageRxCombo.setItems(this.voltageRxStartValues);
            this.voltageRxCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "voltageRxCombo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.voltageRxAlarm = (short)(Double.parseDouble(UniLog2SetupConfiguration2.this.voltageRxCombo.getText().trim().replace(',', '.')) * 100.0);
                    UniLog2SetupConfiguration2.this.configuration.voltageRxAlarm = (short)(UniLog2SetupConfiguration2.this.configuration.voltageRxAlarm < 10 ? 10 : (UniLog2SetupConfiguration2.this.configuration.voltageRxAlarm > 600 ? 600 : (int)UniLog2SetupConfiguration2.this.configuration.voltageRxAlarm));
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.voltageRxCombo.addVerifyListener(new VerifyListener(this){

                public void verifyText(VerifyEvent verifyevent) {
                    log.log(Level.FINEST, "voltageRxCombo.verify, event=" + String.valueOf(verifyevent));
                    verifyevent.doit = StringHelper.verifyTypedInput((DataTypes)DataTypes.DOUBLE, (String)verifyevent.text);
                }
            });
            this.voltageRxCombo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent keyevent) {
                    log.log(Level.FINEST, "voltageRxCombo.keyReleased, event=" + String.valueOf(keyevent));
                    try {
                        UniLog2SetupConfiguration2.this.configuration.voltageRxAlarm = (short)(Double.parseDouble(UniLog2SetupConfiguration2.this.voltageRxCombo.getText().trim().replace(',', '.')) * 100.0);
                        UniLog2SetupConfiguration2.this.configuration.voltageRxAlarm = (short)(UniLog2SetupConfiguration2.this.configuration.voltageRxAlarm < 10 ? 10 : (UniLog2SetupConfiguration2.this.configuration.voltageRxAlarm > 600 ? 600 : (int)UniLog2SetupConfiguration2.this.configuration.voltageRxAlarm));
                        UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            RowData voltageRxLabelLData = new RowData();
            voltageRxLabelLData.width = 50;
            voltageRxLabelLData.height = 19;
            this.voltageRxLabel = new CLabel((Composite)this.unilogTelemtryAlarmsGroup, 0x1000000);
            this.voltageRxLabel.setLayoutData((Object)voltageRxLabelLData);
            this.voltageRxLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.voltageRxLabel.setText(Messages.getString((String)"GDE_MSGT2555"));
            this.fillerComposite = new Composite((Composite)this.unilogTelemtryAlarmsGroup, 0);
            fillerCompositeRA1LData = new RowData();
            fillerCompositeRA1LData.width = this.fillerWidth;
            fillerCompositeRA1LData.height = 20;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRA1LData);
            this.cellVoltageButton = new Button((Composite)this.unilogTelemtryAlarmsGroup, 16416);
            RowData cellVoltageButtonLData = new RowData();
            cellVoltageButtonLData.width = this.buttonWidth;
            cellVoltageButtonLData.height = 19;
            this.cellVoltageButton.setLayoutData((Object)cellVoltageButtonLData);
            this.cellVoltageButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.cellVoltageButton.setText(Messages.getString((String)"GDE_MSGT2569"));
            this.cellVoltageButton.setSelection((this.configuration.telemetryAlarms & 4) > 0);
            this.cellVoltageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "cellVoltageButton.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.telemetryAlarms = UniLog2SetupConfiguration2.this.cellVoltageButton.getSelection() ? (short)(UniLog2SetupConfiguration2.this.configuration.telemetryAlarms | 4) : (short)(UniLog2SetupConfiguration2.this.configuration.telemetryAlarms ^ 4);
                    UniLog2SetupConfiguration2.this.cellVoltageButton.setSelection((UniLog2SetupConfiguration2.this.configuration.telemetryAlarms & 4) > 0);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            RowData cellVoltageCComboLData = new RowData();
            cellVoltageCComboLData.width = this.comboWidth;
            cellVoltageCComboLData.height = 17;
            this.cellVoltageCombo = new CCombo((Composite)this.unilogTelemtryAlarmsGroup, 2048);
            this.cellVoltageCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.cellVoltageCombo.setLayoutData((Object)cellVoltageCComboLData);
            this.cellVoltageCombo.setItems(this.cellVoltageStartValues);
            this.cellVoltageCombo.setText(String.format(Locale.ENGLISH, "%5.1f", (double)this.configuration.cellVoltageAlarm / 10.0));
            this.cellVoltageCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "cellVoltageCombo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.cellVoltageAlarm = (short)(Double.parseDouble(UniLog2SetupConfiguration2.this.cellVoltageCombo.getText().trim().replace(',', '.')) * 100.0);
                    UniLog2SetupConfiguration2.this.configuration.cellVoltageAlarm = (short)(UniLog2SetupConfiguration2.this.configuration.cellVoltageAlarm < 10 ? 10 : (UniLog2SetupConfiguration2.this.configuration.cellVoltageAlarm > 600 ? 600 : (int)UniLog2SetupConfiguration2.this.configuration.cellVoltageAlarm));
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.cellVoltageCombo.addVerifyListener(new VerifyListener(this){

                public void verifyText(VerifyEvent verifyevent) {
                    log.log(Level.FINEST, "cellVoltageCombo.verify, event=" + String.valueOf(verifyevent));
                    verifyevent.doit = StringHelper.verifyTypedInput((DataTypes)DataTypes.DOUBLE, (String)verifyevent.text);
                }
            });
            this.cellVoltageCombo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent keyevent) {
                    log.log(Level.FINEST, "cellVoltageCombo.keyReleased, event=" + String.valueOf(keyevent));
                    try {
                        UniLog2SetupConfiguration2.this.configuration.cellVoltageAlarm = (short)(Double.parseDouble(UniLog2SetupConfiguration2.this.cellVoltageCombo.getText().trim().replace(',', '.')) * 100.0);
                        UniLog2SetupConfiguration2.this.configuration.cellVoltageAlarm = (short)(UniLog2SetupConfiguration2.this.configuration.cellVoltageAlarm < 10 ? 10 : (UniLog2SetupConfiguration2.this.configuration.cellVoltageAlarm > 600 ? 600 : (int)UniLog2SetupConfiguration2.this.configuration.cellVoltageAlarm));
                        UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            RowData cellVoltageLabelLData = new RowData();
            cellVoltageLabelLData.width = 50;
            cellVoltageLabelLData.height = 19;
            this.cellVoltageLabel = new CLabel((Composite)this.unilogTelemtryAlarmsGroup, 0x1000000);
            this.cellVoltageLabel.setLayoutData((Object)cellVoltageLabelLData);
            this.cellVoltageLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.cellVoltageLabel.setText(Messages.getString((String)"GDE_MSGT2555"));
            this.fillerComposite = new Composite((Composite)this.unilogTelemtryAlarmsGroup, 0);
            fillerCompositeRA1LData = new RowData();
            fillerCompositeRA1LData.width = this.fillerWidth;
            fillerCompositeRA1LData.height = 20;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRA1LData);
            this.analogAlarm1Button = new Button((Composite)this.unilogTelemtryAlarmsGroup, 16416);
            RowData analogAlarm1ButtonLData = new RowData();
            analogAlarm1ButtonLData.width = this.buttonWidth / 4 * 3 - 3;
            analogAlarm1ButtonLData.height = 19;
            this.analogAlarm1Button.setLayoutData((Object)analogAlarm1ButtonLData);
            this.analogAlarm1Button.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.analogAlarm1Button.setText("  A1");
            this.analogAlarm1Button.setSelection((this.configuration.telemetryAlarms & 0x80) > 0);
            this.analogAlarm1Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "analogAlarm1Button.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.telemetryAlarms = UniLog2SetupConfiguration2.this.analogAlarm1Button.getSelection() ? (short)(UniLog2SetupConfiguration2.this.configuration.telemetryAlarms | 0x80) : (short)(UniLog2SetupConfiguration2.this.configuration.telemetryAlarms ^ 0x80);
                    UniLog2SetupConfiguration2.this.analogAlarm1Button.setSelection((UniLog2SetupConfiguration2.this.configuration.telemetryAlarms & 0x80) > 0);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.analogAlarm1DirectionButton = new Button((Composite)this.unilogTelemtryAlarmsGroup, 16416);
            RowData analogAlarm1DirectionButtonLData = new RowData();
            analogAlarm1DirectionButtonLData.width = this.buttonWidth / 4;
            analogAlarm1DirectionButtonLData.height = 19;
            this.analogAlarm1DirectionButton.setLayoutData((Object)analogAlarm1DirectionButtonLData);
            this.analogAlarm1DirectionButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.analogAlarm1DirectionButton.setText("<");
            this.analogAlarm1DirectionButton.setSelection((this.configuration.telemetryAlarms & 0x80) > 0);
            this.analogAlarm1DirectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "analogAlarm1DirectionButton.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.analogAlarm1Direct = (short)(UniLog2SetupConfiguration2.this.analogAlarm1DirectionButton.getSelection() ? 1 : 0);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.analogAlarm1Combo = new CCombo((Composite)this.unilogTelemtryAlarmsGroup, 2048);
            this.analogAlarm1Combo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            RowData analogAlarm1CComboLData = new RowData();
            analogAlarm1CComboLData.width = this.comboWidth;
            analogAlarm1CComboLData.height = 17;
            this.analogAlarm1Combo.setLayoutData((Object)analogAlarm1CComboLData);
            this.analogAlarm1Combo.setItems(this.analogAlarmStartValues);
            this.analogAlarm1Combo.setText(String.format(Locale.ENGLISH, "  %4df", this.configuration.analogAlarm1));
            this.analogAlarm1Combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "analogAlarm1Combo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.analogAlarm1 = (short)Integer.parseInt(UniLog2SetupConfiguration2.this.analogAlarm1Combo.getText().trim());
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.analogAlarm1Combo.addVerifyListener(new VerifyListener(this){

                public void verifyText(VerifyEvent verifyevent) {
                    log.log(Level.FINEST, "analogAlarm1Combo.verify, event=" + String.valueOf(verifyevent));
                    verifyevent.doit = StringHelper.verifyTypedInput((DataTypes)DataTypes.INTEGER, (String)verifyevent.text);
                }
            });
            this.analogAlarm1Combo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent keyevent) {
                    log.log(Level.FINEST, "analogAlarm1Combo.keyReleased, event=" + String.valueOf(keyevent));
                    try {
                        UniLog2SetupConfiguration2.this.configuration.analogAlarm1 = (short)Integer.parseInt(UniLog2SetupConfiguration2.this.analogAlarm1Combo.getText().trim());
                        UniLog2SetupConfiguration2.this.configuration.analogAlarm1 = (short)(UniLog2SetupConfiguration2.this.configuration.analogAlarm1 > 3000 ? 3000 : (UniLog2SetupConfiguration2.this.configuration.analogAlarm1 < -100 ? -100 : (int)UniLog2SetupConfiguration2.this.configuration.analogAlarm1));
                        UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            this.analogAlarm1Label = new CLabel((Composite)this.unilogTelemtryAlarmsGroup, 0x1000000);
            RowData analogAlarm1LabelLData = new RowData();
            analogAlarm1LabelLData.width = 50;
            analogAlarm1LabelLData.height = 19;
            this.analogAlarm1Label.setLayoutData((Object)analogAlarm1LabelLData);
            this.analogAlarm1Label.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.fillerComposite = new Composite((Composite)this.unilogTelemtryAlarmsGroup, 0);
            fillerCompositeRA1LData = new RowData();
            fillerCompositeRA1LData.width = this.fillerWidth;
            fillerCompositeRA1LData.height = 20;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRA1LData);
            this.analogAlarm2Button = new Button((Composite)this.unilogTelemtryAlarmsGroup, 16416);
            RowData analogAlarm2ButtonLData = new RowData();
            analogAlarm2ButtonLData.width = this.buttonWidth / 4 * 3 - 3;
            analogAlarm2ButtonLData.height = 19;
            this.analogAlarm2Button.setLayoutData((Object)analogAlarm2ButtonLData);
            this.analogAlarm2Button.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.analogAlarm2Button.setText("  A2");
            this.analogAlarm2Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "analogAlarm2Button.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.telemetryAlarms = UniLog2SetupConfiguration2.this.analogAlarm2Button.getSelection() ? (short)(UniLog2SetupConfiguration2.this.configuration.telemetryAlarms | 0x100) : (short)(UniLog2SetupConfiguration2.this.configuration.telemetryAlarms ^ 0x100);
                    UniLog2SetupConfiguration2.this.analogAlarm2Button.setSelection((UniLog2SetupConfiguration2.this.configuration.telemetryAlarms & 0x100) > 0);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.analogAlarm2DirectionButton = new Button((Composite)this.unilogTelemtryAlarmsGroup, 16416);
            RowData analogAlarm2DirectionButtonLData = new RowData();
            analogAlarm2DirectionButtonLData.width = this.buttonWidth / 4;
            analogAlarm2DirectionButtonLData.height = 19;
            this.analogAlarm2DirectionButton.setLayoutData((Object)analogAlarm2DirectionButtonLData);
            this.analogAlarm2DirectionButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.analogAlarm2DirectionButton.setText("<");
            this.analogAlarm2DirectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "analogAlarm2DirectionButton.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.analogAlarm2Direct = (short)(UniLog2SetupConfiguration2.this.analogAlarm2DirectionButton.getSelection() ? 1 : 0);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.analogAlarm2Combo = new CCombo((Composite)this.unilogTelemtryAlarmsGroup, 2048);
            this.analogAlarm2Combo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            RowData analogAlarm2CComboLData = new RowData();
            analogAlarm2CComboLData.width = this.comboWidth;
            analogAlarm2CComboLData.height = 17;
            this.analogAlarm2Combo.setLayoutData((Object)analogAlarm2CComboLData);
            this.analogAlarm2Combo.setItems(this.analogAlarmStartValues);
            this.analogAlarm2Combo.setText(String.format(Locale.ENGLISH, "  %4df", this.configuration.analogAlarm2));
            this.analogAlarm2Combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "analogAlarm2Combo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.analogAlarm2 = (short)Integer.parseInt(UniLog2SetupConfiguration2.this.analogAlarm2Combo.getText().trim());
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.analogAlarm2Combo.addVerifyListener(new VerifyListener(this){

                public void verifyText(VerifyEvent verifyevent) {
                    log.log(Level.FINEST, "analogAlarm2Combo.verify, event=" + String.valueOf(verifyevent));
                    verifyevent.doit = StringHelper.verifyTypedInput((DataTypes)DataTypes.INTEGER, (String)verifyevent.text);
                }
            });
            this.analogAlarm2Combo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent keyevent) {
                    log.log(Level.FINEST, "analogAlarm2Combo.keyReleased, event=" + String.valueOf(keyevent));
                    try {
                        UniLog2SetupConfiguration2.this.configuration.analogAlarm2 = (short)Integer.parseInt(UniLog2SetupConfiguration2.this.analogAlarm2Combo.getText().trim());
                        UniLog2SetupConfiguration2.this.configuration.analogAlarm2 = (short)(UniLog2SetupConfiguration2.this.configuration.analogAlarm2 > 3000 ? 3000 : (UniLog2SetupConfiguration2.this.configuration.analogAlarm2 < -100 ? -100 : (int)UniLog2SetupConfiguration2.this.configuration.analogAlarm2));
                        UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            this.analogAlarm2Label = new CLabel((Composite)this.unilogTelemtryAlarmsGroup, 0x1000000);
            RowData analogAlarm2LabelLData = new RowData();
            analogAlarm2LabelLData.width = 50;
            analogAlarm2LabelLData.height = 19;
            this.analogAlarm2Label.setLayoutData((Object)analogAlarm2LabelLData);
            this.analogAlarm2Label.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.fillerComposite = new Composite((Composite)this.unilogTelemtryAlarmsGroup, 0);
            fillerCompositeRA1LData = new RowData();
            fillerCompositeRA1LData.width = this.fillerWidth;
            fillerCompositeRA1LData.height = 20;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRA1LData);
            this.analogAlarm3Button = new Button((Composite)this.unilogTelemtryAlarmsGroup, 16416);
            RowData analogAlarm3ButtonLData = new RowData();
            analogAlarm3ButtonLData.width = this.buttonWidth / 4 * 3 - 3;
            analogAlarm3ButtonLData.height = 19;
            this.analogAlarm3Button.setLayoutData((Object)analogAlarm3ButtonLData);
            this.analogAlarm3Button.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.analogAlarm3Button.setText("  A3");
            this.analogAlarm3Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "analogAlarm3Button.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.telemetryAlarms = UniLog2SetupConfiguration2.this.analogAlarm3Button.getSelection() ? (short)(UniLog2SetupConfiguration2.this.configuration.telemetryAlarms | 0x200) : (short)(UniLog2SetupConfiguration2.this.configuration.telemetryAlarms ^ 0x200);
                    UniLog2SetupConfiguration2.this.analogAlarm3Button.setSelection((UniLog2SetupConfiguration2.this.configuration.telemetryAlarms & 0x200) > 0);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.analogAlarm3DirectionButton = new Button((Composite)this.unilogTelemtryAlarmsGroup, 16416);
            RowData analogAlarm3DirectionButtonLData = new RowData();
            analogAlarm3DirectionButtonLData.width = this.buttonWidth / 4;
            analogAlarm3DirectionButtonLData.height = 19;
            this.analogAlarm3DirectionButton.setLayoutData((Object)analogAlarm3DirectionButtonLData);
            this.analogAlarm3DirectionButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.analogAlarm3DirectionButton.setText("<");
            this.analogAlarm3DirectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "analogAlarm3DirectionButton.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.analogAlarm3Direct = (short)(UniLog2SetupConfiguration2.this.analogAlarm3DirectionButton.getSelection() ? 1 : 0);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.analogAlarm3Combo = new CCombo((Composite)this.unilogTelemtryAlarmsGroup, 2048);
            this.analogAlarm3Combo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            RowData analogAlarm3CComboLData = new RowData();
            analogAlarm3CComboLData.width = this.comboWidth;
            analogAlarm3CComboLData.height = 17;
            this.analogAlarm3Combo.setLayoutData((Object)analogAlarm3CComboLData);
            this.analogAlarm3Combo.setItems(this.analogAlarmStartValues);
            this.analogAlarm3Combo.setText(String.format(Locale.ENGLISH, "  %4df", this.configuration.analogAlarm3));
            this.analogAlarm3Combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "analogAlarm3Combo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.analogAlarm3 = (short)Integer.parseInt(UniLog2SetupConfiguration2.this.analogAlarm3Combo.getText().trim());
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.analogAlarm3Combo.addVerifyListener(new VerifyListener(this){

                public void verifyText(VerifyEvent verifyevent) {
                    log.log(Level.FINEST, "analogAlarm3Combo.verify, event=" + String.valueOf(verifyevent));
                    verifyevent.doit = StringHelper.verifyTypedInput((DataTypes)DataTypes.INTEGER, (String)verifyevent.text);
                }
            });
            this.analogAlarm3Combo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent keyevent) {
                    log.log(Level.FINEST, "analogAlarm3Combo.keyReleased, event=" + String.valueOf(keyevent));
                    try {
                        UniLog2SetupConfiguration2.this.configuration.analogAlarm3 = (short)Integer.parseInt(UniLog2SetupConfiguration2.this.analogAlarm3Combo.getText().trim());
                        UniLog2SetupConfiguration2.this.configuration.analogAlarm3 = (short)(UniLog2SetupConfiguration2.this.configuration.analogAlarm3 > 3000 ? 3000 : (UniLog2SetupConfiguration2.this.configuration.analogAlarm3 < -100 ? -100 : (int)UniLog2SetupConfiguration2.this.configuration.analogAlarm3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.analogAlarm3Label = new CLabel((Composite)this.unilogTelemtryAlarmsGroup, 0x1000000);
            RowData analogAlarm3LabelLData = new RowData();
            analogAlarm3LabelLData.width = 50;
            analogAlarm3LabelLData.height = 19;
            this.analogAlarm3Label.setLayoutData((Object)analogAlarm3LabelLData);
            this.analogAlarm3Label.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.fillerComposite = new Composite((Composite)this.unilogTelemtryAlarmsGroup, 0);
            fillerCompositeRA1LData = new RowData();
            fillerCompositeRA1LData.width = this.fillerWidth;
            fillerCompositeRA1LData.height = 20;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRA1LData);
            this.rpmMinButton = new Button((Composite)this.unilogTelemtryAlarmsGroup, 16416);
            RowData rpmMinButtonLData = new RowData();
            rpmMinButtonLData.width = this.buttonWidth;
            rpmMinButtonLData.height = 19;
            this.rpmMinButton.setLayoutData((Object)rpmMinButtonLData);
            this.rpmMinButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.rpmMinButton.setText(Messages.getString((String)"GDE_MSGT2561") + " min");
            this.rpmMinButton.setSelection((this.configuration.telemetryAlarms & 4) > 0);
            this.rpmMinButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "rpmMinButton.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.telemetryAlarms = UniLog2SetupConfiguration2.this.rpmMinButton.getSelection() ? (short)(UniLog2SetupConfiguration2.this.configuration.telemetryAlarms | 0x2000) : (short)(UniLog2SetupConfiguration2.this.configuration.telemetryAlarms ^ 0x2000);
                    UniLog2SetupConfiguration2.this.rpmMinButton.setSelection((UniLog2SetupConfiguration2.this.configuration.telemetryAlarms & 0x2000) > 0);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            RowData rpmMinCComboLData = new RowData();
            rpmMinCComboLData.width = this.comboWidth;
            rpmMinCComboLData.height = 17;
            this.rpmMinCombo = new CCombo((Composite)this.unilogTelemtryAlarmsGroup, 2048);
            this.rpmMinCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.rpmMinCombo.setLayoutData((Object)rpmMinCComboLData);
            this.rpmMinCombo.setItems(this.rpmMinValues);
            this.rpmMinCombo.setText(String.format(Locale.ENGLISH, "%5d", this.configuration.rpmMinAlarm * 100));
            this.rpmMinCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "rpmMinCombo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.rpmMinAlarm = (short)(Integer.parseInt(UniLog2SetupConfiguration2.this.rpmMinCombo.getText().trim()) / 100);
                    UniLog2SetupConfiguration2.this.configuration.rpmMinAlarm = UniLog2SetupConfiguration2.this.configuration.rpmMinAlarm < 1 ? 1 : (UniLog2SetupConfiguration2.this.configuration.rpmMinAlarm > 2000 ? 2000 : (int)UniLog2SetupConfiguration2.this.configuration.rpmMinAlarm);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.rpmMinCombo.addVerifyListener(new VerifyListener(this){

                public void verifyText(VerifyEvent verifyevent) {
                    log.log(Level.FINEST, "rpmMinCombo.verify, event=" + String.valueOf(verifyevent));
                    verifyevent.doit = StringHelper.verifyTypedInput((DataTypes)DataTypes.INTEGER, (String)verifyevent.text);
                }
            });
            this.rpmMinCombo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent keyevent) {
                    log.log(Level.FINEST, "rpmMinCombo.keyReleased, event=" + String.valueOf(keyevent));
                    try {
                        UniLog2SetupConfiguration2.this.configuration.rpmMinAlarm = (short)(Integer.parseInt(UniLog2SetupConfiguration2.this.rpmMinCombo.getText().trim()) / 100);
                        UniLog2SetupConfiguration2.this.configuration.rpmMinAlarm = UniLog2SetupConfiguration2.this.configuration.rpmMinAlarm < 1 ? 1 : (UniLog2SetupConfiguration2.this.configuration.rpmMinAlarm > 2000 ? 2000 : (int)UniLog2SetupConfiguration2.this.configuration.rpmMinAlarm);
                        UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            RowData rpmMinLabelLData = new RowData();
            rpmMinLabelLData.width = 50;
            rpmMinLabelLData.height = 19;
            this.rpmMinLabel = new CLabel((Composite)this.unilogTelemtryAlarmsGroup, 0x1000000);
            this.rpmMinLabel.setLayoutData((Object)rpmMinLabelLData);
            this.rpmMinLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.rpmMinLabel.setText(Messages.getString((String)"GDE_MSGT2507"));
            this.fillerComposite = new Composite((Composite)this.unilogTelemtryAlarmsGroup, 0);
            fillerCompositeRA1LData = new RowData();
            fillerCompositeRA1LData.width = this.fillerWidth;
            fillerCompositeRA1LData.height = 20;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRA1LData);
            this.rpmMaxButton = new Button((Composite)this.unilogTelemtryAlarmsGroup, 16416);
            RowData rpmMaxButtonLData = new RowData();
            rpmMaxButtonLData.width = this.buttonWidth;
            rpmMaxButtonLData.height = 19;
            this.rpmMaxButton.setLayoutData((Object)rpmMaxButtonLData);
            this.rpmMaxButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.rpmMaxButton.setText(Messages.getString((String)"GDE_MSGT2561") + " max");
            this.rpmMaxButton.setSelection((this.configuration.telemetryAlarms & 4) > 0);
            this.rpmMaxButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "rpmMaxButton.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.telemetryAlarms = UniLog2SetupConfiguration2.this.rpmMaxButton.getSelection() ? (short)(UniLog2SetupConfiguration2.this.configuration.telemetryAlarms | 0x4000) : (short)(UniLog2SetupConfiguration2.this.configuration.telemetryAlarms ^ 0x4000);
                    UniLog2SetupConfiguration2.this.rpmMaxButton.setSelection((UniLog2SetupConfiguration2.this.configuration.telemetryAlarms & 0x4000) > 0);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            RowData rpmMaxCComboLData = new RowData();
            rpmMaxCComboLData.width = this.comboWidth;
            rpmMaxCComboLData.height = 17;
            this.rpmMaxCombo = new CCombo((Composite)this.unilogTelemtryAlarmsGroup, 2048);
            this.rpmMaxCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.rpmMaxCombo.setLayoutData((Object)rpmMaxCComboLData);
            this.rpmMaxCombo.setItems(this.rpmMaxValues);
            this.rpmMaxCombo.setText(String.format(Locale.ENGLISH, "%5.1f", (double)this.configuration.rpmMaxAlarm / 10.0));
            this.rpmMaxCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "rpmMaxCombo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.rpmMaxAlarm = (short)(Integer.parseInt(UniLog2SetupConfiguration2.this.rpmMaxCombo.getText().trim()) / 100);
                    UniLog2SetupConfiguration2.this.configuration.rpmMaxAlarm = UniLog2SetupConfiguration2.this.configuration.rpmMaxAlarm < 1 ? 1 : (UniLog2SetupConfiguration2.this.configuration.rpmMaxAlarm > 2000 ? 2000 : (int)UniLog2SetupConfiguration2.this.configuration.rpmMaxAlarm);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.rpmMaxCombo.addVerifyListener(new VerifyListener(this){

                public void verifyText(VerifyEvent verifyevent) {
                    log.log(Level.FINEST, "rpmMaxCombo.verify, event=" + String.valueOf(verifyevent));
                    verifyevent.doit = StringHelper.verifyTypedInput((DataTypes)DataTypes.INTEGER, (String)verifyevent.text);
                }
            });
            this.rpmMaxCombo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent keyevent) {
                    log.log(Level.FINEST, "rpmMaxCombo.keyReleased, event=" + String.valueOf(keyevent));
                    try {
                        UniLog2SetupConfiguration2.this.configuration.rpmMaxAlarm = (short)(Integer.parseInt(UniLog2SetupConfiguration2.this.rpmMaxCombo.getText().trim()) / 100);
                        UniLog2SetupConfiguration2.this.configuration.rpmMaxAlarm = UniLog2SetupConfiguration2.this.configuration.rpmMaxAlarm < 1 ? 1 : (UniLog2SetupConfiguration2.this.configuration.rpmMaxAlarm > 2000 ? 2000 : (int)UniLog2SetupConfiguration2.this.configuration.rpmMaxAlarm);
                        UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            RowData rpmMaxLabelLData = new RowData();
            rpmMaxLabelLData.width = 50;
            rpmMaxLabelLData.height = 19;
            this.rpmMaxLabel = new CLabel((Composite)this.unilogTelemtryAlarmsGroup, 0x1000000);
            this.rpmMaxLabel.setLayoutData((Object)rpmMaxLabelLData);
            this.rpmMaxLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.rpmMaxLabel.setText(Messages.getString((String)"GDE_MSGT2507"));
            mLinkGroupStatic = this.mLinkAddressesGroup = new Group((Composite)this, 0);
            RowLayout mLinkAddressesGroupLayout = new RowLayout(256);
            this.mLinkAddressesGroup.setLayout((Layout)mLinkAddressesGroupLayout);
            FormData mLinkAddressesGroupLData = new FormData();
            mLinkAddressesGroupLData.top = new FormAttachment(0, 1000, 335);
            mLinkAddressesGroupLData.left = new FormAttachment(0, 1000, 12);
            mLinkAddressesGroupLData.width = 290;
            mLinkAddressesGroupLData.height = 325;
            this.mLinkAddressesGroup.setLayoutData((Object)mLinkAddressesGroupLData);
            this.mLinkAddressesGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.mLinkAddressesGroup.setText(Messages.getString((String)"GDE_MSGT2558"));
            this.addressVoltageLabel = new CLabel((Composite)this.mLinkAddressesGroup, 131072);
            this.addressVoltageLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            RowData addressLabel1LData = new RowData();
            addressLabel1LData.width = this.labelWidth;
            addressLabel1LData.height = 21;
            this.addressVoltageLabel.setLayoutData((Object)addressLabel1LData);
            this.addressVoltageLabel.setText(Messages.getString((String)"GDE_MSGT2559"));
            this.addressVoltageText = new Text((Composite)this.mLinkAddressesGroup, 0x1000808);
            this.addressVoltageText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            RowData addressText1LData = new RowData();
            addressText1LData.width = this.textWidth;
            addressText1LData.height = 16;
            this.addressVoltageText.setLayoutData((Object)addressText1LData);
            this.addressVoltageText.setText(this.sliderValues[this.configuration.mLinkAddressVario]);
            this.addressVoltageText.setEditable(false);
            this.addressVoltageText.setBackground(SWTResourceManager.getColor((int)1));
            this.addressVoltageSlider = new Slider((Composite)this.mLinkAddressesGroup, 0);
            this.addressVoltageSlider.setMinimum(this.sliderMinimum);
            this.addressVoltageSlider.setMaximum(this.sliderMaximum);
            this.addressVoltageSlider.setIncrement(this.sliderIncrement);
            RowData addressSlider1LData = new RowData();
            addressSlider1LData.width = this.sliderWidth;
            addressSlider1LData.height = 17;
            this.addressVoltageSlider.setLayoutData((Object)addressSlider1LData);
            this.addressVoltageSlider.setSelection((int)this.configuration.mLinkAddressVario);
            this.addressVoltageSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "addressSlider1.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.mLinkAddressVoltage = (byte)UniLog2SetupConfiguration2.this.addressVoltageSlider.getSelection();
                    UniLog2SetupConfiguration2.this.addressVoltageText.setText(UniLog2SetupConfiguration2.this.sliderValues[UniLog2SetupConfiguration2.this.configuration.mLinkAddressVoltage]);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.addressCurrentLabel = new CLabel((Composite)this.mLinkAddressesGroup, 131072);
            this.addressCurrentLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            RowData addressLabel2LData = new RowData();
            addressLabel2LData.width = this.labelWidth;
            addressLabel2LData.height = 21;
            this.addressCurrentLabel.setLayoutData((Object)addressLabel2LData);
            this.addressCurrentLabel.setText(Messages.getString((String)"GDE_MSGT2560"));
            this.addressCurrentText = new Text((Composite)this.mLinkAddressesGroup, 0x1000808);
            this.addressCurrentText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            RowData addressText2LData = new RowData();
            addressText2LData.width = this.textWidth;
            addressText2LData.height = 16;
            this.addressCurrentText.setLayoutData((Object)addressText2LData);
            this.addressCurrentText.setText(this.sliderValues[this.configuration.mLinkAddressA1]);
            this.addressCurrentText.setEditable(false);
            this.addressCurrentText.setBackground(SWTResourceManager.getColor((int)1));
            this.addressCurrentSlider = new Slider((Composite)this.mLinkAddressesGroup, 0);
            this.addressCurrentSlider.setMinimum(this.sliderMinimum);
            this.addressCurrentSlider.setMaximum(this.sliderMaximum);
            this.addressCurrentSlider.setIncrement(this.sliderIncrement);
            RowData addressSlider2LData = new RowData();
            addressSlider2LData.width = this.sliderWidth;
            addressSlider2LData.height = 17;
            this.addressCurrentSlider.setLayoutData((Object)addressSlider2LData);
            this.addressCurrentSlider.setSelection((int)this.configuration.mLinkAddressA1);
            this.addressCurrentSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "addressSlider2.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.mLinkAddressCurrent = (byte)UniLog2SetupConfiguration2.this.addressCurrentSlider.getSelection();
                    UniLog2SetupConfiguration2.this.addressCurrentText.setText(UniLog2SetupConfiguration2.this.sliderValues[UniLog2SetupConfiguration2.this.configuration.mLinkAddressCurrent]);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.addressRevolutionLabel = new CLabel((Composite)this.mLinkAddressesGroup, 131072);
            this.addressRevolutionLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            RowData addressLabel2maxLData = new RowData();
            addressLabel2maxLData.width = this.labelWidth;
            addressLabel2maxLData.height = 21;
            this.addressRevolutionLabel.setLayoutData((Object)addressLabel2maxLData);
            this.addressRevolutionLabel.setText(Messages.getString((String)"GDE_MSGT2561"));
            this.addressRevolutionText = new Text((Composite)this.mLinkAddressesGroup, 0x1000808);
            this.addressRevolutionText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            RowData addressText2maxLData = new RowData();
            addressText2maxLData.width = this.textWidth;
            addressText2maxLData.height = 16;
            this.addressRevolutionText.setLayoutData((Object)addressText2maxLData);
            this.addressRevolutionText.setEditable(false);
            this.addressRevolutionText.setBackground(SWTResourceManager.getColor((int)1));
            this.addressRevolutionSlider = new Slider((Composite)this.mLinkAddressesGroup, 0);
            this.addressRevolutionSlider.setMinimum(this.sliderMinimum);
            this.addressRevolutionSlider.setMaximum(this.sliderMaximum);
            this.addressRevolutionSlider.setIncrement(this.sliderIncrement);
            RowData addressSlider2maxLData = new RowData();
            addressSlider2maxLData.width = this.sliderWidth;
            addressSlider2maxLData.height = 17;
            this.addressRevolutionSlider.setLayoutData((Object)addressSlider2maxLData);
            this.addressRevolutionSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "addressSlider3.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.mLinkAddressRevolution = (byte)UniLog2SetupConfiguration2.this.addressRevolutionSlider.getSelection();
                    UniLog2SetupConfiguration2.this.addressRevolutionText.setText(UniLog2SetupConfiguration2.this.sliderValues[UniLog2SetupConfiguration2.this.configuration.mLinkAddressRevolution]);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.addressCapacityLabel = new CLabel((Composite)this.mLinkAddressesGroup, 131072);
            this.addressCapacityLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            RowData addressLabel3LData = new RowData();
            addressLabel3LData.width = this.labelWidth;
            addressLabel3LData.height = 21;
            this.addressCapacityLabel.setLayoutData((Object)addressLabel3LData);
            this.addressCapacityLabel.setText(Messages.getString((String)"GDE_MSGT2562"));
            this.addressCapacityText = new Text((Composite)this.mLinkAddressesGroup, 0x1000808);
            this.addressCapacityText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            RowData addressText3LData = new RowData();
            addressText3LData.width = this.textWidth;
            addressText3LData.height = 16;
            this.addressCapacityText.setLayoutData((Object)addressText3LData);
            this.addressCapacityText.setText(this.sliderValues[this.configuration.mLinkAddressCapacity]);
            this.addressCapacityText.setEditable(false);
            this.addressCapacityText.setBackground(SWTResourceManager.getColor((int)1));
            this.addressCapacitySlider = new Slider((Composite)this.mLinkAddressesGroup, 0);
            this.addressCapacitySlider.setMinimum(this.sliderMinimum);
            this.addressCapacitySlider.setMaximum(this.sliderMaximum);
            this.addressCapacitySlider.setIncrement(this.sliderIncrement);
            RowData addressSlider3LData = new RowData();
            addressSlider3LData.width = this.sliderWidth;
            addressSlider3LData.height = 17;
            this.addressCapacitySlider.setLayoutData((Object)addressSlider3LData);
            this.addressCapacitySlider.setSelection((int)this.configuration.mLinkAddressCapacity);
            this.addressCapacitySlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "addressSlider3.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.mLinkAddressCapacity = (byte)UniLog2SetupConfiguration2.this.addressCapacitySlider.getSelection();
                    UniLog2SetupConfiguration2.this.addressCapacityText.setText(UniLog2SetupConfiguration2.this.sliderValues[UniLog2SetupConfiguration2.this.configuration.mLinkAddressCapacity]);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.addressVarioLabel = new CLabel((Composite)this.mLinkAddressesGroup, 131072);
            this.addressVarioLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            RowData addressLabel3maxLData = new RowData();
            addressLabel3maxLData.width = this.labelWidth;
            addressLabel3maxLData.height = 21;
            this.addressVarioLabel.setLayoutData((Object)addressLabel3maxLData);
            this.addressVarioLabel.setText(Messages.getString((String)"GDE_MSGT2563"));
            this.addressVarioText = new Text((Composite)this.mLinkAddressesGroup, 0x1000808);
            this.addressVarioText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            RowData addressText3maxLData = new RowData();
            addressText3maxLData.width = this.textWidth;
            addressText3maxLData.height = 16;
            this.addressVarioText.setLayoutData((Object)addressText3maxLData);
            this.addressVarioText.setEditable(false);
            this.addressVarioText.setBackground(SWTResourceManager.getColor((int)1));
            this.addressVarioSlider = new Slider((Composite)this.mLinkAddressesGroup, 0);
            this.addressVarioSlider.setMinimum(this.sliderMinimum);
            this.addressVarioSlider.setMaximum(this.sliderMaximum);
            this.addressVarioSlider.setIncrement(this.sliderIncrement);
            RowData addressSlider3maxLData = new RowData();
            addressSlider3maxLData.width = this.sliderWidth;
            addressSlider3maxLData.height = 17;
            this.addressVarioSlider.setLayoutData((Object)addressSlider3maxLData);
            this.addressVarioSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "addressSlider3max.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.mLinkAddressVario = (byte)UniLog2SetupConfiguration2.this.addressVarioSlider.getSelection();
                    UniLog2SetupConfiguration2.this.addressVarioText.setText(UniLog2SetupConfiguration2.this.sliderValues[UniLog2SetupConfiguration2.this.configuration.mLinkAddressVario]);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.addressHeightLabel = new CLabel((Composite)this.mLinkAddressesGroup, 131072);
            this.addressHeightLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            addressLabel3maxLData = new RowData();
            addressLabel3maxLData.width = this.labelWidth;
            addressLabel3maxLData.height = 21;
            this.addressHeightLabel.setLayoutData((Object)addressLabel3maxLData);
            this.addressHeightLabel.setText(Messages.getString((String)"GDE_MSGT2564"));
            this.addressHeightText = new Text((Composite)this.mLinkAddressesGroup, 0x1000808);
            this.addressHeightText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            addressText3maxLData = new RowData();
            addressText3maxLData.width = this.textWidth;
            addressText3maxLData.height = 16;
            this.addressHeightText.setLayoutData((Object)addressText3maxLData);
            this.addressHeightText.setEditable(false);
            this.addressHeightText.setBackground(SWTResourceManager.getColor((int)1));
            this.addressHeightSlider = new Slider((Composite)this.mLinkAddressesGroup, 0);
            this.addressHeightSlider.setMinimum(this.sliderMinimum);
            this.addressHeightSlider.setMaximum(this.sliderMaximum);
            this.addressHeightSlider.setIncrement(this.sliderIncrement);
            addressSlider3maxLData = new RowData();
            addressSlider3maxLData.width = this.sliderWidth;
            addressSlider3maxLData.height = 17;
            this.addressHeightSlider.setLayoutData((Object)addressSlider3maxLData);
            this.addressHeightSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "addressSlider3max.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.mLinkAddressHeight = (byte)UniLog2SetupConfiguration2.this.addressHeightSlider.getSelection();
                    UniLog2SetupConfiguration2.this.addressHeightText.setText(UniLog2SetupConfiguration2.this.sliderValues[UniLog2SetupConfiguration2.this.configuration.mLinkAddressHeight]);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.addressIntHeightLabel = new CLabel((Composite)this.mLinkAddressesGroup, 131072);
            this.addressIntHeightLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            addressLabel3maxLData = new RowData();
            addressLabel3maxLData.width = this.labelWidth;
            addressLabel3maxLData.height = 21;
            this.addressIntHeightLabel.setLayoutData((Object)addressLabel3maxLData);
            this.addressIntHeightLabel.setText(Messages.getString((String)"GDE_MSGT2585"));
            this.addressHeightGainText = new Text((Composite)this.mLinkAddressesGroup, 0x1000808);
            this.addressHeightGainText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            addressText3maxLData = new RowData();
            addressText3maxLData.width = this.textWidth;
            addressText3maxLData.height = 16;
            this.addressHeightGainText.setLayoutData((Object)addressText3maxLData);
            this.addressHeightGainText.setEditable(false);
            this.addressHeightGainText.setBackground(SWTResourceManager.getColor((int)1));
            this.addressHeightGainSlider = new Slider((Composite)this.mLinkAddressesGroup, 0);
            this.addressHeightGainSlider.setMinimum(this.sliderMinimum);
            this.addressHeightGainSlider.setMaximum(this.sliderMaximum);
            this.addressHeightGainSlider.setIncrement(this.sliderIncrement);
            addressSlider3maxLData = new RowData();
            addressSlider3maxLData.width = this.sliderWidth;
            addressSlider3maxLData.height = 17;
            this.addressHeightGainSlider.setLayoutData((Object)addressSlider3maxLData);
            this.addressHeightGainSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "addressSlider3max.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.mLinkAddressHeightGain = (byte)UniLog2SetupConfiguration2.this.addressHeightGainSlider.getSelection();
                    UniLog2SetupConfiguration2.this.addressHeightGainText.setText(UniLog2SetupConfiguration2.this.sliderValues[UniLog2SetupConfiguration2.this.configuration.mLinkAddressHeightGain]);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.addressEnergyLabel = new CLabel((Composite)this.mLinkAddressesGroup, 131072);
            this.addressEnergyLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            addressLabel3maxLData = new RowData();
            addressLabel3maxLData.width = this.labelWidth;
            addressLabel3maxLData.height = 21;
            this.addressEnergyLabel.setLayoutData((Object)addressLabel3maxLData);
            this.addressEnergyLabel.setText(Messages.getString((String)"GDE_MSGT2547").split(" ")[0]);
            this.addressEnergyText = new Text((Composite)this.mLinkAddressesGroup, 0x1000808);
            this.addressEnergyText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            addressText3maxLData = new RowData();
            addressText3maxLData.width = this.textWidth;
            addressText3maxLData.height = 16;
            this.addressEnergyText.setLayoutData((Object)addressText3maxLData);
            this.addressEnergyText.setEditable(false);
            this.addressEnergyText.setBackground(SWTResourceManager.getColor((int)1));
            this.addressEnergySlider = new Slider((Composite)this.mLinkAddressesGroup, 0);
            this.addressEnergySlider.setMinimum(this.sliderMinimum);
            this.addressEnergySlider.setMaximum(this.sliderMaximum);
            this.addressEnergySlider.setIncrement(this.sliderIncrement);
            addressSlider3maxLData = new RowData();
            addressSlider3maxLData.width = this.sliderWidth;
            addressSlider3maxLData.height = 17;
            this.addressEnergySlider.setLayoutData((Object)addressSlider3maxLData);
            this.addressEnergySlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "addressSlider3max.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.mLinkAddressEnergy = (byte)UniLog2SetupConfiguration2.this.addressEnergySlider.getSelection();
                    UniLog2SetupConfiguration2.this.addressEnergyText.setText(UniLog2SetupConfiguration2.this.sliderValues[UniLog2SetupConfiguration2.this.configuration.mLinkAddressEnergy]);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.addressRemainCapLabel = new CLabel((Composite)this.mLinkAddressesGroup, 131072);
            this.addressRemainCapLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            addressLabel3maxLData = new RowData();
            addressLabel3maxLData.width = this.labelWidth;
            addressLabel3maxLData.height = 21;
            this.addressRemainCapLabel.setLayoutData((Object)addressLabel3maxLData);
            this.addressRemainCapLabel.setText(Messages.getString((String)"GDE_MSGT2591"));
            this.addressRemainCapText = new Text((Composite)this.mLinkAddressesGroup, 0x1000808);
            this.addressRemainCapText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            addressText3maxLData = new RowData();
            addressText3maxLData.width = this.textWidth;
            addressText3maxLData.height = 16;
            this.addressRemainCapText.setLayoutData((Object)addressText3maxLData);
            this.addressRemainCapText.setEditable(false);
            this.addressRemainCapText.setBackground(SWTResourceManager.getColor((int)1));
            this.addressRemainCapSlider = new Slider((Composite)this.mLinkAddressesGroup, 0);
            this.addressRemainCapSlider.setMinimum(this.sliderMinimum);
            this.addressRemainCapSlider.setMaximum(this.sliderMaximum);
            this.addressRemainCapSlider.setIncrement(this.sliderIncrement);
            addressSlider3maxLData = new RowData();
            addressSlider3maxLData.width = this.sliderWidth;
            addressSlider3maxLData.height = 17;
            this.addressRemainCapSlider.setLayoutData((Object)addressSlider3maxLData);
            this.addressRemainCapSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "addressRemainCapSlider.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.mLinkAddressRemainCap = (byte)UniLog2SetupConfiguration2.this.addressRemainCapSlider.getSelection();
                    UniLog2SetupConfiguration2.this.addressRemainCapText.setText(UniLog2SetupConfiguration2.this.sliderValues[UniLog2SetupConfiguration2.this.configuration.mLinkAddressRemainCap]);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.cellMinimumLabel = new CLabel((Composite)this.mLinkAddressesGroup, 131072);
            this.cellMinimumLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            addressLabel3maxLData = new RowData();
            addressLabel3maxLData.width = this.labelWidth;
            addressLabel3maxLData.height = 21;
            this.cellMinimumLabel.setLayoutData((Object)addressLabel3maxLData);
            this.cellMinimumLabel.setText(Messages.getString((String)"GDE_MSGT2514"));
            this.cellMinimumText = new Text((Composite)this.mLinkAddressesGroup, 0x1000808);
            this.cellMinimumText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            addressText3maxLData = new RowData();
            addressText3maxLData.width = this.textWidth;
            addressText3maxLData.height = 16;
            this.cellMinimumText.setLayoutData((Object)addressText3maxLData);
            this.cellMinimumText.setEditable(false);
            this.cellMinimumText.setBackground(SWTResourceManager.getColor((int)1));
            this.cellMinimumSlider = new Slider((Composite)this.mLinkAddressesGroup, 0);
            this.cellMinimumSlider.setMinimum(this.sliderMinimum);
            this.cellMinimumSlider.setMaximum(this.sliderMaximum);
            this.cellMinimumSlider.setIncrement(this.sliderIncrement);
            addressSlider3maxLData = new RowData();
            addressSlider3maxLData.width = this.sliderWidth;
            addressSlider3maxLData.height = 17;
            this.cellMinimumSlider.setLayoutData((Object)addressSlider3maxLData);
            this.cellMinimumSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "addressSlider3max.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.mLinkAddressCellMinimum = (byte)UniLog2SetupConfiguration2.this.cellMinimumSlider.getSelection();
                    UniLog2SetupConfiguration2.this.cellMinimumText.setText(UniLog2SetupConfiguration2.this.sliderValues[UniLog2SetupConfiguration2.this.configuration.mLinkAddressCellMinimum]);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.fillerComposite = new Composite((Composite)this.mLinkAddressesGroup, 0);
            fillerCompositeRA1LData = new RowData();
            fillerCompositeRA1LData.width = 280;
            fillerCompositeRA1LData.height = 4;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRA1LData);
            this.a1Label = new CLabel((Composite)this.mLinkAddressesGroup, 131072);
            RowData a1LabelLData = new RowData();
            a1LabelLData.width = GDE.IS_LINUX ? 40 : 43;
            a1LabelLData.height = 19;
            this.a1Label.setLayoutData((Object)a1LabelLData);
            this.a1Label.setText("A1");
            this.a1Label.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.a1Combo = new CCombo((Composite)this.mLinkAddressesGroup, 2048);
            RowData a1ComboLData = new RowData();
            a1ComboLData.width = GDE.IS_LINUX ? 45 : 40;
            a1ComboLData.height = 17;
            this.a1Combo.setLayoutData((Object)a1ComboLData);
            this.a1Combo.setItems(this.sliderValues);
            this.a1Combo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.a1Combo.setEditable(false);
            this.a1Combo.setBackground(SWTResourceManager.getColor((int)1));
            this.a1Combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "a1Combo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.mLinkAddressA1 = (byte)UniLog2SetupConfiguration2.this.a1Combo.getSelectionIndex();
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.a2Label = new CLabel((Composite)this.mLinkAddressesGroup, 131072);
            RowData a2LabelLData = new RowData();
            a2LabelLData.width = GDE.IS_LINUX ? 40 : 43;
            a2LabelLData.height = 19;
            this.a2Label.setLayoutData((Object)a2LabelLData);
            this.a2Label.setText("A2");
            this.a2Label.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.a2Combo = new CCombo((Composite)this.mLinkAddressesGroup, 2048);
            RowData a2ComboLData = new RowData();
            a2ComboLData.width = GDE.IS_LINUX ? 45 : 40;
            a2ComboLData.height = 17;
            this.a2Combo.setLayoutData((Object)a2ComboLData);
            this.a2Combo.setItems(this.sliderValues);
            this.a2Combo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.a2Combo.setEditable(false);
            this.a2Combo.setBackground(SWTResourceManager.getColor((int)1));
            this.a2Combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "a1Combo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.mLinkAddressA2 = (byte)UniLog2SetupConfiguration2.this.a2Combo.getSelectionIndex();
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.a3Label = new CLabel((Composite)this.mLinkAddressesGroup, 131072);
            RowData a3LabelLData = new RowData();
            a3LabelLData.width = GDE.IS_LINUX ? 40 : 43;
            a3LabelLData.height = 19;
            this.a3Label.setLayoutData((Object)a3LabelLData);
            this.a3Label.setText("A3");
            this.a3Label.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.a3Combo = new CCombo((Composite)this.mLinkAddressesGroup, 2048);
            RowData a3ComboLData = new RowData();
            a3ComboLData.width = GDE.IS_LINUX ? 45 : 40;
            a3ComboLData.height = 17;
            this.a3Combo.setLayoutData((Object)a3ComboLData);
            this.a3Combo.setItems(this.sliderValues);
            this.a3Combo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.a3Combo.setEditable(false);
            this.a3Combo.setBackground(SWTResourceManager.getColor((int)1));
            this.a3Combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "a1Combo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.mLinkAddressA3 = (byte)UniLog2SetupConfiguration2.this.a3Combo.getSelectionIndex();
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.c1Label = new CLabel((Composite)this.mLinkAddressesGroup, 131072);
            RowData c1LabelLData = new RowData();
            c1LabelLData.width = GDE.IS_LINUX ? 40 : 43;
            c1LabelLData.height = 19;
            this.c1Label.setLayoutData((Object)c1LabelLData);
            this.c1Label.setText(Messages.getString((String)"GDE_MSGT2570"));
            this.c1Label.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.c1Combo = new CCombo((Composite)this.mLinkAddressesGroup, 2048);
            RowData c1ComboLData = new RowData();
            c1ComboLData.width = GDE.IS_LINUX ? 45 : 40;
            c1ComboLData.height = 17;
            this.c1Combo.setLayoutData((Object)c1ComboLData);
            this.c1Combo.setItems(this.sliderValues);
            this.c1Combo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.c1Combo.setEditable(false);
            this.c1Combo.setBackground(SWTResourceManager.getColor((int)1));
            this.c1Combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "c1Combo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.mLinkAddressCell1 = (byte)UniLog2SetupConfiguration2.this.c1Combo.getSelectionIndex();
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.c2Label = new CLabel((Composite)this.mLinkAddressesGroup, 131072);
            RowData c2LabelLData = new RowData();
            c2LabelLData.width = GDE.IS_LINUX ? 40 : 43;
            c2LabelLData.height = 19;
            this.c2Label.setLayoutData((Object)c2LabelLData);
            this.c2Label.setText(Messages.getString((String)"GDE_MSGT2571"));
            this.c2Label.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.c2Combo = new CCombo((Composite)this.mLinkAddressesGroup, 2048);
            RowData c2ComboLData = new RowData();
            c2ComboLData.width = GDE.IS_LINUX ? 45 : 40;
            c2ComboLData.height = 17;
            this.c2Combo.setLayoutData((Object)c2ComboLData);
            this.c2Combo.setItems(this.sliderValues);
            this.c2Combo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.c2Combo.setEditable(false);
            this.c2Combo.setBackground(SWTResourceManager.getColor((int)1));
            this.c2Combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "a1Combo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.mLinkAddressCell2 = (byte)UniLog2SetupConfiguration2.this.c2Combo.getSelectionIndex();
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.c3Label = new CLabel((Composite)this.mLinkAddressesGroup, 131072);
            RowData c3LabelLData = new RowData();
            c3LabelLData.width = GDE.IS_LINUX ? 40 : 43;
            c3LabelLData.height = 19;
            this.c3Label.setLayoutData((Object)c3LabelLData);
            this.c3Label.setText(Messages.getString((String)"GDE_MSGT2572"));
            this.c3Label.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.c3Combo = new CCombo((Composite)this.mLinkAddressesGroup, 2048);
            RowData c3ComboLData = new RowData();
            c3ComboLData.width = GDE.IS_LINUX ? 45 : 40;
            c3ComboLData.height = 17;
            this.c3Combo.setLayoutData((Object)c3ComboLData);
            this.c3Combo.setItems(this.sliderValues);
            this.c3Combo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.c3Combo.setEditable(false);
            this.c3Combo.setBackground(SWTResourceManager.getColor((int)1));
            this.c3Combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "c3Combo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.mLinkAddressCell3 = (byte)UniLog2SetupConfiguration2.this.c3Combo.getSelectionIndex();
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.c4Label = new CLabel((Composite)this.mLinkAddressesGroup, 131072);
            RowData c4LabelLData = new RowData();
            c4LabelLData.width = GDE.IS_LINUX ? 40 : 43;
            c4LabelLData.height = 19;
            this.c4Label.setLayoutData((Object)c4LabelLData);
            this.c4Label.setText(Messages.getString((String)"GDE_MSGT2573"));
            this.c4Label.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.c4Combo = new CCombo((Composite)this.mLinkAddressesGroup, 2048);
            RowData c4ComboLData = new RowData();
            c4ComboLData.width = GDE.IS_LINUX ? 45 : 40;
            c4ComboLData.height = 17;
            this.c4Combo.setLayoutData((Object)c4ComboLData);
            this.c4Combo.setItems(this.sliderValues);
            this.c4Combo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.c4Combo.setEditable(false);
            this.c4Combo.setBackground(SWTResourceManager.getColor((int)1));
            this.c4Combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "c4Combo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.mLinkAddressCell4 = (byte)UniLog2SetupConfiguration2.this.c4Combo.getSelectionIndex();
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.c5Label = new CLabel((Composite)this.mLinkAddressesGroup, 131072);
            RowData c5LabelLData = new RowData();
            c5LabelLData.width = GDE.IS_LINUX ? 40 : 43;
            c5LabelLData.height = 19;
            this.c5Label.setLayoutData((Object)c5LabelLData);
            this.c5Label.setText(Messages.getString((String)"GDE_MSGT2574"));
            this.c5Label.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.c5Combo = new CCombo((Composite)this.mLinkAddressesGroup, 2048);
            RowData c5ComboLData = new RowData();
            c5ComboLData.width = GDE.IS_LINUX ? 45 : 40;
            c5ComboLData.height = 17;
            this.c5Combo.setLayoutData((Object)c5ComboLData);
            this.c5Combo.setItems(this.sliderValues);
            this.c5Combo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.c5Combo.setEditable(false);
            this.c5Combo.setBackground(SWTResourceManager.getColor((int)1));
            this.c5Combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "a1Combo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.mLinkAddressCell5 = (byte)UniLog2SetupConfiguration2.this.c5Combo.getSelectionIndex();
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.c6Label = new CLabel((Composite)this.mLinkAddressesGroup, 131072);
            RowData c6LabelLData = new RowData();
            c6LabelLData.width = GDE.IS_LINUX ? 40 : 43;
            c6LabelLData.height = 19;
            this.c6Label.setLayoutData((Object)c6LabelLData);
            this.c6Label.setText(Messages.getString((String)"GDE_MSGT2575"));
            this.c6Label.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.c6Combo = new CCombo((Composite)this.mLinkAddressesGroup, 2048);
            RowData c6ComboLData = new RowData();
            c6ComboLData.width = GDE.IS_LINUX ? 45 : 40;
            c6ComboLData.height = 17;
            this.c6Combo.setLayoutData((Object)c6ComboLData);
            this.c6Combo.setItems(this.sliderValues);
            this.c6Combo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.c6Combo.setEditable(false);
            this.c6Combo.setBackground(SWTResourceManager.getColor((int)1));
            this.c6Combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "a1Combo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.mLinkAddressCell6 = (byte)UniLog2SetupConfiguration2.this.c6Combo.getSelectionIndex();
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            jetiExGroupStatic = this.jetiExGroup = new Group((Composite)this, 0);
            mLinkAddressesGroupLayout = new RowLayout(256);
            this.jetiExGroup.setLayout((Layout)mLinkAddressesGroupLayout);
            mLinkAddressesGroupLData = new FormData();
            mLinkAddressesGroupLData.top = new FormAttachment(0, 1000, 335);
            mLinkAddressesGroupLData.left = new FormAttachment(0, 1000, 12);
            mLinkAddressesGroupLData.width = 290;
            mLinkAddressesGroupLData.height = 270;
            this.jetiExGroup.setLayoutData((Object)mLinkAddressesGroupLData);
            this.jetiExGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.jetiExGroup.setText("Jeti EX ");
            this.fillerComposite = new Composite((Composite)this.mLinkAddressesGroup, 0);
            fillerCompositeRA1LData = new RowData();
            fillerCompositeRA1LData.width = 280;
            fillerCompositeRA1LData.height = 2;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRA1LData);
            this.measurement1 = new Button((Composite)this.jetiExGroup, 16416);
            analogAlarm1DirectionButtonLData = new RowData();
            analogAlarm1DirectionButtonLData.width = 142;
            analogAlarm1DirectionButtonLData.height = 19;
            this.measurement1.setLayoutData((Object)analogAlarm1DirectionButtonLData);
            this.measurement1.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.measurement1.setText(this.jetiValueNames[1]);
            this.measurement1.setEnabled(false);
            this.measurement1.setSelection(true);
            this.measurement2 = new Button((Composite)this.jetiExGroup, 16416);
            analogAlarm1DirectionButtonLData = new RowData();
            analogAlarm1DirectionButtonLData.width = 142;
            analogAlarm1DirectionButtonLData.height = 19;
            this.measurement2.setLayoutData((Object)analogAlarm1DirectionButtonLData);
            this.measurement2.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.measurement2.setText(this.jetiValueNames[2]);
            this.measurement2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "measurement2.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility = UniLog2SetupConfiguration2.this.measurement2.getSelection() ? UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility & 0xFFFFFFFB : UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility + 4;
                    UniLog2SetupConfiguration2.this.jetiExSelectionLabel.setText(Messages.getString((String)"GDE_MSGT2590", (Object[])new Object[]{UniLog2SetupConfiguration2.this.configuration.getJetiMeasurementCount()}));
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.measurement3 = new Button((Composite)this.jetiExGroup, 16416);
            analogAlarm1DirectionButtonLData = new RowData();
            analogAlarm1DirectionButtonLData.width = 142;
            analogAlarm1DirectionButtonLData.height = 19;
            this.measurement3.setLayoutData((Object)analogAlarm1DirectionButtonLData);
            this.measurement3.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.measurement3.setText(this.jetiValueNames[3]);
            this.measurement3.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "measurement3.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility = UniLog2SetupConfiguration2.this.measurement3.getSelection() ? UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility & 0xFFFFFFF7 : UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility + 8;
                    UniLog2SetupConfiguration2.this.jetiExSelectionLabel.setText(Messages.getString((String)"GDE_MSGT2590", (Object[])new Object[]{UniLog2SetupConfiguration2.this.configuration.getJetiMeasurementCount()}));
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.measurement4 = new Button((Composite)this.jetiExGroup, 16416);
            analogAlarm1DirectionButtonLData = new RowData();
            analogAlarm1DirectionButtonLData.width = 142;
            analogAlarm1DirectionButtonLData.height = 19;
            this.measurement4.setLayoutData((Object)analogAlarm1DirectionButtonLData);
            this.measurement4.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.measurement4.setText(this.jetiValueNames[4]);
            this.measurement4.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "measurement4.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility = UniLog2SetupConfiguration2.this.measurement4.getSelection() ? UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility & 0xFFFFFFEF : UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility + 16;
                    UniLog2SetupConfiguration2.this.jetiExSelectionLabel.setText(Messages.getString((String)"GDE_MSGT2590", (Object[])new Object[]{UniLog2SetupConfiguration2.this.configuration.getJetiMeasurementCount()}));
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.measurement5 = new Button((Composite)this.jetiExGroup, 16416);
            analogAlarm1DirectionButtonLData = new RowData();
            analogAlarm1DirectionButtonLData.width = 142;
            analogAlarm1DirectionButtonLData.height = 19;
            this.measurement5.setLayoutData((Object)analogAlarm1DirectionButtonLData);
            this.measurement5.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.measurement5.setText(this.jetiValueNames[5]);
            this.measurement5.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "measurement5.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility = UniLog2SetupConfiguration2.this.measurement5.getSelection() ? UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility & 0xFFFFFFDF : UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility + 32;
                    UniLog2SetupConfiguration2.this.jetiExSelectionLabel.setText(Messages.getString((String)"GDE_MSGT2590", (Object[])new Object[]{UniLog2SetupConfiguration2.this.configuration.getJetiMeasurementCount()}));
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.measurement6 = new Button((Composite)this.jetiExGroup, 16416);
            analogAlarm1DirectionButtonLData = new RowData();
            analogAlarm1DirectionButtonLData.width = 142;
            analogAlarm1DirectionButtonLData.height = 19;
            this.measurement6.setLayoutData((Object)analogAlarm1DirectionButtonLData);
            this.measurement6.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.measurement6.setText(this.jetiValueNames[6]);
            this.measurement6.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "measurement6.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility = UniLog2SetupConfiguration2.this.measurement6.getSelection() ? UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility & 0xFFFFFFBF : UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility + 64;
                    UniLog2SetupConfiguration2.this.jetiExSelectionLabel.setText(Messages.getString((String)"GDE_MSGT2590", (Object[])new Object[]{UniLog2SetupConfiguration2.this.configuration.getJetiMeasurementCount()}));
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.measurement7 = new Button((Composite)this.jetiExGroup, 16416);
            analogAlarm1DirectionButtonLData = new RowData();
            analogAlarm1DirectionButtonLData.width = 142;
            analogAlarm1DirectionButtonLData.height = 19;
            this.measurement7.setLayoutData((Object)analogAlarm1DirectionButtonLData);
            this.measurement7.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.measurement7.setText(this.jetiValueNames[7]);
            this.measurement7.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "measurement7.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility = UniLog2SetupConfiguration2.this.measurement7.getSelection() ? UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility & 0xFFFFFF7F : UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility + 128;
                    UniLog2SetupConfiguration2.this.jetiExSelectionLabel.setText(Messages.getString((String)"GDE_MSGT2590", (Object[])new Object[]{UniLog2SetupConfiguration2.this.configuration.getJetiMeasurementCount()}));
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.measurement8 = new Button((Composite)this.jetiExGroup, 16416);
            analogAlarm1DirectionButtonLData = new RowData();
            analogAlarm1DirectionButtonLData.width = 142;
            analogAlarm1DirectionButtonLData.height = 19;
            this.measurement8.setLayoutData((Object)analogAlarm1DirectionButtonLData);
            this.measurement8.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.measurement8.setText(this.jetiValueNames[8]);
            this.measurement8.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "measurement8.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility = UniLog2SetupConfiguration2.this.measurement8.getSelection() ? UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility & 0xFFFFFEFF : UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility + 256;
                    UniLog2SetupConfiguration2.this.jetiExSelectionLabel.setText(Messages.getString((String)"GDE_MSGT2590", (Object[])new Object[]{UniLog2SetupConfiguration2.this.configuration.getJetiMeasurementCount()}));
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.measurement9 = new Button((Composite)this.jetiExGroup, 16416);
            analogAlarm1DirectionButtonLData = new RowData();
            analogAlarm1DirectionButtonLData.width = 142;
            analogAlarm1DirectionButtonLData.height = 19;
            this.measurement9.setLayoutData((Object)analogAlarm1DirectionButtonLData);
            this.measurement9.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.measurement9.setText(this.jetiValueNames[9]);
            this.measurement9.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "measurement9.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility = UniLog2SetupConfiguration2.this.measurement9.getSelection() ? UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility & 0xFFFFFDFF : UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility + 512;
                    UniLog2SetupConfiguration2.this.jetiExSelectionLabel.setText(Messages.getString((String)"GDE_MSGT2590", (Object[])new Object[]{UniLog2SetupConfiguration2.this.configuration.getJetiMeasurementCount()}));
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.measurement10 = new Button((Composite)this.jetiExGroup, 16416);
            analogAlarm1DirectionButtonLData = new RowData();
            analogAlarm1DirectionButtonLData.width = 142;
            analogAlarm1DirectionButtonLData.height = 19;
            this.measurement10.setLayoutData((Object)analogAlarm1DirectionButtonLData);
            this.measurement10.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.measurement10.setText(this.jetiValueNames[10]);
            this.measurement10.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "measurement10.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility = UniLog2SetupConfiguration2.this.measurement10.getSelection() ? UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility & 0xFFFFFBFF : UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility + 1024;
                    UniLog2SetupConfiguration2.this.jetiExSelectionLabel.setText(Messages.getString((String)"GDE_MSGT2590", (Object[])new Object[]{UniLog2SetupConfiguration2.this.configuration.getJetiMeasurementCount()}));
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.measurement11 = new Button((Composite)this.jetiExGroup, 16416);
            analogAlarm1DirectionButtonLData = new RowData();
            analogAlarm1DirectionButtonLData.width = 142;
            analogAlarm1DirectionButtonLData.height = 19;
            this.measurement11.setLayoutData((Object)analogAlarm1DirectionButtonLData);
            this.measurement11.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.measurement11.setText(this.jetiValueNames[11]);
            this.measurement11.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "measurement11.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility = UniLog2SetupConfiguration2.this.measurement11.getSelection() ? UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility & 0xFFFFF7FF : UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility + 2048;
                    UniLog2SetupConfiguration2.this.jetiExSelectionLabel.setText(Messages.getString((String)"GDE_MSGT2590", (Object[])new Object[]{UniLog2SetupConfiguration2.this.configuration.getJetiMeasurementCount()}));
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.measurement12 = new Button((Composite)this.jetiExGroup, 16416);
            analogAlarm1DirectionButtonLData = new RowData();
            analogAlarm1DirectionButtonLData.width = 142;
            analogAlarm1DirectionButtonLData.height = 19;
            this.measurement12.setLayoutData((Object)analogAlarm1DirectionButtonLData);
            this.measurement12.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.measurement12.setText(this.jetiValueNames[12]);
            this.measurement12.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "measurement12.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility = UniLog2SetupConfiguration2.this.measurement12.getSelection() ? UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility & 0xFFFFEFFF : UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility + 4096;
                    UniLog2SetupConfiguration2.this.jetiExSelectionLabel.setText(Messages.getString((String)"GDE_MSGT2590", (Object[])new Object[]{UniLog2SetupConfiguration2.this.configuration.getJetiMeasurementCount()}));
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.measurement13 = new Button((Composite)this.jetiExGroup, 16416);
            analogAlarm1DirectionButtonLData = new RowData();
            analogAlarm1DirectionButtonLData.width = 142;
            analogAlarm1DirectionButtonLData.height = 19;
            this.measurement13.setLayoutData((Object)analogAlarm1DirectionButtonLData);
            this.measurement13.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.measurement13.setText(this.jetiValueNames[13]);
            this.measurement13.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "measurement13.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility = UniLog2SetupConfiguration2.this.measurement13.getSelection() ? UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility & 0xFFFFDFFF : UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility + 8192;
                    UniLog2SetupConfiguration2.this.jetiExSelectionLabel.setText(Messages.getString((String)"GDE_MSGT2590", (Object[])new Object[]{UniLog2SetupConfiguration2.this.configuration.getJetiMeasurementCount()}));
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.measurement14 = new Button((Composite)this.jetiExGroup, 16416);
            analogAlarm1DirectionButtonLData = new RowData();
            analogAlarm1DirectionButtonLData.width = 142;
            analogAlarm1DirectionButtonLData.height = 19;
            this.measurement14.setLayoutData((Object)analogAlarm1DirectionButtonLData);
            this.measurement14.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.measurement14.setText(this.jetiValueNames[14]);
            this.measurement14.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "measurement14.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility = UniLog2SetupConfiguration2.this.measurement14.getSelection() ? UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility & 0xFFFFBFFF : UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility + 16384;
                    UniLog2SetupConfiguration2.this.jetiExSelectionLabel.setText(Messages.getString((String)"GDE_MSGT2590", (Object[])new Object[]{UniLog2SetupConfiguration2.this.configuration.getJetiMeasurementCount()}));
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.measurement15 = new Button((Composite)this.jetiExGroup, 16416);
            analogAlarm1DirectionButtonLData = new RowData();
            analogAlarm1DirectionButtonLData.width = 142;
            analogAlarm1DirectionButtonLData.height = 19;
            this.measurement15.setLayoutData((Object)analogAlarm1DirectionButtonLData);
            this.measurement15.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.measurement15.setText(this.jetiValueNames[15]);
            this.measurement15.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "measurement15.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility = UniLog2SetupConfiguration2.this.measurement15.getSelection() ? UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility & 0xFFFF7FFF : UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility + 32768;
                    UniLog2SetupConfiguration2.this.jetiExSelectionLabel.setText(Messages.getString((String)"GDE_MSGT2590", (Object[])new Object[]{UniLog2SetupConfiguration2.this.configuration.getJetiMeasurementCount()}));
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.measurement16 = new Button((Composite)this.jetiExGroup, 16416);
            analogAlarm1DirectionButtonLData = new RowData();
            analogAlarm1DirectionButtonLData.width = 142;
            analogAlarm1DirectionButtonLData.height = 19;
            this.measurement16.setLayoutData((Object)analogAlarm1DirectionButtonLData);
            this.measurement16.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.measurement16.setText(this.jetiValueNames[16]);
            this.measurement16.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "measurement16.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility = UniLog2SetupConfiguration2.this.measurement16.getSelection() ? UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility & 0xFFFEFFFF : UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility + 65536;
                    UniLog2SetupConfiguration2.this.jetiExSelectionLabel.setText(Messages.getString((String)"GDE_MSGT2590", (Object[])new Object[]{UniLog2SetupConfiguration2.this.configuration.getJetiMeasurementCount()}));
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.measurement17 = new Button((Composite)this.jetiExGroup, 16416);
            analogAlarm1DirectionButtonLData = new RowData();
            analogAlarm1DirectionButtonLData.width = 142;
            analogAlarm1DirectionButtonLData.height = 19;
            this.measurement17.setLayoutData((Object)analogAlarm1DirectionButtonLData);
            this.measurement17.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.measurement17.setText(this.jetiValueNames[17]);
            this.measurement17.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "measurement17.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility = UniLog2SetupConfiguration2.this.measurement17.getSelection() ? UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility & 0xFFFDFFFF : UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility + 131072;
                    UniLog2SetupConfiguration2.this.jetiExSelectionLabel.setText(Messages.getString((String)"GDE_MSGT2590", (Object[])new Object[]{UniLog2SetupConfiguration2.this.configuration.getJetiMeasurementCount()}));
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.measurement18 = new Button((Composite)this.jetiExGroup, 16416);
            analogAlarm1DirectionButtonLData = new RowData();
            analogAlarm1DirectionButtonLData.width = 142;
            analogAlarm1DirectionButtonLData.height = 19;
            this.measurement18.setLayoutData((Object)analogAlarm1DirectionButtonLData);
            this.measurement18.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.measurement18.setText(this.jetiValueNames[18]);
            this.measurement18.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "measurement18.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility = UniLog2SetupConfiguration2.this.measurement18.getSelection() ? UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility & 0xFFFBFFFF : UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility + 262144;
                    UniLog2SetupConfiguration2.this.jetiExSelectionLabel.setText(Messages.getString((String)"GDE_MSGT2590", (Object[])new Object[]{UniLog2SetupConfiguration2.this.configuration.getJetiMeasurementCount()}));
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.measurement19 = new Button((Composite)this.jetiExGroup, 16416);
            analogAlarm1DirectionButtonLData = new RowData();
            analogAlarm1DirectionButtonLData.width = 142;
            analogAlarm1DirectionButtonLData.height = 19;
            this.measurement19.setLayoutData((Object)analogAlarm1DirectionButtonLData);
            this.measurement19.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.measurement19.setText(this.jetiValueNames[19]);
            this.measurement19.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "measurement19.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility = UniLog2SetupConfiguration2.this.measurement19.getSelection() ? UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility & 0xFFF7FFFF : UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility + 524288;
                    UniLog2SetupConfiguration2.this.jetiExSelectionLabel.setText(Messages.getString((String)"GDE_MSGT2590", (Object[])new Object[]{UniLog2SetupConfiguration2.this.configuration.getJetiMeasurementCount()}));
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.measurement20 = new Button((Composite)this.jetiExGroup, 16416);
            analogAlarm1DirectionButtonLData = new RowData();
            analogAlarm1DirectionButtonLData.width = 142;
            analogAlarm1DirectionButtonLData.height = 19;
            this.measurement20.setLayoutData((Object)analogAlarm1DirectionButtonLData);
            this.measurement20.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.measurement20.setText(this.jetiValueNames[20]);
            this.measurement20.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "measurement20.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility = UniLog2SetupConfiguration2.this.measurement20.getSelection() ? UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility & 0xFFEFFFFF : UniLog2SetupConfiguration2.this.configuration.jetiValueVisibility + 0x100000;
                    UniLog2SetupConfiguration2.this.jetiExSelectionLabel.setText(Messages.getString((String)"GDE_MSGT2590", (Object[])new Object[]{UniLog2SetupConfiguration2.this.configuration.getJetiMeasurementCount()}));
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.jetiExSelectionLabel = new CLabel((Composite)this.jetiExGroup, 0x1000000);
            this.jetiExSelectionLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            RowData jetiExSelectionLData = new RowData();
            jetiExSelectionLData.width = 285;
            jetiExSelectionLData.height = 25;
            this.jetiExSelectionLabel.setLayoutData((Object)jetiExSelectionLData);
            this.jetiExSelectionLabel.setText(Messages.getString((String)"GDE_MSGT2590", (Object[])new Object[]{this.configuration.getJetiMeasurementCount()}));
            spektrumAdapterGroupStatic = this.spektrumAdapterGroup = new Group((Composite)this, 0);
            mLinkAddressesGroupLayout = new RowLayout(256);
            this.spektrumAdapterGroup.setLayout((Layout)mLinkAddressesGroupLayout);
            mLinkAddressesGroupLData = new FormData();
            mLinkAddressesGroupLData.top = new FormAttachment(0, 1000, 335);
            mLinkAddressesGroupLData.left = new FormAttachment(0, 1000, 12);
            mLinkAddressesGroupLData.width = 290;
            mLinkAddressesGroupLData.height = 145;
            this.spektrumAdapterGroup.setLayoutData((Object)mLinkAddressesGroupLData);
            this.spektrumAdapterGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.spektrumAdapterGroup.setText(Messages.getString((String)"GDE_MSGT2594"));
            this.fillerComposite = new Composite((Composite)this.spektrumAdapterGroup, 0);
            fillerCompositeRA1LData = new RowData();
            fillerCompositeRA1LData.width = 280;
            fillerCompositeRA1LData.height = 2;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRA1LData);
            this.spektrumAddressLabel = new CLabel((Composite)this.spektrumAdapterGroup, 131072);
            this.spektrumAddressLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            addressLabel1LData = new RowData();
            addressLabel1LData.width = 140;
            addressLabel1LData.height = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
            this.spektrumAddressLabel.setLayoutData((Object)addressLabel1LData);
            this.spektrumAddressLabel.setText(Messages.getString((String)"GDE_MSGT2595"));
            this.spektrumAddressCombo = new CCombo((Composite)this.spektrumAdapterGroup, 2048);
            currentCComboLData = new RowData();
            currentCComboLData.width = 60;
            currentCComboLData.height = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
            this.spektrumAddressCombo.setLayoutData((Object)currentCComboLData);
            this.spektrumAddressCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.spektrumAddressCombo.setItems(this.spektrumAddresses);
            this.spektrumAddressCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.spektrumAddressCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "spektrumAddrssCombo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.spektrumNumber = (byte)Integer.parseInt(UniLog2SetupConfiguration2.this.spektrumAddressCombo.getText().trim());
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.fillerComposite = new Composite((Composite)this.spektrumAdapterGroup, 0);
            fillerCompositeRA1LData = new RowData();
            fillerCompositeRA1LData.width = 280;
            fillerCompositeRA1LData.height = 2;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRA1LData);
            this.fillerComposite = new Composite((Composite)this.spektrumAdapterGroup, 0);
            fillerCompositeRA1LData = new RowData();
            fillerCompositeRA1LData.width = this.fillerWidth;
            fillerCompositeRA1LData.height = 20;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRA1LData);
            this.spektrumEscSensor = new Button((Composite)this.spektrumAdapterGroup, 16416);
            analogAlarm1DirectionButtonLData = new RowData();
            analogAlarm1DirectionButtonLData.width = 280 - this.fillerWidth;
            analogAlarm1DirectionButtonLData.height = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
            this.spektrumEscSensor.setLayoutData((Object)analogAlarm1DirectionButtonLData);
            this.spektrumEscSensor.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.spektrumEscSensor.setText(Messages.getString((String)"GDE_MSGT2596"));
            this.spektrumEscSensor.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "spektrumEscSensor.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.spektrumSensors = (byte)(UniLog2SetupConfiguration2.this.spektrumEscSensor.getSelection() ? UniLog2SetupConfiguration2.this.configuration.spektrumSensors & 0xFE : UniLog2SetupConfiguration2.this.configuration.spektrumSensors | 1);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.fillerComposite = new Composite((Composite)this.spektrumAdapterGroup, 0);
            fillerCompositeRA1LData = new RowData();
            fillerCompositeRA1LData.width = this.fillerWidth;
            fillerCompositeRA1LData.height = 20;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRA1LData);
            this.spektrumCurrentSensor = new Button((Composite)this.spektrumAdapterGroup, 16416);
            analogAlarm1DirectionButtonLData = new RowData();
            analogAlarm1DirectionButtonLData.width = 280 - this.fillerWidth;
            analogAlarm1DirectionButtonLData.height = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
            this.spektrumCurrentSensor.setLayoutData((Object)analogAlarm1DirectionButtonLData);
            this.spektrumCurrentSensor.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.spektrumCurrentSensor.setText(Messages.getString((String)"GDE_MSGT2597"));
            this.spektrumCurrentSensor.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "spektrumCurrentSensor.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.spektrumSensors = (byte)(UniLog2SetupConfiguration2.this.spektrumCurrentSensor.getSelection() ? UniLog2SetupConfiguration2.this.configuration.spektrumSensors & 0xFD : UniLog2SetupConfiguration2.this.configuration.spektrumSensors | 2);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.fillerComposite = new Composite((Composite)this.spektrumAdapterGroup, 0);
            fillerCompositeRA1LData = new RowData();
            fillerCompositeRA1LData.width = this.fillerWidth;
            fillerCompositeRA1LData.height = 20;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRA1LData);
            this.spektrumVarioSensor = new Button((Composite)this.spektrumAdapterGroup, 16416);
            analogAlarm1DirectionButtonLData = new RowData();
            analogAlarm1DirectionButtonLData.width = 280 - this.fillerWidth;
            analogAlarm1DirectionButtonLData.height = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
            this.spektrumVarioSensor.setLayoutData((Object)analogAlarm1DirectionButtonLData);
            this.spektrumVarioSensor.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.spektrumVarioSensor.setText(Messages.getString((String)"GDE_MSGT2598"));
            this.spektrumVarioSensor.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "spektrumVarioSensor.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.spektrumSensors = (byte)(UniLog2SetupConfiguration2.this.spektrumVarioSensor.getSelection() ? UniLog2SetupConfiguration2.this.configuration.spektrumSensors & 0xFB : UniLog2SetupConfiguration2.this.configuration.spektrumSensors | 4);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.fillerComposite = new Composite((Composite)this.spektrumAdapterGroup, 0);
            fillerCompositeRA1LData = new RowData();
            fillerCompositeRA1LData.width = this.fillerWidth;
            fillerCompositeRA1LData.height = 20;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRA1LData);
            this.spektrumLiPoMonitor = new Button((Composite)this.spektrumAdapterGroup, 16416);
            analogAlarm1DirectionButtonLData = new RowData();
            analogAlarm1DirectionButtonLData.width = 280 - this.fillerWidth;
            analogAlarm1DirectionButtonLData.height = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
            this.spektrumLiPoMonitor.setLayoutData((Object)analogAlarm1DirectionButtonLData);
            this.spektrumLiPoMonitor.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.spektrumLiPoMonitor.setText(Messages.getString((String)"GDE_MSGT2599"));
            this.spektrumLiPoMonitor.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "spektrumLiPoMonitor.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration2.this.configuration.spektrumSensors = (byte)(UniLog2SetupConfiguration2.this.spektrumLiPoMonitor.getSelection() ? UniLog2SetupConfiguration2.this.configuration.spektrumSensors & 0xF7 : UniLog2SetupConfiguration2.this.configuration.spektrumSensors | 8);
                    UniLog2SetupConfiguration2.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.layout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

