/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TaskItem;
import org.eclipse.swt.widgets.Widget;

public class TaskBar
extends Widget {
    int itemCount;
    TaskItem[] items = new TaskItem[4];

    TaskBar(Display display, int n) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.display = display;
        this.reskinWidget();
    }

    void createItem(TaskItem taskItem, int n) {
        if (n == -1) {
            n = this.itemCount;
        }
        if (0 > n || n > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            TaskItem[] taskItemArray = new TaskItem[this.items.length + 4];
            System.arraycopy(this.items, 0, taskItemArray, 0, this.items.length);
            this.items = taskItemArray;
        }
        System.arraycopy(this.items, n, this.items, n + 1, this.itemCount++ - n);
        this.items[n] = taskItem;
    }

    void createItems() {
    }

    void destroyItem(TaskItem taskItem) {
        int n;
        for (n = 0; n < this.itemCount && this.items[n] != taskItem; ++n) {
        }
        if (n == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
    }

    public TaskItem getItem(int n) {
        this.checkWidget();
        this.createItems();
        if (0 > n || n >= this.itemCount) {
            this.error(6);
        }
        return this.items[n];
    }

    public int getItemCount() {
        this.checkWidget();
        this.createItems();
        return this.itemCount;
    }

    public TaskItem getItem(Shell shell) {
        this.checkWidget();
        return null;
    }

    public TaskItem[] getItems() {
        this.checkWidget();
        this.createItems();
        TaskItem[] taskItemArray = new TaskItem[this.itemCount];
        System.arraycopy(this.items, 0, taskItemArray, 0, taskItemArray.length);
        return taskItemArray;
    }

    @Override
    void releaseChildren(boolean bl) {
        if (this.items != null) {
            for (int i = 0; i < this.items.length; ++i) {
                TaskItem taskItem = this.items[i];
                if (taskItem == null || taskItem.isDisposed()) continue;
                taskItem.release(false);
            }
            this.items = null;
        }
        super.releaseChildren(bl);
    }

    @Override
    void releaseParent() {
        super.releaseParent();
    }

    @Override
    void reskinChildren(int n) {
        if (this.items != null) {
            for (int i = 0; i < this.items.length; ++i) {
                TaskItem taskItem = this.items[i];
                if (taskItem == null) continue;
                taskItem.reskin(n);
            }
        }
        super.reskinChildren(n);
    }
}

