/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Dimension;
import java.awt.Shape;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xhtmlrenderer.context.StyleReference;
import org.xhtmlrenderer.css.style.derived.RectPropertySet;
import org.xhtmlrenderer.extend.NamespaceHandler;
import org.xhtmlrenderer.extend.UserInterface;
import org.xhtmlrenderer.layout.BoxBuilder;
import org.xhtmlrenderer.layout.Layer;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.pdf.ITextFontContext;
import org.xhtmlrenderer.pdf.ITextFontResolver;
import org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.xhtmlrenderer.pdf.ITextReplacedElementFactory;
import org.xhtmlrenderer.pdf.ITextTextRenderer;
import org.xhtmlrenderer.pdf.ITextUserAgent;
import org.xhtmlrenderer.pdf.PDFCreationListener;
import org.xhtmlrenderer.pdf.PDFEncryption;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.PageBox;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.render.ViewportBox;
import org.xhtmlrenderer.resource.XMLResource;
import org.xhtmlrenderer.simple.extend.XhtmlNamespaceHandler;
import org.xhtmlrenderer.util.Configuration;
import org.xml.sax.InputSource;

public class ITextRenderer {
    private static final float DEFAULT_DOTS_PER_POINT = 26.666666f;
    private static final int DEFAULT_DOTS_PER_PIXEL = 20;
    private final SharedContext _sharedContext;
    private final ITextOutputDevice _outputDevice;
    private org.w3c.dom.Document _doc;
    private BlockBox _root;
    private final float _dotsPerPoint;
    private Document _pdfDoc;
    private PdfWriter _writer;
    private PDFEncryption _pdfEncryption;
    private Character _pdfVersion;
    private Dimension _dim;
    private boolean scaleToFit;
    private final char[] validPdfVersions = new char[]{'2', '3', '4', '5', '6', '7'};
    private PDFCreationListener _listener;

    public ITextRenderer() {
        this(26.666666f, 20);
    }

    public ITextRenderer(float dotsPerPoint, int dotsPerPixel) {
        this._dotsPerPoint = dotsPerPoint;
        this._outputDevice = new ITextOutputDevice(this._dotsPerPoint);
        ITextUserAgent userAgent = new ITextUserAgent(this._outputDevice);
        this._sharedContext = new SharedContext();
        this._sharedContext.setUserAgentCallback(userAgent);
        this._sharedContext.setCss(new StyleReference(userAgent));
        userAgent.setSharedContext(this._sharedContext);
        this._outputDevice.setSharedContext(this._sharedContext);
        ITextFontResolver fontResolver = new ITextFontResolver(this._sharedContext);
        this._sharedContext.setFontResolver(fontResolver);
        ITextReplacedElementFactory replacedElementFactory = new ITextReplacedElementFactory(this._outputDevice);
        this._sharedContext.setReplacedElementFactory(replacedElementFactory);
        this._sharedContext.setTextRenderer(new ITextTextRenderer());
        this._sharedContext.setDPI(72.0f * this._dotsPerPoint);
        this._sharedContext.setDotsPerPixel(dotsPerPixel);
        this._sharedContext.setPrint(true);
        this._sharedContext.setInteractive(false);
    }

    public org.w3c.dom.Document getDocument() {
        return this._doc;
    }

    public ITextFontResolver getFontResolver() {
        return (ITextFontResolver)this._sharedContext.getFontResolver();
    }

    private org.w3c.dom.Document loadDocument(String uri) {
        return this._sharedContext.getUac().getXMLResource(uri).getDocument();
    }

    public void setDocument(String uri) {
        this.setDocument(this.loadDocument(uri), uri);
    }

    public void setDocument(org.w3c.dom.Document doc, String url) {
        this.setDocument(doc, url, new XhtmlNamespaceHandler());
    }

    public void setDocument(File file) throws IOException {
        File parent = file.getAbsoluteFile().getParentFile();
        this.setDocument(this.loadDocument(file.toURI().toURL().toExternalForm()), parent == null ? "" : parent.toURI().toURL().toExternalForm());
    }

    public void setDocument(byte[] bytes) throws IOException {
        ByteArrayInputStream inputStream2 = new ByteArrayInputStream(bytes);
        org.w3c.dom.Document dom = XMLResource.load(inputStream2).getDocument();
        this.setDocument(dom, "");
    }

    public void setDocumentFromString(String content) {
        this.setDocumentFromString(content, null);
    }

    public void setDocumentFromString(String content, String baseUrl) {
        InputSource is = new InputSource(new BufferedReader(new StringReader(content)));
        org.w3c.dom.Document dom = XMLResource.load(is).getDocument();
        this.setDocument(dom, baseUrl);
    }

    public void setDocument(org.w3c.dom.Document doc, String url, NamespaceHandler nsh) {
        this._doc = doc;
        this.getFontResolver().flushFontFaceFonts();
        this._sharedContext.reset();
        if (Configuration.isTrue("xr.cache.stylesheets", true)) {
            this._sharedContext.getCss().flushStyleSheets();
        } else {
            this._sharedContext.getCss().flushAllStyleSheets();
        }
        this._sharedContext.setBaseURL(url);
        this._sharedContext.setNamespaceHandler(nsh);
        this._sharedContext.getCss().setDocumentContext(this._sharedContext, this._sharedContext.getNamespaceHandler(), doc, new NullUserInterface());
        this.getFontResolver().importFontFaces(this._sharedContext.getCss().getFontFaceRules());
    }

    public PDFEncryption getPDFEncryption() {
        return this._pdfEncryption;
    }

    public void setPDFEncryption(PDFEncryption pdfEncryption) {
        this._pdfEncryption = pdfEncryption;
    }

    public void setPDFVersion(char _v) {
        for (int i2 = 0; i2 < this.validPdfVersions.length; ++i2) {
            if (_v != this.validPdfVersions[i2]) continue;
            this._pdfVersion = new Character(_v);
            return;
        }
        throw new IllegalArgumentException("Invalid PDF version character; use valid constants from PdfWriter (e.g. PdfWriter.VERSION_1_2)");
    }

    public char getPDFVersion() {
        return this._pdfVersion == null ? (char)'0' : this._pdfVersion.charValue();
    }

    public void layout() {
        LayoutContext c2 = this.newLayoutContext();
        BlockBox root2 = BoxBuilder.createRootBox(c2, this._doc);
        root2.setContainingBlock(new ViewportBox(this.getInitialExtents(c2)));
        root2.layout(c2);
        this._dim = root2.getLayer().getPaintingDimension(c2);
        root2.getLayer().trimEmptyPages(c2, this._dim.height);
        root2.getLayer().layoutPages(c2);
        this._root = root2;
    }

    private java.awt.Rectangle getInitialExtents(LayoutContext c2) {
        PageBox first = Layer.createPageBox(c2, "first");
        return new java.awt.Rectangle(0, 0, first.getContentWidth(c2), first.getContentHeight(c2));
    }

    private RenderingContext newRenderingContext() {
        RenderingContext result2 = this._sharedContext.newRenderingContextInstance();
        result2.setFontContext(new ITextFontContext());
        result2.setOutputDevice(this._outputDevice);
        this._sharedContext.getTextRenderer().setup(result2.getFontContext());
        result2.setRootLayer(this._root.getLayer());
        return result2;
    }

    private LayoutContext newLayoutContext() {
        LayoutContext result2 = this._sharedContext.newLayoutContextInstance();
        result2.setFontContext(new ITextFontContext());
        this._sharedContext.getTextRenderer().setup(result2.getFontContext());
        return result2;
    }

    public void createPDF(OutputStream os) throws DocumentException, IOException {
        this.createPDF(os, true, 0);
    }

    public void writeNextDocument() throws DocumentException, IOException {
        this.writeNextDocument(0);
    }

    public void writeNextDocument(int initialPageNo) throws DocumentException, IOException {
        List pages = this._root.getLayer().getPages();
        RenderingContext c2 = this.newRenderingContext();
        c2.setInitialPageNo(initialPageNo);
        PageBox firstPage = (PageBox)pages.get(0);
        Rectangle firstPageSize = new Rectangle(0.0f, 0.0f, (float)firstPage.getWidth(c2) / this._dotsPerPoint, (float)firstPage.getHeight(c2) / this._dotsPerPoint);
        this._outputDevice.setStartPageNo(this._writer.getPageNumber());
        this._pdfDoc.setPageSize(firstPageSize);
        this._pdfDoc.newPage();
        this.writePDF(pages, c2, firstPageSize, this._pdfDoc, this._writer);
    }

    public void finishPDF() {
        if (this._pdfDoc != null) {
            this.fireOnClose();
            this._pdfDoc.close();
        }
    }

    public void createPDF(OutputStream os, boolean finish) throws DocumentException, IOException {
        this.createPDF(os, finish, 0);
    }

    public void createPDF(OutputStream os, boolean finish, int initialPageNo) throws DocumentException, IOException {
        List pages = this._root.getLayer().getPages();
        RenderingContext c2 = this.newRenderingContext();
        c2.setInitialPageNo(initialPageNo);
        PageBox firstPage = (PageBox)pages.get(0);
        int pageWidth = this.calculateWidth(c2, firstPage);
        Rectangle firstPageSize = new Rectangle(0.0f, 0.0f, (float)pageWidth / this._dotsPerPoint, (float)firstPage.getHeight(c2) / this._dotsPerPoint);
        Document doc = new Document(firstPageSize, 0.0f, 0.0f, 0.0f, 0.0f);
        PdfWriter writer = PdfWriter.getInstance(doc, os);
        if (this._pdfVersion != null) {
            writer.setPdfVersion(this._pdfVersion.charValue());
        }
        if (this._pdfEncryption != null) {
            writer.setEncryption(this._pdfEncryption.getUserPassword(), this._pdfEncryption.getOwnerPassword(), this._pdfEncryption.getAllowedPrivileges(), this._pdfEncryption.getEncryptionType());
        }
        this._pdfDoc = doc;
        this._writer = writer;
        this.firePreOpen();
        doc.open();
        this.writePDF(pages, c2, firstPageSize, doc, writer);
        if (finish) {
            this.fireOnClose();
            doc.close();
        }
    }

    private int calculateWidth(RenderingContext c2, PageBox firstPage) {
        if (this.isScaleToFit()) {
            int pageWidth = firstPage.getWidth(c2);
            java.awt.Rectangle pageRec = firstPage.getPrintClippingBounds(c2);
            if (this._dim.getWidth() > pageRec.getWidth()) {
                RectPropertySet margin = firstPage.getMargin(c2);
                pageWidth = (int)(this._dim.getWidth() + (double)margin.left() + (double)margin.right());
            }
            return pageWidth;
        }
        return firstPage.getWidth(c2);
    }

    private void firePreOpen() {
        if (this._listener != null) {
            this._listener.preOpen(this);
        }
    }

    private void firePreWrite(int pageCount) {
        if (this._listener != null) {
            this._listener.preWrite(this, pageCount);
        }
    }

    private void fireOnClose() {
        if (this._listener != null) {
            this._listener.onClose(this);
        }
    }

    private void writePDF(List pages, RenderingContext c2, Rectangle firstPageSize, Document doc, PdfWriter writer) throws DocumentException, IOException {
        this._outputDevice.setRoot(this._root);
        this._outputDevice.start(this._doc);
        this._outputDevice.setWriter(writer);
        this._outputDevice.initializePage(writer.getDirectContent(), firstPageSize.getHeight());
        this._root.getLayer().assignPagePaintingPositions(c2, (short)2);
        int pageCount = this._root.getLayer().getPages().size();
        c2.setPageCount(pageCount);
        this.firePreWrite(pageCount);
        this.setDidValues(doc);
        for (int i2 = 0; i2 < pageCount; ++i2) {
            PageBox currentPage = (PageBox)pages.get(i2);
            c2.setPage(i2, currentPage);
            this.paintPage(c2, writer, currentPage);
            this._outputDevice.finishPage();
            if (i2 == pageCount - 1) continue;
            PageBox nextPage = (PageBox)pages.get(i2 + 1);
            int pageWidth = this.calculateWidth(c2, nextPage);
            Rectangle nextPageSize = new Rectangle(0.0f, 0.0f, (float)pageWidth / this._dotsPerPoint, (float)nextPage.getHeight(c2) / this._dotsPerPoint);
            doc.setPageSize(nextPageSize);
            doc.newPage();
            this._outputDevice.initializePage(writer.getDirectContent(), nextPageSize.getHeight());
        }
        this._outputDevice.finish(c2, this._root);
    }

    private void setDidValues(Document doc) {
        String v2 = this._outputDevice.getMetadataByName("title");
        if (v2 != null) {
            doc.addTitle(v2);
        }
        if ((v2 = this._outputDevice.getMetadataByName("author")) != null) {
            doc.addAuthor(v2);
        }
        if ((v2 = this._outputDevice.getMetadataByName("subject")) != null) {
            doc.addSubject(v2);
        }
        if ((v2 = this._outputDevice.getMetadataByName("keywords")) != null) {
            doc.addKeywords(v2);
        }
    }

    private void paintPage(RenderingContext c2, PdfWriter writer, PageBox page) throws IOException {
        this.provideMetadataToPage(writer, page);
        page.paintBackground(c2, 0, (short)2);
        page.paintMarginAreas(c2, 0, (short)2);
        page.paintBorder(c2, 0, (short)2);
        Shape working = this._outputDevice.getClip();
        java.awt.Rectangle content = page.getPrintClippingBounds(c2);
        if (this.isScaleToFit()) {
            int pageWidth = this.calculateWidth(c2, page);
            content.setSize(pageWidth, (int)content.getSize().getHeight());
        }
        this._outputDevice.clip(content);
        int top2 = -page.getPaintingTop() + page.getMarginBorderPadding(c2, 3);
        int left2 = page.getMarginBorderPadding(c2, 1);
        this._outputDevice.translate(left2, top2);
        this._root.getLayer().paint(c2);
        this._outputDevice.translate(-left2, -top2);
        this._outputDevice.setClip(working);
    }

    private void provideMetadataToPage(PdfWriter writer, PageBox page) throws IOException {
        byte[] metadata2 = null;
        if (page.getMetadata() != null) {
            try {
                String metadataBody = this.stringfyMetadata(page.getMetadata());
                if (metadataBody != null) {
                    metadata2 = this.createXPacket(this.stringfyMetadata(page.getMetadata())).getBytes("UTF-8");
                }
            }
            catch (UnsupportedEncodingException e2) {
                throw new RuntimeException(e2);
            }
        }
        if (metadata2 != null) {
            writer.setPageXmpMetadata(metadata2);
        }
    }

    private String stringfyMetadata(Element element) {
        Element target = ITextRenderer.getFirstChildElement(element);
        if (target == null) {
            return null;
        }
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter output = new StringWriter();
            transformer.transform(new DOMSource(target), new StreamResult(output));
            return output.toString();
        }
        catch (TransformerConfigurationException e2) {
            throw new RuntimeException(e2);
        }
        catch (TransformerException e3) {
            throw new RuntimeException(e3);
        }
    }

    private static Element getFirstChildElement(Element element) {
        for (Node n2 = element.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
            if (n2.getNodeType() != 1) continue;
            return (Element)n2;
        }
        return null;
    }

    private String createXPacket(String metadata2) {
        StringBuffer result2 = new StringBuffer(metadata2.length() + 50);
        result2.append("<?xpacket begin='\ufeff' id='W5M0MpCehiHzreSzNTczkc9d'?>\n");
        result2.append(metadata2);
        result2.append("\n<?xpacket end='r'?>");
        return result2.toString();
    }

    public ITextOutputDevice getOutputDevice() {
        return this._outputDevice;
    }

    public SharedContext getSharedContext() {
        return this._sharedContext;
    }

    public void exportText(Writer writer) throws IOException {
        RenderingContext c2 = this.newRenderingContext();
        c2.setPageCount(this._root.getLayer().getPages().size());
        this._root.exportText(c2, writer);
    }

    public BlockBox getRootBox() {
        return this._root;
    }

    public float getDotsPerPoint() {
        return this._dotsPerPoint;
    }

    public List findPagePositionsByID(Pattern pattern) {
        return this._outputDevice.findPagePositionsByID(this.newLayoutContext(), pattern);
    }

    public PDFCreationListener getListener() {
        return this._listener;
    }

    public void setListener(PDFCreationListener listener2) {
        this._listener = listener2;
    }

    public PdfWriter getWriter() {
        return this._writer;
    }

    public boolean isScaleToFit() {
        return this.scaleToFit;
    }

    public boolean setScaleToFit(boolean scaleToFit) {
        this.scaleToFit = scaleToFit;
        return this.scaleToFit;
    }

    private static final class NullUserInterface
    implements UserInterface {
        private NullUserInterface() {
        }

        @Override
        public boolean isHover(Element e2) {
            return false;
        }

        @Override
        public boolean isActive(Element e2) {
            return false;
        }

        @Override
        public boolean isFocus(Element e2) {
            return false;
        }
    }
}

