/*
 * Decompiled with CFR 0.152.
 */
package gde.device.nmea;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.DeviceDialog;
import gde.device.IDevice;
import gde.device.nmea.NMEAAdapterDialogTabItem;
import gde.messages.Messages;
import gde.ui.SWTResourceManager;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class NMEAAdapterDialog
extends DeviceDialog {
    static final Logger log = Logger.getLogger(NMEAAdapterDialog.class.getName());
    CTabFolder tabFolder;
    Button saveButton;
    Button closeButton;
    Button helpButton;
    CLabel timeZoneOffsetUTCLabel;
    CLabel timeZoneOffsetUTCUnit;
    CCombo timeZoneOffsetUTCCombo;
    final IDevice device;
    final Settings settings;
    int measurementsCount = 0;
    int offsetTimeZone = 0;
    final List<CTabItem> configurations = new ArrayList<CTabItem>();
    final String[] deltaUTC = new String[]{"  -12", "  -11", "  -10", "    -9", "    -8", "    -7", "    -6", "    -5", "    -4", "    -3", "    -2", "    -1", "     0", "   +1", "   +2", "   +3", "   +4", "   +5", "   +6", "   +7", "   +8", "   +9", " +10", " +11", " +12"};

    public NMEAAdapterDialog(Shell parent, IDevice useDevice) {
        super(parent);
        this.device = useDevice;
        this.settings = Settings.getInstance();
        for (int i = 1; i <= this.device.getChannelCount(); ++i) {
            int actualMeasurementCount = this.device.getNumberOfMeasurements(i);
            this.measurementsCount = actualMeasurementCount > this.measurementsCount ? actualMeasurementCount : this.measurementsCount;
        }
        this.offsetTimeZone = this.device.getUTCdelta();
    }

    public void open() {
        try {
            this.shellAlpha = Settings.getInstance().getDialogAlphaValue();
            this.isAlphaEnabled = Settings.getInstance().isDeviceDialogAlphaEnabled();
            log.log(Level.FINE, "dialogShell.isDisposed() " + String.valueOf(this.dialogShell == null ? "null" : Boolean.valueOf(this.dialogShell.isDisposed())));
            if (this.dialogShell == null || this.dialogShell.isDisposed()) {
                this.dialogShell = this.settings.isDeviceDialogsModal() ? new Shell(this.application.getShell(), 34912) : (this.settings.isDeviceDialogsOnTop() ? new Shell(this.application.getDisplay(), 18528) : new Shell(this.application.getDisplay(), 2144));
                SWTResourceManager.registerResourceUser((Widget)this.dialogShell);
                if (this.isAlphaEnabled) {
                    this.dialogShell.setAlpha(254);
                }
                FormLayout dialogShellLayout = new FormLayout();
                this.dialogShell.setLayout((Layout)dialogShellLayout);
                this.dialogShell.layout();
                this.dialogShell.setSize(310, 80 + this.measurementsCount * 28 + 40 + 80);
                this.dialogShell.setText(this.device.getName() + Messages.getString((String)"GDE_MSGT0273"));
                this.dialogShell.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.dialogShell.setImage(SWTResourceManager.getImage((String)"gde/resource/ToolBoxHot.gif"));
                this.dialogShell.addListener(31, new Listener(){

                    public void handleEvent(Event event) {
                        switch (event.detail) {
                            case 2: {
                                NMEAAdapterDialog.this.dialogShell.close();
                                event.detail = 0;
                                event.doit = false;
                            }
                        }
                    }
                });
                this.dialogShell.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent evt) {
                        log.log(Level.FINEST, "dialogShell.widgetDisposed, event=" + String.valueOf(evt));
                        if (NMEAAdapterDialog.this.device.isChangePropery()) {
                            String msg = Messages.getString((String)"GDE_MSGI0041", (Object[])new String[]{NMEAAdapterDialog.this.device.getPropertiesFileName()});
                            if (NMEAAdapterDialog.this.application.openYesNoMessageDialog(NMEAAdapterDialog.this.getDialogShell(), msg) == 64) {
                                log.log(Level.FINE, "SWT.YES");
                                NMEAAdapterDialog.this.device.storeDeviceProperties();
                                NMEAAdapterDialog.this.setClosePossible(true);
                            }
                        }
                        NMEAAdapterDialog.this.dispose();
                    }
                });
                this.dialogShell.addHelpListener(new HelpListener(){

                    public void helpRequested(HelpEvent evt) {
                        log.log(Level.FINER, "dialogShell.helpRequested, event=" + String.valueOf(evt));
                        NMEAAdapterDialog.this.application.openHelpDialog("NMEA-Adapter", "HelpInfo.html");
                    }
                });
                this.tabFolder = new CTabFolder((Composite)this.dialogShell, 0);
                for (int i = 0; i < this.device.getChannelCount(); ++i) {
                    this.configurations.add(new NMEAAdapterDialogTabItem(this.tabFolder, this, i + 1, this.device));
                }
                this.timeZoneOffsetUTCLabel = new CLabel((Composite)this.dialogShell, 131072);
                this.timeZoneOffsetUTCLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.timeZoneOffsetUTCLabel.setText(Messages.getString((String)"GDE_MSGT2111"));
                FormData timeZoneOffsetUTCLabelLData = new FormData();
                timeZoneOffsetUTCLabelLData.width = 120;
                timeZoneOffsetUTCLabelLData.height = 20;
                timeZoneOffsetUTCLabelLData.bottom = new FormAttachment(1000, 1000, -50);
                timeZoneOffsetUTCLabelLData.left = new FormAttachment(0, 1000, 15);
                this.timeZoneOffsetUTCLabel.setLayoutData((Object)timeZoneOffsetUTCLabelLData);
                this.timeZoneOffsetUTCCombo = new CCombo((Composite)this.dialogShell, 133120);
                this.timeZoneOffsetUTCCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.timeZoneOffsetUTCCombo.setItems(this.deltaUTC);
                FormData timeZoneOffsetUTCComboLData = new FormData();
                timeZoneOffsetUTCComboLData.width = 50;
                timeZoneOffsetUTCComboLData.height = 17;
                timeZoneOffsetUTCComboLData.bottom = new FormAttachment(1000, 1000, -50);
                timeZoneOffsetUTCComboLData.right = new FormAttachment(1000, 1000, -75);
                this.timeZoneOffsetUTCCombo.setLayoutData((Object)timeZoneOffsetUTCComboLData);
                this.timeZoneOffsetUTCCombo.select(this.offsetTimeZone + 12);
                this.timeZoneOffsetUTCCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "timeZoneOffsetUTCCombo.widgetSelected, event=" + String.valueOf(evt));
                        NMEAAdapterDialog.this.offsetTimeZone = NMEAAdapterDialog.this.timeZoneOffsetUTCCombo.getSelectionIndex() - 12;
                        NMEAAdapterDialog.this.device.setUTCdelta(NMEAAdapterDialog.this.offsetTimeZone);
                        NMEAAdapterDialog.this.saveButton.setEnabled(true);
                    }
                });
                this.timeZoneOffsetUTCUnit = new CLabel((Composite)this.dialogShell, 131072);
                this.timeZoneOffsetUTCUnit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.timeZoneOffsetUTCUnit.setText(Messages.getString((String)"GDE_MSGT2112"));
                FormData timeZoneOffsetUTCUnitLData = new FormData();
                timeZoneOffsetUTCUnitLData.width = 40;
                timeZoneOffsetUTCUnitLData.height = 20;
                timeZoneOffsetUTCUnitLData.bottom = new FormAttachment(1000, 1000, -50);
                timeZoneOffsetUTCUnitLData.right = new FormAttachment(1000, 1000, -20);
                this.timeZoneOffsetUTCUnit.setLayoutData((Object)timeZoneOffsetUTCUnitLData);
                this.saveButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData saveButtonLData = new FormData();
                saveButtonLData.width = 105;
                saveButtonLData.height = GDE.IS_MAC ? 33 : 30;
                saveButtonLData.left = new FormAttachment(0, 1000, 10);
                saveButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.saveButton.setLayoutData((Object)saveButtonLData);
                this.saveButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.saveButton.setText(Messages.getString((String)"GDE_MSGT0486"));
                this.saveButton.setEnabled(false);
                this.saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "saveButton.widgetSelected, event=" + String.valueOf(evt));
                        NMEAAdapterDialog.this.device.storeDeviceProperties();
                        NMEAAdapterDialog.this.saveButton.setEnabled(false);
                    }
                });
                this.helpButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData helpButtonLData = new FormData();
                helpButtonLData.width = GDE.IS_MAC ? 50 : 40;
                helpButtonLData.height = GDE.IS_MAC ? 33 : 30;
                helpButtonLData.left = new FormAttachment(0, 1000, GDE.IS_MAC ? 129 : 132);
                helpButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.helpButton.setLayoutData((Object)helpButtonLData);
                this.helpButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.helpButton.setImage(SWTResourceManager.getImage((String)"gde/resource/QuestionHot.gif"));
                this.helpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "helpButton.widgetSelected, event=" + String.valueOf(evt));
                        NMEAAdapterDialog.this.application.openHelpDialog("NMEA-Adapter", "HelpInfo.html");
                    }
                });
                this.closeButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData closeButtonLData = new FormData();
                closeButtonLData.width = 105;
                closeButtonLData.height = GDE.IS_MAC ? 33 : 30;
                closeButtonLData.right = new FormAttachment(1000, 1000, -10);
                closeButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.closeButton.setLayoutData((Object)closeButtonLData);
                this.closeButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.closeButton.setText(Messages.getString((String)"GDE_MSGT0485"));
                this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "closeButton.widgetSelected, event=" + String.valueOf(evt));
                        NMEAAdapterDialog.this.dialogShell.dispose();
                    }
                });
                FormData tabFolderLData = new FormData();
                tabFolderLData.top = new FormAttachment(0, 1000, 0);
                tabFolderLData.left = new FormAttachment(0, 1000, 0);
                tabFolderLData.right = new FormAttachment(1000, 1000, 0);
                tabFolderLData.bottom = new FormAttachment(1000, 1000, -80);
                this.tabFolder.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.tabFolder.setLayoutData((Object)tabFolderLData);
                this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "configTabFolder.widgetSelected, event=" + String.valueOf(evt));
                        int channelNumber = NMEAAdapterDialog.this.tabFolder.getSelectionIndex();
                        if (channelNumber >= 0 && channelNumber <= NMEAAdapterDialog.this.device.getChannelCount()) {
                            String configKey = ++channelNumber + " : " + ((CTabItem)evt.item).getText();
                            Channels channels = Channels.getInstance();
                            Channel activeChannel = channels.getActiveChannel();
                            if (activeChannel != null) {
                                log.log(Level.FINE, "activeChannel = " + activeChannel.getName() + " configKey = " + configKey);
                                RecordSet activeRecordSet = activeChannel.getActiveRecordSet();
                                if (activeRecordSet != null && activeChannel.getNumber() != channelNumber) {
                                    int answer = NMEAAdapterDialog.this.application.openYesNoMessageDialog(NMEAAdapterDialog.this.getDialogShell(), Messages.getString((String)"GDE_MSGI2100"));
                                    if (answer == 64) {
                                        String recordSetKey = activeRecordSet.getName();
                                        Channel tmpChannel = (Channel)channels.get((Object)channelNumber);
                                        if (tmpChannel != null) {
                                            log.log(Level.FINE, "move record set " + recordSetKey + " to channel/configuration " + channelNumber + " : " + configKey);
                                            tmpChannel.put((Object)recordSetKey, (Object)activeRecordSet.clone(channelNumber));
                                            activeChannel.remove(recordSetKey);
                                            channels.switchChannel(channelNumber, recordSetKey);
                                            RecordSet newActiveRecordSet = ((Channel)channels.get((Object)channelNumber)).getActiveRecordSet();
                                            if (newActiveRecordSet != null) {
                                                NMEAAdapterDialog.this.device.updateVisibilityStatus(newActiveRecordSet, false);
                                                NMEAAdapterDialog.this.device.makeInActiveDisplayable(newActiveRecordSet);
                                            }
                                        }
                                    }
                                    NMEAAdapterDialog.this.application.updateCurveSelectorTable();
                                }
                            }
                        }
                    }
                });
                try {
                    this.tabFolder.setSelection(Channels.getInstance().getActiveChannelNumber() - 1);
                }
                catch (RuntimeException e) {
                    this.tabFolder.setSelection(0);
                }
                this.dialogShell.setLocation(this.getParent().toDisplay(this.getParent().getSize().x / 2 - 175, 100));
                this.dialogShell.open();
            } else {
                this.dialogShell.setVisible(true);
                this.dialogShell.setActive();
            }
            Display display = this.dialogShell.getDisplay();
            while (!this.dialogShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void enableSaveButton(boolean enable) {
        this.saveButton.setEnabled(enable);
    }

    public Integer getTabFolderSelectionIndex() {
        return this.tabFolder.getSelectionIndex();
    }
}

