/*
 * Decompiled with CFR 0.152.
 */
package gde.device.bantam;

import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.InputTypes;
import gde.device.bantam.EStationDialog;
import gde.device.bantam.eStation;
import gde.exception.DataInconsitsentException;
import gde.io.LogViewReader;
import gde.log.Level;
import gde.messages.Messages;
import gde.utils.StringHelper;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.xml.bind.JAXBException;

public class eStationBC680W
extends eStation {
    public eStationBC680W(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        this.dialog = new EStationDialog(this.application.getShell(), this);
        this.ACCU_TYPES = new String[]{Messages.getString((String)"GDE_MSGT1403"), "", "", "", Messages.getString((String)"GDE_MSGT1404"), Messages.getString((String)"GDE_MSGT1405"), Messages.getString((String)"GDE_MSGT1406"), "Save", "Load"};
    }

    public eStationBC680W(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        this.dialog = new EStationDialog(this.application.getShell(), this);
        this.ACCU_TYPES = new String[]{Messages.getString((String)"GDE_MSGT1403"), "", "", "", Messages.getString((String)"GDE_MSGT1404"), Messages.getString((String)"GDE_MSGT1405"), Messages.getString((String)"GDE_MSGT1406"), "Save", "Load"};
    }

    @Override
    public HashMap<String, String> getConfigurationValues(HashMap<String, String> configData, byte[] dataBuffer) {
        configData.put("ext_temp_cut_off", "0");
        configData.put("wait_time", "0");
        configData.put("in_voltage_cut_off", "0");
        configData.put("safety_time", "0");
        configData.put("capacity_cut_off", "0");
        if (this.getProcessingMode(dataBuffer) != 0) {
            configData.put("battery_type", this.ACCU_TYPES[this.getAccuCellType(dataBuffer)]);
            configData.put("processing_time", "" + ((dataBuffer[9] & 0x7F) * 100 + (dataBuffer[10] & 0x7F)));
        }
        if (log.isLoggable(Level.FINE)) {
            for (Map.Entry<String, String> entry : configData.entrySet()) {
                log.log(Level.FINE, entry.getKey() + " = " + entry.getValue());
            }
        }
        return configData;
    }

    @Override
    public EStationDialog getDialog() {
        return this.dialog;
    }

    @Override
    public int getLovDataByteSize() {
        return 120;
    }

    @Override
    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int deviceDataBufferSize = Math.abs(this.getDataBlockSize(InputTypes.SERIAL_IO));
        int[] points = new int[this.getNumberOfMeasurements(1)];
        int offset = 0;
        int progressCycle = 0;
        int lovDataSize = this.getLovDataByteSize();
        long lastDateTime = 0L;
        long sumTimeDelta = 0L;
        long deltaTime = 0L;
        if (dataBuffer[0] == 123) {
            byte[] convertBuffer = new byte[deviceDataBufferSize];
            if (doUpdateProgressBar) {
                this.application.setProgress(progressCycle, sThreadId);
            }
            for (int i = 0; i < recordDataSize; ++i) {
                System.arraycopy(dataBuffer, offset + i * lovDataSize, convertBuffer, 0, deviceDataBufferSize);
                recordSet.addPoints(this.convertDataBytes(points, convertBuffer));
                if (!doUpdateProgressBar || i % 50 != 0) continue;
                this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
            }
            recordSet.setTimeStep_ms(this.getAverageTimeStep_ms() != null ? this.getAverageTimeStep_ms() : 1478.0);
        } else {
            byte[] sizeBuffer = new byte[4];
            byte[] convertBuffer = new byte[deviceDataBufferSize];
            if (doUpdateProgressBar) {
                this.application.setProgress(progressCycle, sThreadId);
            }
            for (int i = 0; i < recordDataSize; ++i) {
                System.arraycopy(dataBuffer, offset, sizeBuffer, 0, 4);
                lovDataSize = 4 + LogViewReader.parse2Int((byte[])sizeBuffer);
                System.arraycopy(dataBuffer, offset + 4, convertBuffer, 0, deviceDataBufferSize);
                recordSet.addPoints(this.convertDataBytes(points, convertBuffer));
                StringBuilder sb = new StringBuilder();
                byte[] timeBuffer = new byte[lovDataSize - deviceDataBufferSize - 4];
                System.arraycopy(dataBuffer, (offset += lovDataSize) - timeBuffer.length, timeBuffer, 0, timeBuffer.length);
                String timeStamp = new String(timeBuffer).substring(0, timeBuffer.length - 8) + "0000000000";
                long dateTime = Long.parseLong(timeStamp.substring(6, 17));
                log.log(Level.FINEST, timeStamp + " " + timeStamp.substring(6, 17) + " " + dateTime);
                sb.append(dateTime);
                deltaTime = lastDateTime == 0L ? 0L : (dateTime - lastDateTime) / 1000L - 217L;
                sb.append(" - ").append(deltaTime);
                sb.append(" - ").append(sumTimeDelta += deltaTime);
                log.log(Level.FINER, sb.toString());
                lastDateTime = dateTime;
                recordSet.addTimeStep_ms((double)sumTimeDelta);
                if (!doUpdateProgressBar || i % 50 != 0) continue;
                this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
            }
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        this.updateVisibilityStatus(recordSet, true);
        recordSet.syncScaleOfSyncableRecords();
    }

    @Override
    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        int maxVotage = Integer.MIN_VALUE;
        int minVotage = Integer.MAX_VALUE;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, StringHelper.byte2FourDigitsIntegerString((byte[])dataBuffer, (byte)-128, (int)1, (int)(dataBuffer.length - 2)));
        }
        points[0] = (((dataBuffer[15] & 0xFF) - 128) * 100 + ((dataBuffer[16] & 0xFF) - 128)) * 10;
        points[1] = (((dataBuffer[11] & 0xFF) - 128) * 100 + ((dataBuffer[12] & 0xFF) - 128)) * 10;
        points[2] = (((dataBuffer[7] & 0xFF) - 128) * 100 + ((dataBuffer[8] & 0xFF) - 128)) * 1000;
        points[3] = Double.valueOf((double)points[0] / 1000.0 * ((double)points[1] / 1000.0) * 1000.0).intValue();
        points[4] = Double.valueOf((double)points[0] / 1000.0 * ((double)points[2] / 1000.0)).intValue();
        points[5] = (((dataBuffer[13] & 0xFF) - 128) * 100 + ((dataBuffer[14] & 0xFF) - 128)) * 10;
        points[6] = (((dataBuffer[4] & 0xFF) - 128) * 100 + ((dataBuffer[5] & 0xFF) - 128)) * 10;
        points[7] = 0;
        int i = 0;
        int j = 0;
        while (i < 6) {
            points[i + 8] = (((dataBuffer[j + 19] & 0xFF) - 128) * 100 + ((dataBuffer[j + 20] & 0xFF) - 128)) * 10;
            if (points[i + 8] > 0) {
                maxVotage = points[i + 8] > maxVotage ? points[i + 8] : maxVotage;
                minVotage = points[i + 8] < minVotage ? points[i + 8] : minVotage;
            }
            ++i;
            j += 2;
        }
        points[7] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
        return points;
    }

    @Override
    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int progressCycle = 0;
        Vector<Integer> timeStamps = new Vector<Integer>(1, 1);
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        int timeStampBufferSize = 0;
        if (!recordSet.isTimeStepConstant()) {
            timeStampBufferSize = 4 * recordDataSize;
            byte[] timeStampBuffer = new byte[timeStampBufferSize];
            System.arraycopy(dataBuffer, 0, timeStampBuffer, 0, timeStampBufferSize);
            for (int i = 0; i < recordDataSize; ++i) {
                timeStamps.add(((timeStampBuffer[0 + i * 4] & 0xFF) << 24) + ((timeStampBuffer[1 + i * 4] & 0xFF) << 16) + ((timeStampBuffer[2 + i * 4] & 0xFF) << 8) + ((timeStampBuffer[3 + i * 4] & 0xFF) << 0));
                if (!doUpdateProgressBar || i % 50 != 0) continue;
                this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
            }
        }
        log.log(Level.FINE, timeStamps.size() + " timeStamps = " + timeStamps.toString());
        for (int i = 0; i < recordDataSize; ++i) {
            log.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize + timeStampBufferSize);
            System.arraycopy(dataBuffer, i * dataBufferSize + timeStampBufferSize, convertBuffer, 0, dataBufferSize);
            points[0] = ((convertBuffer[0] & 0xFF) << 24) + ((convertBuffer[1] & 0xFF) << 16) + ((convertBuffer[2] & 0xFF) << 8) + ((convertBuffer[3] & 0xFF) << 0);
            points[1] = ((convertBuffer[4] & 0xFF) << 24) + ((convertBuffer[5] & 0xFF) << 16) + ((convertBuffer[6] & 0xFF) << 8) + ((convertBuffer[7] & 0xFF) << 0);
            points[2] = ((convertBuffer[8] & 0xFF) << 24) + ((convertBuffer[9] & 0xFF) << 16) + ((convertBuffer[10] & 0xFF) << 8) + ((convertBuffer[11] & 0xFF) << 0);
            points[3] = Double.valueOf((double)points[0] / 1000.0 * ((double)points[1] / 1000.0) * 1000.0).intValue();
            points[4] = Double.valueOf((double)points[0] / 1000.0 * ((double)points[2] / 1000.0)).intValue();
            points[5] = ((convertBuffer[12] & 0xFF) << 24) + ((convertBuffer[13] & 0xFF) << 16) + ((convertBuffer[14] & 0xFF) << 8) + ((convertBuffer[15] & 0xFF) << 0);
            points[6] = ((convertBuffer[16] & 0xFF) << 24) + ((convertBuffer[17] & 0xFF) << 16) + ((convertBuffer[18] & 0xFF) << 8) + ((convertBuffer[19] & 0xFF) << 0);
            points[7] = 0;
            int maxVotage = Integer.MIN_VALUE;
            int minVotage = Integer.MAX_VALUE;
            int j = 0;
            int k = 0;
            while (j < 6) {
                points[j + 8] = ((convertBuffer[k + 20] & 0xFF) << 24) + ((convertBuffer[k + 21] & 0xFF) << 16) + ((convertBuffer[k + 22] & 0xFF) << 8) + ((convertBuffer[k + 23] & 0xFF) << 0);
                if (points[j + 8] > 0) {
                    maxVotage = points[j + 8] > maxVotage ? points[j + 8] : maxVotage;
                    minVotage = points[j + 8] < minVotage ? points[j + 8] : minVotage;
                }
                ++j;
                k += 4;
            }
            int n = points[7] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
            if (recordSet.isTimeStepConstant()) {
                recordSet.addPoints(points);
            } else {
                recordSet.addPoints(points, (double)((Integer)timeStamps.get(i)).intValue() / 10.0);
            }
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    @Override
    boolean isCycleMode(byte[] dataBuffer) {
        return ((dataBuffer[8] & 0xFF) - 128 & 0x10) > 0;
    }

    @Override
    public int getNumberOfCycle(byte[] dataBuffer) {
        return 0;
    }

    @Override
    public int getAccuCellType(byte[] dataBuffer) {
        return (dataBuffer[2] & 0xFF) - 128;
    }

    @Override
    public boolean isProcessing(byte[] dataBuffer) {
        return (dataBuffer[1] & 0xFF) - 128 > 0;
    }

    @Override
    public int getProcessingMode(byte[] dataBuffer) {
        int modeIndex = (dataBuffer[1] & 0xFF) - 128;
        if (modeIndex != 0) {
            modeIndex = (dataBuffer[1] & 0xF) == 2 ? 2 : 1;
        }
        return modeIndex;
    }

    @Override
    public int getProcessingTime(byte[] dataBuffer) {
        return (dataBuffer[9] & 0x7F) * 100 + (dataBuffer[10] & 0x7F);
    }

    @Override
    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        int i;
        int displayableCounter = 0;
        recordSet.setAllDisplayable();
        for (String recordKey : recordSet.getNoneCalculationRecordNames()) {
            recordSet.get((Object)recordKey).setActive(Boolean.valueOf(true));
        }
        for (i = 5; i < recordSet.size(); ++i) {
            Record record = recordSet.get(i);
            record.setDisplayable(record.hasReasonableData());
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, record.getName() + " setDisplayable=" + record.hasReasonableData());
            }
            if (!record.isActive() || !record.isDisplayable()) continue;
            ++displayableCounter;
        }
        if (log.isLoggable(Level.FINE)) {
            for (i = 0; i < recordSet.size(); ++i) {
                Record record = recordSet.get(i);
                log.log(Level.FINE, record.getName() + " isActive=" + record.isActive() + " isVisible=" + record.isVisible() + " isDisplayable=" + record.isDisplayable());
            }
        }
        recordSet.setConfiguredDisplayable(displayableCounter);
    }
}

