/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTView;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Sash
extends Control {
    Cursor sizeCursor;
    boolean dragging;
    int lastX;
    int lastY;
    int startX;
    int startY;
    private static final int INCREMENT = 1;
    private static final int PAGE_INCREMENT = 9;
    NSArray accessibilityAttributes = null;

    public Sash(Composite composite, int n) {
        super(composite, Sash.checkStyle(n));
        int n2 = (n & 0x200) != 0 ? 9 : 7;
        this.sizeCursor = new Cursor(this.display, n2);
    }

    int accessibilityAttributeNames(int n, int n2) {
        if (this.accessibilityAttributes == null) {
            NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(10);
            nSMutableArray.addObject(OS.NSAccessibilityRoleAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityRoleDescriptionAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityParentAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityPositionAttribute);
            nSMutableArray.addObject(OS.NSAccessibilitySizeAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityWindowAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityTopLevelUIElementAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityFocusedAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityValueAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityMaxValueAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityMinValueAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityNextContentsAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityPreviousContentsAttribute);
            nSMutableArray.addObject(OS.NSAccessibilityOrientationAttribute);
            if (this.accessible != null) {
                NSMutableArray nSMutableArray2 = NSMutableArray.arrayWithCapacity(3);
                nSMutableArray2.addObject(OS.NSAccessibilityHelpAttribute);
                nSMutableArray2.addObject(OS.NSAccessibilityDescriptionAttribute);
                nSMutableArray2.addObject(OS.NSAccessibilityTitleAttribute);
                for (int i = nSMutableArray2.count() - 1; i >= 0; --i) {
                    NSString nSString = new NSString(nSMutableArray2.objectAtIndex((int)i).id);
                    if (this.accessible.internal_accessibilityAttributeValue(nSString, -1) == null) continue;
                    nSMutableArray.addObject(nSMutableArray2.objectAtIndex(i));
                }
            }
            this.accessibilityAttributes = nSMutableArray;
            this.accessibilityAttributes.retain();
        }
        return this.accessibilityAttributes.id;
    }

    int accessibilityAttributeValue(int n, int n2, int n3) {
        Control[] controlArray;
        int n4 = 0;
        NSString nSString = new NSString(n3);
        if (this.accessible != null && (controlArray = this.accessible.internal_accessibilityAttributeValue(nSString, -1)) != null) {
            n4 = controlArray.id;
        }
        if (n4 != 0) {
            return n4;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityRoleAttribute) || nSString.isEqualToString(OS.NSAccessibilityRoleDescriptionAttribute)) {
            controlArray = OS.NSAccessibilitySplitterRole;
            if (nSString.isEqualToString(OS.NSAccessibilityRoleAttribute)) {
                return controlArray.id;
            }
            return OS.NSAccessibilityRoleDescription(controlArray.id, 0);
        }
        if (nSString.isEqualToString(OS.NSAccessibilityEnabledAttribute)) {
            return NSNumber.numberWithBool((boolean)this.isEnabled()).id;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityOrientationAttribute)) {
            controlArray = (this.style & 0x200) != 0 ? OS.NSAccessibilityVerticalOrientationValue : OS.NSAccessibilityHorizontalOrientationValue;
            return controlArray.id;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityValueAttribute)) {
            controlArray = this.getLocation();
            int n5 = (this.style & 0x200) != 0 ? controlArray.x : controlArray.y;
            return NSNumber.numberWithInt((int)n5).id;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityMaxValueAttribute)) {
            controlArray = this.parent.topView().frame();
            float f = (this.style & 0x200) != 0 ? controlArray.width : controlArray.height;
            return NSNumber.numberWithDouble((double)((double)f)).id;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityMinValueAttribute)) {
            return NSNumber.numberWithInt((int)0).id;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityNextContentsAttribute)) {
            controlArray = this.parent._getChildren();
            Control control = null;
            for (int i = 0; i < controlArray.length; ++i) {
                if (controlArray[i] != this || i >= controlArray.length - 1) continue;
                control = controlArray[i + 1];
                break;
            }
            if (control != null) {
                return NSArray.arrayWithObject((id)control.view).id;
            }
            return NSArray.array().id;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityPreviousContentsAttribute)) {
            controlArray = this.parent._getChildren();
            Control control = null;
            for (int i = 0; i < controlArray.length; ++i) {
                if (controlArray[i] != this || i <= 0) continue;
                control = controlArray[i - 1];
                break;
            }
            if (control != null) {
                return NSArray.arrayWithObject((id)control.view).id;
            }
            return NSArray.array().id;
        }
        return super.accessibilityAttributeValue(n, n2, n3);
    }

    boolean accessibilityIsIgnored(int n, int n2) {
        return false;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return Sash.checkBits(n |= 0x10000, 256, 512, 0, 0, 0, 0);
    }

    boolean becomeFirstResponder(int n, int n2) {
        boolean bl = super.becomeFirstResponder(n, n2);
        NSRect nSRect = this.view.frame();
        this.lastX = (int)nSRect.x;
        this.lastY = (int)nSRect.y;
        return bl;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        if ((this.style & 0x100) != 0) {
            n3 += 64;
            n4 += 5;
        } else {
            n3 += 5;
            n4 += 64;
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        return new Point(n3, n4);
    }

    void createHandle() {
        this.state |= 0x800;
        NSView nSView = (NSView)new SWTView().alloc();
        nSView.init();
        this.view = nSView;
    }

    void drawBackground(int n, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
        if (n != this.view.id) {
            return;
        }
        this.fillBackground(this.view, nSGraphicsContext, nSRect, -1);
    }

    Cursor findCursor() {
        Cursor cursor = super.findCursor();
        if (cursor == null) {
            int n = (this.style & 0x100) != 0 ? 7 : 9;
            cursor = this.display.getSystemCursor(n);
        }
        return cursor;
    }

    boolean sendKeyEvent(NSEvent nSEvent, int n) {
        super.sendKeyEvent(nSEvent, n);
        if (n == 1) {
            short s = nSEvent.keyCode();
            switch (s) {
                case 123: 
                case 124: 
                case 125: 
                case 126: {
                    int n2 = 0;
                    int n3 = 0;
                    int n4 = 9;
                    int n5 = nSEvent.modifierFlags();
                    if ((n5 & 0x40000) != 0) {
                        n4 = 1;
                    }
                    if ((this.style & 0x200) != 0) {
                        if (s == 126 || s == 125) break;
                        n2 = s == 123 ? -n4 : n4;
                    } else {
                        if (s == 123 || s == 124) break;
                        n3 = s == 126 ? -n4 : n4;
                    }
                    Rectangle rectangle = this.getBounds();
                    int n6 = rectangle.width;
                    int n7 = rectangle.height;
                    Rectangle rectangle2 = this.parent.getBounds();
                    int n8 = rectangle2.width;
                    int n9 = rectangle2.height;
                    int n10 = this.lastX;
                    int n11 = this.lastY;
                    if ((this.style & 0x200) != 0) {
                        n10 = Math.min(Math.max(0, this.lastX + n2), n8 - n6);
                    } else {
                        n11 = Math.min(Math.max(0, this.lastY + n3), n9 - n7);
                    }
                    if (n10 == this.lastX && n11 == this.lastY) {
                        return true;
                    }
                    Event event = new Event();
                    event.x = n10;
                    event.y = n11;
                    event.width = n6;
                    event.height = n7;
                    this.sendSelectionEvent(13, event, true);
                    if (this.isDisposed() || !event.doit) break;
                    this.setBounds(event.x, event.y, n6, n7);
                    if (this.isDisposed()) break;
                    this.lastX = event.x;
                    this.lastY = event.y;
                    if (this.isDisposed()) {
                        return false;
                    }
                    int n12 = event.x;
                    int n13 = event.y;
                    if ((this.style & 0x200) != 0) {
                        n13 += n7 / 2;
                    } else {
                        n12 += n6 / 2;
                    }
                    this.display.setCursorLocation(this.parent.toDisplay(n12, n13));
                    break;
                }
            }
        }
        return true;
    }

    void mouseDown(int n, int n2, int n3) {
        super.mouseDown(n, n2, n3);
        if (this.isDisposed()) {
            return;
        }
        NSEvent nSEvent = new NSEvent(n3);
        if (nSEvent.clickCount() != 1) {
            return;
        }
        NSPoint nSPoint = nSEvent.locationInWindow();
        NSPoint nSPoint2 = this.view.convertPoint_fromView_(nSPoint, null);
        this.startX = (int)nSPoint2.x;
        this.startY = (int)nSPoint2.y;
        NSRect nSRect = this.view.frame();
        Event event = new Event();
        event.x = (int)nSRect.x;
        event.y = (int)nSRect.y;
        event.width = (int)nSRect.width;
        event.height = (int)nSRect.height;
        this.sendSelectionEvent(13, event, true);
        if (this.isDisposed()) {
            return;
        }
        if (event.doit) {
            this.lastX = event.x;
            this.lastY = event.y;
            this.dragging = true;
            this.setLocation(event.x, event.y);
        }
    }

    boolean mouseEvent(int n, int n2, int n3, int n4) {
        super.mouseEvent(n, n2, n3, n4);
        return new NSEvent(n3).type() != 1;
    }

    void mouseDragged(int n, int n2, int n3) {
        super.mouseDragged(n, n2, n3);
        if (this.isDisposed()) {
            return;
        }
        if (!this.dragging) {
            return;
        }
        NSEvent nSEvent = new NSEvent(n3);
        NSPoint nSPoint = nSEvent.locationInWindow();
        NSPoint nSPoint2 = this.view.convertPoint_fromView_(nSPoint, null);
        NSRect nSRect = this.view.frame();
        NSRect nSRect2 = this.parent.topView().frame();
        int n4 = this.lastX;
        int n5 = this.lastY;
        if ((this.style & 0x200) != 0) {
            n4 = Math.min(Math.max(0, (int)(nSPoint2.x + nSRect.x - (float)this.startX)), (int)(nSRect2.width - nSRect.width));
        } else {
            n5 = Math.min(Math.max(0, (int)(nSPoint2.y + nSRect.y - (float)this.startY)), (int)(nSRect2.height - nSRect.height));
        }
        if (n4 == this.lastX && n5 == this.lastY) {
            return;
        }
        Event event = new Event();
        event.x = n4;
        event.y = n5;
        event.width = (int)nSRect.width;
        event.height = (int)nSRect.height;
        this.sendSelectionEvent(13, event, true);
        if (this.isDisposed()) {
            return;
        }
        if (event.doit) {
            this.lastX = event.x;
            this.lastY = event.y;
            this.setBounds(event.x, event.y, (int)nSRect.width, (int)nSRect.height);
        }
    }

    void mouseUp(int n, int n2, int n3) {
        super.mouseUp(n, n2, n3);
        if (this.isDisposed()) {
            return;
        }
        if (!this.dragging) {
            return;
        }
        this.dragging = false;
        NSRect nSRect = this.view.frame();
        Event event = new Event();
        event.x = this.lastX;
        event.y = this.lastY;
        event.width = (int)nSRect.width;
        event.height = (int)nSRect.height;
        this.sendSelectionEvent(13, event, true);
        if (this.isDisposed()) {
            return;
        }
        if (event.doit) {
            this.setBounds(event.x, event.y, (int)nSRect.width, (int)nSRect.height);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.accessibilityAttributes != null) {
            this.accessibilityAttributes.release();
        }
        this.accessibilityAttributes = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.sizeCursor != null) {
            this.sizeCursor.dispose();
        }
        this.sizeCursor = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void superKeyDown(int n, int n2, int n3) {
    }

    void superKeyUp(int n, int n2, int n3) {
    }

    int traversalCode(int n, NSEvent nSEvent) {
        return 0;
    }
}

