/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSColorList;
import org.eclipse.swt.internal.cocoa.NSColorPanel;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTPanelDelegate;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    RGB rgb;
    RGB[] rgbs;
    boolean selected;

    public ColorDialog(Shell shell) {
        this(shell, 65536);
    }

    public ColorDialog(Shell shell, int n) {
        super(shell, ColorDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    void changeColor(int n, int n2, int n3) {
        this.selected = true;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB[] getRGBs() {
        return this.rgbs;
    }

    public RGB open() {
        NSColor nSColor;
        NSObject nSObject;
        Object object;
        int n;
        NSObject nSObject2;
        NSColorList nSColorList;
        NSObject nSObject3;
        Display display;
        NSColorPanel nSColorPanel = NSColorPanel.sharedColorPanel();
        Display display2 = display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        if (this.rgb != null) {
            nSObject3 = NSColor.colorWithDeviceRed((float)this.rgb.red / 255.0f, (float)this.rgb.green / 255.0f, (float)this.rgb.blue / 255.0f, 1.0f);
            nSColorPanel.setColor((NSColor)nSObject3);
        }
        if ((nSColorList = NSColorList.colorListNamed((NSString)(nSObject3 = Display.getApplicationName()))) == null) {
            nSColorList = (NSColorList)new NSColorList().alloc();
            nSColorList.initWithName((NSString)nSObject3);
            nSColorPanel.attachColorList(nSColorList);
        } else {
            nSColorList.retain();
        }
        if (this.rgbs != null) {
            int n2;
            nSObject2 = nSColorList.allKeys();
            n = ((NSArray)nSObject2).count();
            for (n2 = n - 1; n2 >= 0; --n2) {
                nSColorList.removeColorWithKey(new NSString(((NSArray)nSObject2).objectAtIndex(n2)));
            }
            for (n2 = 0; n2 < this.rgbs.length; ++n2) {
                object = this.rgbs[n2];
                if (object == null) continue;
                NSColor nSColor2 = NSColor.colorWithDeviceRed((float)((RGB)object).red / 255.0f, (float)((RGB)object).green / 255.0f, (float)((RGB)object).blue / 255.0f, 1.0f);
                nSObject = nSObject3;
                if (n2 > 0) {
                    nSObject = ((NSString)nSObject).stringByAppendingString(NSString.stringWith(" " + n2));
                }
                nSColorList.insertColor(nSColor2, (NSString)nSObject, n2);
            }
        }
        nSObject2 = (SWTPanelDelegate)new SWTPanelDelegate().alloc().init();
        n = OS.NewGlobalRef(this);
        if (n == 0) {
            this.error(2);
        }
        OS.object_setInstanceVariable(((SWTPanelDelegate)nSObject2).id, Display.SWT_OBJECT, n);
        nSColorPanel.setDelegate(nSObject2);
        this.rgb = null;
        this.selected = false;
        nSColorPanel.orderFront(null);
        display.setModalDialog(this);
        NSApplication.sharedApplication().runModalForWindow(nSColorPanel);
        display.setModalDialog(null);
        nSColorPanel.setDelegate(null);
        nSObject2.release();
        OS.DeleteGlobalRef(n);
        if (this.selected && (nSColor = nSColorPanel.color()) != null) {
            object = display.getNSColorRGB(nSColor);
            this.rgb = new RGB((int)(object[0] * 255.0f), (int)(object[1] * 255.0f), (int)(object[2] * 255.0f));
        }
        NSArray nSArray = nSColorList.allKeys();
        int n3 = nSArray.count();
        this.rgbs = new RGB[n3];
        for (int i = 0; i < n3; ++i) {
            nSObject = new NSString(nSArray.objectAtIndex(i));
            float[] fArray = display.getNSColorRGB(nSColorList.colorWithKey((NSString)nSObject));
            this.rgbs[i] = new RGB((int)(fArray[0] * 255.0f), (int)(fArray[1] * 255.0f), (int)(fArray[2] * 255.0f));
        }
        nSColorList.release();
        return this.rgb;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }

    public void setRGBs(RGB[] rGBArray) {
        this.rgbs = rGBArray;
    }

    void windowWillClose(int n, int n2, int n3) {
        NSApplication.sharedApplication().stop(null);
    }
}

