/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple.xhtml.controls;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xhtmlrenderer.simple.xhtml.XhtmlForm;
import org.xhtmlrenderer.simple.xhtml.controls.AbstractControl;

public class SelectControl
extends AbstractControl {
    private int _size;
    private boolean _multiple;
    private List _values;
    private String _initialValue;
    private String[] _initialValues;
    private Map _options;

    public SelectControl(XhtmlForm form2, Element e2) {
        super(form2, e2);
        this._size = SelectControl.getIntAttribute(e2, "size", 1);
        boolean bl = this._multiple = e2.getAttribute("multiple").length() != 0;
        if (this._multiple) {
            this._values = new ArrayList();
        }
        super.setValue(null);
        this.setSuccessful(false);
        this._options = new LinkedHashMap();
        this.traverseOptions(e2, "");
        if (this._multiple) {
            this._initialValues = this.getMultipleValues();
            if (this._initialValues.length > 0) {
                this.setSuccessful(true);
            }
        } else {
            this._initialValue = this.getValue();
            if (this._initialValue != null) {
                this.setSuccessful(true);
            }
        }
    }

    private void traverseOptions(Element e2, String prefix) {
        NodeList children = e2.getChildNodes();
        for (int i2 = 0; i2 < children.getLength(); ++i2) {
            if (children.item(i2).getNodeType() != 1) continue;
            Element child = (Element)children.item(i2);
            if (child.getNodeName().equalsIgnoreCase("optgroup")) {
                this.traverseOptions(child, prefix + child.getAttribute("label") + " ");
                continue;
            }
            if (!child.getNodeName().equalsIgnoreCase("option")) continue;
            String value = child.getAttribute("value");
            String label2 = child.getAttribute("label");
            String content = SelectControl.collectText(child);
            if (value.length() == 0) {
                value = content;
            }
            label2 = label2.length() == 0 ? content : prefix.concat(label2);
            this._options.put(value, label2);
            if (child.getAttribute("selected").length() == 0) continue;
            if (this.isMultiple()) {
                if (this._values.contains(value)) continue;
                this._values.add(value);
                continue;
            }
            this.setValue(value);
        }
    }

    public int getSize() {
        return this._size;
    }

    @Override
    public boolean isMultiple() {
        return this._multiple;
    }

    public Map getOptions() {
        return new LinkedHashMap(this._options);
    }

    @Override
    public void setValue(String value) {
        if (!this.isMultiple()) {
            if (this._options.containsKey(value)) {
                super.setValue(value);
                this.setSuccessful(true);
            } else {
                this.setSuccessful(false);
                super.setValue(null);
            }
        }
    }

    @Override
    public String[] getMultipleValues() {
        if (this.isMultiple()) {
            return this._values.toArray(new String[this._values.size()]);
        }
        return null;
    }

    @Override
    public void setMultipleValues(String[] values2) {
        if (this.isMultiple()) {
            this._values.clear();
            for (int i2 = 0; i2 < values2.length; ++i2) {
                if (this._options.get(values2[i2]) == null || this._values.contains(values2[i2])) continue;
                this._values.add(values2[i2]);
            }
            if (this._values.isEmpty()) {
                this.setSuccessful(false);
            } else {
                this.setSuccessful(true);
            }
            this.fireChanged();
        }
    }

    @Override
    public void reset() {
        if (this.isMultiple()) {
            this.setMultipleValues(this._initialValues);
        } else {
            this.setValue(this._initialValue);
        }
    }
}

