/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.exceptions.UnsupportedPdfException;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.text.pdf.FilterHandlers;
import com.itextpdf.text.pdf.PRTokeniser;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfContentParser;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.parser.InlineImageInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class InlineImageUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(InlineImageUtils.class.getName());
    private static final Map<PdfName, PdfName> inlineImageEntryAbbreviationMap = new HashMap<PdfName, PdfName>();
    private static final Map<PdfName, PdfName> inlineImageColorSpaceAbbreviationMap;
    private static final Map<PdfName, PdfName> inlineImageFilterAbbreviationMap;

    private InlineImageUtils() {
    }

    public static InlineImageInfo parseInlineImage(PdfContentParser ps, PdfDictionary colorSpaceDic) throws IOException {
        PdfDictionary inlineImageDictionary = InlineImageUtils.parseInlineImageDictionary(ps);
        byte[] samples = InlineImageUtils.parseInlineImageSamples(inlineImageDictionary, colorSpaceDic, ps);
        return new InlineImageInfo(samples, inlineImageDictionary);
    }

    private static PdfDictionary parseInlineImageDictionary(PdfContentParser ps) throws IOException {
        PdfDictionary dictionary = new PdfDictionary();
        PdfObject key2 = ps.readPRObject();
        while (key2 != null && !"ID".equals(key2.toString())) {
            PdfObject value = ps.readPRObject();
            PdfName resolvedKey = inlineImageEntryAbbreviationMap.get(key2);
            if (resolvedKey == null) {
                resolvedKey = (PdfName)key2;
            }
            dictionary.put(resolvedKey, InlineImageUtils.getAlternateValue(resolvedKey, value));
            key2 = ps.readPRObject();
        }
        int ch = ps.getTokeniser().read();
        if (!PRTokeniser.isWhitespace(ch)) {
            throw new IOException("Unexpected character " + ch + " found after ID in inline image");
        }
        return dictionary;
    }

    private static PdfObject getAlternateValue(PdfName key2, PdfObject value) {
        PdfName altValue;
        if (key2 == PdfName.FILTER) {
            if (value instanceof PdfName) {
                PdfName altValue2 = inlineImageFilterAbbreviationMap.get(value);
                if (altValue2 != null) {
                    return altValue2;
                }
            } else if (value instanceof PdfArray) {
                PdfArray array = (PdfArray)value;
                PdfArray altArray = new PdfArray();
                int count = array.size();
                for (int i2 = 0; i2 < count; ++i2) {
                    altArray.add(InlineImageUtils.getAlternateValue(key2, array.getPdfObject(i2)));
                }
                return altArray;
            }
        } else if (key2 == PdfName.COLORSPACE && (altValue = inlineImageColorSpaceAbbreviationMap.get(value)) != null) {
            return altValue;
        }
        return value;
    }

    private static int getComponentsPerPixel(PdfName colorSpaceName, PdfDictionary colorSpaceDic) {
        if (colorSpaceName == null) {
            return 1;
        }
        if (colorSpaceName.equals(PdfName.DEVICEGRAY)) {
            return 1;
        }
        if (colorSpaceName.equals(PdfName.DEVICERGB)) {
            return 3;
        }
        if (colorSpaceName.equals(PdfName.DEVICECMYK)) {
            return 4;
        }
        if (colorSpaceDic != null) {
            PdfArray colorSpace = colorSpaceDic.getAsArray(colorSpaceName);
            if (colorSpace != null) {
                if (PdfName.INDEXED.equals(colorSpace.getAsName(0))) {
                    return 1;
                }
            } else {
                PdfName tempName = colorSpaceDic.getAsName(colorSpaceName);
                if (tempName != null) {
                    return InlineImageUtils.getComponentsPerPixel(tempName, colorSpaceDic);
                }
            }
        }
        throw new IllegalArgumentException("Unexpected color space " + colorSpaceName);
    }

    private static int computeBytesPerRow(PdfDictionary imageDictionary, PdfDictionary colorSpaceDic) {
        PdfNumber wObj = imageDictionary.getAsNumber(PdfName.WIDTH);
        PdfNumber bpcObj = imageDictionary.getAsNumber(PdfName.BITSPERCOMPONENT);
        int cpp = InlineImageUtils.getComponentsPerPixel(imageDictionary.getAsName(PdfName.COLORSPACE), colorSpaceDic);
        int w2 = wObj.intValue();
        int bpc = bpcObj != null ? bpcObj.intValue() : 1;
        int bytesPerRow = (w2 * bpc * cpp + 7) / 8;
        return bytesPerRow;
    }

    private static byte[] parseUnfilteredSamples(PdfDictionary imageDictionary, PdfDictionary colorSpaceDic, PdfContentParser ps) throws IOException {
        PdfObject ei2;
        if (imageDictionary.contains(PdfName.FILTER)) {
            throw new IllegalArgumentException("Dictionary contains filters");
        }
        PdfNumber h2 = imageDictionary.getAsNumber(PdfName.HEIGHT);
        int bytesToRead = InlineImageUtils.computeBytesPerRow(imageDictionary, colorSpaceDic) * h2.intValue();
        byte[] bytes = new byte[bytesToRead];
        PRTokeniser tokeniser = ps.getTokeniser();
        int shouldBeWhiteSpace = tokeniser.read();
        int startIndex = 0;
        if (!PRTokeniser.isWhitespace(shouldBeWhiteSpace) || shouldBeWhiteSpace == 0) {
            bytes[0] = (byte)shouldBeWhiteSpace;
            ++startIndex;
        }
        for (int i2 = startIndex; i2 < bytesToRead; ++i2) {
            int ch = tokeniser.read();
            if (ch == -1) {
                throw new InlineImageParseException("End of content stream reached before end of image data");
            }
            bytes[i2] = (byte)ch;
        }
        PdfObject ei = ps.readPRObject();
        if (!ei.toString().equals("EI") && !(ei2 = ps.readPRObject()).toString().equals("EI")) {
            throw new InlineImageParseException("EI not found after end of image data");
        }
        return bytes;
    }

    private static byte[] parseInlineImageSamples(PdfDictionary imageDictionary, PdfDictionary colorSpaceDic, PdfContentParser ps) throws IOException {
        int ch;
        if (!imageDictionary.contains(PdfName.FILTER)) {
            return InlineImageUtils.parseUnfilteredSamples(imageDictionary, colorSpaceDic, ps);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayOutputStream accumulated = new ByteArrayOutputStream();
        int found = 0;
        PRTokeniser tokeniser = ps.getTokeniser();
        while ((ch = tokeniser.read()) != -1) {
            if (found == 0 && PRTokeniser.isWhitespace(ch)) {
                ++found;
                accumulated.write(ch);
                continue;
            }
            if (found == 1 && ch == 69) {
                ++found;
                accumulated.write(ch);
                continue;
            }
            if (found == 1 && PRTokeniser.isWhitespace(ch)) {
                baos.write(accumulated.toByteArray());
                accumulated.reset();
                accumulated.write(ch);
                continue;
            }
            if (found == 2 && ch == 73) {
                ++found;
                accumulated.write(ch);
                continue;
            }
            if (found == 3 && PRTokeniser.isWhitespace(ch)) {
                byte[] tmp = baos.toByteArray();
                if (InlineImageUtils.inlineImageStreamBytesAreComplete(tmp, imageDictionary)) {
                    return tmp;
                }
                baos.write(accumulated.toByteArray());
                accumulated.reset();
                baos.write(ch);
                found = 0;
                continue;
            }
            baos.write(accumulated.toByteArray());
            accumulated.reset();
            baos.write(ch);
            found = 0;
        }
        throw new InlineImageParseException("Could not find image data or EI");
    }

    private static boolean inlineImageStreamBytesAreComplete(byte[] samples, PdfDictionary imageDictionary) {
        try {
            PdfReader.decodeBytes(samples, imageDictionary, FilterHandlers.getDefaultFilterHandlers());
            return true;
        }
        catch (UnsupportedPdfException e2) {
            LOGGER.warn(e2.getMessage());
            return true;
        }
        catch (IOException e3) {
            return false;
        }
    }

    static {
        inlineImageEntryAbbreviationMap.put(PdfName.BITSPERCOMPONENT, PdfName.BITSPERCOMPONENT);
        inlineImageEntryAbbreviationMap.put(PdfName.COLORSPACE, PdfName.COLORSPACE);
        inlineImageEntryAbbreviationMap.put(PdfName.DECODE, PdfName.DECODE);
        inlineImageEntryAbbreviationMap.put(PdfName.DECODEPARMS, PdfName.DECODEPARMS);
        inlineImageEntryAbbreviationMap.put(PdfName.FILTER, PdfName.FILTER);
        inlineImageEntryAbbreviationMap.put(PdfName.HEIGHT, PdfName.HEIGHT);
        inlineImageEntryAbbreviationMap.put(PdfName.IMAGEMASK, PdfName.IMAGEMASK);
        inlineImageEntryAbbreviationMap.put(PdfName.INTENT, PdfName.INTENT);
        inlineImageEntryAbbreviationMap.put(PdfName.INTERPOLATE, PdfName.INTERPOLATE);
        inlineImageEntryAbbreviationMap.put(PdfName.WIDTH, PdfName.WIDTH);
        inlineImageEntryAbbreviationMap.put(new PdfName("BPC"), PdfName.BITSPERCOMPONENT);
        inlineImageEntryAbbreviationMap.put(new PdfName("CS"), PdfName.COLORSPACE);
        inlineImageEntryAbbreviationMap.put(new PdfName("D"), PdfName.DECODE);
        inlineImageEntryAbbreviationMap.put(new PdfName("DP"), PdfName.DECODEPARMS);
        inlineImageEntryAbbreviationMap.put(new PdfName("F"), PdfName.FILTER);
        inlineImageEntryAbbreviationMap.put(new PdfName("H"), PdfName.HEIGHT);
        inlineImageEntryAbbreviationMap.put(new PdfName("IM"), PdfName.IMAGEMASK);
        inlineImageEntryAbbreviationMap.put(new PdfName("I"), PdfName.INTERPOLATE);
        inlineImageEntryAbbreviationMap.put(new PdfName("W"), PdfName.WIDTH);
        inlineImageColorSpaceAbbreviationMap = new HashMap<PdfName, PdfName>();
        inlineImageColorSpaceAbbreviationMap.put(new PdfName("G"), PdfName.DEVICEGRAY);
        inlineImageColorSpaceAbbreviationMap.put(new PdfName("RGB"), PdfName.DEVICERGB);
        inlineImageColorSpaceAbbreviationMap.put(new PdfName("CMYK"), PdfName.DEVICECMYK);
        inlineImageColorSpaceAbbreviationMap.put(new PdfName("I"), PdfName.INDEXED);
        inlineImageFilterAbbreviationMap = new HashMap<PdfName, PdfName>();
        inlineImageFilterAbbreviationMap.put(new PdfName("AHx"), PdfName.ASCIIHEXDECODE);
        inlineImageFilterAbbreviationMap.put(new PdfName("A85"), PdfName.ASCII85DECODE);
        inlineImageFilterAbbreviationMap.put(new PdfName("LZW"), PdfName.LZWDECODE);
        inlineImageFilterAbbreviationMap.put(new PdfName("Fl"), PdfName.FLATEDECODE);
        inlineImageFilterAbbreviationMap.put(new PdfName("RL"), PdfName.RUNLENGTHDECODE);
        inlineImageFilterAbbreviationMap.put(new PdfName("CCF"), PdfName.CCITTFAXDECODE);
        inlineImageFilterAbbreviationMap.put(new PdfName("DCT"), PdfName.DCTDECODE);
    }

    public static class InlineImageParseException
    extends IOException {
        private static final long serialVersionUID = 233760879000268548L;

        public InlineImageParseException(String message2) {
            super(message2);
        }
    }
}

