/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.IOException;
import org.eclipse.swt.internal.image.PngDecodingDataStream;

public class PngHuffmanTable {
    CodeLengthInfo[] codeLengthInfo;
    int[] codeValues;
    static final int MAX_CODE_LENGTH = 15;
    static final int BAD_CODE = 0xFFFFFFF;
    static final int[] incs = new int[]{1391376, 463792, 198768, 86961, 33936, 13776, 4592, 1968, 861, 336, 112, 48, 21, 7, 3, 1};

    PngHuffmanTable(int[] lengths) {
        this.initialize(lengths);
        this.generateTable(lengths);
    }

    private void initialize(int[] lengths) {
        int i;
        this.codeValues = new int[lengths.length];
        for (i = 0; i < this.codeValues.length; ++i) {
            this.codeValues[i] = i;
        }
        this.codeLengthInfo = new CodeLengthInfo[15];
        for (i = 0; i < 15; ++i) {
            this.codeLengthInfo[i] = new CodeLengthInfo();
            this.codeLengthInfo[i].length = i;
            this.codeLengthInfo[i].baseIndex = 0;
            this.codeLengthInfo[i].min = 0xFFFFFFF;
            this.codeLengthInfo[i].max = -1;
        }
    }

    private void generateTable(int[] lengths) {
        for (int k = 0; k < 16; ++k) {
            int h;
            for (int i = h = incs[k]; i < lengths.length; ++i) {
                int v = lengths[i];
                int codeValuesTemp = this.codeValues[i];
                for (int j = i; j >= h && (lengths[j - h] > v || lengths[j - h] == v && this.codeValues[j - h] > codeValuesTemp); j -= h) {
                    lengths[j] = lengths[j - h];
                    this.codeValues[j] = this.codeValues[j - h];
                }
                lengths[j] = v;
                this.codeValues[j] = codeValuesTemp;
            }
        }
        int[] codes = new int[lengths.length];
        int lastLength = 0;
        int code = 0;
        for (int i = 0; i < lengths.length; ++i) {
            while (lastLength != lengths[i]) {
                ++lastLength;
                code <<= 1;
            }
            if (lastLength == 0) continue;
            codes[i] = code++;
        }
        int last = 0;
        for (int i = 0; i < lengths.length; ++i) {
            if (last != lengths[i]) {
                last = lengths[i];
                this.codeLengthInfo[last - 1].baseIndex = i;
                this.codeLengthInfo[last - 1].min = codes[i];
            }
            if (last == 0) continue;
            this.codeLengthInfo[last - 1].max = codes[i];
        }
    }

    int getNextValue(PngDecodingDataStream stream) throws IOException {
        int codelength;
        int code = stream.getNextIdatBit();
        for (codelength = 0; codelength < 15 && code > this.codeLengthInfo[codelength].max; ++codelength) {
            code = code << 1 | stream.getNextIdatBit();
        }
        if (codelength >= 15) {
            stream.error();
        }
        int offset = code - this.codeLengthInfo[codelength].min;
        int index = this.codeLengthInfo[codelength].baseIndex + offset;
        return this.codeValues[index];
    }

    static class CodeLengthInfo {
        int length;
        int max;
        int min;
        int baseIndex;

        CodeLengthInfo() {
        }
    }
}

