/*
 * Decompiled with CFR 0.152.
 */
package gde.device.kontronik;

import gde.GDE;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.smmodellbau.JLog2;
import gde.exception.DataInconsitsentException;
import gde.io.CSVSerialDataReaderWriter;
import gde.io.DataParser;
import gde.io.IDataParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.utils.FileUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.xml.bind.JAXBException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class Kosmik
extends JLog2 {
    public Kosmik(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
    }

    public Kosmik(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
    }

    @Override
    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int deviceDataBufferSize = Math.abs(this.getDataBlockSize(InputTypes.FILE_IO)) * 6;
        int[] points = new int[recordSet.size()];
        int offset = 0;
        int progressCycle = 0;
        int lovDataSize = 0;
        byte[] convertBuffer = new byte[deviceDataBufferSize];
        double lastDateTime = 0.0;
        double sumTimeDelta = 0.0;
        double deltaTime = 0.0;
        int timeBufferSize = 10;
        byte[] timeBuffer = new byte[timeBufferSize];
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        for (int i = 0; i < recordDataSize; ++i) {
            lovDataSize = deviceDataBufferSize / 4;
            System.arraycopy(dataBuffer, offset, convertBuffer, 0, deviceDataBufferSize / 3);
            for (int j = deviceDataBufferSize / 4; j < deviceDataBufferSize; ++j) {
                convertBuffer[j] = dataBuffer[offset + j];
                ++lovDataSize;
                if (dataBuffer[offset + j] == 10 && dataBuffer[offset + j - 1] == 13) break;
            }
            System.arraycopy(convertBuffer, 0, timeBuffer, 0, timeBuffer.length);
            long dateTime = (long)(lastDateTime + 50.0);
            try {
                dateTime = Long.parseLong(String.format("%c%c%c%c%c%c000", Character.valueOf((char)timeBuffer[4]), Character.valueOf((char)timeBuffer[5]), Character.valueOf((char)timeBuffer[6]), Character.valueOf((char)timeBuffer[7]), Character.valueOf((char)timeBuffer[8]), Character.valueOf((char)timeBuffer[9])).trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            double d = deltaTime = lastDateTime == 0.0 ? 0.0 : (double)dateTime - lastDateTime;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("%d; %4.1fd ms - %d : %s", i, deltaTime, dateTime, new String(timeBuffer).trim()));
            }
            lastDateTime = dateTime;
            recordSet.addPoints(this.convertDataBytes(points, convertBuffer), sumTimeDelta += deltaTime);
            offset += lovDataSize + 8;
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
    }

    @Override
    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        DataParser data = new DataParser(this.getDataBlockTimeUnitFactor(), this.getDataBlockLeader(), this.getDataBlockSeparator().value(), null, null, this.getDataBlockSize(InputTypes.FILE_IO), this.getDataBlockFormat(InputTypes.FILE_IO), true);
        int[] startLength = new int[]{0, 0};
        byte[] lineBuffer = null;
        try {
            this.setDataLineStartAndLength(dataBuffer, startLength);
            lineBuffer = new byte[startLength[1]];
            System.arraycopy(dataBuffer, startLength[0], lineBuffer, 0, startLength[1]);
            data.parse(new String(lineBuffer), 0);
            int[] values = data.getValues();
            for (int i = 0; i < values.length; ++i) {
                points[i] = values[i];
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage());
        }
        return points;
    }

    @Override
    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int i;
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int progressCycle = 0;
        Vector<Integer> timeStamps = new Vector<Integer>(1, 1);
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        int timeStampBufferSize = recordSet.isTimeStepConstant() ? 0 : 4 * recordDataSize;
        byte[] timeStampBuffer = new byte[timeStampBufferSize];
        if (!recordSet.isTimeStepConstant()) {
            System.arraycopy(dataBuffer, 0, timeStampBuffer, 0, timeStampBufferSize);
            for (i = 0; i < recordDataSize; ++i) {
                timeStamps.add(((timeStampBuffer[0 + i * 4] & 0xFF) << 24) + ((timeStampBuffer[1 + i * 4] & 0xFF) << 16) + ((timeStampBuffer[2 + i * 4] & 0xFF) << 8) + ((timeStampBuffer[3 + i * 4] & 0xFF) << 0));
            }
            log.log(Level.FINE, timeStamps.size() + " timeStamps = " + timeStamps.toString());
        }
        for (i = 0; i < recordDataSize; ++i) {
            log.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize + timeStampBufferSize);
            System.arraycopy(dataBuffer, i * dataBufferSize + timeStampBufferSize, convertBuffer, 0, dataBufferSize);
            for (int j = 0; j < points.length; ++j) {
                points[j] = ((convertBuffer[0 + j * 4] & 0xFF) << 24) + ((convertBuffer[1 + j * 4] & 0xFF) << 16) + ((convertBuffer[2 + j * 4] & 0xFF) << 8) + ((convertBuffer[3 + j * 4] & 0xFF) << 0);
            }
            if (recordSet.isTimeStepConstant()) {
                recordSet.addPoints(points);
            } else {
                recordSet.addPoints(points, (double)((Integer)timeStamps.get(i)).intValue() / 10.0);
            }
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    @Override
    public void importDeviceData() {
        final FileDialog fd = FileUtils.getImportDirectoryFileDialog((IDevice)this, (String)Messages.getString((String)"GDE_MSGT2800"));
        Thread reader = new Thread("reader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Kosmik.this.application.setPortConnected(true);
                    for (String tmpFileName : fd.getFileNames()) {
                        String selectedImportFile = fd.getFilterPath() + "/" + tmpFileName;
                        log.log(Level.FINE, "selectedImportFile = " + selectedImportFile);
                        if (fd.getFileName().length() <= 4) continue;
                        try {
                            Integer channelConfigNumber = Kosmik.this.dialog != null && !Kosmik.this.dialog.isDisposed() ? Integer.valueOf(Kosmik.this.dialog.getTabFolderSelectionIndex() + 1) : null;
                            String recordNameExtend = selectedImportFile.contains("_") ? selectedImportFile.substring(selectedImportFile.lastIndexOf(95) + 1, selectedImportFile.lastIndexOf(46)) : selectedImportFile.substring(selectedImportFile.lastIndexOf(GDE.FILE_SEPARATOR) + 1, selectedImportFile.lastIndexOf(46));
                            RecordSet redRecordSet = CSVSerialDataReaderWriter.read((String)selectedImportFile, (IDevice)Kosmik.this, (String)recordNameExtend, (Integer)channelConfigNumber, (IDataParser)new DataParser(Kosmik.this.getDataBlockTimeUnitFactor(), Kosmik.this.getDataBlockLeader(), Kosmik.this.getDataBlockSeparator().value(), Kosmik.this.getDataBlockCheckSumType(), Kosmik.this.getDataBlockSize(InputTypes.FILE_IO)));
                            try {
                                String line;
                                BufferedReader lineReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(selectedImportFile), "ISO-8859-1"));
                                while ((line = lineReader.readLine()) != null) {
                                    if (!line.toLowerCase().contains("kosmik")) continue;
                                    redRecordSet.setRecordSetDescription(redRecordSet.getRecordSetDescription() + GDE.LINE_SEPARATOR + line.substring(2).trim());
                                    lineReader.close();
                                }
                            }
                            catch (Exception exception) {}
                        }
                        catch (Throwable e) {
                            log.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                finally {
                    Kosmik.this.application.setPortConnected(false);
                }
            }
        };
        reader.start();
    }

    public boolean recordSetNumberFollowChannel() {
        return false;
    }

    @Override
    public void updateFileImportMenu(Menu importMenue) {
        if (importMenue.getItem(importMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0018"))) {
            new MenuItem(importMenue, 2);
            MenuItem importDeviceLogItem = new MenuItem(importMenue, 8);
            importDeviceLogItem.setText(Messages.getString((String)"GDE_MSGW2809", (Object[])GDE.MOD1));
            importDeviceLogItem.setAccelerator(SWT.MOD1 + Messages.getAcceleratorChar((String)"GDE_MSGW2809"));
            importDeviceLogItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(Level.FINEST, "importDeviceLogItem action performed! " + String.valueOf(e));
                    Kosmik.this.open_closeCommPort();
                }
            });
        }
    }
}

