/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;

public class TreeCursor
extends Canvas {
    Tree tree;
    TreeItem row;
    TreeColumn column;
    Listener listener;
    Listener treeListener;
    Listener resizeListener;
    Listener disposeItemListener;
    Listener disposeColumnListener;
    Color background = null;
    Color foreground = null;
    static final int BACKGROUND = 27;
    static final int FOREGROUND = 26;

    public TreeCursor(Tree parent, int style) {
        super(parent, style);
        ScrollBar vBar;
        this.tree = parent;
        this.setBackground(null);
        this.setForeground(null);
        this.listener = event -> {
            if (this.row != null) {
                if (this.row.isDisposed()) {
                    this.unhookRowColumnListeners();
                    this._resize();
                    this.tree.setFocus();
                    return;
                }
                TreeItem current = this.row;
                TreeItem parentItem = this.row.getParentItem();
                while (parentItem != null && !parentItem.getExpanded()) {
                    current = parentItem;
                    parentItem = current.getParentItem();
                }
                if (current != this.row) {
                    this.setRowColumn(current, this.column, false);
                }
            }
            switch (event.type) {
                case 12: {
                    this.onDispose(event);
                    break;
                }
                case 15: 
                case 16: {
                    this.redraw();
                    break;
                }
                case 1: {
                    this.keyDown(event);
                    break;
                }
                case 9: {
                    this.paint(event);
                    break;
                }
                case 31: {
                    event.doit = true;
                    switch (event.detail) {
                        case 4: 
                        case 32: 
                        case 64: {
                            event.doit = false;
                        }
                    }
                }
            }
        };
        int[] events = new int[]{12, 15, 16, 1, 9, 31};
        int i2 = 0;
        while (i2 < events.length) {
            this.addListener(events[i2], this.listener);
            ++i2;
        }
        this.treeListener = event -> {
            switch (event.type) {
                case 18: {
                    this.treeCollapse(event);
                    break;
                }
                case 17: {
                    this.treeExpand(event);
                    break;
                }
                case 15: {
                    this.treeFocusIn(event);
                    break;
                }
                case 3: {
                    this.treeMouseDown(event);
                }
            }
        };
        this.tree.addListener(18, this.treeListener);
        this.tree.addListener(17, this.treeListener);
        this.tree.addListener(15, this.treeListener);
        this.tree.addListener(3, this.treeListener);
        this.disposeItemListener = event -> {
            TreeItem currentItem = this.row;
            while (currentItem != null) {
                currentItem.removeListener(12, this.disposeItemListener);
                currentItem = currentItem.getParentItem();
            }
            TreeItem disposedItem = (TreeItem)event.widget;
            TreeItem parentItem = disposedItem.getParentItem();
            if (parentItem != null) {
                this.setRowColumn(parentItem, this.column, true);
            } else if (this.tree.getItemCount() == 1) {
                this.unhookRowColumnListeners();
            } else {
                TreeItem nextItem;
                TreeItem previousItem;
                TreeItem newFocus = null;
                int rowIndex = this.tree.indexOf(disposedItem);
                if (rowIndex != 0 && !(previousItem = this.tree.getItem(rowIndex - 1)).isDisposed()) {
                    newFocus = previousItem;
                }
                if (newFocus == null && rowIndex + 1 < this.tree.getItemCount() && !(nextItem = this.tree.getItem(rowIndex + 1)).isDisposed()) {
                    newFocus = nextItem;
                }
                if (newFocus != null) {
                    this.setRowColumn(newFocus, this.column, true);
                } else {
                    this.unhookRowColumnListeners();
                }
            }
            this._resize();
        };
        this.disposeColumnListener = event -> {
            if (this.column != null) {
                if (this.tree.getColumnCount() == 1) {
                    this.column = null;
                } else {
                    int columnIndex;
                    int positionIndex = columnIndex = this.tree.indexOf(this.column);
                    int[] columnOrder = this.tree.getColumnOrder();
                    int i2 = 0;
                    while (i2 < columnOrder.length) {
                        if (columnOrder[i2] == columnIndex) {
                            positionIndex = i2;
                            break;
                        }
                        ++i2;
                    }
                    if (positionIndex == columnOrder.length - 1) {
                        this.setRowColumn(this.row, this.tree.getColumn(columnOrder[positionIndex - 1]), true);
                    } else {
                        this.setRowColumn(this.row, this.tree.getColumn(columnOrder[positionIndex + 1]), true);
                    }
                }
            }
            this._resize();
        };
        this.resizeListener = event -> this._resize();
        ScrollBar hBar = this.tree.getHorizontalBar();
        if (hBar != null) {
            hBar.addListener(13, this.resizeListener);
        }
        if ((vBar = this.tree.getVerticalBar()) != null) {
            vBar.addListener(13, this.resizeListener);
        }
        this.getAccessible().addAccessibleControlListener(new AccessibleControlAdapter(){

            @Override
            public void getRole(AccessibleControlEvent e2) {
                e2.detail = 29;
            }
        });
        this.getAccessible().addAccessibleListener(new AccessibleAdapter(){

            @Override
            public void getName(AccessibleEvent e2) {
                if (TreeCursor.this.row == null) {
                    return;
                }
                int columnIndex = TreeCursor.this.column == null ? 0 : TreeCursor.this.tree.indexOf(TreeCursor.this.column);
                e2.result = TreeCursor.this.row.getText(columnIndex);
            }
        });
    }

    public void addSelectionListener(SelectionListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int countSubTreePages(TreeItem root2) {
        int pages = 1;
        if (root2 == null) {
            return 0;
        }
        if (root2.getItemCount() == 0) {
            return 1;
        }
        if (!root2.getExpanded()) {
            return 1;
        }
        TreeItem[] items = root2.getItems();
        int i2 = 0;
        while (i2 < items.length) {
            pages += this.countSubTreePages(items[i2]);
            ++i2;
        }
        return pages;
    }

    int findIndex(TreeItem[] items, TreeItem treeItem) {
        if (items == null || treeItem == null) {
            return -1;
        }
        Rectangle rect = treeItem.getBounds();
        int index = 0;
        int i2 = 0;
        while (i2 < items.length) {
            TreeItem previousItem = null;
            TreeItem currentItem = items[i2];
            if (i2 > 0) {
                previousItem = items[i2 - 1];
            }
            Rectangle rect1 = currentItem.getBounds();
            if (rect.y == rect1.y) {
                return index;
            }
            if (rect.y < rect1.y) {
                return index - 1 + this.findIndex(previousItem.getItems(), treeItem);
            }
            if (rect.y > rect1.y && i2 == items.length - 1) {
                return index + this.findIndex(currentItem.getItems(), treeItem);
            }
            index = rect.y >= rect1.y + (1 + currentItem.getItemCount()) * this.tree.getItemHeight() && currentItem.getExpanded() ? (index += this.countSubTreePages(currentItem)) : ++index;
            ++i2;
        }
        return -1;
    }

    TreeItem findItem(TreeItem[] items, Point pt) {
        int start = 0;
        int end = items.length - 1;
        int index = end / 2;
        while (end - start > 1) {
            TreeItem currentItem = items[index];
            Rectangle bounds = currentItem.getBounds();
            if (pt.y < bounds.y) {
                end = index;
                index = (end - start) / 2;
                continue;
            }
            start = index;
            index = start + (end - start) / 2;
        }
        Rectangle endBounds = items[end].getBounds();
        if (endBounds.y < pt.y) {
            if (endBounds.y + endBounds.height < pt.y) {
                if (!items[end].getExpanded()) {
                    return null;
                }
                return this.findItem(items[end].getItems(), pt);
            }
            int[] columnOrder = this.tree.getColumnOrder();
            Rectangle bounds = null;
            if (columnOrder.length > 0) {
                Rectangle rect1 = items[end].getBounds(columnOrder[0]);
                Rectangle rect2 = items[end].getBounds(columnOrder[columnOrder.length - 1]);
                bounds = rect1.union(rect2);
                bounds.height = bounds.height + (this.tree.getLinesVisible() ? this.tree.getGridLineWidth() : 0);
            } else {
                bounds = items[end].getBounds();
            }
            return bounds.contains(pt) ? items[end] : null;
        }
        Rectangle startBounds = items[start].getBounds();
        if (startBounds.y + startBounds.height < pt.y) {
            return this.findItem(items[start].getItems(), pt);
        }
        int[] columnOrder = this.tree.getColumnOrder();
        Rectangle bounds = null;
        if (columnOrder.length > 0) {
            Rectangle rect1 = items[start].getBounds(columnOrder[0]);
            Rectangle rect2 = items[start].getBounds(columnOrder[columnOrder.length - 1]);
            bounds = rect1.union(rect2);
            bounds.height = bounds.height + (this.tree.getLinesVisible() ? this.tree.getGridLineWidth() : 0);
        } else {
            bounds = items[start].getBounds();
        }
        return bounds.contains(pt) ? items[start] : null;
    }

    @Override
    public Color getBackground() {
        this.checkWidget();
        if (this.background == null) {
            return this.getDisplay().getSystemColor(27);
        }
        return this.background;
    }

    public int getColumn() {
        this.checkWidget();
        return this.column == null ? 0 : this.tree.indexOf(this.column);
    }

    @Override
    public Color getForeground() {
        this.checkWidget();
        if (this.foreground == null) {
            return this.getDisplay().getSystemColor(26);
        }
        return this.foreground;
    }

    TreeItem getLastVisibleItem(TreeItem[] items) {
        if (items == null) {
            return null;
        }
        TreeItem last = items[items.length - 1];
        if (last.getExpanded() && last.getItemCount() > 0) {
            return this.getLastVisibleItem(last.getItems());
        }
        return last;
    }

    TreeItem getNextItem(TreeItem item2) {
        int index;
        if (item2 == null) {
            return null;
        }
        if (item2.getExpanded() && item2.getItemCount() > 0) {
            return item2.getItem(0);
        }
        TreeItem parentItem = item2.getParentItem();
        while (parentItem != null) {
            index = parentItem.indexOf(item2);
            if (index == -1) {
                return null;
            }
            if (index < parentItem.getItemCount() - 1) {
                return parentItem.getItem(index + 1);
            }
            item2 = parentItem;
            parentItem = item2.getParentItem();
        }
        index = this.tree.indexOf(item2);
        if (index == -1) {
            return null;
        }
        if (index == this.tree.getItemCount() - 1) {
            return null;
        }
        return this.tree.getItem(index + 1);
    }

    TreeItem getPreviousItem(TreeItem item2) {
        if (item2 == null) {
            return null;
        }
        TreeItem parentItem = item2.getParentItem();
        if (parentItem == null) {
            int index = this.tree.indexOf(item2);
            if (index == -1 || index == 0) {
                return null;
            }
            item2 = this.tree.getItem(index - 1);
            if (item2.getExpanded() && item2.getItemCount() > 0) {
                return this.getLastVisibleItem(item2.getItems());
            }
            return item2;
        }
        int index = parentItem.indexOf(item2);
        if (index == -1) {
            return null;
        }
        if (index == 0) {
            return parentItem;
        }
        item2 = parentItem.getItem(index - 1);
        if (item2.getExpanded() && item2.getItemCount() > 0) {
            return this.getLastVisibleItem(item2.getItems());
        }
        return item2;
    }

    public TreeItem getRow() {
        this.checkWidget();
        return this.row;
    }

    void keyDown(Event event) {
        if (this.row == null) {
            return;
        }
        switch (event.character) {
            case '\r': {
                this.notifyListeners(14, new Event());
                return;
            }
        }
        switch (event.keyCode) {
            case 0x1000001: {
                TreeItem previousItem = this.getPreviousItem(this.row);
                if (previousItem == null) break;
                this.setRowColumn(previousItem, this.column, true);
                break;
            }
            case 0x1000002: {
                TreeItem nextItem = this.getNextItem(this.row);
                if (nextItem == null) break;
                this.setRowColumn(nextItem, this.column, true);
                break;
            }
            case 0x1000003: 
            case 0x1000004: {
                if ((event.stateMask & SWT.MOD1) != 0) {
                    this.row.setExpanded(event.keyCode == 0x1000004);
                    break;
                }
                int columnCount = this.tree.getColumnCount();
                if (columnCount == 0) break;
                int columnIndex = this.column == null ? 0 : this.tree.indexOf(this.column);
                int[] columnOrder = this.tree.getColumnOrder();
                int index = 0;
                while (index < columnOrder.length) {
                    if (columnOrder[index] == columnIndex) break;
                    ++index;
                }
                if (index == columnOrder.length) {
                    index = 0;
                }
                int leadKey = (this.getStyle() & 0x4000000) != 0 ? 0x1000004 : 0x1000003;
                TreeItem parentRow = this.row.getParentItem();
                int rowIndex = this.tree.indexOf(this.row);
                if (event.keyCode == leadKey) {
                    if (parentRow != null) {
                        this.setRowColumn(this.row, this.tree.getColumn(columnOrder[Math.max(0, index - 1)]), true);
                        break;
                    }
                    this.setRowColumn(rowIndex, columnOrder[Math.max(0, index - 1)], true);
                    break;
                }
                if (parentRow != null) {
                    this.setRowColumn(this.row, this.tree.getColumn(columnOrder[Math.min(columnCount - 1, index + 1)]), true);
                    break;
                }
                this.setRowColumn(rowIndex, columnOrder[Math.min(columnCount - 1, index + 1)], true);
                break;
            }
            case 0x1000007: {
                int columnIndex = this.column == null ? 0 : this.tree.indexOf(this.column);
                this.setRowColumn(0, columnIndex, true);
                break;
            }
            case 0x1000008: {
                TreeItem[] items = this.tree.getItems();
                this.setRowColumn(this.getLastVisibleItem(items), this.column, true);
                break;
            }
            case 0x1000005: {
                Rectangle rect = this.tree.getClientArea();
                Rectangle itemRect = this.tree.getTopItem().getBounds();
                TreeItem item2 = this.row;
                int index = this.findIndex(this.tree.getItems(), item2);
                int itemHeight = this.tree.getItemHeight();
                rect.height -= itemRect.y;
                int page = Math.max(1, rect.height / itemHeight);
                if (index - page <= 0) {
                    TreeItem first = this.tree.getItem(0);
                    this.setRowColumn(first, this.column, true);
                    break;
                }
                int i2 = 0;
                while (i2 < page) {
                    item2 = this.getPreviousItem(item2);
                    ++i2;
                }
                this.setRowColumn(item2, this.column, true);
                break;
            }
            case 0x1000006: {
                Rectangle rect = this.tree.getClientArea();
                Rectangle itemRect = this.tree.getTopItem().getBounds();
                TreeItem item3 = this.row;
                int index = this.findIndex(this.tree.getItems(), item3);
                int height = this.tree.getItemHeight();
                rect.height -= itemRect.y;
                TreeItem last = this.getLastVisibleItem(this.tree.getItems());
                int page = Math.max(1, rect.height / height);
                int end = this.findIndex(this.tree.getItems(), last);
                if (end <= index + page) {
                    this.setRowColumn(last, this.column, true);
                    break;
                }
                int i3 = 0;
                while (i3 < page) {
                    item3 = this.getNextItem(item3);
                    ++i3;
                }
                this.setRowColumn(item3, this.column, true);
            }
        }
    }

    void onDispose(Event event) {
        ScrollBar vBar;
        this.removeListener(12, this.listener);
        this.notifyListeners(12, event);
        event.type = 0;
        this.tree.removeListener(18, this.treeListener);
        this.tree.removeListener(17, this.treeListener);
        this.tree.removeListener(15, this.treeListener);
        this.tree.removeListener(3, this.treeListener);
        this.unhookRowColumnListeners();
        ScrollBar hBar = this.tree.getHorizontalBar();
        if (hBar != null) {
            hBar.removeListener(13, this.resizeListener);
        }
        if ((vBar = this.tree.getVerticalBar()) != null) {
            vBar.removeListener(13, this.resizeListener);
        }
    }

    void paint(Event event) {
        String text2;
        int columnIndex;
        if (this.row == null) {
            return;
        }
        int orderedIndex = columnIndex = this.column == null ? 0 : this.tree.indexOf(this.column);
        int[] columnOrder = this.tree.getColumnOrder();
        int i2 = 0;
        while (i2 < columnOrder.length) {
            if (columnOrder[i2] == columnIndex) {
                orderedIndex = i2;
                break;
            }
            ++i2;
        }
        GC gc = event.gc;
        gc.setBackground(this.getBackground());
        gc.setForeground(this.getForeground());
        gc.fillRectangle(event.x, event.y, event.width, event.height);
        Image image = this.row.getImage(columnIndex);
        int x2 = 0;
        String platform = SWT.getPlatform();
        if (image != null) {
            if ("win32".equals(platform)) {
                if (orderedIndex > 0) {
                    x2 += 2;
                }
            } else {
                x2 += 2;
            }
        }
        Point size = this.getSize();
        if (image != null) {
            Rectangle imageSize = image.getBounds();
            int imageY = (size.y - imageSize.height) / 2;
            gc.drawImage(image, x2, imageY);
            x2 += imageSize.width;
        }
        if ((text2 = this.row.getText(columnIndex)).length() > 0) {
            int alignmnent;
            Rectangle bounds = this.row.getBounds(columnIndex);
            Point extent = gc.stringExtent(text2);
            if ("win32".equals(platform)) {
                if (this.tree.getColumnCount() == 0 || orderedIndex == 0) {
                    x2 += image == null ? 2 : 5;
                } else {
                    alignmnent = this.column.getAlignment();
                    switch (alignmnent) {
                        case 16384: {
                            x2 += image == null ? 5 : 3;
                            break;
                        }
                        case 131072: {
                            x2 = bounds.width - extent.x - 2;
                            break;
                        }
                        case 0x1000000: {
                            x2 = (int)((double)x2 + Math.ceil((double)(bounds.width - x2 - extent.x) / 2.0));
                        }
                    }
                }
            } else if (this.tree.getColumnCount() == 0) {
                x2 += image == null ? 4 : 3;
            } else {
                alignmnent = this.column.getAlignment();
                switch (alignmnent) {
                    case 16384: {
                        x2 += image == null ? 5 : 3;
                        break;
                    }
                    case 131072: {
                        x2 = bounds.width - extent.x - 2;
                        break;
                    }
                    case 0x1000000: {
                        x2 += (bounds.width - x2 - extent.x) / 2 + 2;
                    }
                }
            }
            int textY = (size.y - extent.y) / 2;
            gc.drawString(text2, x2, textY);
        }
        if (this.isFocusControl()) {
            Display display = this.getDisplay();
            gc.setBackground(display.getSystemColor(2));
            gc.setForeground(display.getSystemColor(1));
            gc.drawFocus(0, 0, size.x, size.y);
        }
    }

    public void removeSelectionListener(SelectionListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener2);
        this.removeListener(14, listener2);
    }

    void _resize() {
        if (this.row == null) {
            this.setBounds(-200, -200, 0, 0);
        } else {
            int columnIndex = this.column == null ? 0 : this.tree.indexOf(this.column);
            this.setBounds(this.row.getBounds(columnIndex));
        }
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
        super.setBackground(this.getBackground());
        this.redraw();
    }

    @Override
    public void setForeground(Color color) {
        this.foreground = color;
        super.setForeground(this.getForeground());
        this.redraw();
    }

    void setRowColumn(int row2, int column2, boolean notify) {
        TreeItem item2 = row2 == -1 ? null : this.tree.getItem(row2);
        TreeColumn col = column2 == -1 || this.tree.getColumnCount() == 0 ? null : this.tree.getColumn(column2);
        this.setRowColumn(item2, col, notify);
    }

    void setRowColumn(TreeItem row2, TreeColumn column2, boolean notify) {
        TreeItem currentItem;
        if (this.row != null && this.row != row2) {
            currentItem = this.row;
            while (currentItem != null) {
                currentItem.removeListener(12, this.disposeItemListener);
                currentItem = currentItem.getParentItem();
            }
            this.row = null;
        }
        if (this.column != null && this.column != column2) {
            this.column.removeListener(12, this.disposeColumnListener);
            this.column.removeListener(10, this.resizeListener);
            this.column.removeListener(11, this.resizeListener);
            this.column = null;
        }
        if (row2 != null) {
            if (this.row != row2) {
                this.row = row2;
                currentItem = row2;
                while (currentItem != null) {
                    currentItem.addListener(12, this.disposeItemListener);
                    currentItem = currentItem.getParentItem();
                }
                this.tree.showItem(row2);
            }
            if (this.column != column2 && column2 != null) {
                this.column = column2;
                column2.addListener(12, this.disposeColumnListener);
                column2.addListener(10, this.resizeListener);
                column2.addListener(11, this.resizeListener);
                this.tree.showColumn(column2);
            }
            int columnIndex = column2 == null ? 0 : this.tree.indexOf(column2);
            this.setBounds(row2.getBounds(columnIndex));
            this.redraw();
            if (notify) {
                this.notifyListeners(13, new Event());
            }
        }
    }

    public void setSelection(int row2, int column2) {
        int maxColumnIndex;
        this.checkWidget();
        int columnCount = this.tree.getColumnCount();
        int n2 = maxColumnIndex = columnCount == 0 ? 0 : columnCount - 1;
        if (row2 < 0 || row2 >= this.tree.getItemCount() || column2 < 0 || column2 > maxColumnIndex) {
            SWT.error(5);
        }
        this.setRowColumn(row2, column2, false);
    }

    public void setSelection(TreeItem row2, int column2) {
        int maxColumnIndex;
        this.checkWidget();
        int columnCount = this.tree.getColumnCount();
        int n2 = maxColumnIndex = columnCount == 0 ? 0 : columnCount - 1;
        if (row2 == null || row2.isDisposed() || column2 < 0 || column2 > maxColumnIndex) {
            SWT.error(5);
        }
        TreeColumn col = this.tree.getColumnCount() == 0 ? null : this.tree.getColumn(column2);
        this.setRowColumn(row2, col, false);
    }

    @Override
    public void setVisible(boolean visible) {
        this.checkWidget();
        if (visible) {
            this._resize();
        }
        super.setVisible(visible);
    }

    void treeCollapse(Event event) {
        if (this.row == null) {
            return;
        }
        TreeItem root2 = (TreeItem)event.item;
        TreeItem parentItem = this.row.getParentItem();
        while (parentItem != null) {
            if (parentItem == root2) {
                this.setRowColumn(root2, this.column, true);
                return;
            }
            parentItem = parentItem.getParentItem();
        }
        this.getDisplay().asyncExec(() -> {
            if (this.isDisposed()) {
                return;
            }
            this.setRowColumn(this.row, this.column, true);
        });
    }

    void treeExpand(Event event) {
        this.getDisplay().asyncExec(() -> {
            if (this.isDisposed()) {
                return;
            }
            this.setRowColumn(this.row, this.column, true);
        });
    }

    void treeFocusIn(Event event) {
        if (this.isVisible()) {
            if (this.row == null && this.column == null) {
                return;
            }
            this.setFocus();
        }
    }

    void treeMouseDown(Event event) {
        if (this.tree.getItemCount() == 0) {
            return;
        }
        Point pt = new Point(event.x, event.y);
        TreeItem item2 = this.tree.getItem(pt);
        if (item2 == null && (this.tree.getStyle() & 0x10000) == 0) {
            TreeItem currentItem = this.tree.getTopItem();
            TreeItem parentItem = currentItem.getParentItem();
            while (parentItem != null) {
                currentItem = parentItem;
                parentItem = currentItem.getParentItem();
            }
            int start = this.tree.indexOf(currentItem);
            int viewportItemCount = this.tree.getClientArea().height / this.tree.getItemHeight();
            int end = Math.min(start + viewportItemCount, this.tree.getItemCount() - 1);
            TreeItem[] allItems = this.tree.getItems();
            TreeItem[] items = new TreeItem[end - start + 1];
            System.arraycopy(allItems, start, items, 0, end - start + 1);
            item2 = this.findItem(items, pt);
        }
        if (item2 == null) {
            return;
        }
        TreeColumn newColumn = null;
        int lineWidth = this.tree.getLinesVisible() ? this.tree.getGridLineWidth() : 0;
        int columnCount = this.tree.getColumnCount();
        if (columnCount > 0) {
            int i2 = 0;
            while (i2 < columnCount) {
                Rectangle rect = item2.getBounds(i2);
                rect.width += lineWidth;
                rect.height += lineWidth;
                if (rect.contains(pt)) {
                    newColumn = this.tree.getColumn(i2);
                    break;
                }
                ++i2;
            }
            if (newColumn == null) {
                newColumn = this.tree.getColumn(0);
            }
        }
        this.setRowColumn(item2, newColumn, true);
        this.setFocus();
    }

    void unhookRowColumnListeners() {
        if (this.column != null && !this.column.isDisposed()) {
            this.column.removeListener(12, this.disposeColumnListener);
            this.column.removeListener(10, this.resizeListener);
            this.column.removeListener(11, this.resizeListener);
        }
        this.column = null;
        if (this.row != null && !this.row.isDisposed()) {
            TreeItem currentItem = this.row;
            while (currentItem != null) {
                currentItem.removeListener(12, this.disposeItemListener);
                currentItem = currentItem.getParentItem();
            }
        }
        this.row = null;
    }
}

