/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.random;

import java.io.Serializable;
import org.apache.commons.math3.random.BitsStreamGenerator;
import org.apache.commons.math3.util.FastMath;

public class MersenneTwister
extends BitsStreamGenerator
implements Serializable {
    private static final long serialVersionUID = 8661194735290153518L;
    private static final int N = 624;
    private static final int M = 397;
    private static final int[] MAG01 = new int[]{0, -1727483681};
    private int[] mt = new int[624];
    private int mti;

    public MersenneTwister() {
        this.setSeed(System.currentTimeMillis() + (long)System.identityHashCode(this));
    }

    public MersenneTwister(int seed) {
        this.setSeed(seed);
    }

    public MersenneTwister(int[] seed) {
        this.setSeed(seed);
    }

    public MersenneTwister(long seed) {
        this.setSeed(seed);
    }

    public void setSeed(int seed) {
        long longMT = seed;
        this.mt[0] = (int)longMT;
        this.mti = 1;
        while (this.mti < 624) {
            longMT = 1812433253L * (longMT ^ longMT >> 30) + (long)this.mti & 0xFFFFFFFFL;
            this.mt[this.mti] = (int)longMT;
            ++this.mti;
        }
        this.clear();
    }

    public void setSeed(int[] seed) {
        long l2;
        long l1;
        long l0;
        int k2;
        if (seed == null) {
            this.setSeed(System.currentTimeMillis() + (long)System.identityHashCode(this));
            return;
        }
        this.setSeed(19650218);
        int i2 = 1;
        int j2 = 0;
        for (k2 = FastMath.max(624, seed.length); k2 != 0; --k2) {
            l0 = (long)this.mt[i2] & Integer.MAX_VALUE | (this.mt[i2] < 0 ? 0x80000000L : 0L);
            l1 = (long)this.mt[i2 - 1] & Integer.MAX_VALUE | (this.mt[i2 - 1] < 0 ? 0x80000000L : 0L);
            l2 = (l0 ^ (l1 ^ l1 >> 30) * 1664525L) + (long)seed[j2] + (long)j2;
            this.mt[i2] = (int)(l2 & 0xFFFFFFFFL);
            ++j2;
            if (++i2 >= 624) {
                this.mt[0] = this.mt[623];
                i2 = 1;
            }
            if (j2 < seed.length) continue;
            j2 = 0;
        }
        for (k2 = 623; k2 != 0; --k2) {
            l0 = (long)this.mt[i2] & Integer.MAX_VALUE | (this.mt[i2] < 0 ? 0x80000000L : 0L);
            l1 = (long)this.mt[i2 - 1] & Integer.MAX_VALUE | (this.mt[i2 - 1] < 0 ? 0x80000000L : 0L);
            l2 = (l0 ^ (l1 ^ l1 >> 30) * 1566083941L) - (long)i2;
            this.mt[i2] = (int)(l2 & 0xFFFFFFFFL);
            if (++i2 < 624) continue;
            this.mt[0] = this.mt[623];
            i2 = 1;
        }
        this.mt[0] = Integer.MIN_VALUE;
        this.clear();
    }

    public void setSeed(long seed) {
        this.setSeed(new int[]{(int)(seed >>> 32), (int)(seed & 0xFFFFFFFFL)});
    }

    protected int next(int bits) {
        int y2;
        if (this.mti >= 624) {
            int mtCurr;
            int k2;
            int mtNext = this.mt[0];
            for (k2 = 0; k2 < 227; ++k2) {
                mtCurr = mtNext;
                mtNext = this.mt[k2 + 1];
                y2 = mtCurr & Integer.MIN_VALUE | mtNext & Integer.MAX_VALUE;
                this.mt[k2] = this.mt[k2 + 397] ^ y2 >>> 1 ^ MAG01[y2 & 1];
            }
            for (k2 = 227; k2 < 623; ++k2) {
                mtCurr = mtNext;
                mtNext = this.mt[k2 + 1];
                y2 = mtCurr & Integer.MIN_VALUE | mtNext & Integer.MAX_VALUE;
                this.mt[k2] = this.mt[k2 + -227] ^ y2 >>> 1 ^ MAG01[y2 & 1];
            }
            y2 = mtNext & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ y2 >>> 1 ^ MAG01[y2 & 1];
            this.mti = 0;
        }
        y2 = this.mt[this.mti++];
        y2 ^= y2 >>> 11;
        y2 ^= y2 << 7 & 0x9D2C5680;
        y2 ^= y2 << 15 & 0xEFC60000;
        y2 ^= y2 >>> 18;
        return y2 >>> 32 - bits;
    }
}

