/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swing;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.xhtmlrenderer.css.parser.FSColor;
import org.xhtmlrenderer.css.parser.FSRGBColor;
import org.xhtmlrenderer.extend.FSGlyphVector;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.extend.OutputDevice;
import org.xhtmlrenderer.extend.ReplacedElement;
import org.xhtmlrenderer.render.AbstractOutputDevice;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.FSFont;
import org.xhtmlrenderer.render.InlineLayoutBox;
import org.xhtmlrenderer.render.InlineText;
import org.xhtmlrenderer.render.JustificationInfo;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.swing.AWTFSFont;
import org.xhtmlrenderer.swing.AWTFSGlyphVector;
import org.xhtmlrenderer.swing.AWTFSImage;
import org.xhtmlrenderer.swing.ImageReplacedElement;
import org.xhtmlrenderer.swing.RootPanel;
import org.xhtmlrenderer.swing.SwingReplacedElement;

public class Java2DOutputDevice
extends AbstractOutputDevice
implements OutputDevice {
    private Graphics2D _graphics;

    public Java2DOutputDevice(Graphics2D graphics) {
        this._graphics = graphics;
    }

    public Java2DOutputDevice(BufferedImage outputImage) {
        this(outputImage.createGraphics());
    }

    @Override
    public void drawSelection(RenderingContext c2, InlineText inlineText) {
        if (inlineText.isSelected()) {
            InlineLayoutBox iB = inlineText.getParent();
            String text2 = inlineText.getSubstring();
            if (text2 != null && text2.length() > 0) {
                FSFont font = iB.getStyle().getFSFont(c2);
                FSGlyphVector glyphVector = c2.getTextRenderer().getGlyphVector(c2.getOutputDevice(), font, inlineText.getSubstring());
                Rectangle start = c2.getTextRenderer().getGlyphBounds(c2.getOutputDevice(), font, glyphVector, inlineText.getSelectionStart(), iB.getAbsX() + inlineText.getX(), iB.getAbsY() + iB.getBaseline());
                Rectangle end = c2.getTextRenderer().getGlyphBounds(c2.getOutputDevice(), font, glyphVector, inlineText.getSelectionEnd() - 1, iB.getAbsX() + inlineText.getX(), iB.getAbsY() + iB.getBaseline());
                Graphics2D graphics = this.getGraphics();
                double scaleX = graphics.getTransform().getScaleX();
                boolean allSelected = text2.length() == inlineText.getSelectionEnd() - inlineText.getSelectionStart();
                int startX = inlineText.getSelectionStart() == inlineText.getStart() ? iB.getAbsX() + inlineText.getX() : (int)Math.round((double)start.x / scaleX);
                int endX = allSelected ? startX + inlineText.getWidth() : (int)Math.round((double)(end.x + end.width) / scaleX);
                this._graphics.setColor(UIManager.getColor("TextArea.selectionBackground"));
                this.fillRect(startX, iB.getAbsY(), endX - startX, iB.getHeight());
                this._graphics.setColor(Color.WHITE);
                this.setFont(iB.getStyle().getFSFont(c2));
                this.drawSelectedText(c2, inlineText, iB, glyphVector);
            }
        }
    }

    private void drawSelectedText(RenderingContext c2, InlineText inlineText, InlineLayoutBox iB, FSGlyphVector glyphVector) {
        JustificationInfo info;
        int i2;
        GlyphVector vector = ((AWTFSGlyphVector)glyphVector).getGlyphVector();
        for (i2 = 0; i2 < inlineText.getSelectionStart(); ++i2) {
            vector.setGlyphPosition(i2, new Point2D.Float(-100000.0f, -100000.0f));
        }
        for (i2 = inlineText.getSelectionEnd(); i2 < inlineText.getSubstring().length(); ++i2) {
            vector.setGlyphPosition(i2, new Point2D.Float(-100000.0f, -100000.0f));
        }
        if (inlineText.getParent().getStyle().isTextJustify() && (info = inlineText.getParent().getLineBox().getJustificationInfo()) != null) {
            String string2 = inlineText.getSubstring();
            float adjust = 0.0f;
            for (int i3 = inlineText.getSelectionStart(); i3 < inlineText.getSelectionEnd(); ++i3) {
                char ch = string2.charAt(i3);
                if (i3 != 0) {
                    Point2D point = vector.getGlyphPosition(i3);
                    vector.setGlyphPosition(i3, new Point2D.Double(point.getX() + (double)adjust, point.getY()));
                }
                if (ch == ' ' || ch == '\u00a0' || ch == '\u3000') {
                    adjust += info.getSpaceAdjust();
                    continue;
                }
                adjust += info.getNonSpaceAdjust();
            }
        }
        c2.getTextRenderer().drawGlyphVector(c2.getOutputDevice(), glyphVector, iB.getAbsX() + inlineText.getX(), iB.getAbsY() + iB.getBaseline());
    }

    @Override
    public void drawBorderLine(Shape bounds, int side, int lineWidth, boolean solid) {
        this.draw(bounds);
    }

    @Override
    public void paintReplacedElement(RenderingContext c2, BlockBox box) {
        ReplacedElement replaced = box.getReplacedElement();
        if (replaced instanceof SwingReplacedElement) {
            Rectangle contentBounds = box.getContentAreaEdge(box.getAbsX(), box.getAbsY(), c2);
            JComponent component = ((SwingReplacedElement)box.getReplacedElement()).getJComponent();
            RootPanel canvas2 = (RootPanel)c2.getCanvas();
            CellRendererPane pane2 = canvas2.getCellRendererPane();
            pane2.paintComponent(this._graphics, component, canvas2, contentBounds.x, contentBounds.y, contentBounds.width, contentBounds.height, true);
        } else if (replaced instanceof ImageReplacedElement) {
            Image image = ((ImageReplacedElement)replaced).getImage();
            Point location = replaced.getLocation();
            this._graphics.drawImage(image, (int)location.getX(), (int)location.getY(), null);
        }
    }

    @Override
    public void setColor(FSColor color) {
        if (!(color instanceof FSRGBColor)) {
            throw new RuntimeException("internal error: unsupported color class " + color.getClass().getName());
        }
        FSRGBColor rgb = (FSRGBColor)color;
        this._graphics.setColor(new Color(rgb.getRed(), rgb.getGreen(), rgb.getBlue()));
    }

    @Override
    protected void drawLine(int x1, int y1, int x2, int y2) {
        this._graphics.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawRect(int x2, int y2, int width, int height) {
        this._graphics.drawRect(x2, y2, width, height);
    }

    @Override
    public void fillRect(int x2, int y2, int width, int height) {
        this._graphics.fillRect(x2, y2, width, height);
    }

    @Override
    public void setClip(Shape s2) {
        this._graphics.setClip(s2);
    }

    @Override
    public Shape getClip() {
        return this._graphics.getClip();
    }

    @Override
    public void clip(Shape s2) {
        this._graphics.clip(s2);
    }

    @Override
    public void translate(double tx, double ty) {
        this._graphics.translate(tx, ty);
    }

    public Graphics2D getGraphics() {
        return this._graphics;
    }

    @Override
    public void drawOval(int x2, int y2, int width, int height) {
        this._graphics.drawOval(x2, y2, width, height);
    }

    @Override
    public void fillOval(int x2, int y2, int width, int height) {
        this._graphics.fillOval(x2, y2, width, height);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key2) {
        return this._graphics.getRenderingHint(key2);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key2, Object value) {
        this._graphics.setRenderingHint(key2, value);
    }

    @Override
    public void setFont(FSFont font) {
        this._graphics.setFont(((AWTFSFont)font).getAWTFont());
    }

    @Override
    public void setStroke(Stroke s2) {
        this._graphics.setStroke(s2);
    }

    @Override
    public Stroke getStroke() {
        return this._graphics.getStroke();
    }

    @Override
    public void fill(Shape s2) {
        this._graphics.fill(s2);
    }

    @Override
    public void draw(Shape s2) {
        this._graphics.draw(s2);
    }

    @Override
    public void drawImage(FSImage image, int x2, int y2) {
        this._graphics.drawImage((Image)((AWTFSImage)image).getImage(), x2, y2, null);
    }

    @Override
    public boolean isSupportsSelection() {
        return true;
    }

    @Override
    public boolean isSupportsCMYKColors() {
        return true;
    }
}

