/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.parser.FilteredTextRenderListener;
import com.itextpdf.text.pdf.parser.MarkedContentRenderFilter;
import com.itextpdf.text.pdf.parser.PdfContentStreamProcessor;
import com.itextpdf.text.pdf.parser.SimpleTextExtractionStrategy;
import com.itextpdf.text.xml.XMLUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Set;

public class TaggedPdfReaderTool {
    protected PdfReader reader;
    protected PrintWriter out;

    public void convertToXml(PdfReader reader, OutputStream os, String charset) throws IOException {
        this.reader = reader;
        OutputStreamWriter outs = new OutputStreamWriter(os, charset);
        this.out = new PrintWriter(outs);
        PdfDictionary catalog = reader.getCatalog();
        PdfDictionary struct = catalog.getAsDict(PdfName.STRUCTTREEROOT);
        if (struct == null) {
            throw new IOException(MessageLocalization.getComposedMessage("no.structtreeroot.found", new Object[0]));
        }
        this.inspectChild(struct.getDirectObject(PdfName.K));
        this.out.flush();
        this.out.close();
    }

    public void convertToXml(PdfReader reader, OutputStream os) throws IOException {
        this.convertToXml(reader, os, "UTF-8");
    }

    public void inspectChild(PdfObject k2) throws IOException {
        if (k2 == null) {
            return;
        }
        if (k2 instanceof PdfArray) {
            this.inspectChildArray((PdfArray)k2);
        } else if (k2 instanceof PdfDictionary) {
            this.inspectChildDictionary((PdfDictionary)k2);
        }
    }

    public void inspectChildArray(PdfArray k2) throws IOException {
        if (k2 == null) {
            return;
        }
        for (int i2 = 0; i2 < k2.size(); ++i2) {
            this.inspectChild(k2.getDirectObject(i2));
        }
    }

    public void inspectChildDictionary(PdfDictionary k2) throws IOException {
        this.inspectChildDictionary(k2, false);
    }

    public void inspectChildDictionary(PdfDictionary k2, boolean inspectAttributes) throws IOException {
        if (k2 == null) {
            return;
        }
        PdfName s2 = k2.getAsName(PdfName.S);
        if (s2 != null) {
            PdfDictionary dict;
            PdfDictionary a2;
            String tagN = PdfName.decodeName(s2.toString());
            String tag = TaggedPdfReaderTool.fixTagName(tagN);
            this.out.print("<");
            this.out.print(tag);
            if (inspectAttributes && (a2 = k2.getAsDict(PdfName.A)) != null) {
                Set<PdfName> keys2 = a2.getKeys();
                for (PdfName key2 : keys2) {
                    this.out.print(' ');
                    PdfObject value = a2.get(key2);
                    value = PdfReader.getPdfObject(value);
                    this.out.print(this.xmlName(key2));
                    this.out.print("=\"");
                    this.out.print(value.toString());
                    this.out.print("\"");
                }
            }
            this.out.print(">");
            PdfObject alt = k2.get(PdfName.ALT);
            if (alt != null && alt.toString() != null) {
                this.out.print("<alt><![CDATA[");
                this.out.print(alt.toString().replaceAll("[\\000]*", ""));
                this.out.print("]]></alt>");
            }
            if ((dict = k2.getAsDict(PdfName.PG)) != null) {
                this.parseTag(tagN, k2.getDirectObject(PdfName.K), dict);
            }
            this.inspectChild(k2.getDirectObject(PdfName.K));
            this.out.print("</");
            this.out.print(tag);
            this.out.println(">");
        } else {
            this.inspectChild(k2.getDirectObject(PdfName.K));
        }
    }

    protected String xmlName(PdfName name) {
        String xmlName = name.toString().replaceFirst("/", "");
        xmlName = Character.toLowerCase(xmlName.charAt(0)) + xmlName.substring(1);
        return xmlName;
    }

    private static String fixTagName(String tag) {
        StringBuilder sb = new StringBuilder();
        for (int k2 = 0; k2 < tag.length(); ++k2) {
            boolean nameMiddle;
            char c2 = tag.charAt(k2);
            boolean nameStart = c2 == ':' || c2 >= 'A' && c2 <= 'Z' || c2 == '_' || c2 >= 'a' && c2 <= 'z' || c2 >= '\u00c0' && c2 <= '\u00d6' || c2 >= '\u00d8' && c2 <= '\u00f6' || c2 >= '\u00f8' && c2 <= '\u02ff' || c2 >= '\u0370' && c2 <= '\u037d' || c2 >= '\u037f' && c2 <= '\u1fff' || c2 >= '\u200c' && c2 <= '\u200d' || c2 >= '\u2070' && c2 <= '\u218f' || c2 >= '\u2c00' && c2 <= '\u2fef' || c2 >= '\u3001' && c2 <= '\ud7ff' || c2 >= '\uf900' && c2 <= '\ufdcf' || c2 >= '\ufdf0' && c2 <= '\ufffd';
            boolean bl = nameMiddle = c2 == '-' || c2 == '.' || c2 >= '0' && c2 <= '9' || c2 == '\u00b7' || c2 >= '\u0300' && c2 <= '\u036f' || c2 >= '\u203f' && c2 <= '\u2040' || nameStart;
            if (k2 == 0) {
                if (!nameStart) {
                    c2 = '_';
                }
            } else if (!nameMiddle) {
                c2 = '-';
            }
            sb.append(c2);
        }
        return sb.toString();
    }

    public void parseTag(String tag, PdfObject object, PdfDictionary page) throws IOException {
        if (object instanceof PdfNumber) {
            PdfNumber mcid = (PdfNumber)object;
            MarkedContentRenderFilter filter2 = new MarkedContentRenderFilter(mcid.intValue());
            SimpleTextExtractionStrategy strategy = new SimpleTextExtractionStrategy();
            FilteredTextRenderListener listener2 = new FilteredTextRenderListener(strategy, filter2);
            PdfContentStreamProcessor processor = new PdfContentStreamProcessor(listener2);
            processor.processContent(PdfReader.getPageContent(page), page.getAsDict(PdfName.RESOURCES));
            this.out.print(XMLUtil.escapeXML(listener2.getResultantText(), true));
        } else if (object instanceof PdfArray) {
            PdfArray arr = (PdfArray)object;
            int n2 = arr.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.parseTag(tag, arr.getPdfObject(i2), page);
                if (i2 >= n2 - 1) continue;
                this.out.println();
            }
        } else if (object instanceof PdfDictionary) {
            PdfDictionary mcr = (PdfDictionary)object;
            this.parseTag(tag, mcr.getDirectObject(PdfName.MCID), mcr.getAsDict(PdfName.PG));
        }
    }
}

