/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.device.graupner.HoTTAdapter;
import gde.device.graupner.HoTTAdapter2;
import gde.device.graupner.HoTTbinReader;
import gde.device.graupner.HoTTlogHistoReader;
import gde.device.graupner.HoTTlogReader;
import gde.device.graupner.HoTTlogReader2;
import gde.device.graupner.PackageLoss;
import gde.exception.DataInconsitsentException;
import gde.exception.ThrowableUtils;
import gde.histo.device.UniversalSampler;
import gde.log.Level;
import gde.utils.StringHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Logger;

public class HoTTlogHistoReader2
extends HoTTlogHistoReader {
    private static final String $CLASS_NAME = HoTTlogHistoReader2.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private static final int INITIALIZE_SAMPLING_FACTOR = 1;

    public HoTTlogHistoReader2(HoTTAdapter.PickerParameters pickerParameters, HashMap<String, String> newInfoHeader) {
        super(pickerParameters, 1, newInfoHeader);
        HoTTlogReader2.isHoTTAdapter2 = this.analyzer.getActiveDevice() instanceof HoTTAdapter2;
    }

    @Override
    protected void read(InputStream data_in, int initializeBlocks, UniversalSampler histoRandomSample) throws DataInconsitsentException, IOException {
        int i;
        HoTTAdapter2 device = (HoTTAdapter2)this.analyzer.getActiveDevice();
        boolean isChannelsEnabled = this.analyzer.getActiveChannel().getNumber() == 4;
        boolean isReceiverData = false;
        boolean isVarioData = false;
        boolean isGPSData = false;
        boolean isGeneralData = false;
        boolean isElectricData = false;
        boolean isMotorDriverData = false;
        boolean[] isResetMinMax = new boolean[]{false, false, false, false, false};
        int[] points = histoRandomSample.getPoints();
        byte[] buf = new byte[this.dataBlockSize];
        long[] timeSteps_ms = new long[]{0L};
        boolean isTextModusSignaled = false;
        int[] valuesRec = new int[10];
        int[] valuesChn = new int[23];
        int[] valuesVar = new int[13];
        int[] valuesGPS = new int[24];
        int[] valuesGAM = new int[26];
        int[] valuesEAM = new int[31];
        int[] valuesESC = new int[30];
        HoTTbinReader.setAltitudeClimbPickeParameter(this.pickerParameters, this.detectedSensors);
        HoTTlogReader.RcvLogParser rcvLogParser = (HoTTlogReader.RcvLogParser)HoTTAdapter.Sensor.RECEIVER.createLogParser(this.pickerParameters, valuesRec, timeSteps_ms, buf, this.numberUsedChannels);
        HoTTlogReader.ChnLogParser chnLogParser = (HoTTlogReader.ChnLogParser)HoTTAdapter.Sensor.CHANNEL.createLogParser(this.pickerParameters, valuesChn, timeSteps_ms, buf, this.numberUsedChannels);
        HoTTlogReader.VarLogParser varLogParser = (HoTTlogReader.VarLogParser)HoTTAdapter.Sensor.VARIO.createLogParser(this.pickerParameters, valuesVar, timeSteps_ms, buf, this.numberUsedChannels);
        HoTTlogReader.GpsLogParser gpsLogParser = (HoTTlogReader.GpsLogParser)HoTTAdapter.Sensor.GPS.createLogParser(this.pickerParameters, valuesGPS, timeSteps_ms, buf, this.numberUsedChannels);
        HoTTlogReader.GamLogParser gamLogParser = (HoTTlogReader.GamLogParser)HoTTAdapter.Sensor.GAM.createLogParser(this.pickerParameters, valuesGAM, timeSteps_ms, buf, this.numberUsedChannels);
        HoTTlogReader.EamLogParser eamLogParser = (HoTTlogReader.EamLogParser)HoTTAdapter.Sensor.EAM.createLogParser(this.pickerParameters, valuesEAM, timeSteps_ms, buf, this.numberUsedChannels);
        HoTTlogReader.EscLogParser escLogParser = (HoTTlogReader.EscLogParser)HoTTAdapter.Sensor.ESC.createLogParser(this.pickerParameters, valuesESC, timeSteps_ms, buf, this.numberUsedChannels);
        boolean isJustMigrated = false;
        HashSet<HoTTlogReader.LogParser> migrationJobs = new HashSet<HoTTlogReader.LogParser>();
        HoTTlogHistoReader.Procedure migrator = () -> {
            if (migrationJobs.contains(eamLogParser)) {
                eamLogParser.migratePoints(points);
            }
            if (migrationJobs.contains(gamLogParser)) {
                gamLogParser.migratePoints(points);
            }
            if (migrationJobs.contains(gpsLogParser)) {
                gpsLogParser.migratePoints(points);
            }
            if (migrationJobs.contains(varLogParser)) {
                varLogParser.migratePoints(points);
            }
            if (migrationJobs.contains(escLogParser)) {
                escLogParser.migratePoints(points);
            }
            migrationJobs.clear();
        };
        HoTTlogHistoReader.Procedure pointsAdder = initializeBlocks <= 0 ? () -> {
            this.readTimer.invoke();
            boolean isValidSample = histoRandomSample.capturePoints(timeSteps_ms[0]);
            this.reviewTimer.invoke();
            if (isValidSample) {
                try {
                    int j;
                    int[] histoRandomSamplePoints = histoRandomSample.getSamplePoints();
                    if (!isResetMinMax[4]) {
                        for (j = 10; j < 19; ++j) {
                            this.tmpRecordSet.get(j).setMinMax(histoRandomSamplePoints[j], histoRandomSamplePoints[j]);
                        }
                        isResetMinMax[4] = true;
                    }
                    if (!isResetMinMax[3] && histoRandomSamplePoints[27] >= 3000 && histoRandomSamplePoints[20] != 0 && histoRandomSamplePoints[21] != 0) {
                        for (j = 20; j < 37; ++j) {
                            this.tmpRecordSet.get(j).setMinMax(histoRandomSamplePoints[j], histoRandomSamplePoints[j]);
                        }
                        isResetMinMax[3] = true;
                    }
                    if (!isResetMinMax[2] && histoRandomSamplePoints[38] != 0) {
                        for (j = 38; j < 59; ++j) {
                            this.tmpRecordSet.get(j).setMinMax(histoRandomSamplePoints[j], histoRandomSamplePoints[j]);
                        }
                        isResetMinMax[2] = true;
                    }
                    if (!isResetMinMax[1] && histoRandomSamplePoints[60] != 0) {
                        for (j = 60; j < 99; ++j) {
                            this.tmpRecordSet.get(j).setMinMax(histoRandomSamplePoints[j], histoRandomSamplePoints[j]);
                        }
                        isResetMinMax[1] = true;
                    }
                    if (this.isChannelsChannelEnabled) {
                        if (!isResetMinMax[0] && histoRandomSamplePoints[107] != 0) {
                            for (j = 107; j < 135; ++j) {
                                this.tmpRecordSet.get(j).setMinMax(histoRandomSamplePoints[j], histoRandomSamplePoints[j]);
                            }
                            isResetMinMax[0] = true;
                        }
                    } else if (!isResetMinMax[0] && histoRandomSamplePoints[87] != 0) {
                        for (j = 87; j < 115; ++j) {
                            this.tmpRecordSet.get(j).setMinMax(histoRandomSamplePoints[j], histoRandomSamplePoints[j]);
                        }
                        isResetMinMax[0] = true;
                    }
                    this.tmpRecordSet.addPoints(histoRandomSamplePoints, (double)histoRandomSample.getSampleTimeStep_ms());
                }
                catch (DataInconsitsentException e) {
                    throw ThrowableUtils.rethrow((Throwable)e);
                }
                this.addTimer.invoke();
                this.pickTimer.invoke();
            }
        } : () -> histoRandomSample.capturePoints(timeSteps_ms[0]);
        boolean doFullRead = initializeBlocks <= 0;
        int datablocksLimit = doFullRead ? (int)this.logEntryCount : initializeBlocks;
        for (i = 0; i < datablocksLimit; ++i) {
            if (buf.length != data_in.read(buf)) {
                log.log(Level.WARNING, "reading buf failed 1");
            }
            if (this.isASCII) {
                HoTTlogReader.convertAscii2Raw(this.rawDataBlockSize, buf);
            }
            if (buf[8] != 0 && buf[9] != 0 && buf[24] != 31) break;
        }
        while (i < datablocksLimit) {
            if (buf.length != data_in.read(buf)) {
                log.log(Level.WARNING, "reading buf failed 2");
            }
            if (log.isLoggable(Level.FINE)) {
                if (this.isASCII) {
                    log.log(Level.FINE, new String(buf));
                } else {
                    log.log(Level.FINE, StringHelper.byte2Hex4CharString((byte[])buf, (int)buf.length));
                }
            }
            if (this.isASCII) {
                HoTTlogReader.convertAscii2Raw(this.rawDataBlockSize, buf);
            }
            if (buf[8] != 0 && buf[9] != 0) {
                if (buf[24] != 31 && log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, String.format("Sensor %02X", buf[26]));
                }
                rcvLogParser.trackPackageLoss(true);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, StringHelper.byte2Hex2CharString((byte[])new byte[]{buf[7]}, (int)1) + " - " + StringHelper.printBinary((byte)buf[7], (boolean)false));
                }
                if (buf[24] != 31) {
                    isReceiverData = rcvLogParser.parse();
                    System.arraycopy(valuesRec, 0, points, 0, 10);
                }
                if (isChannelsEnabled) {
                    chnLogParser.parse();
                    System.arraycopy(valuesChn, 3, points, 87, 20);
                }
                switch ((byte)(buf[26] & 0xFF)) {
                    case -112: {
                        isVarioData = varLogParser.parse();
                        if (!isVarioData || !isReceiverData) break;
                        migrationJobs.add(varLogParser);
                        migrator.invoke();
                        isJustMigrated = true;
                        isReceiverData = false;
                        break;
                    }
                    case -96: {
                        isGPSData = gpsLogParser.parse();
                        if (!isGPSData || !isReceiverData) break;
                        migrationJobs.add(gpsLogParser);
                        migrator.invoke();
                        isJustMigrated = true;
                        isReceiverData = false;
                        break;
                    }
                    case -48: {
                        isGeneralData = gamLogParser.parse();
                        if (!isGeneralData || !isReceiverData) break;
                        migrationJobs.add(gamLogParser);
                        migrator.invoke();
                        isJustMigrated = true;
                        isReceiverData = false;
                        break;
                    }
                    case -32: {
                        isElectricData = eamLogParser.parse();
                        if (!isElectricData || !isReceiverData) break;
                        migrationJobs.add(eamLogParser);
                        migrator.invoke();
                        isJustMigrated = true;
                        isReceiverData = false;
                        break;
                    }
                    case -64: {
                        isMotorDriverData = escLogParser.parse(this.tmpRecordSet, escLogParser.getTimeStep_ms());
                        if (!isMotorDriverData || !isReceiverData) break;
                        migrationJobs.add(escLogParser);
                        migrator.invoke();
                        isJustMigrated = true;
                        isReceiverData = false;
                        break;
                    }
                }
                if (isReceiverData) {
                    pointsAdder.invoke();
                    isReceiverData = false;
                } else if (isChannelsEnabled && !isJustMigrated) {
                    pointsAdder.invoke();
                }
                timeSteps_ms[0] = timeSteps_ms[0] + 50L;
                if (isJustMigrated) {
                    pointsAdder.invoke();
                }
                isJustMigrated = !rcvLogParser.updateLossStatistics();
                isJustMigrated = false;
            } else {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "-->> Found tx=rx=0 dBm");
                }
                rcvLogParser.trackPackageLoss(false);
                if (isChannelsEnabled) {
                    chnLogParser.parse();
                    System.arraycopy(valuesChn, 3, points, 87, 20);
                    pointsAdder.invoke();
                }
                timeSteps_ms[0] = timeSteps_ms[0] + 50L;
            }
            ++i;
        }
        if (doFullRead) {
            rcvLogParser.finalUpdateLossStatistics();
            PackageLoss lostPackages = rcvLogParser.getLostPackages();
            Integer[] scores = this.getScores(lostPackages, histoRandomSample, this.truss.getVault());
            device.calculateInactiveRecords(this.tmpRecordSet);
            device.updateVisibilityStatus(this.tmpRecordSet, true);
            this.truss.promoteTruss(this.tmpRecordSet, scores);
            this.finishTimer.invoke();
            this.writeFinalLog(isTextModusSignaled, lostPackages, histoRandomSample, this.truss.getVault());
            this.tmpRecordSet.cleanup();
        }
        log.log(Level.FINER, " > ends <  doFullRead=", doFullRead);
    }
}

