/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.dialog.edit;

import gde.GDE;
import gde.device.DataTypes;
import gde.device.DeviceConfiguration;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.ui.dialog.edit.ChannelTypeTabItem;
import gde.ui.dialog.edit.ContextMenu;
import gde.ui.dialog.edit.DevicePropertiesEditor;
import gde.utils.StringHelper;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class UsbPortTypeTabItem
extends CTabItem {
    static final Logger log = Logger.getLogger(ChannelTypeTabItem.class.getName());
    Composite usbPortComposite;
    Composite timeOutComposite;
    Label usbPortDescriptionLabel;
    Label timeOutDescriptionLabel;
    Label vendorIDLabel;
    Label productIDLabel;
    Label productStringLabel;
    Label interfaceLabel;
    Label endPointInLable;
    Label endPointOutLable;
    Label timeOutLabel;
    Text vendorIDText;
    Text productIDText;
    Text productStringText;
    Text interfaceText;
    Text endPointInText;
    Text endPointOutText;
    Button productStringButton;
    Button timeOutButton;
    Label ReadTimeoutLabel;
    Label ReadStableIndexLabel;
    Label _WTOCharDelayTimeLabel;
    Label _WTOExtraDelayTimeLabel;
    Text ReadTimeoutText;
    Text ReadStableIndexText;
    Text _WTOCharDelayTimeText;
    Text _WTOExtraDelayTimeText;
    String vendorID = "";
    String productID = "";
    String productString = "";
    boolean isUseProductString = false;
    String usbInterface = "";
    String usbEndPointIn = "";
    String usbEndPointOut = "";
    boolean isUseTimeOut = false;
    int ReadTimeout = 0;
    int ReadStableIndex = 0;
    int WTOCharDelayTime = 0;
    int WTOExtraDelayTime = 0;
    DeviceConfiguration deviceConfig;
    Menu popupMenu;
    ContextMenu contextMenu;
    final CTabFolder tabFolder;
    final DevicePropertiesEditor propsEditor;

    public UsbPortTypeTabItem(CTabFolder parent, int style, int index) {
        super(parent, style, index);
        this.tabFolder = parent;
        this.propsEditor = DevicePropertiesEditor.getInstance();
        log.log(java.util.logging.Level.FINE, "UsbPortTypeTabItem ");
        this.initGUI();
    }

    private void initGUI() {
        try {
            SWTResourceManager.registerResourceUser((Widget)this);
            this.setText(Messages.getString("GDE_MSGT0979"));
            this.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.usbPortComposite = new Composite((Composite)this.tabFolder, 0);
            this.usbPortComposite.setLayout(null);
            this.setControl((Control)this.usbPortComposite);
            this.usbPortComposite.addHelpListener(new HelpListener(){

                public void helpRequested(HelpEvent evt) {
                    log.log(Level.FINEST, "usbPortComposite.helpRequested " + String.valueOf(evt));
                    DataExplorer.getInstance().openHelpDialog("", "HelpInfo_A1.html#device_properties_serial_port");
                }
            });
            this.usbPortComposite.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent focusevent) {
                    log.log(java.util.logging.Level.FINEST, "usbPortComposite.focusLost, event=" + String.valueOf(focusevent));
                    UsbPortTypeTabItem.this.enableContextmenu(false);
                }

                public void focusGained(FocusEvent focusevent) {
                    log.log(java.util.logging.Level.FINEST, "usbPortComposite.focusGained, event=" + String.valueOf(focusevent));
                    UsbPortTypeTabItem.this.enableContextmenu(true);
                }
            });
            this.usbPortDescriptionLabel = new Label(this.usbPortComposite, 0x1000040);
            this.usbPortDescriptionLabel.setText(Messages.getString("GDE_MSGT0980"));
            this.usbPortDescriptionLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.usbPortDescriptionLabel.setBounds(12, 6, 602, 56);
            this.vendorIDLabel = new Label(this.usbPortComposite, 16384);
            this.vendorIDLabel.setText("Vendor ID");
            this.vendorIDLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.vendorIDLabel.setBounds(30, 74, 100, 20);
            this.vendorIDText = new Text(this.usbPortComposite, 2048);
            this.vendorIDText.setBounds(150, 76, 60, 20);
            this.vendorIDText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.vendorIDText.setEditable(true);
            this.vendorIDText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "vendorIDText.verifyText, event=" + String.valueOf(evt));
                    evt.doit = StringHelper.verifyTypedInput(DataTypes.STRING, evt.text);
                }
            });
            this.vendorIDText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "vendorIDText.keyReleased, event=" + String.valueOf(evt));
                    UsbPortTypeTabItem.this.productID = UsbPortTypeTabItem.this.vendorIDText.getText();
                    if (UsbPortTypeTabItem.this.deviceConfig != null) {
                        UsbPortTypeTabItem.this.deviceConfig.setUsbVendorId(UsbPortTypeTabItem.this.vendorIDText.getText().trim());
                        UsbPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this.productIDLabel = new Label(this.usbPortComposite, 16384);
            this.productIDLabel.setText("Product ID");
            this.productIDLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.productIDLabel.setBounds(30, 104, 100, 20);
            this.productIDText = new Text(this.usbPortComposite, 2048);
            this.productIDText.setBounds(150, 106, 60, 20);
            this.productIDText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.productIDText.setEditable(true);
            this.productIDText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "productIDText.verifyText, event=" + String.valueOf(evt));
                    evt.doit = StringHelper.verifyTypedInput(DataTypes.STRING, evt.text);
                }
            });
            this.productIDText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "productIDText.keyReleased, event=" + String.valueOf(evt));
                    UsbPortTypeTabItem.this.productID = UsbPortTypeTabItem.this.productIDText.getText();
                    if (UsbPortTypeTabItem.this.deviceConfig != null) {
                        UsbPortTypeTabItem.this.deviceConfig.setTcpPortNumber(UsbPortTypeTabItem.this.productIDText.getText().trim());
                        UsbPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            Group productStringGroup = new Group(this.usbPortComposite, 2048);
            productStringGroup.setText("Product String (optional)");
            productStringGroup.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            productStringGroup.setBounds(25, 134, 320, 70);
            this.productStringButton = new Button((Composite)productStringGroup, 2080);
            this.productStringButton.setBounds(8, 10, 15, 15);
            this.productStringButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "productStringButton.widgetSelected, event=" + String.valueOf(evt));
                    UsbPortTypeTabItem.this.isUseProductString = UsbPortTypeTabItem.this.productStringButton.getSelection();
                    UsbPortTypeTabItem.this.productStringLabel.setEnabled(UsbPortTypeTabItem.this.isUseProductString);
                    UsbPortTypeTabItem.this.productStringText.setEnabled(UsbPortTypeTabItem.this.isUseProductString);
                    UsbPortTypeTabItem.this.productStringText.setEditable(UsbPortTypeTabItem.this.isUseProductString);
                    if (UsbPortTypeTabItem.this.isUseProductString) {
                        if (UsbPortTypeTabItem.this.deviceConfig != null) {
                            UsbPortTypeTabItem.this.productString = UsbPortTypeTabItem.this.deviceConfig.getName();
                            UsbPortTypeTabItem.this.productStringText.setText(UsbPortTypeTabItem.this.productString);
                            String productString = UsbPortTypeTabItem.this.productStringText.getText().trim();
                            UsbPortTypeTabItem.this.deviceConfig.setUsbProductString(productString);
                            UsbPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                        }
                    } else if (UsbPortTypeTabItem.this.deviceConfig != null) {
                        UsbPortTypeTabItem.this.deviceConfig.removeUsbProductString();
                        UsbPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                    UsbPortTypeTabItem.this.enableTimeout();
                }
            });
            this.productStringLabel = new Label((Composite)productStringGroup, 16384);
            this.productStringLabel.setText("Product String");
            this.productStringLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.productStringLabel.setBounds(30, 10, 90, 20);
            this.productStringText = new Text((Composite)productStringGroup, 2048);
            this.productStringText.setBounds(120, 10, 180, 20);
            this.productStringText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.productStringText.setEditable(true);
            this.productStringText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "productStringText.verifyText, event=" + String.valueOf(evt));
                    evt.doit = StringHelper.verifyTypedInput(DataTypes.STRING, evt.text);
                }
            });
            this.productStringText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "productStringText.keyReleased, event=" + String.valueOf(evt));
                    UsbPortTypeTabItem.this.productString = UsbPortTypeTabItem.this.productStringText.getText();
                    if (UsbPortTypeTabItem.this.deviceConfig != null) {
                        String productString = UsbPortTypeTabItem.this.productStringText.getText().trim();
                        UsbPortTypeTabItem.this.deviceConfig.setUsbProductString(productString);
                        UsbPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this.interfaceLabel = new Label(this.usbPortComposite, 16384);
            this.interfaceLabel.setText("Interface");
            this.interfaceLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.interfaceLabel.setBounds(30, 210, 150, 20);
            this.interfaceText = new Text(this.usbPortComposite, 2048);
            this.interfaceText.setBounds(150, 210, 60, 20);
            this.interfaceText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.interfaceText.setEditable(true);
            this.interfaceText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "interfaceText.verifyText, event=" + String.valueOf(evt));
                    evt.doit = StringHelper.verifyTypedInput(DataTypes.STRING, evt.text);
                }
            });
            this.interfaceText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "interfaceIdText.keyReleased, event=" + String.valueOf(evt));
                    UsbPortTypeTabItem.this.usbInterface = UsbPortTypeTabItem.this.interfaceText.getText();
                    if (UsbPortTypeTabItem.this.deviceConfig != null) {
                        UsbPortTypeTabItem.this.deviceConfig.setUsbInterface(UsbPortTypeTabItem.this.interfaceText.getText().trim());
                        UsbPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this.endPointInLable = new Label(this.usbPortComposite, 16384);
            this.endPointInLable.setText("Endpoint In");
            this.endPointInLable.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.endPointInLable.setBounds(30, 250, 150, 20);
            this.endPointInText = new Text(this.usbPortComposite, 2048);
            this.endPointInText.setBounds(150, 250, 60, 20);
            this.endPointInText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.endPointInText.setEditable(true);
            this.endPointInText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "endPointInText.verifyText, event=" + String.valueOf(evt));
                    evt.doit = StringHelper.verifyTypedInput(DataTypes.STRING, evt.text);
                }
            });
            this.endPointInText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "endPointInText.keyReleased, event=" + String.valueOf(evt));
                    UsbPortTypeTabItem.this.usbEndPointIn = UsbPortTypeTabItem.this.endPointInText.getText().trim();
                    if (UsbPortTypeTabItem.this.deviceConfig != null) {
                        UsbPortTypeTabItem.this.deviceConfig.setUsbEndpointIn(UsbPortTypeTabItem.this.usbEndPointIn);
                        UsbPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this.endPointOutLable = new Label(this.usbPortComposite, 16384);
            this.endPointOutLable.setText("Endpoint Out");
            this.endPointOutLable.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.endPointOutLable.setBounds(30, 290, 150, 20);
            this.endPointOutText = new Text(this.usbPortComposite, 2048);
            this.endPointOutText.setBounds(150, 290, 60, 20);
            this.endPointOutText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.endPointOutText.setEditable(true);
            this.endPointOutText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "endPointOutText.verifyText, event=" + String.valueOf(evt));
                    evt.doit = StringHelper.verifyTypedInput(DataTypes.STRING, evt.text);
                }
            });
            this.endPointOutText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "endPointOutText.keyReleased, event=" + String.valueOf(evt));
                    UsbPortTypeTabItem.this.usbEndPointOut = UsbPortTypeTabItem.this.endPointOutText.getText().trim();
                    if (UsbPortTypeTabItem.this.deviceConfig != null) {
                        UsbPortTypeTabItem.this.deviceConfig.setUsbEndpointOut(UsbPortTypeTabItem.this.usbEndPointOut);
                        UsbPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this.timeOutComposite = new Composite(this.usbPortComposite, 2048);
            this.timeOutComposite.setLayout(null);
            this.timeOutComposite.setBounds(355, 80, 250, 220);
            this.timeOutDescriptionLabel = new Label(this.timeOutComposite, 64);
            this.timeOutDescriptionLabel.setText(Messages.getString("GDE_MSGT0591"));
            this.timeOutDescriptionLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.timeOutDescriptionLabel.setBounds(6, 3, 232, 69);
            this.timeOutLabel = new Label(this.timeOutComposite, 131072);
            this.timeOutLabel.setText(Messages.getString("GDE_MSGT0586"));
            this.timeOutLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.timeOutLabel.setBounds(6, 70, 140, 20);
            this.timeOutButton = new Button(this.timeOutComposite, 32);
            this.timeOutButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.timeOutButton.setBounds(161, 70, 70, 20);
            this.timeOutButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "timeOutButton.widgetSelected, event=" + String.valueOf(evt));
                    UsbPortTypeTabItem.this.isUseTimeOut = UsbPortTypeTabItem.this.timeOutButton.getSelection();
                    if (UsbPortTypeTabItem.this.isUseTimeOut) {
                        if (UsbPortTypeTabItem.this.deviceConfig != null) {
                            UsbPortTypeTabItem.this.ReadTimeout = UsbPortTypeTabItem.this.deviceConfig.getReadTimeOut();
                            UsbPortTypeTabItem.this.deviceConfig.setReadTimeOut(UsbPortTypeTabItem.this.ReadTimeout);
                            UsbPortTypeTabItem.this.ReadStableIndex = UsbPortTypeTabItem.this.deviceConfig.getReadStableIndex();
                            UsbPortTypeTabItem.this.deviceConfig.setReadStableIndex(UsbPortTypeTabItem.this.ReadStableIndex);
                            UsbPortTypeTabItem.this.WTOCharDelayTime = UsbPortTypeTabItem.this.deviceConfig.getWriteCharDelayTime();
                            UsbPortTypeTabItem.this.deviceConfig.setWriteCharDelayTime(UsbPortTypeTabItem.this.WTOCharDelayTime);
                            UsbPortTypeTabItem.this.WTOExtraDelayTime = UsbPortTypeTabItem.this.deviceConfig.getWriteDelayTime();
                            UsbPortTypeTabItem.this.deviceConfig.setWriteDelayTime(UsbPortTypeTabItem.this.WTOExtraDelayTime);
                            UsbPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                        } else {
                            UsbPortTypeTabItem.this.ReadTimeout = 0;
                            UsbPortTypeTabItem.this.ReadStableIndex = 0;
                            UsbPortTypeTabItem.this.WTOCharDelayTime = 0;
                            UsbPortTypeTabItem.this.WTOExtraDelayTime = 0;
                        }
                    } else {
                        if (UsbPortTypeTabItem.this.deviceConfig != null) {
                            UsbPortTypeTabItem.this.deviceConfig.removeSerialPortTimeOut();
                        }
                        UsbPortTypeTabItem.this.ReadTimeout = 0;
                        UsbPortTypeTabItem.this.ReadStableIndex = 0;
                        UsbPortTypeTabItem.this.WTOCharDelayTime = 0;
                        UsbPortTypeTabItem.this.WTOExtraDelayTime = 0;
                    }
                    UsbPortTypeTabItem.this.enableTimeout();
                }
            });
            this.ReadTimeoutLabel = new Label(this.timeOutComposite, 131072);
            this.ReadTimeoutLabel.setText(Messages.getString("GDE_MSGT0587"));
            this.ReadTimeoutLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.ReadTimeoutLabel.setBounds(6, 100, 140, 20);
            this.ReadTimeoutText = new Text(this.timeOutComposite, 2048);
            this.ReadTimeoutText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.ReadTimeoutText.setBounds(162, 100, 70, 20);
            this.ReadTimeoutText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "ReadTimeoutText.verifyText, event=" + String.valueOf(evt));
                    evt.doit = StringHelper.verifyTypedInput(DataTypes.INTEGER, evt.text);
                }
            });
            this.ReadTimeoutText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "ReadTimeoutText.keyReleased, event=" + String.valueOf(evt));
                    int n = UsbPortTypeTabItem.this.ReadTimeout = UsbPortTypeTabItem.this.ReadTimeoutText.getText().equals("") ? 0 : Integer.parseInt(UsbPortTypeTabItem.this.ReadTimeoutText.getText());
                    if (UsbPortTypeTabItem.this.deviceConfig != null) {
                        UsbPortTypeTabItem.this.deviceConfig.setReadTimeOut(UsbPortTypeTabItem.this.ReadTimeout);
                        UsbPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this.ReadStableIndexLabel = new Label(this.timeOutComposite, 131072);
            this.ReadStableIndexLabel.setText(Messages.getString("GDE_MSGT0588"));
            this.ReadStableIndexLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.ReadStableIndexLabel.setBounds(6, 130, 140, 20);
            this.ReadStableIndexText = new Text(this.timeOutComposite, 2048);
            this.ReadStableIndexText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.ReadStableIndexText.setBounds(162, 130, 70, 20);
            this.ReadStableIndexText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "ReadStableIndexText.verifyText, event=" + String.valueOf(evt));
                    evt.doit = StringHelper.verifyTypedInput(DataTypes.INTEGER, evt.text);
                }
            });
            this.ReadStableIndexText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "ReadStableIndexText.keyReleased, event=" + String.valueOf(evt));
                    int n = UsbPortTypeTabItem.this.ReadStableIndex = UsbPortTypeTabItem.this.ReadStableIndexText.getText().equals("") ? 0 : Integer.parseInt(UsbPortTypeTabItem.this.ReadStableIndexText.getText());
                    if (UsbPortTypeTabItem.this.deviceConfig != null) {
                        UsbPortTypeTabItem.this.deviceConfig.setReadStableIndex(UsbPortTypeTabItem.this.ReadStableIndex);
                        UsbPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this._WTOCharDelayTimeLabel = new Label(this.timeOutComposite, 131072);
            this._WTOCharDelayTimeLabel.setText(Messages.getString("GDE_MSGT0589"));
            this._WTOCharDelayTimeLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this._WTOCharDelayTimeLabel.setBounds(6, 160, 140, 20);
            this._WTOCharDelayTimeText = new Text(this.timeOutComposite, 2048);
            this._WTOCharDelayTimeText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this._WTOCharDelayTimeText.setBounds(162, 160, 70, 20);
            this._WTOCharDelayTimeText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "_WRTOCharDelayTimeText.verifyText, event=" + String.valueOf(evt));
                    evt.doit = StringHelper.verifyTypedInput(DataTypes.INTEGER, evt.text);
                }
            });
            this._WTOCharDelayTimeText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "_WRTOCharDelayTimeText.keyReleased, event=" + String.valueOf(evt));
                    int n = UsbPortTypeTabItem.this.WTOCharDelayTime = UsbPortTypeTabItem.this._WTOCharDelayTimeText.getText().equals("") ? 0 : Integer.parseInt(UsbPortTypeTabItem.this._WTOCharDelayTimeText.getText());
                    if (UsbPortTypeTabItem.this.deviceConfig != null) {
                        UsbPortTypeTabItem.this.deviceConfig.setWriteCharDelayTime(UsbPortTypeTabItem.this.WTOCharDelayTime);
                        UsbPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this._WTOExtraDelayTimeLabel = new Label(this.timeOutComposite, 131072);
            this._WTOExtraDelayTimeLabel.setText(Messages.getString("GDE_MSGT0590"));
            this._WTOExtraDelayTimeLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this._WTOExtraDelayTimeLabel.setBounds(6, 190, 140, 20);
            this._WTOExtraDelayTimeText = new Text(this.timeOutComposite, 2048);
            this._WTOExtraDelayTimeText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this._WTOExtraDelayTimeText.setBounds(162, 190, 70, 20);
            this._WTOExtraDelayTimeText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "_WTOExtraDelayTimeText.verifyText, event=" + String.valueOf(evt));
                    evt.doit = StringHelper.verifyTypedInput(DataTypes.INTEGER, evt.text);
                }
            });
            this._WTOExtraDelayTimeText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "_WTOExtraDelayTimeText.keyReleased, event=" + String.valueOf(evt));
                    int n = UsbPortTypeTabItem.this.WTOExtraDelayTime = UsbPortTypeTabItem.this._WTOExtraDelayTimeText.getText().equals("") ? 0 : Integer.parseInt(UsbPortTypeTabItem.this._WTOExtraDelayTimeText.getText());
                    if (UsbPortTypeTabItem.this.deviceConfig != null) {
                        UsbPortTypeTabItem.this.deviceConfig.setWriteDelayTime(UsbPortTypeTabItem.this.WTOExtraDelayTime);
                        UsbPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void enableContextmenu(boolean enable) {
        if (enable && (this.popupMenu == null || this.contextMenu == null)) {
            this.popupMenu = new Menu((Decorations)this.tabFolder.getShell(), 8);
            this.contextMenu = new ContextMenu(this.popupMenu, this.tabFolder);
            this.contextMenu.create();
        } else {
            this.popupMenu = null;
            this.contextMenu = null;
        }
        this.usbPortComposite.setMenu(this.popupMenu);
        this.usbPortDescriptionLabel.setMenu(this.popupMenu);
        this.productIDLabel.setMenu(this.popupMenu);
        this.timeOutComposite.setMenu(this.popupMenu);
        this.timeOutLabel.setMenu(this.popupMenu);
        this.timeOutButton.setMenu(this.popupMenu);
        this.ReadTimeoutLabel.setMenu(this.popupMenu);
        this.ReadStableIndexLabel.setMenu(this.popupMenu);
        this._WTOCharDelayTimeLabel.setMenu(this.popupMenu);
        this._WTOExtraDelayTimeLabel.setMenu(this.popupMenu);
        this.timeOutDescriptionLabel.setMenu(this.popupMenu);
    }

    public void setDeviceConfig(DeviceConfiguration deviceConfig) {
        this.deviceConfig = deviceConfig;
        if (deviceConfig.getUsbPortType() == null) {
            deviceConfig.createUsbPort();
        }
        this.vendorID = deviceConfig.getUsbPortType().getVendorId();
        this.productID = deviceConfig.getUsbPortType().getProductId();
        if (deviceConfig.getUsbPortType().getProductString() != null) {
            this.isUseProductString = true;
            this.productStringButton.setSelection(true);
            this.productString = deviceConfig.getUsbPortType().getProductString();
        } else {
            this.isUseProductString = false;
            this.productStringButton.setSelection(false);
        }
        this.usbInterface = deviceConfig.getUsbPortType().getUsbInterface().getInterface().getValue();
        this.usbEndPointIn = deviceConfig.getUsbPortType().getUsbInterface().getEndPointIn();
        this.usbEndPointOut = deviceConfig.getUsbPortType().getUsbInterface().getEndPointOut();
        if (deviceConfig.getUsbPortType().getTimeOut() != null) {
            this.isUseTimeOut = true;
            this.timeOutButton.setSelection(true);
        } else {
            this.isUseTimeOut = false;
            this.timeOutButton.setSelection(false);
        }
        this.ReadTimeout = deviceConfig.getReadTimeOut();
        this.ReadStableIndex = deviceConfig.getReadStableIndex();
        this.WTOCharDelayTime = deviceConfig.getWriteCharDelayTime();
        this.WTOExtraDelayTime = deviceConfig.getWriteDelayTime();
        this.timeOutComposite.redraw();
        this.initialize();
    }

    private void initialize() {
        this.vendorIDText.setText(this.vendorID);
        this.productIDText.setText(this.productID);
        this.productStringText.setEnabled(this.isUseProductString);
        this.productStringText.setEditable(this.isUseProductString);
        if (this.isUseProductString) {
            this.productStringButton.setSelection(true);
            this.productStringText.setText(this.productString);
        }
        this.interfaceText.setText(this.usbInterface);
        this.endPointInText.setText(this.usbEndPointIn);
        this.endPointOutText.setText(this.usbEndPointOut);
        this.ReadTimeoutText.setText("" + this.ReadTimeout);
        this.ReadStableIndexText.setText("" + this.ReadStableIndex);
        this._WTOCharDelayTimeText.setText("" + this.WTOCharDelayTime);
        this._WTOExtraDelayTimeText.setText("" + this.WTOExtraDelayTime);
        this.timeOutButton.setSelection(this.isUseTimeOut);
        this.enableTimeout();
    }

    private void enableTimeout() {
        if (this.timeOutButton.getSelection()) {
            this.ReadTimeoutLabel.setEnabled(true);
            this.ReadTimeoutText.setEnabled(true);
            this.ReadStableIndexLabel.setEnabled(true);
            this.ReadStableIndexText.setEnabled(true);
            this._WTOCharDelayTimeLabel.setEnabled(true);
            this._WTOCharDelayTimeText.setEnabled(true);
            this._WTOExtraDelayTimeLabel.setEnabled(true);
            this._WTOExtraDelayTimeText.setEnabled(true);
        } else {
            this.ReadTimeoutLabel.setEnabled(false);
            this.ReadTimeoutText.setEnabled(false);
            this.ReadStableIndexLabel.setEnabled(false);
            this.ReadStableIndexText.setEnabled(false);
            this._WTOCharDelayTimeLabel.setEnabled(false);
            this._WTOCharDelayTimeText.setEnabled(false);
            this._WTOExtraDelayTimeLabel.setEnabled(false);
            this._WTOExtraDelayTimeText.setEnabled(false);
        }
    }
}

