/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.dialog.edit;

import gde.GDE;
import gde.comm.DeviceCommPort;
import gde.device.DataBitsTypes;
import gde.device.DataTypes;
import gde.device.DeviceConfiguration;
import gde.device.FlowControlTypes;
import gde.device.ParityTypes;
import gde.device.RespondType;
import gde.device.StopBitsTypes;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.ui.dialog.edit.ChannelTypeTabItem;
import gde.ui.dialog.edit.ContextMenu;
import gde.ui.dialog.edit.DevicePropertiesEditor;
import gde.utils.StringHelper;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SeriaPortTypeTabItem
extends CTabItem {
    static final Logger log = Logger.getLogger(ChannelTypeTabItem.class.getName());
    Composite serialPortComposite;
    Composite timeOutComposite;
    Label serialPortDescriptionLabel;
    Label timeOutDescriptionLabel;
    Label portNameLabel;
    Label baudeRateLabel;
    Label dataBitsLabel;
    Label stopBitsLabel;
    Label parityLabel;
    Label flowControlLabel;
    Label rtsLabel;
    Label dtrLabel;
    Label respondLabel;
    Label requestLabel;
    Label timeOutLabel;
    Text portNameText;
    Text requestText;
    CCombo baudeRateCombo;
    CCombo dataBitsCombo;
    CCombo stopBitsCombo;
    CCombo parityCombo;
    CCombo flowControlCombo;
    CCombo respondCombo;
    Button isRTSButton;
    Button isDTRButton;
    Button requestButton;
    Button timeOutButton;
    Label ReadTimeoutLabel;
    Label ReadStableIndexLabel;
    Label _WTOCharDelayTimeLabel;
    Label _WTOExtraDelayTimeLabel;
    Text ReadTimeoutText;
    Text ReadStableIndexText;
    Text _WTOCharDelayTimeText;
    Text _WTOExtraDelayTimeText;
    String portName = "";
    int baudeRateIndex = 0;
    int dataBitsIndex = 0;
    int stopBitsIndex = 0;
    int parityIndex = 0;
    int flowControlIndex = 0;
    boolean isRTS = false;
    boolean isDTR = false;
    RespondType respondType = RespondType.fromValue("CSV");
    String request = "";
    boolean isUseRequest = false;
    boolean useTimeOut = false;
    int ReadTimeout = 0;
    int ReadStableIndex = 0;
    int WTOCharDelayTime = 0;
    int WTOExtraDelayTime = 0;
    DeviceConfiguration deviceConfig;
    Menu popupMenu;
    ContextMenu contextMenu;
    final CTabFolder tabFolder;
    final DevicePropertiesEditor propsEditor;

    public SeriaPortTypeTabItem(CTabFolder parent, int style, int index) {
        super(parent, style, index);
        this.tabFolder = parent;
        this.propsEditor = DevicePropertiesEditor.getInstance();
        log.log(java.util.logging.Level.FINE, "SeriaPortTypeTabItem ");
        this.initGUI();
    }

    private void initGUI() {
        try {
            SWTResourceManager.registerResourceUser((Widget)this);
            this.setText(Messages.getString("GDE_MSGT0510"));
            this.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.serialPortComposite = new Composite((Composite)this.tabFolder, 0);
            this.serialPortComposite.setLayout(null);
            this.setControl((Control)this.serialPortComposite);
            this.serialPortComposite.addHelpListener(new HelpListener(){

                public void helpRequested(HelpEvent evt) {
                    log.log(Level.FINEST, "serialPortComposite.helpRequested " + String.valueOf(evt));
                    DataExplorer.getInstance().openHelpDialog("", "HelpInfo_A1.html#device_properties_serial_port");
                }
            });
            this.serialPortComposite.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent focusevent) {
                    log.log(java.util.logging.Level.FINEST, "serialPortComposite.focusLost, event=" + String.valueOf(focusevent));
                    SeriaPortTypeTabItem.this.enableContextmenu(false);
                }

                public void focusGained(FocusEvent focusevent) {
                    log.log(java.util.logging.Level.FINEST, "serialPortComposite.focusGained, event=" + String.valueOf(focusevent));
                    SeriaPortTypeTabItem.this.enableContextmenu(true);
                }
            });
            this.serialPortDescriptionLabel = new Label(this.serialPortComposite, 0x1000040);
            this.serialPortDescriptionLabel.setText(Messages.getString("GDE_MSGT0577"));
            this.serialPortDescriptionLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.serialPortDescriptionLabel.setBounds(12, 6, 602, 56);
            this.portNameLabel = new Label(this.serialPortComposite, 131072);
            this.portNameLabel.setText(Messages.getString("GDE_MSGT0578"));
            this.portNameLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.portNameLabel.setBounds(5, 74, 100, 20);
            this.portNameText = new Text(this.serialPortComposite, 2048);
            this.portNameText.setBounds(141, 76, 180, 20);
            this.portNameText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.portNameText.setEditable(false);
            this.baudeRateLabel = new Label(this.serialPortComposite, 131072);
            this.baudeRateLabel.setText(Messages.getString("GDE_MSGT0579"));
            this.baudeRateLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.baudeRateLabel.setBounds(5, 99, 100, 20);
            this.baudeRateCombo = new CCombo(this.serialPortComposite, 2048);
            this.baudeRateCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.baudeRateCombo.setItems(DeviceCommPort.STRING_ARRAY_BAUDE_RATES);
            this.baudeRateCombo.setBounds(142, 101, 180, 20);
            this.baudeRateCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "baudeRateCombo.widgetSelected, event=" + String.valueOf(evt));
                    if (SeriaPortTypeTabItem.this.deviceConfig != null) {
                        SeriaPortTypeTabItem.this.deviceConfig.setBaudeRate(Integer.valueOf(SeriaPortTypeTabItem.this.baudeRateCombo.getText()));
                        SeriaPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                    SeriaPortTypeTabItem.this.baudeRateIndex = SeriaPortTypeTabItem.this.baudeRateCombo.getSelectionIndex();
                }
            });
            this.dataBitsLabel = new Label(this.serialPortComposite, 131072);
            this.dataBitsLabel.setText(Messages.getString("GDE_MSGT0580"));
            this.dataBitsLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.dataBitsLabel.setBounds(5, 124, 100, 20);
            this.dataBitsCombo = new CCombo(this.serialPortComposite, 2048);
            this.dataBitsCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.dataBitsCombo.setItems(DataBitsTypes.valuesAsStingArray());
            this.dataBitsCombo.setBounds(142, 126, 180, 20);
            this.dataBitsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "dataBitsCombo.widgetSelected, event=" + String.valueOf(evt));
                    if (SeriaPortTypeTabItem.this.deviceConfig != null) {
                        SeriaPortTypeTabItem.this.deviceConfig.setDataBits(DataBitsTypes.fromValue(SeriaPortTypeTabItem.this.dataBitsCombo.getText()));
                    }
                    SeriaPortTypeTabItem.this.dataBitsIndex = SeriaPortTypeTabItem.this.dataBitsCombo.getSelectionIndex();
                }
            });
            this.stopBitsLabel = new Label(this.serialPortComposite, 131072);
            this.stopBitsLabel.setText(Messages.getString("GDE_MSGT0581"));
            this.stopBitsLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.stopBitsLabel.setBounds(5, 149, 100, 20);
            this.stopBitsCombo = new CCombo(this.serialPortComposite, 2048);
            this.stopBitsCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.stopBitsCombo.setItems(StopBitsTypes.valuesAsStingArray());
            this.stopBitsCombo.setBounds(142, 151, 180, 20);
            this.stopBitsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "stopBitsCombo.widgetSelected, event=" + String.valueOf(evt));
                    if (SeriaPortTypeTabItem.this.deviceConfig != null) {
                        SeriaPortTypeTabItem.this.deviceConfig.setStopBits(StopBitsTypes.values()[SeriaPortTypeTabItem.this.stopBitsCombo.getSelectionIndex()]);
                        SeriaPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                    SeriaPortTypeTabItem.this.stopBitsIndex = SeriaPortTypeTabItem.this.stopBitsCombo.getSelectionIndex();
                }
            });
            this.parityLabel = new Label(this.serialPortComposite, 131072);
            this.parityLabel.setText(Messages.getString("GDE_MSGT0582"));
            this.parityLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.parityLabel.setBounds(5, 174, 100, 20);
            this.parityCombo = new CCombo(this.serialPortComposite, 2048);
            this.parityCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.parityCombo.setItems(ParityTypes.valuesAsStingArray());
            this.parityCombo.setBounds(142, 176, 180, 20);
            this.parityCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "parityCombo.widgetSelected, event=" + String.valueOf(evt));
                    if (SeriaPortTypeTabItem.this.deviceConfig != null) {
                        SeriaPortTypeTabItem.this.deviceConfig.setParity(ParityTypes.values()[SeriaPortTypeTabItem.this.parityCombo.getSelectionIndex()]);
                        SeriaPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                    SeriaPortTypeTabItem.this.parityIndex = SeriaPortTypeTabItem.this.parityCombo.getSelectionIndex();
                }
            });
            this.flowControlLabel = new Label(this.serialPortComposite, 131072);
            this.flowControlLabel.setText(Messages.getString("GDE_MSGT0583"));
            this.flowControlLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.flowControlLabel.setBounds(5, 199, 100, 20);
            this.flowControlCombo = new CCombo(this.serialPortComposite, 2048);
            this.flowControlCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.flowControlCombo.setItems(FlowControlTypes.valuesAsStingArray());
            this.flowControlCombo.setBounds(142, 201, 180, 20);
            this.flowControlCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "flowControlCombo.widgetSelected, event=" + String.valueOf(evt));
                    if (SeriaPortTypeTabItem.this.deviceConfig != null) {
                        SeriaPortTypeTabItem.this.deviceConfig.setFlowCtrlMode(FlowControlTypes.values()[SeriaPortTypeTabItem.this.flowControlCombo.getSelectionIndex()]);
                        SeriaPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                    SeriaPortTypeTabItem.this.flowControlIndex = SeriaPortTypeTabItem.this.flowControlCombo.getSelectionIndex();
                }
            });
            this.rtsLabel = new Label(this.serialPortComposite, 131072);
            this.rtsLabel.setText(Messages.getString("GDE_MSGT0584"));
            this.rtsLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.rtsLabel.setBounds(5, 224, 100, 20);
            this.isRTSButton = new Button(this.serialPortComposite, 32);
            this.isRTSButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.isRTSButton.setBounds(142, 224, 180, 20);
            this.isRTSButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "isRTSButton.widgetSelected, event=" + String.valueOf(evt));
                    if (SeriaPortTypeTabItem.this.deviceConfig != null) {
                        SeriaPortTypeTabItem.this.deviceConfig.setIsRTS(SeriaPortTypeTabItem.this.isRTSButton.getSelection());
                        SeriaPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                    SeriaPortTypeTabItem.this.isRTS = SeriaPortTypeTabItem.this.isRTSButton.getSelection();
                }
            });
            this.dtrLabel = new Label(this.serialPortComposite, 131072);
            this.dtrLabel.setText(Messages.getString("GDE_MSGT0585"));
            this.dtrLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.dtrLabel.setBounds(5, 249, 100, 20);
            this.isDTRButton = new Button(this.serialPortComposite, 32);
            this.isDTRButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.isDTRButton.setBounds(142, 249, 180, 20);
            this.isDTRButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "isDTRButton.widgetSelected, event=" + String.valueOf(evt));
                    if (SeriaPortTypeTabItem.this.deviceConfig != null) {
                        SeriaPortTypeTabItem.this.deviceConfig.setIsDTR(SeriaPortTypeTabItem.this.isDTRButton.getSelection());
                        SeriaPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                    SeriaPortTypeTabItem.this.isDTR = SeriaPortTypeTabItem.this.isDTRButton.getSelection();
                }
            });
            this.respondLabel = new Label(this.serialPortComposite, 16384);
            this.respondLabel.setText("Respond Type");
            this.respondLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.respondLabel.setBounds(28, 270, 138, 20);
            this.respondCombo = new CCombo(this.serialPortComposite, 2048);
            this.respondCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.respondCombo.setItems(RespondType.valuesAsStingArray());
            this.respondCombo.setBounds(142, 271, 100, 20);
            this.respondCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "flowControlCombo.widgetSelected, event=" + String.valueOf(evt));
                    if (SeriaPortTypeTabItem.this.deviceConfig != null) {
                        SeriaPortTypeTabItem.this.deviceConfig.setTcpRespondType(RespondType.fromValue(RespondType.valuesAsStingArray()[SeriaPortTypeTabItem.this.respondCombo.getSelectionIndex()]));
                        SeriaPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            Group requestGroup = new Group(this.serialPortComposite, 2048);
            requestGroup.setText("Request (optional)");
            requestGroup.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            requestGroup.setBounds(15, 290, 320, 120);
            Label requestGroupLabel = new Label((Composite)requestGroup, 0x1000040);
            requestGroupLabel.setText("Optional request, will be send as byte array, if required to request a respond");
            requestGroupLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            requestGroupLabel.setBounds(10, 10, 250, 40);
            this.requestButton = new Button((Composite)requestGroup, 2080);
            this.requestButton.setBounds(8, 62, 15, 15);
            this.requestButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "requestButton.widgetSelected, event=" + String.valueOf(evt));
                    SeriaPortTypeTabItem.this.isUseRequest = SeriaPortTypeTabItem.this.requestButton.getSelection();
                    SeriaPortTypeTabItem.this.requestLabel.setEnabled(SeriaPortTypeTabItem.this.isUseRequest);
                    SeriaPortTypeTabItem.this.requestText.setEnabled(SeriaPortTypeTabItem.this.isUseRequest);
                    SeriaPortTypeTabItem.this.requestText.setEditable(SeriaPortTypeTabItem.this.isUseRequest);
                    if (SeriaPortTypeTabItem.this.isUseRequest) {
                        if (SeriaPortTypeTabItem.this.deviceConfig != null) {
                            SeriaPortTypeTabItem.this.deviceConfig.setSerialPortRequest(new byte[]{81});
                            SeriaPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                        }
                    } else if (SeriaPortTypeTabItem.this.deviceConfig != null) {
                        SeriaPortTypeTabItem.this.deviceConfig.removeSerialPortRequest();
                        SeriaPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                    SeriaPortTypeTabItem.this.enableTimeout();
                }
            });
            this.requestLabel = new Label((Composite)requestGroup, 16384);
            this.requestLabel.setText("two char per byte");
            this.requestLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.requestLabel.setBounds(30, 60, 140, 20);
            this.requestText = new Text((Composite)requestGroup, 2048);
            this.requestText.setBounds(160, 60, 100, 20);
            this.requestText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.requestText.setEditable(true);
            this.requestText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "requestText.verifyText, event=" + String.valueOf(evt));
                    evt.doit = StringHelper.verifyTypedInput(DataTypes.HEXADECIMAL, evt.text);
                }
            });
            this.requestText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "requestText.keyReleased, event=" + String.valueOf(evt));
                    SeriaPortTypeTabItem.this.request = SeriaPortTypeTabItem.this.requestText.getText();
                    if (SeriaPortTypeTabItem.this.deviceConfig != null) {
                        byte[] request = StringHelper.byteString2ByteArray(SeriaPortTypeTabItem.this.requestText.getText());
                        SeriaPortTypeTabItem.this.deviceConfig.setSerialPortRequest(request);
                        SeriaPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this.timeOutComposite = new Composite(this.serialPortComposite, 2048);
            this.timeOutComposite.setLayout(null);
            this.timeOutComposite.setBounds(355, 80, 250, 220);
            this.timeOutDescriptionLabel = new Label(this.timeOutComposite, 64);
            this.timeOutDescriptionLabel.setText(Messages.getString("GDE_MSGT0591"));
            this.timeOutDescriptionLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.timeOutDescriptionLabel.setBounds(6, 3, 232, 69);
            this.timeOutLabel = new Label(this.timeOutComposite, 131072);
            this.timeOutLabel.setText(Messages.getString("GDE_MSGT0586"));
            this.timeOutLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.timeOutLabel.setBounds(6, 70, 140, 20);
            this.timeOutButton = new Button(this.timeOutComposite, 32);
            this.timeOutButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.timeOutButton.setBounds(161, 70, 70, 20);
            this.timeOutButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "timeOutButton.widgetSelected, event=" + String.valueOf(evt));
                    SeriaPortTypeTabItem.this.useTimeOut = SeriaPortTypeTabItem.this.timeOutButton.getSelection();
                    if (SeriaPortTypeTabItem.this.useTimeOut) {
                        if (SeriaPortTypeTabItem.this.deviceConfig != null) {
                            SeriaPortTypeTabItem.this.ReadTimeout = SeriaPortTypeTabItem.this.deviceConfig.getReadTimeOut();
                            SeriaPortTypeTabItem.this.deviceConfig.setReadTimeOut(SeriaPortTypeTabItem.this.ReadTimeout);
                            SeriaPortTypeTabItem.this.ReadStableIndex = SeriaPortTypeTabItem.this.deviceConfig.getReadStableIndex();
                            SeriaPortTypeTabItem.this.deviceConfig.setReadStableIndex(SeriaPortTypeTabItem.this.ReadStableIndex);
                            SeriaPortTypeTabItem.this.WTOCharDelayTime = SeriaPortTypeTabItem.this.deviceConfig.getWriteCharDelayTime();
                            SeriaPortTypeTabItem.this.deviceConfig.setWriteCharDelayTime(SeriaPortTypeTabItem.this.WTOCharDelayTime);
                            SeriaPortTypeTabItem.this.WTOExtraDelayTime = SeriaPortTypeTabItem.this.deviceConfig.getWriteDelayTime();
                            SeriaPortTypeTabItem.this.deviceConfig.setWriteDelayTime(SeriaPortTypeTabItem.this.WTOExtraDelayTime);
                            SeriaPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                        } else {
                            SeriaPortTypeTabItem.this.ReadTimeout = 0;
                            SeriaPortTypeTabItem.this.ReadStableIndex = 0;
                            SeriaPortTypeTabItem.this.WTOCharDelayTime = 0;
                            SeriaPortTypeTabItem.this.WTOExtraDelayTime = 0;
                        }
                    } else {
                        if (SeriaPortTypeTabItem.this.deviceConfig != null) {
                            SeriaPortTypeTabItem.this.deviceConfig.removeSerialPortTimeOut();
                        }
                        SeriaPortTypeTabItem.this.ReadTimeout = 0;
                        SeriaPortTypeTabItem.this.ReadStableIndex = 0;
                        SeriaPortTypeTabItem.this.WTOCharDelayTime = 0;
                        SeriaPortTypeTabItem.this.WTOExtraDelayTime = 0;
                    }
                    SeriaPortTypeTabItem.this.enableTimeout();
                }
            });
            this.ReadTimeoutLabel = new Label(this.timeOutComposite, 131072);
            this.ReadTimeoutLabel.setText(Messages.getString("GDE_MSGT0587"));
            this.ReadTimeoutLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.ReadTimeoutLabel.setBounds(6, 100, 140, 20);
            this.ReadTimeoutText = new Text(this.timeOutComposite, 2048);
            this.ReadTimeoutText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.ReadTimeoutText.setBounds(162, 100, 70, 20);
            this.ReadTimeoutText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "ReadTimeoutText.verifyText, event=" + String.valueOf(evt));
                    evt.doit = StringHelper.verifyTypedInput(DataTypes.INTEGER, evt.text);
                }
            });
            this.ReadTimeoutText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "ReadTimeoutText.keyReleased, event=" + String.valueOf(evt));
                    int n = SeriaPortTypeTabItem.this.ReadTimeout = SeriaPortTypeTabItem.this.ReadTimeoutText.getText().equals("") ? 0 : Integer.parseInt(SeriaPortTypeTabItem.this.ReadTimeoutText.getText());
                    if (SeriaPortTypeTabItem.this.deviceConfig != null) {
                        SeriaPortTypeTabItem.this.deviceConfig.setReadTimeOut(SeriaPortTypeTabItem.this.ReadTimeout);
                        SeriaPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this.ReadStableIndexLabel = new Label(this.timeOutComposite, 131072);
            this.ReadStableIndexLabel.setText(Messages.getString("GDE_MSGT0588"));
            this.ReadStableIndexLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.ReadStableIndexLabel.setBounds(6, 130, 140, 20);
            this.ReadStableIndexText = new Text(this.timeOutComposite, 2048);
            this.ReadStableIndexText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.ReadStableIndexText.setBounds(162, 130, 70, 20);
            this.ReadStableIndexText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "ReadStableIndexText.verifyText, event=" + String.valueOf(evt));
                    evt.doit = StringHelper.verifyTypedInput(DataTypes.INTEGER, evt.text);
                }
            });
            this.ReadStableIndexText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "ReadStableIndexText.keyReleased, event=" + String.valueOf(evt));
                    int n = SeriaPortTypeTabItem.this.ReadStableIndex = SeriaPortTypeTabItem.this.ReadStableIndexText.getText().equals("") ? 0 : Integer.parseInt(SeriaPortTypeTabItem.this.ReadStableIndexText.getText());
                    if (SeriaPortTypeTabItem.this.deviceConfig != null) {
                        SeriaPortTypeTabItem.this.deviceConfig.setReadStableIndex(SeriaPortTypeTabItem.this.ReadStableIndex);
                        SeriaPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this._WTOCharDelayTimeLabel = new Label(this.timeOutComposite, 131072);
            this._WTOCharDelayTimeLabel.setText(Messages.getString("GDE_MSGT0589"));
            this._WTOCharDelayTimeLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this._WTOCharDelayTimeLabel.setBounds(6, 160, 140, 20);
            this._WTOCharDelayTimeText = new Text(this.timeOutComposite, 2048);
            this._WTOCharDelayTimeText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this._WTOCharDelayTimeText.setBounds(162, 160, 70, 20);
            this._WTOCharDelayTimeText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "_WRTOCharDelayTimeText.verifyText, event=" + String.valueOf(evt));
                    evt.doit = StringHelper.verifyTypedInput(DataTypes.INTEGER, evt.text);
                }
            });
            this._WTOCharDelayTimeText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "_WRTOCharDelayTimeText.keyReleased, event=" + String.valueOf(evt));
                    int n = SeriaPortTypeTabItem.this.WTOCharDelayTime = SeriaPortTypeTabItem.this._WTOCharDelayTimeText.getText().equals("") ? 0 : Integer.parseInt(SeriaPortTypeTabItem.this._WTOCharDelayTimeText.getText());
                    if (SeriaPortTypeTabItem.this.deviceConfig != null) {
                        SeriaPortTypeTabItem.this.deviceConfig.setWriteCharDelayTime(SeriaPortTypeTabItem.this.WTOCharDelayTime);
                        SeriaPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this._WTOExtraDelayTimeLabel = new Label(this.timeOutComposite, 131072);
            this._WTOExtraDelayTimeLabel.setText(Messages.getString("GDE_MSGT0590"));
            this._WTOExtraDelayTimeLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this._WTOExtraDelayTimeLabel.setBounds(6, 190, 140, 20);
            this._WTOExtraDelayTimeText = new Text(this.timeOutComposite, 2048);
            this._WTOExtraDelayTimeText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this._WTOExtraDelayTimeText.setBounds(162, 190, 70, 20);
            this._WTOExtraDelayTimeText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "_WTOExtraDelayTimeText.verifyText, event=" + String.valueOf(evt));
                    evt.doit = StringHelper.verifyTypedInput(DataTypes.INTEGER, evt.text);
                }
            });
            this._WTOExtraDelayTimeText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "_WTOExtraDelayTimeText.keyReleased, event=" + String.valueOf(evt));
                    int n = SeriaPortTypeTabItem.this.WTOExtraDelayTime = SeriaPortTypeTabItem.this._WTOExtraDelayTimeText.getText().equals("") ? 0 : Integer.parseInt(SeriaPortTypeTabItem.this._WTOExtraDelayTimeText.getText());
                    if (SeriaPortTypeTabItem.this.deviceConfig != null) {
                        SeriaPortTypeTabItem.this.deviceConfig.setWriteDelayTime(SeriaPortTypeTabItem.this.WTOExtraDelayTime);
                        SeriaPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void enableContextmenu(boolean enable) {
        if (enable && (this.popupMenu == null || this.contextMenu == null)) {
            this.popupMenu = new Menu((Decorations)this.tabFolder.getShell(), 8);
            this.contextMenu = new ContextMenu(this.popupMenu, this.tabFolder);
            this.contextMenu.create();
        } else {
            this.popupMenu = null;
            this.contextMenu = null;
        }
        this.serialPortComposite.setMenu(this.popupMenu);
        this.serialPortDescriptionLabel.setMenu(this.popupMenu);
        this.portNameLabel.setMenu(this.popupMenu);
        this.baudeRateLabel.setMenu(this.popupMenu);
        this.dataBitsLabel.setMenu(this.popupMenu);
        this.stopBitsLabel.setMenu(this.popupMenu);
        this.parityLabel.setMenu(this.popupMenu);
        this.flowControlLabel.setMenu(this.popupMenu);
        this.rtsLabel.setMenu(this.popupMenu);
        this.isRTSButton.setMenu(this.popupMenu);
        this.dtrLabel.setMenu(this.popupMenu);
        this.isDTRButton.setMenu(this.popupMenu);
        this.timeOutComposite.setMenu(this.popupMenu);
        this.timeOutLabel.setMenu(this.popupMenu);
        this.timeOutButton.setMenu(this.popupMenu);
        this.ReadTimeoutLabel.setMenu(this.popupMenu);
        this.ReadStableIndexLabel.setMenu(this.popupMenu);
        this._WTOCharDelayTimeLabel.setMenu(this.popupMenu);
        this._WTOExtraDelayTimeLabel.setMenu(this.popupMenu);
        this.timeOutDescriptionLabel.setMenu(this.popupMenu);
    }

    public void setDeviceConfig(DeviceConfiguration deviceConfig) {
        this.deviceConfig = deviceConfig;
        this.portName = deviceConfig.getPort();
        this.baudeRateIndex = this.getSelectionIndex(this.baudeRateCombo, "" + deviceConfig.getBaudeRate());
        this.dataBitsIndex = deviceConfig.getDataBits().ordinal();
        this.stopBitsIndex = deviceConfig.getStopBits().ordinal();
        this.parityIndex = deviceConfig.getParity().ordinal();
        this.flowControlIndex = deviceConfig.getFlowCtrlModeOrdinal();
        this.isRTS = deviceConfig.isRTS();
        this.isDTR = deviceConfig.isDTR();
        this.respondType = deviceConfig.getSerialPortType().getRespond();
        if (deviceConfig.getSerialPortType().getRequest() != null) {
            this.isUseRequest = true;
            this.requestButton.setSelection(true);
            StringBuilder sb = new StringBuilder();
            for (byte b : deviceConfig.getSerialPortType().getRequest()) {
                sb.append(String.format("%02X", b));
            }
            this.request = sb.toString();
        } else {
            this.isUseRequest = false;
            this.requestButton.setSelection(false);
        }
        if (deviceConfig.getSerialPortType().getTimeOut() != null) {
            this.useTimeOut = true;
            this.timeOutButton.setSelection(true);
        } else {
            this.useTimeOut = false;
            this.timeOutButton.setSelection(false);
        }
        this.ReadTimeout = deviceConfig.getReadTimeOut();
        this.ReadStableIndex = deviceConfig.getReadStableIndex();
        this.WTOCharDelayTime = deviceConfig.getWriteCharDelayTime();
        this.WTOExtraDelayTime = deviceConfig.getWriteDelayTime();
        this.timeOutComposite.redraw();
        this.initialize();
    }

    private int getSelectionIndex(CCombo useCombo, String searchString) {
        int searchIndex = 0;
        for (String item : useCombo.getItems()) {
            if (item.equals(searchString)) break;
            ++searchIndex;
        }
        return searchIndex;
    }

    private void initialize() {
        this.portNameText.setText(this.portName);
        this.baudeRateCombo.select(this.baudeRateIndex);
        this.dataBitsCombo.select(this.dataBitsIndex);
        this.stopBitsCombo.select(this.stopBitsIndex);
        this.parityCombo.select(this.parityIndex);
        this.flowControlCombo.select(this.flowControlIndex);
        this.isRTSButton.setSelection(this.isRTS);
        this.isDTRButton.setSelection(this.isDTR);
        if (this.respondType != null) {
            this.respondCombo.select(this.getSelectionIndex(this.respondCombo, this.respondType.toString()));
        } else {
            this.respondLabel.setForeground(SWTResourceManager.getColor(15));
            this.respondCombo.setEnabled(false);
        }
        this.requestText.setEnabled(this.isUseRequest);
        this.requestText.setEditable(this.isUseRequest);
        if (this.isUseRequest) {
            this.requestButton.setSelection(true);
            this.requestText.setText(this.request);
        }
        this.ReadTimeoutText.setText("" + this.ReadTimeout);
        this.ReadStableIndexText.setText("" + this.ReadStableIndex);
        this._WTOCharDelayTimeText.setText("" + this.WTOCharDelayTime);
        this._WTOExtraDelayTimeText.setText("" + this.WTOExtraDelayTime);
        this.timeOutButton.setSelection(this.useTimeOut);
        this.enableTimeout();
    }

    private void enableTimeout() {
        if (this.timeOutButton.getSelection()) {
            this.ReadTimeoutLabel.setEnabled(true);
            this.ReadTimeoutText.setEnabled(true);
            this.ReadStableIndexLabel.setEnabled(true);
            this.ReadStableIndexText.setEnabled(true);
            this._WTOCharDelayTimeLabel.setEnabled(true);
            this._WTOCharDelayTimeText.setEnabled(true);
            this._WTOExtraDelayTimeLabel.setEnabled(true);
            this._WTOExtraDelayTimeText.setEnabled(true);
        } else {
            this.ReadTimeoutLabel.setEnabled(false);
            this.ReadTimeoutText.setEnabled(false);
            this.ReadStableIndexLabel.setEnabled(false);
            this.ReadStableIndexText.setEnabled(false);
            this._WTOCharDelayTimeLabel.setEnabled(false);
            this._WTOCharDelayTimeText.setEnabled(false);
            this._WTOExtraDelayTimeLabel.setEnabled(false);
            this._WTOExtraDelayTimeText.setEnabled(false);
        }
    }
}

