/*
 * Decompiled with CFR 0.152.
 */
package gde.data;

import gde.Analyzer;
import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.RecordSet;
import gde.device.ChannelTypes;
import gde.device.IDevice;
import gde.histo.ui.HistoExplorer;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Logger;

public final class Channels
extends HashMap<Integer, Channel> {
    static final long serialVersionUID = 26031957L;
    static final Logger log = Logger.getLogger(Channels.class.getName());
    static final int CHANNEL_NAME_MIN_LENGTH = 3;
    private static volatile Channels channles = null;
    private int activeChannelNumber = 1;
    private String[] channelNames = new String[1];
    private Analyzer analyzer;

    public static Channels createChannels() {
        return new Channels(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Channels getInstance() {
        if (channles != null) return channles;
        channles = new Channels(4);
        Class<Channels> clazz = Channels.class;
        synchronized (Channels.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return channles;
        }
    }

    private Channels(int initialCapacity) {
        super(initialCapacity);
    }

    public Channels(Channels that) {
        this(4);
        if (that.analyzer == null) {
            throw new IllegalArgumentException("setup is missing");
        }
        this.analyzer = that.analyzer;
        this.activeChannelNumber = that.activeChannelNumber;
        this.channelNames = (String[])that.channelNames.clone();
    }

    public int getChannelNumber(String channelName) {
        int searchedNumber = 1;
        if (channelName != null && channelName.length() >= 3) {
            if (channelName.contains(":") && channelName.split(":").length >= 1 && Character.isDigit(channelName.split(":")[0].trim().charAt(0))) {
                return Integer.valueOf(channelName.split(":")[0].trim());
            }
            if (channelName.contains(" ") && channelName.split(" ").length > 1 && Character.isDigit(channelName.split(" ")[1].trim().charAt(0))) {
                try {
                    return Integer.valueOf(channelName.split(" ")[1].trim());
                }
                catch (NumberFormatException e) {
                    if (channelName.split(" ")[1].trim().contains("+")) {
                        String tmpNum = channelName.split(" ")[1].trim();
                        log.log(Level.WARNING, "channel name = " + channelName);
                        return Integer.valueOf(tmpNum.substring(0, tmpNum.indexOf(43))) + Integer.valueOf(tmpNum.substring(tmpNum.indexOf(43) + 1));
                    }
                }
            } else {
                for (String name : this.getChannelNames()) {
                    if (name.split(":")[1].trim().equals(channelName) || name.split(":")[1].trim().split(" ")[0].trim().equals(channelName)) break;
                    ++searchedNumber;
                }
            }
        }
        return searchedNumber;
    }

    public String[] getChannelNames() {
        return this.channelNames;
    }

    public void setChannelNames(String[] newChannelNames) {
        this.channelNames = (String[])newChannelNames.clone();
    }

    @Deprecated
    public String getChannelNamesToString() {
        StringBuilder sb = new StringBuilder();
        for (String channelName : DataExplorer.getInstance().getMenuToolBar().getChannelSelectCombo().getItems()) {
            sb.append(channelName.split(":")[1]).append(", ");
        }
        return sb.toString();
    }

    public void switchChannel(String channelName) {
        RecordSet recordSet = this.getActiveChannel().getActiveRecordSet();
        if (recordSet != null) {
            recordSet.resetZoomAndMeasurement();
        }
        this.switchChannel(Integer.valueOf(channelName.split(":")[0].trim()), "");
    }

    public void switchChannel(int channelNumber, String recordSetKey) {
        if (!GDE.isWithUi()) {
            throw new UnsupportedOperationException("for use with internal UI only");
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "switching to channel " + channelNumber);
        }
        DataExplorer application = DataExplorer.getInstance();
        application.checkUpdateFileComment();
        application.checkUpdateRecordSetComment();
        if (channelNumber <= this.keySet().size()) {
            if (channelNumber != this.getActiveChannelNumber() || this.getActiveChannel().getActiveRecordSet() == null) {
                String currentObjectKey = this.getActiveChannel().getObjectKey();
                this.setActiveChannelNumber(channelNumber);
                if (this.getActiveChannel().getType() == ChannelTypes.TYPE_CONFIG) {
                    this.getActiveChannel().setObjectKey(currentObjectKey);
                }
                application.getMenuToolBar().updateChannelToolItems();
                if (recordSetKey == null || recordSetKey.length() < 1) {
                    this.getActiveChannel().setActiveRecordSet(this.getActiveChannel().getLastActiveRecordSetName());
                } else {
                    this.getActiveChannel().setActiveRecordSet(recordSetKey);
                }
                if (this.getActiveChannel().type == ChannelTypes.TYPE_OUTLET) {
                    application.updateTitleBar(application.getObjectKey(), application.getActiveDevice().getName(), application.getActiveDevice().getPort());
                }
                Settings.getInstance().addDeviceUse(application.getActiveDevice().getDeviceConfiguration().getName(), channelNumber);
            } else if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "nothing to do selected channel == active channel");
            }
            application.cleanHeaderAndCommentInGraphicsWindow();
            Channel activeChannel = this.getActiveChannel();
            if (activeChannel != null) {
                RecordSet recordSet = activeChannel.getActiveRecordSet();
                if (recordSet != null) {
                    if (!recordSet.hasDisplayableData) {
                        recordSet.loadFileData(activeChannel.getFullQualifiedFileName(), true);
                    }
                    recordSet.resetZoomAndMeasurement();
                    if (recordSet.isRecalculation) {
                        recordSet.checkAllDisplayable();
                    }
                    recordSet.updateVisibleAndDisplayableRecordsForTable();
                }
                application.resetGraphicsWindowZoomAndMeasurement();
                application.getMenuToolBar().updateChannelSelector();
                application.getMenuToolBar().updateRecordSetSelectCombo();
                application.updateMenusRegardingGPSData();
                application.updateAllTabs(true);
                application.getActiveDevice().setLastChannelNumber(channelNumber);
                if (application.getHistoExplorer().isPresent() == Settings.getInstance().isHistoActive() && Settings.getInstance().isHistoActive()) {
                    application.getHistoExplorer().ifPresent(HistoExplorer::updateHistoTabs);
                }
            }
        } else {
            application.openMessageDialogAsync(Messages.getString("GDE_MSGW0006"));
        }
    }

    public int getActiveChannelNumber() {
        return this.activeChannelNumber;
    }

    public void setActiveChannelNumber(int newActiveChannelNumber) {
        this.activeChannelNumber = newActiveChannelNumber;
    }

    public Channel getActiveChannel() {
        return (Channel)this.get(this.activeChannelNumber);
    }

    public void cleanup() {
        this.activeChannelNumber = 1;
        this.channelNames = new String[1];
        try {
            Channel activeChannel = this.getActiveChannel();
            if (activeChannel != null) {
                activeChannel.objectKey = "";
                RecordSet activeRecordSet = activeChannel.getActiveRecordSet();
                if (activeRecordSet != null) {
                    activeRecordSet.parent.clear();
                }
            }
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
        for (int i = 1; i <= super.size(); ++i) {
            Channel channel = (Channel)this.get(i);
            channel.setFileName("");
            channel.setSaved(false);
            for (int j = 0; j < channel.size(); ++j) {
                channel.getRecordSets().clear();
            }
            channel.clear();
        }
        this.clear();
        log.log(Level.FINE, "visited");
    }

    public String checkRecordSetsSaved() {
        StringBuffer sb = new StringBuffer();
        for (int i = 1; i <= super.size(); ++i) {
            Channel channel = (Channel)this.get(i);
            for (String recordSetkey : channel.getRecordSetNames()) {
                if (channel.get(recordSetkey) == null || ((RecordSet)channel.get(recordSetkey)).isSaved()) continue;
                sb.append(System.getProperty("line.separator")).append(channel.getName()).append(" -> ").append(((RecordSet)channel.get(recordSetkey)).getName());
                if (((RecordSet)channel.get(recordSetkey)).getUnsaveReasons().size() <= 0) continue;
                sb.append(" (");
                for (String reason : ((RecordSet)channel.get(recordSetkey)).getUnsaveReasons()) {
                    sb.append(reason).append(", ");
                }
                sb.delete(sb.lastIndexOf(", "), sb.lastIndexOf(", ") + 2).append(")");
            }
        }
        return sb.toString();
    }

    public void setupChannels(Analyzer newAnalyzer) {
        this.cleanup();
        this.analyzer = newAnalyzer;
        IDevice device = newAnalyzer.getActiveDevice();
        int channelCount = device.getChannelCount();
        this.channelNames = new String[channelCount];
        for (int i = 1; i <= channelCount; ++i) {
            log.log(Level.FINE, "setting up channels = " + i);
            Channel newChannel = new Channel(newAnalyzer, device.getChannelNameReplacement(i), device.getChannelTypes(i));
            newChannel.setObjectKey(newAnalyzer.getSettings().getActiveObjectKey());
            this.put(i, newChannel);
            this.channelNames[i - 1] = i + " : " + device.getChannelNameReplacement(i);
        }
    }

    public Channel addChannel(String channelConfigName, ChannelTypes channelType, Analyzer newAnalyzer) {
        this.analyzer = newAnalyzer;
        Channel channel = new Channel(newAnalyzer, channelConfigName, channelType);
        this.put(channel.getNumber(), channel);
        Vector<Object> newChannelNames = new Vector<Object>();
        for (String channelConfigKey : this.getChannelNames()) {
            newChannelNames.add(channelConfigKey);
        }
        newChannelNames.add(channel.getNumber() + " : " + channelConfigName);
        this.setChannelNames(newChannelNames.toArray(new String[1]));
        return channel;
    }

    public void syncFileDescription(Channel syncChannel, String updateComment) {
        for (Integer channelNumber : this.keySet()) {
            Channel channel = (Channel)this.get(channelNumber);
            if (channel.equals(syncChannel)) continue;
            channel.setFileDescription(updateComment);
        }
    }
}

