/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.render;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.w3c.dom.Element;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.parser.FSColor;
import org.xhtmlrenderer.css.parser.FSRGBColor;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.css.style.derived.BorderPropertySet;
import org.xhtmlrenderer.css.style.derived.RectPropertySet;
import org.xhtmlrenderer.layout.Layer;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.PaintingInfo;
import org.xhtmlrenderer.layout.Styleable;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.BoxDimensions;
import org.xhtmlrenderer.render.ContentLimitContainer;
import org.xhtmlrenderer.render.InlineLayoutBox;
import org.xhtmlrenderer.render.PageBox;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.util.XRLog;

public abstract class Box
implements Styleable {
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private Element _element;
    private int _x;
    private int _y;
    private int _absY;
    private int _absX;
    private int _contentWidth;
    private int _rightMBP = 0;
    private int _leftMBP = 0;
    private int _height;
    private Layer _layer = null;
    private Layer _containingLayer;
    private Box _parent;
    private List _boxes;
    private int _tx;
    private int _ty;
    private CalculatedStyle _style;
    private Box _containingBlock;
    private Dimension _relativeOffset;
    private PaintingInfo _paintingInfo;
    private RectPropertySet _workingMargin;
    private int _index;
    private String _pseudoElementOrClass;
    private boolean _anonymous;
    public static final int NOTHING = 0;
    public static final int FLUX = 1;
    public static final int CHILDREN_FLUX = 2;
    public static final int DONE = 3;
    private int _state = 0;
    public static final int DUMP_RENDER = 2;
    public static final int DUMP_LAYOUT = 1;

    protected Box() {
    }

    public abstract String dump(LayoutContext var1, String var2, int var3);

    protected void dumpBoxes(LayoutContext c2, String indent, List boxes, int which, StringBuffer result2) {
        Iterator i2 = boxes.iterator();
        while (i2.hasNext()) {
            Box b2 = (Box)i2.next();
            result2.append(b2.dump(c2, indent + "  ", which));
            if (!i2.hasNext()) continue;
            result2.append('\n');
        }
    }

    public int getWidth() {
        return this.getContentWidth() + this.getLeftMBP() + this.getRightMBP();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Box: ");
        sb.append(" (" + this.getAbsX() + "," + this.getAbsY() + ")->(" + this.getWidth() + " x " + this.getHeight() + ")");
        return sb.toString();
    }

    public void addChildForLayout(LayoutContext c2, Box child) {
        this.addChild(child);
        child.initContainingLayer(c2);
    }

    public void addChild(Box child) {
        if (this._boxes == null) {
            this._boxes = new ArrayList();
        }
        if (child == null) {
            throw new NullPointerException("trying to add null child");
        }
        child.setParent(this);
        child.setIndex(this._boxes.size());
        this._boxes.add(child);
    }

    public void addAllChildren(List children) {
        for (Box box : children) {
            this.addChild(box);
        }
    }

    public void removeAllChildren() {
        if (this._boxes != null) {
            this._boxes.clear();
        }
    }

    public void removeChild(Box target) {
        if (this._boxes != null) {
            boolean found = false;
            Iterator i2 = this.getChildIterator();
            while (i2.hasNext()) {
                Box child = (Box)i2.next();
                if (child.equals(target)) {
                    i2.remove();
                    found = true;
                    continue;
                }
                if (!found) continue;
                child.setIndex(child.getIndex() - 1);
            }
        }
    }

    public Box getPreviousSibling() {
        Box parent = this.getParent();
        return parent == null ? null : parent.getPrevious(this);
    }

    public Box getNextSibling() {
        Box parent = this.getParent();
        return parent == null ? null : parent.getNext(this);
    }

    protected Box getPrevious(Box child) {
        return child.getIndex() == 0 ? null : this.getChild(child.getIndex() - 1);
    }

    protected Box getNext(Box child) {
        return child.getIndex() == this.getChildCount() - 1 ? null : this.getChild(child.getIndex() + 1);
    }

    public void removeChild(int i2) {
        if (this._boxes != null) {
            this.removeChild(this.getChild(i2));
        }
    }

    public void setParent(Box box) {
        this._parent = box;
    }

    public Box getParent() {
        return this._parent;
    }

    public Box getDocumentParent() {
        return this.getParent();
    }

    public int getChildCount() {
        return this._boxes == null ? 0 : this._boxes.size();
    }

    public Box getChild(int i2) {
        if (this._boxes == null) {
            throw new IndexOutOfBoundsException();
        }
        return (Box)this._boxes.get(i2);
    }

    public Iterator getChildIterator() {
        return this._boxes == null ? Collections.EMPTY_LIST.iterator() : this._boxes.iterator();
    }

    public List getChildren() {
        return this._boxes == null ? Collections.EMPTY_LIST : this._boxes;
    }

    public synchronized int getState() {
        return this._state;
    }

    public synchronized void setState(int state) {
        this._state = state;
    }

    public static String stateToString(int state) {
        switch (state) {
            case 0: {
                return "NOTHING";
            }
            case 1: {
                return "FLUX";
            }
            case 2: {
                return "CHILDREN_FLUX";
            }
            case 3: {
                return "DONE";
            }
        }
        return "unknown";
    }

    @Override
    public final CalculatedStyle getStyle() {
        return this._style;
    }

    @Override
    public void setStyle(CalculatedStyle style) {
        this._style = style;
    }

    public Box getContainingBlock() {
        return this._containingBlock == null ? this.getParent() : this._containingBlock;
    }

    public void setContainingBlock(Box containingBlock) {
        this._containingBlock = containingBlock;
    }

    public Rectangle getMarginEdge(int left2, int top2, CssContext cssCtx, int tx, int ty) {
        Rectangle result2 = new Rectangle(left2, top2, this.getWidth(), this.getHeight());
        result2.translate(tx, ty);
        return result2;
    }

    public Rectangle getMarginEdge(CssContext cssCtx, int tx, int ty) {
        return this.getMarginEdge(this.getX(), this.getY(), cssCtx, tx, ty);
    }

    public Rectangle getPaintingBorderEdge(CssContext cssCtx) {
        return this.getBorderEdge(this.getAbsX(), this.getAbsY(), cssCtx);
    }

    public Rectangle getPaintingPaddingEdge(CssContext cssCtx) {
        return this.getPaddingEdge(this.getAbsX(), this.getAbsY(), cssCtx);
    }

    public Rectangle getPaintingClipEdge(CssContext cssCtx) {
        return this.getPaintingBorderEdge(cssCtx);
    }

    public Rectangle getChildrenClipEdge(RenderingContext c2) {
        return this.getPaintingPaddingEdge(c2);
    }

    public boolean intersects(CssContext cssCtx, Shape clip) {
        return clip == null || clip.intersects(this.getPaintingClipEdge(cssCtx));
    }

    public Rectangle getBorderEdge(int left2, int top2, CssContext cssCtx) {
        RectPropertySet margin = this.getMargin(cssCtx);
        Rectangle result2 = new Rectangle(left2 + (int)margin.left(), top2 + (int)margin.top(), this.getWidth() - (int)margin.left() - (int)margin.right(), this.getHeight() - (int)margin.top() - (int)margin.bottom());
        return result2;
    }

    public Rectangle getPaddingEdge(int left2, int top2, CssContext cssCtx) {
        RectPropertySet margin = this.getMargin(cssCtx);
        BorderPropertySet border = this.getBorder(cssCtx);
        Rectangle result2 = new Rectangle(left2 + (int)margin.left() + (int)border.left(), top2 + (int)margin.top() + (int)border.top(), this.getWidth() - (int)margin.width() - (int)border.width(), this.getHeight() - (int)margin.height() - (int)border.height());
        return result2;
    }

    protected int getPaddingWidth(CssContext cssCtx) {
        RectPropertySet padding = this.getPadding(cssCtx);
        return (int)padding.left() + this.getContentWidth() + (int)padding.right();
    }

    public Rectangle getContentAreaEdge(int left2, int top2, CssContext cssCtx) {
        RectPropertySet margin = this.getMargin(cssCtx);
        BorderPropertySet border = this.getBorder(cssCtx);
        RectPropertySet padding = this.getPadding(cssCtx);
        Rectangle result2 = new Rectangle(left2 + (int)margin.left() + (int)border.left() + (int)padding.left(), top2 + (int)margin.top() + (int)border.top() + (int)padding.top(), this.getWidth() - (int)margin.width() - (int)border.width() - (int)padding.width(), this.getHeight() - (int)margin.height() - (int)border.height() - (int)padding.height());
        return result2;
    }

    public Layer getLayer() {
        return this._layer;
    }

    public void setLayer(Layer layer) {
        this._layer = layer;
    }

    public Dimension positionRelative(CssContext cssCtx) {
        int initialX = this.getX();
        int initialY = this.getY();
        CalculatedStyle style = this.getStyle();
        if (!style.isIdent(CSSName.LEFT, IdentValue.AUTO)) {
            this.setX(this.getX() + (int)style.getFloatPropertyProportionalWidth(CSSName.LEFT, this.getContainingBlock().getContentWidth(), cssCtx));
        } else if (!style.isIdent(CSSName.RIGHT, IdentValue.AUTO)) {
            this.setX(this.getX() - (int)style.getFloatPropertyProportionalWidth(CSSName.RIGHT, this.getContainingBlock().getContentWidth(), cssCtx));
        }
        int cbContentHeight = 0;
        if (!this.getContainingBlock().getStyle().isAutoHeight()) {
            CalculatedStyle cbStyle = this.getContainingBlock().getStyle();
            cbContentHeight = (int)cbStyle.getFloatPropertyProportionalHeight(CSSName.HEIGHT, 0.0f, cssCtx);
        } else if (this.isInlineBlock()) {
            cbContentHeight = this.getContainingBlock().getHeight();
        }
        if (!style.isIdent(CSSName.TOP, IdentValue.AUTO)) {
            this.setY(this.getY() + (int)style.getFloatPropertyProportionalHeight(CSSName.TOP, cbContentHeight, cssCtx));
        } else if (!style.isIdent(CSSName.BOTTOM, IdentValue.AUTO)) {
            this.setY(this.getY() - (int)style.getFloatPropertyProportionalHeight(CSSName.BOTTOM, cbContentHeight, cssCtx));
        }
        this.setRelativeOffset(new Dimension(this.getX() - initialX, this.getY() - initialY));
        return this.getRelativeOffset();
    }

    protected boolean isInlineBlock() {
        return false;
    }

    public void setAbsY(int absY) {
        this._absY = absY;
    }

    public int getAbsY() {
        return this._absY;
    }

    public void setAbsX(int absX) {
        this._absX = absX;
    }

    public int getAbsX() {
        return this._absX;
    }

    public boolean isStyled() {
        return this._style != null;
    }

    public int getBorderSides() {
        return 15;
    }

    public void paintBorder(RenderingContext c2) {
        c2.getOutputDevice().paintBorder(c2, this);
    }

    private boolean isPaintsRootElementBackground() {
        return this.isRoot() && this.getStyle().isHasBackground() || this.isBody() && !this.getParent().getStyle().isHasBackground();
    }

    public void paintBackground(RenderingContext c2) {
        if (!this.isPaintsRootElementBackground()) {
            c2.getOutputDevice().paintBackground(c2, this);
        }
    }

    public void paintRootElementBackground(RenderingContext c2) {
        PaintingInfo pI = this.getPaintingInfo();
        if (pI != null) {
            if (this.getStyle().isHasBackground()) {
                this.paintRootElementBackground(c2, pI);
            } else if (this.getChildCount() > 0) {
                Box body = this.getChild(0);
                body.paintRootElementBackground(c2, pI);
            }
        }
    }

    private void paintRootElementBackground(RenderingContext c2, PaintingInfo pI) {
        Dimension marginCorner = pI.getOuterMarginCorner();
        Rectangle canvasBounds = new Rectangle(0, 0, marginCorner.width, marginCorner.height);
        canvasBounds.add(c2.getViewportRectangle());
        c2.getOutputDevice().paintBackground(c2, this.getStyle(), canvasBounds, canvasBounds, BorderPropertySet.EMPTY_BORDER);
    }

    public Layer getContainingLayer() {
        return this._containingLayer;
    }

    public void setContainingLayer(Layer containingLayer) {
        this._containingLayer = containingLayer;
    }

    public void initContainingLayer(LayoutContext c2) {
        if (this.getLayer() != null) {
            this.setContainingLayer(this.getLayer());
        } else if (this.getContainingLayer() == null) {
            List content;
            if (this.getParent() == null || this.getParent().getContainingLayer() == null) {
                throw new RuntimeException("internal error");
            }
            this.setContainingLayer(this.getParent().getContainingLayer());
            if (c2.getLayer().isInline() && (content = ((InlineLayoutBox)c2.getLayer().getMaster()).getElementWithContent()).contains(this)) {
                this.setContainingLayer(c2.getLayer());
            }
        }
    }

    public void connectChildrenToCurrentLayer(LayoutContext c2) {
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            Box box = this.getChild(i2);
            box.setContainingLayer(c2.getLayer());
            box.connectChildrenToCurrentLayer(c2);
        }
    }

    public List getElementBoxes(Element elem) {
        ArrayList<Box> result2 = new ArrayList<Box>();
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            Box child = this.getChild(i2);
            if (child.getElement() == elem) {
                result2.add(child);
            }
            result2.addAll(child.getElementBoxes(elem));
        }
        return result2;
    }

    public void reset(LayoutContext c2) {
        String id;
        Element e2;
        this.resetChildren(c2);
        if (this._layer != null) {
            this._layer.detach();
            this._layer = null;
        }
        this.setContainingLayer(null);
        this.setLayer(null);
        this.setPaintingInfo(null);
        this.setContentWidth(0);
        this._workingMargin = null;
        String anchorName = c2.getNamespaceHandler().getAnchorName(this.getElement());
        if (anchorName != null) {
            c2.removeBoxId(anchorName);
        }
        if ((e2 = this.getElement()) != null && (id = c2.getNamespaceHandler().getID(e2)) != null) {
            c2.removeBoxId(id);
        }
    }

    public void detach(LayoutContext c2) {
        this.reset(c2);
        if (this.getParent() != null) {
            this.getParent().removeChild(this);
            this.setParent(null);
        }
    }

    public void resetChildren(LayoutContext c2, int start, int end) {
        for (int i2 = start; i2 <= end; ++i2) {
            Box box = this.getChild(i2);
            box.reset(c2);
        }
    }

    protected void resetChildren(LayoutContext c2) {
        int remaining = this.getChildCount();
        for (int i2 = 0; i2 < remaining; ++i2) {
            Box box = this.getChild(i2);
            box.reset(c2);
        }
    }

    public abstract void calcCanvasLocation();

    public void calcChildLocations() {
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            Box child = this.getChild(i2);
            child.calcCanvasLocation();
            child.calcChildLocations();
        }
    }

    public int forcePageBreakBefore(LayoutContext c2, IdentValue pageBreakValue, boolean pendingPageName) {
        PageBox page = c2.getRootLayer().getFirstPage(c2, this);
        if (page == null) {
            XRLog.layout(Level.WARNING, "Box has no page");
            return 0;
        }
        int pageBreakCount = 1;
        if (page.getTop() == this.getAbsY()) {
            --pageBreakCount;
            if (pendingPageName && page == c2.getRootLayer().getLastPage()) {
                c2.getRootLayer().removeLastPage();
                c2.setPageName(c2.getPendingPageName());
                c2.getRootLayer().addPage(c2);
            }
        }
        if (page.isLeftPage() && pageBreakValue == IdentValue.LEFT || page.isRightPage() && pageBreakValue == IdentValue.RIGHT) {
            ++pageBreakCount;
        }
        if (pageBreakCount == 0) {
            return 0;
        }
        if (pageBreakCount == 1 && pendingPageName) {
            c2.setPageName(c2.getPendingPageName());
        }
        int delta = page.getBottom() + c2.getExtraSpaceTop() - this.getAbsY();
        if (page == c2.getRootLayer().getLastPage()) {
            c2.getRootLayer().addPage(c2);
        }
        if (pageBreakCount == 2) {
            page = (PageBox)c2.getRootLayer().getPages().get(page.getPageNo() + 1);
            delta += page.getContentHeight(c2);
            if (pageBreakCount == 2 && pendingPageName) {
                c2.setPageName(c2.getPendingPageName());
            }
            if (page == c2.getRootLayer().getLastPage()) {
                c2.getRootLayer().addPage(c2);
            }
        }
        this.setY(this.getY() + delta);
        return delta;
    }

    public void forcePageBreakAfter(LayoutContext c2, IdentValue pageBreakValue) {
        boolean needSecondPageBreak = false;
        PageBox page = c2.getRootLayer().getLastPage(c2, this);
        if (page != null) {
            if (page.isLeftPage() && pageBreakValue == IdentValue.LEFT || page.isRightPage() && pageBreakValue == IdentValue.RIGHT) {
                needSecondPageBreak = true;
            }
            int delta = page.getBottom() + c2.getExtraSpaceTop() - (this.getAbsY() + this.getMarginBorderPadding(c2, 3) + this.getHeight());
            if (page == c2.getRootLayer().getLastPage()) {
                c2.getRootLayer().addPage(c2);
            }
            if (needSecondPageBreak) {
                page = (PageBox)c2.getRootLayer().getPages().get(page.getPageNo() + 1);
                delta += page.getContentHeight(c2);
                if (page == c2.getRootLayer().getLastPage()) {
                    c2.getRootLayer().addPage(c2);
                }
            }
            this.setHeight(this.getHeight() + delta);
        }
    }

    public boolean crossesPageBreak(LayoutContext c2) {
        if (!c2.isPageBreaksAllowed()) {
            return false;
        }
        PageBox pageBox = c2.getRootLayer().getFirstPage(c2, this);
        if (pageBox == null) {
            return false;
        }
        return this.getAbsY() + this.getHeight() >= pageBox.getBottom() - c2.getExtraSpaceBottom();
    }

    public Dimension getRelativeOffset() {
        return this._relativeOffset;
    }

    public void setRelativeOffset(Dimension relativeOffset) {
        this._relativeOffset = relativeOffset;
    }

    public Box find(CssContext cssCtx, int absX, int absY, boolean findAnonymous) {
        PaintingInfo pI = this.getPaintingInfo();
        if (pI != null && !pI.getAggregateBounds().contains(absX, absY)) {
            return null;
        }
        Box result2 = null;
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            Box child = this.getChild(i2);
            result2 = child.find(cssCtx, absX, absY, findAnonymous);
            if (result2 == null) continue;
            return result2;
        }
        Rectangle edge = this.getContentAreaEdge(this.getAbsX(), this.getAbsY(), cssCtx);
        return edge.contains(absX, absY) && this.getStyle().isVisible() ? this : null;
    }

    public boolean isRoot() {
        return this.getElement() != null && !this.isAnonymous() && this.getElement().getParentNode().getNodeType() == 9;
    }

    public boolean isBody() {
        return this.getParent() != null && this.getParent().isRoot();
    }

    @Override
    public Element getElement() {
        return this._element;
    }

    @Override
    public void setElement(Element element) {
        this._element = element;
    }

    public void setMarginTop(CssContext cssContext, int marginTop) {
        this.ensureWorkingMargin(cssContext);
        this._workingMargin.setTop(marginTop);
    }

    public void setMarginBottom(CssContext cssContext, int marginBottom) {
        this.ensureWorkingMargin(cssContext);
        this._workingMargin.setBottom(marginBottom);
    }

    public void setMarginLeft(CssContext cssContext, int marginLeft) {
        this.ensureWorkingMargin(cssContext);
        this._workingMargin.setLeft(marginLeft);
    }

    public void setMarginRight(CssContext cssContext, int marginRight) {
        this.ensureWorkingMargin(cssContext);
        this._workingMargin.setRight(marginRight);
    }

    private void ensureWorkingMargin(CssContext cssContext) {
        if (this._workingMargin == null) {
            this._workingMargin = this.getStyleMargin(cssContext).copyOf();
        }
    }

    public RectPropertySet getMargin(CssContext cssContext) {
        return this._workingMargin != null ? this._workingMargin : this.getStyleMargin(cssContext);
    }

    protected RectPropertySet getStyleMargin(CssContext cssContext) {
        return this.getStyle().getMarginRect(this.getContainingBlockWidth(), cssContext);
    }

    protected RectPropertySet getStyleMargin(CssContext cssContext, boolean useCache) {
        return this.getStyle().getMarginRect(this.getContainingBlockWidth(), cssContext, useCache);
    }

    public RectPropertySet getPadding(CssContext cssCtx) {
        return this.getStyle().getPaddingRect(this.getContainingBlockWidth(), cssCtx);
    }

    public BorderPropertySet getBorder(CssContext cssCtx) {
        return this.getStyle().getBorder(cssCtx);
    }

    protected int getContainingBlockWidth() {
        return this.getContainingBlock().getContentWidth();
    }

    protected void resetTopMargin(CssContext cssContext) {
        if (this._workingMargin != null) {
            RectPropertySet styleMargin = this.getStyleMargin(cssContext);
            this._workingMargin.setTop(styleMargin.top());
        }
    }

    public void clearSelection(List modified) {
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            Box child = this.getChild(i2);
            child.clearSelection(modified);
        }
    }

    public void selectAll() {
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            Box child = this.getChild(i2);
            child.selectAll();
        }
    }

    public PaintingInfo calcPaintingInfo(CssContext c2, boolean useCache) {
        PaintingInfo cached = this.getPaintingInfo();
        if (cached != null && useCache) {
            return cached;
        }
        PaintingInfo result2 = new PaintingInfo();
        Rectangle bounds = this.getMarginEdge(this.getAbsX(), this.getAbsY(), c2, 0, 0);
        result2.setOuterMarginCorner(new Dimension(bounds.x + bounds.width, bounds.y + bounds.height));
        result2.setAggregateBounds(this.getPaintingClipEdge(c2));
        if (!this.getStyle().isOverflowApplies() || this.getStyle().isOverflowVisible()) {
            this.calcChildPaintingInfo(c2, result2, useCache);
        }
        this.setPaintingInfo(result2);
        return result2;
    }

    protected void calcChildPaintingInfo(CssContext c2, PaintingInfo result2, boolean useCache) {
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            Box child = this.getChild(i2);
            PaintingInfo info = child.calcPaintingInfo(c2, useCache);
            this.moveIfGreater(result2.getOuterMarginCorner(), info.getOuterMarginCorner());
            result2.getAggregateBounds().add(info.getAggregateBounds());
        }
    }

    public int getMarginBorderPadding(CssContext cssCtx, int which) {
        BorderPropertySet border = this.getBorder(cssCtx);
        RectPropertySet margin = this.getMargin(cssCtx);
        RectPropertySet padding = this.getPadding(cssCtx);
        switch (which) {
            case 1: {
                return (int)(margin.left() + border.left() + padding.left());
            }
            case 2: {
                return (int)(margin.right() + border.right() + padding.right());
            }
            case 3: {
                return (int)(margin.top() + border.top() + padding.top());
            }
            case 4: {
                return (int)(margin.bottom() + border.bottom() + padding.bottom());
            }
        }
        throw new IllegalArgumentException();
    }

    protected void moveIfGreater(Dimension result2, Dimension test) {
        if (test.width > result2.width) {
            result2.width = test.width;
        }
        if (test.height > result2.height) {
            result2.height = test.height;
        }
    }

    public void restyle(LayoutContext c2) {
        Element e2 = this.getElement();
        CalculatedStyle style = null;
        String pe = this.getPseudoElementOrClass();
        if (pe != null) {
            if (e2 != null) {
                style = c2.getSharedContext().getStyle(e2, true);
                style = style.deriveStyle(c2.getCss().getPseudoElementStyle(e2, pe));
            } else {
                BlockBox container = (BlockBox)this.getParent().getParent();
                e2 = container.getElement();
                style = c2.getSharedContext().getStyle(e2, true);
                style = style.deriveStyle(c2.getCss().getPseudoElementStyle(e2, pe));
                style = style.createAnonymousStyle(IdentValue.INLINE);
            }
        } else if (e2 != null) {
            style = c2.getSharedContext().getStyle(e2, true);
            if (this.isAnonymous()) {
                style = style.createAnonymousStyle(this.getStyle().getIdent(CSSName.DISPLAY));
            }
        } else {
            Box parent = this.getParent();
            if (parent != null && (e2 = parent.getElement()) != null) {
                style = c2.getSharedContext().getStyle(e2, true);
                style = style.createAnonymousStyle(IdentValue.INLINE);
            }
        }
        if (style != null) {
            this.setStyle(style);
        }
        this.restyleChildren(c2);
    }

    protected void restyleChildren(LayoutContext c2) {
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            Box b2 = this.getChild(i2);
            b2.restyle(c2);
        }
    }

    public Box getRestyleTarget() {
        return this;
    }

    protected int getIndex() {
        return this._index;
    }

    protected void setIndex(int index) {
        this._index = index;
    }

    @Override
    public String getPseudoElementOrClass() {
        return this._pseudoElementOrClass;
    }

    public void setPseudoElementOrClass(String pseudoElementOrClass) {
        this._pseudoElementOrClass = pseudoElementOrClass;
    }

    public void setX(int x2) {
        this._x = x2;
    }

    public int getX() {
        return this._x;
    }

    public void setY(int y2) {
        this._y = y2;
    }

    public int getY() {
        return this._y;
    }

    public void setTy(int ty) {
        this._ty = ty;
    }

    public int getTy() {
        return this._ty;
    }

    public void setTx(int tx) {
        this._tx = tx;
    }

    public int getTx() {
        return this._tx;
    }

    public void setRightMBP(int rightMBP) {
        this._rightMBP = rightMBP;
    }

    public int getRightMBP() {
        return this._rightMBP;
    }

    public void setLeftMBP(int leftMBP) {
        this._leftMBP = leftMBP;
    }

    public int getLeftMBP() {
        return this._leftMBP;
    }

    public void setHeight(int height) {
        this._height = height;
    }

    public int getHeight() {
        return this._height;
    }

    public void setContentWidth(int contentWidth) {
        this._contentWidth = contentWidth < 0 ? 0 : contentWidth;
    }

    public int getContentWidth() {
        return this._contentWidth;
    }

    public PaintingInfo getPaintingInfo() {
        return this._paintingInfo;
    }

    private void setPaintingInfo(PaintingInfo paintingInfo) {
        this._paintingInfo = paintingInfo;
    }

    public boolean isAnonymous() {
        return this._anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this._anonymous = anonymous;
    }

    public BoxDimensions getBoxDimensions() {
        BoxDimensions result2 = new BoxDimensions();
        result2.setLeftMBP(this.getLeftMBP());
        result2.setRightMBP(this.getRightMBP());
        result2.setContentWidth(this.getContentWidth());
        result2.setHeight(this.getHeight());
        return result2;
    }

    public void setBoxDimensions(BoxDimensions dimensions) {
        this.setLeftMBP(dimensions.getLeftMBP());
        this.setRightMBP(dimensions.getRightMBP());
        this.setContentWidth(dimensions.getContentWidth());
        this.setHeight(dimensions.getHeight());
    }

    public void collectText(RenderingContext c2, StringBuffer buffer) throws IOException {
        Iterator i2 = this.getChildIterator();
        while (i2.hasNext()) {
            Box b2 = (Box)i2.next();
            b2.collectText(c2, buffer);
        }
    }

    public void exportText(RenderingContext c2, Writer writer) throws IOException {
        if (c2.isPrint() && this.isRoot()) {
            c2.setPage(0, (PageBox)c2.getRootLayer().getPages().get(0));
            c2.getPage().exportLeadingText(c2, writer);
        }
        Iterator i2 = this.getChildIterator();
        while (i2.hasNext()) {
            Box b2 = (Box)i2.next();
            b2.exportText(c2, writer);
        }
        if (c2.isPrint() && this.isRoot()) {
            this.exportPageBoxText(c2, writer);
        }
    }

    private void exportPageBoxText(RenderingContext c2, Writer writer) throws IOException {
        c2.getPage().exportTrailingText(c2, writer);
        if (c2.getPage() != c2.getRootLayer().getLastPage()) {
            List pages = c2.getRootLayer().getPages();
            do {
                PageBox next = (PageBox)pages.get(c2.getPageNo() + 1);
                c2.setPage(next.getPageNo(), next);
                next.exportLeadingText(c2, writer);
                next.exportTrailingText(c2, writer);
            } while (c2.getPage() != c2.getRootLayer().getLastPage());
        }
    }

    protected void exportPageBoxText(RenderingContext c2, Writer writer, int yPos) throws IOException {
        c2.getPage().exportTrailingText(c2, writer);
        List pages = c2.getRootLayer().getPages();
        PageBox next = (PageBox)pages.get(c2.getPageNo() + 1);
        c2.setPage(next.getPageNo(), next);
        while (next.getBottom() < yPos) {
            next.exportLeadingText(c2, writer);
            next.exportTrailingText(c2, writer);
            next = (PageBox)pages.get(c2.getPageNo() + 1);
            c2.setPage(next.getPageNo(), next);
        }
        next.exportLeadingText(c2, writer);
    }

    public boolean isInDocumentFlow() {
        Box parent;
        Box flowRoot = this;
        while ((parent = flowRoot.getParent()) != null) {
            flowRoot = parent;
        }
        return flowRoot.isRoot();
    }

    public void analyzePageBreaks(LayoutContext c2, ContentLimitContainer container) {
        container.updateTop(c2, this.getAbsY());
        Iterator i2 = this.getChildIterator();
        while (i2.hasNext()) {
            Box b2 = (Box)i2.next();
            b2.analyzePageBreaks(c2, container);
        }
        container.updateBottom(c2, this.getAbsY() + this.getHeight());
    }

    public FSColor getEffBackgroundColor(RenderingContext c2) {
        FSColor result2 = null;
        for (Box current = this; current != null; current = current.getContainingBlock()) {
            result2 = current.getStyle().getBackgroundColor();
            if (result2 == null) continue;
            return result2;
        }
        PageBox page = c2.getPage();
        result2 = page.getStyle().getBackgroundColor();
        if (result2 == null) {
            return new FSRGBColor(255, 255, 255);
        }
        return result2;
    }

    protected boolean isMarginAreaRoot() {
        return false;
    }

    public boolean isContainedInMarginBox() {
        Box parent;
        Box current = this;
        while ((parent = current.getParent()) != null) {
            current = parent;
        }
        return current.isMarginAreaRoot();
    }

    public int getEffectiveWidth() {
        return this.getWidth();
    }

    protected boolean isInitialContainingBlock() {
        return false;
    }
}

